/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.bytecodeAnalysis;

import com.intellij.codeInspection.bytecodeAnalysis.AbstractValues;
import com.intellij.codeInspection.bytecodeAnalysis.Component;
import com.intellij.codeInspection.bytecodeAnalysis.ContractAnalysis;
import com.intellij.codeInspection.bytecodeAnalysis.Direction;
import com.intellij.codeInspection.bytecodeAnalysis.EKey;
import com.intellij.codeInspection.bytecodeAnalysis.Equation;
import com.intellij.codeInspection.bytecodeAnalysis.ExpandableArray;
import com.intellij.codeInspection.bytecodeAnalysis.Pending;
import com.intellij.codeInspection.bytecodeAnalysis.State;
import com.intellij.codeInspection.bytecodeAnalysis.Value;
import com.intellij.codeInspection.bytecodeAnalysis.asm.RichControlFlow;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.org.objectweb.asm.tree.analysis.AnalyzerException;
import org.jetbrains.org.objectweb.asm.tree.analysis.BasicValue;
import org.jetbrains.org.objectweb.asm.tree.analysis.Frame;

class InThrowAnalysis
extends ContractAnalysis {
    private BasicValue myReturnValue;
    boolean myHasNonTrivialReturn;
    private Map<State, Set<EKey>> myThrowKeys = new HashMap<State, Set<EKey>>();
    private final List<State> myNextStates = new ArrayList<State>();
    private Set<EKey> myFinalThrowKeys;

    protected InThrowAnalysis(RichControlFlow richControlFlow, Direction direction, boolean[] resultOrigins, boolean stable, ExpandableArray<State> pending) {
        super(richControlFlow, direction, resultOrigins, stable, pending);
    }

    @Override
    @NotNull
    protected Equation analyze() throws AnalyzerException {
        Equation equation = super.analyze();
        if (equation.result == Value.Top && this.myThrowKeys != null && this.myFinalThrowKeys != null && !this.myFinalThrowKeys.isEmpty()) {
            for (Set<EKey> value : this.myThrowKeys.values()) {
                this.updateFinalKeys(value);
            }
            Equation equation2 = this.mkEquation(new Pending(new Component[]{new Component(Value.Top, this.myFinalThrowKeys)}));
            if (equation2 == null) {
                InThrowAnalysis.$$$reportNull$$$0(0);
            }
            return equation2;
        }
        Equation equation3 = equation;
        if (equation3 == null) {
            InThrowAnalysis.$$$reportNull$$$0(1);
        }
        return equation3;
    }

    @Override
    void pendingPush(State st) {
        super.pendingPush(st);
        this.myNextStates.add(st);
    }

    @Override
    void processState(State state) throws AnalyzerException {
        this.myNextStates.clear();
        super.processState(state);
        this.updateThrowPaths(state);
    }

    private void updateThrowPaths(State state) {
        List<EKey> throwKeys = this.interpreter.throwKeys;
        this.interpreter.throwKeys = null;
        if (this.myThrowKeys == null) {
            return;
        }
        Set<EKey> prevKeys = this.myThrowKeys.remove(state);
        if (this.myNextStates.isEmpty()) {
            this.updateFinalKeys(prevKeys);
            return;
        }
        if (prevKeys == null || prevKeys.isEmpty()) {
            prevKeys = throwKeys != null ? Set.copyOf(throwKeys) : Collections.emptySet();
        } else if (throwKeys != null && !throwKeys.isEmpty()) {
            prevKeys = new HashSet<EKey>(prevKeys);
            prevKeys.addAll(throwKeys);
            if (prevKeys.size() > 8) {
                this.myThrowKeys = null;
                return;
            }
        }
        for (State next : this.myNextStates) {
            this.myThrowKeys.put(next, prevKeys);
        }
    }

    private void updateFinalKeys(Set<EKey> prevKeys) {
        if (this.myFinalThrowKeys == null) {
            this.myFinalThrowKeys = new HashSet<EKey>(prevKeys);
        } else {
            if (this.myFinalThrowKeys.isEmpty()) {
                this.myThrowKeys = null;
                return;
            }
            this.myFinalThrowKeys.retainAll(prevKeys);
        }
    }

    @Override
    boolean handleReturn(Frame<BasicValue> frame, int opcode, boolean unsure) {
        Value subResult;
        if (this.interpreter.deReferenced) {
            subResult = Value.Top;
        } else {
            switch (opcode) {
                case 172: 
                case 173: 
                case 174: 
                case 175: 
                case 176: {
                    BasicValue value = (BasicValue)frame.pop();
                    if (!(value instanceof AbstractValues.NthParamValue) && value != AbstractValues.NullValue && value != AbstractValues.TrueValue && value != AbstractValues.FalseValue || this.myReturnValue != null && !this.myReturnValue.equals((Object)value)) {
                        this.myHasNonTrivialReturn = true;
                    } else {
                        this.myReturnValue = value;
                    }
                    subResult = Value.Top;
                    break;
                }
                case 177: {
                    subResult = Value.Top;
                    break;
                }
                case 191: {
                    subResult = Value.Fail;
                    break;
                }
                default: {
                    return false;
                }
            }
        }
        this.internalResult = resultUtil.join(this.internalResult, subResult);
        this.unsureOnly &= unsure;
        if (!unsure && this.internalResult == Value.Top && this.myHasNonTrivialReturn) {
            this.earlyResult = this.internalResult;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/bytecodeAnalysis/InThrowAnalysis", "analyze"));
    }
}

