/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.bytecodeAnalysis;

import com.intellij.codeInspection.bytecodeAnalysis.AbstractValues;
import com.intellij.codeInspection.bytecodeAnalysis.Analysis;
import com.intellij.codeInspection.bytecodeAnalysis.Component;
import com.intellij.codeInspection.bytecodeAnalysis.Conf;
import com.intellij.codeInspection.bytecodeAnalysis.Direction;
import com.intellij.codeInspection.bytecodeAnalysis.EKey;
import com.intellij.codeInspection.bytecodeAnalysis.Equation;
import com.intellij.codeInspection.bytecodeAnalysis.ExpandableArray;
import com.intellij.codeInspection.bytecodeAnalysis.MakeResult;
import com.intellij.codeInspection.bytecodeAnalysis.NotNullInterpreter;
import com.intellij.codeInspection.bytecodeAnalysis.PResults;
import com.intellij.codeInspection.bytecodeAnalysis.Pending;
import com.intellij.codeInspection.bytecodeAnalysis.PendingAction;
import com.intellij.codeInspection.bytecodeAnalysis.ProceedState;
import com.intellij.codeInspection.bytecodeAnalysis.State;
import com.intellij.codeInspection.bytecodeAnalysis.TooComplexException;
import com.intellij.codeInspection.bytecodeAnalysis.Value;
import com.intellij.codeInspection.bytecodeAnalysis.asm.ControlFlowGraph;
import com.intellij.codeInspection.bytecodeAnalysis.asm.RichControlFlow;
import com.intellij.openapi.progress.ProgressManager;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.JumpInsnNode;
import org.jetbrains.org.objectweb.asm.tree.analysis.AnalyzerException;
import org.jetbrains.org.objectweb.asm.tree.analysis.BasicValue;
import org.jetbrains.org.objectweb.asm.tree.analysis.Frame;
import org.jetbrains.org.objectweb.asm.tree.analysis.Interpreter;

class NonNullInAnalysis
extends Analysis<PResults.PResult> {
    private final ExpandableArray<PendingAction> pendingActions;
    private final ExpandableArray<PResults.PResult> results;
    private final NotNullInterpreter interpreter = new NotNullInterpreter();
    boolean possibleNPE;
    private int id;
    private Frame<BasicValue> nextFrame;
    private PResults.PResult subResult;
    private int pendingTop;

    protected NonNullInAnalysis(RichControlFlow richControlFlow, Direction direction, boolean stable, ExpandableArray<PendingAction> pendingActions, ExpandableArray<PResults.PResult> results) {
        super(richControlFlow, direction, stable);
        this.pendingActions = pendingActions;
        this.results = results;
    }

    PResults.PResult combineResults(PResults.PResult delta, int[] subResults) throws AnalyzerException {
        PResults.PResult result = PResults.Identity;
        for (int subResult : subResults) {
            result = PResults.join(result, this.results.get(subResult));
        }
        return PResults.meet(delta, result);
    }

    @NotNull
    Equation mkEquation(PResults.PResult result) {
        if (PResults.Identity == result || PResults.Return == result) {
            return new Equation(this.aKey, Value.Top);
        }
        if (PResults.NPE == result) {
            return new Equation(this.aKey, Value.NotNull);
        }
        PResults.ConditionalNPE condNpe = (PResults.ConditionalNPE)result;
        Set<Component> components = condNpe.sop.stream().map(prod -> new Component(Value.Top, (Collection<EKey>)prod)).collect(Collectors.toSet());
        return new Equation(this.aKey, new Pending(components));
    }

    @Override
    @NotNull
    protected Equation analyze() throws AnalyzerException {
        this.pendingPush(new ProceedState(this.createStartState()));
        int steps = 0;
        while (this.pendingTop > 0 && this.earlyResult == null) {
            if (++steps % 100 == 0) {
                ProgressManager.checkCanceled();
            }
            TooComplexException.check(this.method, steps);
            PendingAction action = this.pendingActions.get(--this.pendingTop);
            if (action instanceof MakeResult) {
                MakeResult makeResult = (MakeResult)action;
                PResults.PResult result = this.combineResults(makeResult.subResult, makeResult.indices);
                State state = makeResult.state;
                int insnIndex = state.conf.insnIndex;
                this.results.set(state.index, result);
                this.addComputed(insnIndex, state);
                continue;
            }
            if (!(action instanceof ProceedState)) continue;
            ProceedState proceedState = (ProceedState)action;
            State state = proceedState.state;
            int insnIndex = state.conf.insnIndex;
            Conf conf = state.conf;
            List<Conf> history = state.history;
            boolean fold = false;
            if (this.dfsTree.loopEnters[insnIndex]) {
                for (Conf prev : history) {
                    if (!AbstractValues.isInstance(conf, prev)) continue;
                    fold = true;
                    break;
                }
            }
            if (fold) {
                this.results.set(state.index, PResults.Identity);
                this.addComputed(insnIndex, state);
                continue;
            }
            State baseState = null;
            List thisComputed = this.computed[insnIndex];
            if (thisComputed != null) {
                for (State prevState : thisComputed) {
                    if (!state.equiv(prevState)) continue;
                    baseState = prevState;
                    break;
                }
            }
            if (baseState != null) {
                this.results.set(state.index, this.results.get(baseState.index));
                continue;
            }
            this.processState(state);
        }
        Equation equation = this.earlyResult != null ? this.mkEquation((PResults.PResult)this.earlyResult) : this.mkEquation(this.results.get(0));
        if (equation == null) {
            NonNullInAnalysis.$$$reportNull$$$0(0);
        }
        return equation;
    }

    private void processState(State state) throws AnalyzerException {
        int i;
        boolean notEmptySubResult;
        int stateIndex = state.index;
        Conf conf = state.conf;
        int insnIndex = conf.insnIndex;
        List<Conf> history = state.history;
        boolean taken = state.taken;
        Frame<BasicValue> frame = conf.frame;
        AbstractInsnNode insnNode = this.methodNode.instructions.get(insnIndex);
        List<Conf> nextHistory = this.dfsTree.loopEnters[insnIndex] ? NonNullInAnalysis.append(history, conf) : history;
        boolean hasCompanions = state.hasCompanions;
        this.execute(frame, insnNode);
        boolean bl = notEmptySubResult = this.subResult != PResults.Identity;
        if (this.subResult == PResults.NPE) {
            this.results.set(stateIndex, PResults.NPE);
            this.possibleNPE = true;
            this.addComputed(insnIndex, state);
            return;
        }
        int opcode = insnNode.getOpcode();
        switch (opcode) {
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: 
            case 177: {
                if (!hasCompanions) {
                    this.earlyResult = PResults.Return;
                } else {
                    this.results.set(stateIndex, PResults.Return);
                    this.addComputed(insnIndex, state);
                }
                return;
            }
        }
        if (opcode == 191) {
            if (taken) {
                this.results.set(stateIndex, PResults.NPE);
                this.possibleNPE = true;
            } else {
                this.results.set(stateIndex, PResults.Identity);
            }
            this.addComputed(insnIndex, state);
            return;
        }
        if (opcode == 199 && NonNullInAnalysis.popValue(frame) instanceof AbstractValues.ParamValue) {
            int nextInsnIndex = insnIndex + 1;
            State nextState = new State(++this.id, new Conf(nextInsnIndex, this.nextFrame), nextHistory, true, hasCompanions || notEmptySubResult, state.unsure);
            this.pendingPush(new MakeResult(state, this.subResult, new int[]{nextState.index}));
            this.pendingPush(new ProceedState(nextState));
            return;
        }
        if (opcode == 198 && NonNullInAnalysis.popValue(frame) instanceof AbstractValues.ParamValue) {
            int nextInsnIndex = this.methodNode.instructions.indexOf((AbstractInsnNode)((JumpInsnNode)insnNode).label);
            State nextState = new State(++this.id, new Conf(nextInsnIndex, this.nextFrame), nextHistory, true, hasCompanions || notEmptySubResult, state.unsure);
            this.pendingPush(new MakeResult(state, this.subResult, new int[]{nextState.index}));
            this.pendingPush(new ProceedState(nextState));
            return;
        }
        if (opcode == 153 && NonNullInAnalysis.popValue(frame) == AbstractValues.InstanceOfCheckValue) {
            int nextInsnIndex = this.methodNode.instructions.indexOf((AbstractInsnNode)((JumpInsnNode)insnNode).label);
            State nextState = new State(++this.id, new Conf(nextInsnIndex, this.nextFrame), nextHistory, true, hasCompanions || notEmptySubResult, state.unsure);
            this.pendingPush(new MakeResult(state, this.subResult, new int[]{nextState.index}));
            this.pendingPush(new ProceedState(nextState));
            return;
        }
        if (opcode == 154 && NonNullInAnalysis.popValue(frame) == AbstractValues.InstanceOfCheckValue) {
            int nextInsnIndex = insnIndex + 1;
            State nextState = new State(++this.id, new Conf(nextInsnIndex, this.nextFrame), nextHistory, true, hasCompanions || notEmptySubResult, state.unsure);
            this.pendingPush(new MakeResult(state, this.subResult, new int[]{nextState.index}));
            this.pendingPush(new ProceedState(nextState));
            return;
        }
        int[] nextInsnIndices = this.controlFlow.transitions[insnIndex];
        int[] subIndices = new int[nextInsnIndices.length];
        for (i = 0; i < nextInsnIndices.length; ++i) {
            subIndices[i] = ++this.id;
        }
        this.pendingPush(new MakeResult(state, this.subResult, subIndices));
        for (i = 0; i < nextInsnIndices.length; ++i) {
            int nextInsnIndex = nextInsnIndices[i];
            Frame<BasicValue> nextFrame1 = this.nextFrame;
            boolean exceptional = state.unsure;
            if (this.controlFlow.errors[nextInsnIndex] && this.controlFlow.errorTransitions.contains(new ControlFlowGraph.Edge(insnIndex, nextInsnIndex))) {
                nextFrame1 = NonNullInAnalysis.createCatchFrame(frame);
                exceptional = true;
            }
            this.pendingPush(new ProceedState(new State(subIndices[i], new Conf(nextInsnIndex, nextFrame1), nextHistory, taken, hasCompanions || notEmptySubResult, exceptional)));
        }
    }

    private void pendingPush(PendingAction action) {
        TooComplexException.check(this.method, this.pendingTop);
        this.pendingActions.set(this.pendingTop++, action);
    }

    private void execute(Frame<BasicValue> frame, AbstractInsnNode insnNode) throws AnalyzerException {
        switch (insnNode.getType()) {
            case 8: 
            case 14: 
            case 15: {
                this.nextFrame = frame;
                this.subResult = PResults.Identity;
                break;
            }
            default: {
                this.nextFrame = new Frame(frame);
                this.interpreter.reset(false);
                this.nextFrame.execute(insnNode, (Interpreter)this.interpreter);
                this.subResult = this.interpreter.getSubResult();
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/bytecodeAnalysis/NonNullInAnalysis", "analyze"));
    }
}

