/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.bytecodeAnalysis;

import com.intellij.codeInspection.bytecodeAnalysis.Component;
import com.intellij.codeInspection.bytecodeAnalysis.CoreHKey;
import com.intellij.codeInspection.bytecodeAnalysis.EKey;
import com.intellij.codeInspection.bytecodeAnalysis.ELattice;
import com.intellij.codeInspection.bytecodeAnalysis.Equation;
import com.intellij.codeInspection.bytecodeAnalysis.Pending;
import com.intellij.codeInspection.bytecodeAnalysis.Result;
import com.intellij.codeInspection.bytecodeAnalysis.ResultUtil;
import com.intellij.codeInspection.bytecodeAnalysis.Value;
import com.intellij.util.containers.Stack;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

final class Solver {
    private final ELattice<Value> lattice;
    private final HashMap<EKey, HashSet<EKey>> dependencies = new HashMap();
    private final HashMap<EKey, Pending> pending = new HashMap();
    private final HashMap<EKey, Value> solved = new HashMap();
    private final Stack<EKey> moving = new Stack();
    private final ResultUtil resultUtil;
    private final HashMap<CoreHKey, Equation> equations = new HashMap();
    private final Value unstableValue;

    Solver(ELattice<Value> lattice, Value unstableValue) {
        this.lattice = lattice;
        this.unstableValue = unstableValue;
        this.resultUtil = new ResultUtil(lattice);
    }

    Result getUnknownResult() {
        return this.unstableValue;
    }

    void addEquation(Equation equation) {
        EKey key = equation.key;
        CoreHKey coreKey = new CoreHKey(key.member, key.dirKey);
        Equation previousEquation = this.equations.get(coreKey);
        if (previousEquation == null) {
            this.equations.put(coreKey, equation);
        } else {
            EKey joinKey = new EKey(coreKey.myMethod, coreKey.dirKey, equation.key.stable && previousEquation.key.stable, false);
            Result joinResult = this.resultUtil.join(equation.result, previousEquation.result);
            Equation joinEquation = new Equation(joinKey, joinResult);
            this.equations.put(coreKey, joinEquation);
        }
    }

    void queueEquation(Equation equation) {
        Result rhs = equation.result;
        if (rhs instanceof Value) {
            this.solved.put(equation.key, (Value)rhs);
            this.moving.push((Object)equation.key);
        } else if (rhs instanceof Pending) {
            Pending pendResult = ((Pending)rhs).copy();
            Result norm = this.normalize(pendResult.delta);
            if (norm instanceof Value) {
                this.solved.put(equation.key, (Value)norm);
                this.moving.push((Object)equation.key);
            } else {
                Pending pendResult1 = ((Pending)rhs).copy();
                for (Component component : pendResult1.delta) {
                    for (EKey trigger : component.ids) {
                        HashSet<EKey> set = this.dependencies.get(trigger);
                        if (set == null) {
                            set = new HashSet();
                            this.dependencies.put(trigger, set);
                        }
                        set.add(equation.key);
                    }
                }
                this.pending.put(equation.key, pendResult1);
            }
        }
    }

    Value negate(Value value) {
        return switch (value) {
            case Value.True -> Value.False;
            case Value.False -> Value.True;
            default -> value;
        };
    }

    Map<EKey, Value> solve() {
        for (Equation equation : this.equations.values()) {
            this.queueEquation(equation);
        }
        while (!this.moving.empty()) {
            Value[] valueArray;
            EKey[] eKeyArray;
            EKey id = (EKey)this.moving.pop();
            Value value = this.solved.get(id);
            if (id.stable) {
                EKey[] eKeyArray2 = new EKey[2];
                eKeyArray2[0] = id;
                eKeyArray = eKeyArray2;
                eKeyArray2[1] = id.invertStability();
            } else {
                EKey[] eKeyArray3 = new EKey[2];
                eKeyArray3[0] = id.invertStability();
                eKeyArray = eKeyArray3;
                eKeyArray3[1] = id;
            }
            EKey[] initialPIds = eKeyArray;
            if (id.stable) {
                Value[] valueArray2 = new Value[2];
                valueArray2[0] = value;
                valueArray = valueArray2;
                valueArray2[1] = value;
            } else {
                Value[] valueArray3 = new Value[2];
                valueArray3[0] = value;
                valueArray = valueArray3;
                valueArray3[1] = this.unstableValue;
            }
            Value[] initialPVals = valueArray;
            EKey[] pIds = new EKey[]{initialPIds[0], initialPIds[1], initialPIds[0].negate(), initialPIds[1].negate()};
            Value[] pVals = new Value[]{initialPVals[0], initialPVals[1], this.negate(initialPVals[0]), this.negate(initialPVals[1])};
            for (int i = 0; i < pIds.length; ++i) {
                EKey pId = pIds[i];
                Value pVal = pVals[i];
                HashSet<EKey> dIds = this.dependencies.get(pId);
                if (dIds == null) continue;
                for (EKey dId : dIds) {
                    Pending pend = this.pending.remove(dId);
                    if (pend == null) continue;
                    Result pend1 = this.substitute(pend, pId, pVal);
                    if (pend1 instanceof Value) {
                        this.solved.put(dId, (Value)pend1);
                        this.moving.push((Object)dId);
                        continue;
                    }
                    this.pending.put(dId, (Pending)pend1);
                }
            }
        }
        this.pending.clear();
        return this.solved;
    }

    Result substitute(@NotNull Pending pending, @NotNull EKey id, @NotNull Value value) {
        Component[] sum;
        if (pending == null) {
            Solver.$$$reportNull$$$0(0);
        }
        if (id == null) {
            Solver.$$$reportNull$$$0(1);
        }
        if (value == null) {
            Solver.$$$reportNull$$$0(2);
        }
        for (Component intIdComponent : sum = pending.delta) {
            if (!intIdComponent.remove(id)) continue;
            intIdComponent.value = this.lattice.meet(intIdComponent.value, value);
        }
        return this.normalize(sum);
    }

    @NotNull
    Result normalize(Component @NotNull [] sum) {
        if (sum == null) {
            Solver.$$$reportNull$$$0(3);
        }
        Value acc = (Value)this.lattice.bot;
        boolean computableNow = true;
        for (Component prod : sum) {
            if (prod.isEmpty() || prod.value == this.lattice.bot) {
                acc = this.lattice.join(acc, prod.value);
                continue;
            }
            computableNow = false;
        }
        return acc == this.lattice.top || computableNow ? acc : new Pending(sum);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pending";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sum";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInspection/bytecodeAnalysis/Solver";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "substitute";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "normalize";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

