/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.bytecodeAnalysis.asm;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.org.objectweb.asm.tree.JumpInsnNode;
import org.jetbrains.org.objectweb.asm.tree.LabelNode;

public class Subroutine {
    LabelNode start;
    boolean[] access;
    List<JumpInsnNode> callers;

    private Subroutine() {
    }

    Subroutine(@Nullable LabelNode start, int maxLocals, @Nullable JumpInsnNode caller) {
        this.start = start;
        this.access = new boolean[maxLocals];
        this.callers = new ArrayList<JumpInsnNode>();
        this.callers.add(caller);
    }

    public Subroutine copy() {
        Subroutine result = new Subroutine();
        result.start = this.start;
        result.access = (boolean[])this.access.clone();
        result.callers = new ArrayList<JumpInsnNode>(this.callers);
        return result;
    }

    public boolean merge(Subroutine subroutine) {
        int i;
        boolean changes = false;
        for (i = 0; i < this.access.length; ++i) {
            if (!subroutine.access[i] || this.access[i]) continue;
            this.access[i] = true;
            changes = true;
        }
        if (subroutine.start == this.start) {
            for (i = 0; i < subroutine.callers.size(); ++i) {
                JumpInsnNode caller = subroutine.callers.get(i);
                if (this.callers.contains(caller)) continue;
                this.callers.add(caller);
                changes = true;
            }
        }
        return changes;
    }
}

