/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.bytecodeAnalysis.asm;

import com.intellij.codeInspection.bytecodeAnalysis.asm.Subroutine;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.org.objectweb.asm.Opcodes;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.InsnList;
import org.jetbrains.org.objectweb.asm.tree.JumpInsnNode;
import org.jetbrains.org.objectweb.asm.tree.LabelNode;
import org.jetbrains.org.objectweb.asm.tree.LookupSwitchInsnNode;
import org.jetbrains.org.objectweb.asm.tree.TableSwitchInsnNode;
import org.jetbrains.org.objectweb.asm.tree.TryCatchBlockNode;
import org.jetbrains.org.objectweb.asm.tree.analysis.AnalyzerException;

@ApiStatus.Internal
public abstract class SubroutineFinder
implements Opcodes {
    InsnList insns;
    List<TryCatchBlockNode>[] handlers;
    Subroutine[] subroutines;
    int n;

    void findSubroutine(int insn, Subroutine sub, List<AbstractInsnNode> calls) throws AnalyzerException {
        while (true) {
            if (insn < 0 || insn >= this.n) {
                throw new AnalyzerException(null, "Execution can fall off end of the code");
            }
            if (this.subroutines[insn] != null) {
                return;
            }
            this.subroutines[insn] = sub.copy();
            AbstractInsnNode node = this.insns.get(insn);
            if (node instanceof JumpInsnNode) {
                JumpInsnNode jNode = (JumpInsnNode)node;
                if (node.getOpcode() == 168) {
                    calls.add(node);
                } else {
                    this.findSubroutine(this.insns.indexOf((AbstractInsnNode)jNode.label), sub, calls);
                }
            } else if (node instanceof TableSwitchInsnNode) {
                TableSwitchInsnNode tsNode = (TableSwitchInsnNode)node;
                this.findSubroutine(this.insns.indexOf((AbstractInsnNode)tsNode.dflt), sub, calls);
                for (i = tsNode.labels.size() - 1; i >= 0; --i) {
                    l = (LabelNode)tsNode.labels.get(i);
                    this.findSubroutine(this.insns.indexOf((AbstractInsnNode)l), sub, calls);
                }
            } else if (node instanceof LookupSwitchInsnNode) {
                LookupSwitchInsnNode lsNode = (LookupSwitchInsnNode)node;
                this.findSubroutine(this.insns.indexOf((AbstractInsnNode)lsNode.dflt), sub, calls);
                for (i = lsNode.labels.size() - 1; i >= 0; --i) {
                    l = (LabelNode)lsNode.labels.get(i);
                    this.findSubroutine(this.insns.indexOf((AbstractInsnNode)l), sub, calls);
                }
            }
            List<TryCatchBlockNode> insnHandlers = this.handlers[insn];
            if (insnHandlers != null) {
                for (TryCatchBlockNode tcb : insnHandlers) {
                    this.findSubroutine(this.insns.indexOf((AbstractInsnNode)tcb.handler), sub, calls);
                }
            }
            switch (node.getOpcode()) {
                case 167: 
                case 169: 
                case 170: 
                case 171: 
                case 172: 
                case 173: 
                case 174: 
                case 175: 
                case 176: 
                case 177: 
                case 191: {
                    return;
                }
            }
            ++insn;
        }
    }
}

