/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.Nullability;
import com.intellij.codeInsight.NullabilityAnnotationInfo;
import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInsight.StaticAnalysisAnnotationManager;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.dataFlow.ContractChecker;
import com.intellij.codeInspection.dataFlow.ContractReturnValue;
import com.intellij.codeInspection.dataFlow.JavaMethodContractUtil;
import com.intellij.codeInspection.dataFlow.MutationSignature;
import com.intellij.codeInspection.dataFlow.StandardMethodContract;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.ExpressionUtils;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ContractInspection
extends AbstractBaseJavaLocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            ContractInspection.$$$reportNull$$$0(0);
        }
        return new JavaElementVisitor(this){

            public void visitMethod(@NotNull PsiMethod method) {
                PsiAnnotation annotation;
                if (method == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((annotation = JavaMethodContractUtil.findContractAnnotation(method)) == null || !ApplicationManager.getApplication().isInternal() && AnnotationUtil.isInferredAnnotation((PsiAnnotation)annotation)) {
                    return;
                }
                boolean ownContract = annotation.getOwner() == method.getModifierList();
                for (StandardMethodContract contract : JavaMethodContractUtil.getMethodContracts(method)) {
                    Map<PsiElement, String> errors = ContractChecker.checkContractClause(method, contract, ownContract);
                    errors.forEach((x$0, x$1) -> holder.registerProblem(x$0, x$1, new LocalQuickFix[0]));
                }
            }

            public void visitAnnotation(@NotNull PsiAnnotation annotation) {
                StandardMethodContract.ParseException error;
                String qualifiedName;
                if (annotation == null) {
                    1.$$$reportNull$$$0(1);
                }
                if ((qualifiedName = annotation.getQualifiedName()) == null) {
                    return;
                }
                if (!ContainerUtil.exists((Object[])StaticAnalysisAnnotationManager.getInstance().getKnownContractAnnotations(), fqn -> fqn.equals(qualifiedName))) {
                    return;
                }
                PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)annotation, PsiMethod.class);
                if (method == null) {
                    return;
                }
                String text = AnnotationUtil.getStringAttributeValue((PsiAnnotation)annotation, null);
                if (StringUtil.isNotEmpty((String)text) && (error = ContractInspection.checkContract(method, text)) != null) {
                    PsiAnnotationMemberValue value = annotation.findAttributeValue(null);
                    assert (value != null);
                    TextRange actualRange = null;
                    if (value instanceof PsiExpression && error.getRange() != null) {
                        actualRange = ExpressionUtils.findStringLiteralRange((PsiExpression)value, error.getRange().getStartOffset(), error.getRange().getEndOffset());
                    }
                    holder.registerProblem((PsiElement)value, actualRange, error.getMessage(), new LocalQuickFix[0]);
                }
                this.checkMutationContract(annotation, method);
            }

            private void checkMutationContract(PsiAnnotation annotation, PsiMethod method) {
                boolean pure;
                String error;
                String mutationContract = AnnotationUtil.getStringAttributeValue((PsiAnnotation)annotation, (String)"mutates");
                if (StringUtil.isNotEmpty((String)mutationContract) && (error = (pure = Boolean.TRUE.equals(AnnotationUtil.getBooleanAttributeValue((PsiAnnotation)annotation, (String)"pure"))) ? JavaAnalysisBundle.message((String)"inspection.contract.checker.pure.method.mutation.contract", (Object[])new Object[0]) : MutationSignature.checkSignature(mutationContract, method)) != null) {
                    PsiAnnotationMemberValue value = annotation.findAttributeValue("mutates");
                    assert (value != null);
                    holder.registerProblem((PsiElement)value, error, new LocalQuickFix[0]);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "method";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "annotation";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/ContractInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitMethod";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitAnnotation";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @Nullable
    public static StandardMethodContract.ParseException checkContract(PsiMethod method, String text) {
        List<StandardMethodContract> contracts;
        try {
            contracts = StandardMethodContract.parseContract(text);
        }
        catch (StandardMethodContract.ParseException e) {
            return e;
        }
        PsiParameter[] parameters = method.getParameterList().getParameters();
        int paramCount = parameters.length;
        List possibleContracts = Collections.singletonList(StandardMethodContract.trivialContract(paramCount, ContractReturnValue.returnAny()));
        for (int clauseIndex = 0; clauseIndex < contracts.size(); ++clauseIndex) {
            StandardMethodContract contract = contracts.get(clauseIndex);
            if (contract.getParameterCount() != paramCount) {
                String message = JavaAnalysisBundle.message((String)"inspection.contract.checker.parameter.count.mismatch", (Object[])new Object[]{paramCount, contract, contract.getParameterCount()});
                return StandardMethodContract.ParseException.forClause(message, text, clauseIndex);
            }
            for (int i = 0; i < parameters.length; ++i) {
                PsiParameter parameter;
                StandardMethodContract.ValueConstraint constraint = contract.getParameterConstraint(i);
                String message = ContractInspection.getConstraintProblem(method, contract, constraint, parameter = parameters[i]);
                if (message == null) continue;
                return StandardMethodContract.ParseException.forConstraint(message, text, clauseIndex, i);
            }
            String problem = contract.getReturnValue().getMethodCompatibilityProblem(method);
            if (problem != null) {
                return StandardMethodContract.ParseException.forReturnValue(problem, text, clauseIndex);
            }
            if (possibleContracts == null) continue;
            if (possibleContracts.isEmpty()) {
                return StandardMethodContract.ParseException.forClause(JavaAnalysisBundle.message((String)"inspection.contract.checker.unreachable.contract.clause", (Object[])new Object[]{contract}), text, clauseIndex);
            }
            if (ContainerUtil.and(possibleContracts, c -> c.intersect(contract) == null)) {
                return StandardMethodContract.ParseException.forClause(JavaAnalysisBundle.message((String)"inspection.contract.checker.contract.clause.never.satisfied", (Object[])new Object[]{contract}), text, clauseIndex);
            }
            if ((possibleContracts = ((StreamEx)StreamEx.of(possibleContracts).flatMap(c -> c.excludeContract(contract)).limit(300L)).toList()).size() < 300) continue;
            possibleContracts = null;
        }
        return null;
    }

    @Nullable
    @InspectionMessage
    private static String getConstraintProblem(PsiMethod method, StandardMethodContract contract, StandardMethodContract.ValueConstraint constraint, PsiParameter parameter) {
        PsiType type = parameter.getType();
        switch (constraint) {
            case NULL_VALUE: {
                if (type instanceof PsiPrimitiveType) {
                    return JavaAnalysisBundle.message((String)"inspection.contract.checker.primitive.parameter.nullability", (Object[])new Object[]{parameter.getName(), type.getPresentableText(), constraint});
                }
                NullabilityAnnotationInfo info = NullableNotNullManager.getInstance((Project)method.getProject()).findEffectiveNullabilityInfo((PsiModifierListOwner)parameter);
                if (info != null && info.getNullability() == Nullability.NOT_NULL) {
                    if (info.isInferred() && contract.getReturnValue().isFail()) {
                        return null;
                    }
                    return JavaAnalysisBundle.message((String)(info.isInferred() ? "inspection.contract.checker.inferred.notnull.parameter.null" : "inspection.contract.checker.notnull.parameter.null"), (Object[])new Object[]{parameter.getName(), constraint});
                }
                return null;
            }
            case NOT_NULL_VALUE: {
                if (type instanceof PsiPrimitiveType) {
                    return JavaAnalysisBundle.message((String)"inspection.contract.checker.primitive.parameter.nullability", (Object[])new Object[]{parameter.getName(), type.getPresentableText(), constraint});
                }
                NullabilityAnnotationInfo info = NullableNotNullManager.getInstance((Project)method.getProject()).findEffectiveNullabilityInfo((PsiModifierListOwner)parameter);
                if (info != null && info.getNullability() == Nullability.NOT_NULL) {
                    return JavaAnalysisBundle.message((String)(info.isInferred() ? "inspection.contract.checker.inferred.notnull.parameter.notnull" : "inspection.contract.checker.notnull.parameter.notnull"), (Object[])new Object[]{parameter.getName(), constraint});
                }
                return null;
            }
            case TRUE_VALUE: 
            case FALSE_VALUE: {
                if (!PsiTypes.booleanType().equals((Object)type) && !type.equalsToText("java.lang.Boolean")) {
                    return JavaAnalysisBundle.message((String)"inspection.contract.checker.boolean.condition.for.nonboolean.parameter", (Object[])new Object[]{parameter.getName(), type.getPresentableText()});
                }
                return null;
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/dataFlow/ContractInspection", "buildVisitor"));
    }
}

