/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.MutationSignature;
import com.intellij.codeInspection.dataFlow.SideEffectHandlers;
import com.intellij.codeInspection.dataFlow.java.JavaDfaValueFactory;
import com.intellij.codeInspection.dataFlow.jvm.descriptors.ThisDescriptor;
import com.intellij.codeInspection.dataFlow.memory.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.value.DfaTypeValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.util.ArrayUtil;
import com.siyeh.ig.psiutils.MethodCallUtils;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DfaCallArguments {
    final DfaValue myQualifier;
    final DfaValue[] myArguments;
    @NotNull
    final MutationSignature myMutation;

    public DfaCallArguments(DfaValue qualifier, DfaValue[] arguments, @NotNull MutationSignature mutation) {
        if (mutation == null) {
            DfaCallArguments.$$$reportNull$$$0(0);
        }
        this.myQualifier = qualifier;
        this.myArguments = arguments;
        this.myMutation = mutation;
    }

    public DfaValue getQualifier() {
        return this.myQualifier;
    }

    public DfaValue[] getArguments() {
        return this.myArguments;
    }

    public DfaCallArguments makeTransparent() {
        return this.myMutation == MutationSignature.transparent() ? this : new DfaCallArguments(this.myQualifier, this.myArguments, MutationSignature.transparent());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DfaCallArguments)) return false;
        DfaCallArguments that = (DfaCallArguments)o;
        if (this.myQualifier != that.myQualifier) return false;
        if (!this.myMutation.equals(that.myMutation)) return false;
        if (!Arrays.equals(this.myArguments, that.myArguments)) return false;
        return true;
    }

    public int hashCode() {
        return (Objects.hashCode(this.myQualifier) * 31 + Arrays.hashCode(this.myArguments)) * 31 + this.myMutation.hashCode();
    }

    public String toString() {
        return String.valueOf(this.myQualifier) + ".call(" + StringUtil.join(Arrays.asList(this.myArguments), (String)", ") + ")";
    }

    public DfaValue[] toArray() {
        if (this.myArguments == null || this.myQualifier == null) {
            return DfaValue.EMPTY_ARRAY;
        }
        return (DfaValue[])ArrayUtil.prepend((Object)this.myQualifier, (Object[])this.myArguments);
    }

    public void flush(@NotNull DfaMemoryState state, @NotNull DfaValueFactory factory, @Nullable PsiMethod method) {
        SideEffectHandlers.SideEffectHandler handler;
        if (state == null) {
            DfaCallArguments.$$$reportNull$$$0(1);
        }
        if (factory == null) {
            DfaCallArguments.$$$reportNull$$$0(2);
        }
        if ((handler = SideEffectHandlers.getHandler(method)) != null) {
            handler.handleSideEffect(factory, state, this);
            return;
        }
        if (this.myMutation.isTransparent()) {
            return;
        }
        if (this.myMutation.isPure()) {
            if (this.myQualifier instanceof DfaVariableValue) {
                Object qualifier = method != null && method.isConstructor() ? ThisDescriptor.createThisValue(factory, method.getContainingClass()) : this.myQualifier;
                state.flushVariables(arg_0 -> DfaCallArguments.lambda$flush$0((DfaValue)qualifier, method, arg_0));
            }
            return;
        }
        if (this.myMutation == MutationSignature.UNKNOWN || this.myArguments == null) {
            state.flushFields();
            return;
        }
        HashSet<DfaValue> qualifiers = new HashSet<DfaValue>();
        if (this.myQualifier != null && this.myMutation.mutatesThis()) {
            qualifiers.add(this.myQualifier);
        }
        for (int i = 0; i < this.myArguments.length; ++i) {
            if (!this.myMutation.mutatesArg(i)) continue;
            qualifiers.add(this.myArguments[i]);
        }
        state.flushFieldsQualifiedBy(qualifiers);
    }

    @Nullable
    static DfaCallArguments fromCall(DfaValueFactory factory, PsiCallExpression call) {
        PsiMethod method = call.resolveMethod();
        if (method == null) {
            return null;
        }
        PsiExpressionList argumentList = call.getArgumentList();
        if (argumentList == null) {
            return null;
        }
        DfaTypeValue qualifierValue = null;
        if (call instanceof PsiMethodCallExpression) {
            PsiExpression qualifier = ((PsiMethodCallExpression)call).getMethodExpression().getQualifierExpression();
            qualifierValue = JavaDfaValueFactory.getExpressionDfaValue(factory, qualifier);
        }
        if (qualifierValue == null) {
            qualifierValue = factory.getUnknown();
        }
        boolean varArgCall = MethodCallUtils.isVarArgCall((PsiCall)call);
        PsiExpression[] args = argumentList.getExpressions();
        PsiParameterList parameterList = method.getParameterList();
        if (parameterList.isEmpty()) {
            return new DfaCallArguments((DfaValue)qualifierValue, DfaValue.EMPTY_ARRAY, MutationSignature.fromCall((PsiCall)call));
        }
        PsiParameter[] parameters = parameterList.getParameters();
        DfaValue[] argValues = new DfaValue[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            DfaTypeValue argValue = null;
            if (!(i >= args.length || varArgCall && i >= parameters.length - 1)) {
                argValue = JavaDfaValueFactory.getExpressionDfaValue(factory, args[i]);
            }
            if (argValue == null) {
                argValue = factory.getUnknown();
            }
            argValues[i] = argValue;
        }
        return new DfaCallArguments((DfaValue)qualifierValue, argValues, MutationSignature.fromCall((PsiCall)call));
    }

    private static /* synthetic */ boolean lambda$flush$0(DfaValue qualifier, PsiMethod method, DfaVariableValue v) {
        PsiMember member;
        PsiElement patt0$temp;
        return v.getQualifier() == qualifier && (patt0$temp = v.getPsiVariable()) instanceof PsiMember && (member = (PsiMember)patt0$temp) != method && member.hasModifierProperty("private") && !member.hasModifierProperty("final");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mutation";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInspection/dataFlow/DfaCallArguments";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "flush";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

