/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.Nullability;
import com.intellij.codeInsight.NullabilityAnnotationInfo;
import com.intellij.codeInsight.NullabilitySource;
import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInsight.TypeNullability;
import com.intellij.codeInsight.daemon.impl.analysis.JavaGenericsUtil;
import com.intellij.codeInspection.dataFlow.ContractValue;
import com.intellij.codeInspection.dataFlow.DfaUtil;
import com.intellij.codeInspection.dataFlow.JavaMethodContractUtil;
import com.intellij.codeInspection.dataFlow.MethodContract;
import com.intellij.codeInspection.dataFlow.StandardMethodContract;
import com.intellij.codeInspection.dataFlow.interpreter.RunnerResult;
import com.intellij.codeInspection.dataFlow.interpreter.StandardDataFlowInterpreter;
import com.intellij.codeInspection.dataFlow.java.ControlFlowAnalyzer;
import com.intellij.codeInspection.dataFlow.java.JavaDfaListener;
import com.intellij.codeInspection.dataFlow.java.inst.MethodCallInstruction;
import com.intellij.codeInspection.dataFlow.jvm.descriptors.PlainDescriptor;
import com.intellij.codeInspection.dataFlow.lang.DfaListener;
import com.intellij.codeInspection.dataFlow.lang.ir.ControlFlow;
import com.intellij.codeInspection.dataFlow.lang.ir.DfaInstructionState;
import com.intellij.codeInspection.dataFlow.lang.ir.Instruction;
import com.intellij.codeInspection.dataFlow.lang.ir.ReturnInstruction;
import com.intellij.codeInspection.dataFlow.memory.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.memory.DfaMemoryStateImpl;
import com.intellij.codeInspection.dataFlow.types.DfConstantType;
import com.intellij.codeInspection.dataFlow.types.DfNullConstantType;
import com.intellij.codeInspection.dataFlow.types.DfPrimitiveType;
import com.intellij.codeInspection.dataFlow.types.DfReferenceType;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.types.DfTypes;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.codeInspection.dataFlow.value.RelationType;
import com.intellij.codeInspection.util.OptionalUtil;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiRecordComponent;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.impl.light.LightCompactConstructorParameter;
import com.intellij.psi.impl.light.LightRecordField;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.DeepestSuperMethodsSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.Stack;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DfaPsiUtil {
    private static final Logger LOG = Logger.getInstance(DfaPsiUtil.class);
    private static final CallMatcher NON_NULL_VAR_ARG = CallMatcher.anyOf(CallMatcher.staticCall("java.util.List", "of"), CallMatcher.staticCall("java.util.Set", "of"), CallMatcher.staticCall("java.util.Map", "ofEntries"));

    public static boolean isFinalField(PsiVariable var) {
        return var.hasModifierProperty("final") && !var.hasModifierProperty("transient") && var instanceof PsiField;
    }

    @Deprecated
    @NotNull
    public static Nullability getElementNullability(@Nullable PsiType resultType, @Nullable PsiModifierListOwner owner) {
        return DfaPsiUtil.getElementNullability(resultType, owner, false);
    }

    @NotNull
    public static Nullability getElementNullabilityForWrite(@Nullable PsiType resultType, @Nullable PsiModifierListOwner owner) {
        return DfaPsiUtil.getElementNullability(resultType, owner, false);
    }

    @NotNull
    public static Nullability getElementNullabilityForRead(@Nullable PsiType resultType, @Nullable PsiModifierListOwner owner) {
        return DfaPsiUtil.getElementNullability(resultType, owner, true);
    }

    @NotNull
    private static Nullability getElementNullability(@Nullable PsiType resultType, @Nullable PsiModifierListOwner owner, boolean forRead) {
        PsiField field;
        PsiMethod method;
        PsiParameter parameter;
        Nullability nullability;
        if (owner == null) {
            return DfaPsiUtil.getTypeNullability(resultType, forRead);
        }
        if (resultType instanceof PsiPrimitiveType) {
            Nullability nullability2 = Nullability.UNKNOWN;
            if (nullability2 == null) {
                DfaPsiUtil.$$$reportNull$$$0(0);
            }
            return nullability2;
        }
        if (owner instanceof PsiEnumConstant) {
            Nullability nullability3 = Nullability.NOT_NULL;
            if (nullability3 == null) {
                DfaPsiUtil.$$$reportNull$$$0(1);
            }
            return nullability3;
        }
        Project project = owner.getProject();
        if (DumbService.isDumb((Project)project)) {
            Nullability nullability4 = Nullability.UNKNOWN;
            if (nullability4 == null) {
                DfaPsiUtil.$$$reportNull$$$0(2);
            }
            return nullability4;
        }
        NullabilityAnnotationInfo fromAnnotation = DfaPsiUtil.getNullabilityFromAnnotation(owner, forRead);
        if (fromAnnotation != null) {
            PsiType type;
            if (resultType != null && fromAnnotation.getNullability() != Nullability.NOT_NULL && (type = PsiUtil.getTypeByPsiElement((PsiElement)owner)) != null) {
                PsiAnnotationOwner annotationOwner = fromAnnotation.getAnnotation().getOwner();
                PsiClass psiClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)type);
                if (psiClass instanceof PsiTypeParameter) {
                    PsiTypeParameter tp = (PsiTypeParameter)psiClass;
                    if (annotationOwner instanceof PsiType && annotationOwner != type && !tp.equals((Object)PsiUtil.resolveClassInClassTypeOnly((PsiType)resultType))) {
                        return DfaPsiUtil.getTypeNullability(resultType, forRead);
                    }
                }
            }
            Nullability nullability5 = fromAnnotation.getNullability();
            if (nullability5 == null) {
                DfaPsiUtil.$$$reportNull$$$0(3);
            }
            return nullability5;
        }
        if (owner instanceof PsiMethod) {
            PsiMethod method2 = (PsiMethod)owner;
            if (DfaPsiUtil.isEnumPredefinedMethod(method2)) {
                Nullability nullability6 = Nullability.NOT_NULL;
                if (nullability6 == null) {
                    DfaPsiUtil.$$$reportNull$$$0(4);
                }
                return nullability6;
            }
            if (DfaPsiUtil.isMapMethodWithUnknownNullity(method2)) {
                Nullability nullability7 = DfaPsiUtil.getTypeNullability(resultType) == Nullability.NULLABLE ? Nullability.NULLABLE : Nullability.UNKNOWN;
                if (nullability7 == null) {
                    DfaPsiUtil.$$$reportNull$$$0(5);
                }
                return nullability7;
            }
        }
        if (owner instanceof PsiParameter && (nullability = DfaPsiUtil.inferParameterNullability(parameter = (PsiParameter)owner)) != Nullability.UNKNOWN) {
            Nullability nullability8 = nullability;
            if (nullability8 == null) {
                DfaPsiUtil.$$$reportNull$$$0(6);
            }
            return nullability8;
        }
        Nullability fromType = DfaPsiUtil.getNullabilityFromType(resultType, owner);
        if (fromType != null) {
            Nullability nullability9 = fromType;
            if (nullability9 == null) {
                DfaPsiUtil.$$$reportNull$$$0(7);
            }
            return nullability9;
        }
        if (owner instanceof PsiMethod && (method = (PsiMethod)owner).getParameterList().isEmpty() && forRead && (field = PropertyUtil.getFieldOfGetter(method)) != null && DfaPsiUtil.getElementNullabilityForRead(resultType, (PsiModifierListOwner)field) == Nullability.NULLABLE) {
            Nullability nullability10 = Nullability.NULLABLE;
            if (nullability10 == null) {
                DfaPsiUtil.$$$reportNull$$$0(8);
            }
            return nullability10;
        }
        Nullability nullability11 = Nullability.UNKNOWN;
        if (nullability11 == null) {
            DfaPsiUtil.$$$reportNull$$$0(9);
        }
        return nullability11;
    }

    @Nullable
    private static Nullability getNullabilityFromType(@Nullable PsiType resultType, @NotNull PsiModifierListOwner owner) {
        if (owner == null) {
            DfaPsiUtil.$$$reportNull$$$0(10);
        }
        if (resultType == null) {
            return null;
        }
        TypeNullability typeNullability = resultType.getNullability();
        if (typeNullability.equals((Object)TypeNullability.UNKNOWN)) {
            return null;
        }
        Nullability fromType = typeNullability.nullability();
        if (fromType == Nullability.NOT_NULL && DfaPsiUtil.hasNullContract(owner)) {
            return Nullability.UNKNOWN;
        }
        return fromType;
    }

    private static boolean hasNullContract(@NotNull PsiModifierListOwner owner) {
        PsiParameter parameter;
        PsiElement psiElement;
        if (owner == null) {
            DfaPsiUtil.$$$reportNull$$$0(11);
        }
        if (owner instanceof PsiParameter && (psiElement = (parameter = (PsiParameter)owner).getDeclarationScope()) instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)psiElement;
            int index = method.getParameterList().getParameterIndex(parameter);
            List<StandardMethodContract> contracts = JavaMethodContractUtil.getMethodContracts(method);
            return ContainerUtil.exists(contracts, c -> c.getParameterConstraint(index) == StandardMethodContract.ValueConstraint.NULL_VALUE);
        }
        return false;
    }

    @Nullable
    private static NullabilityAnnotationInfo getNullabilityFromAnnotation(@NotNull PsiModifierListOwner owner, boolean ignoreParameterNullabilityInference) {
        NullableNotNullManager manager;
        NullabilityAnnotationInfo info;
        if (owner == null) {
            DfaPsiUtil.$$$reportNull$$$0(12);
        }
        if ((info = (manager = NullableNotNullManager.getInstance((Project)owner.getProject())).findEffectiveNullabilityInfo(owner)) == null || DfaPsiUtil.shouldIgnoreAnnotation(info.getAnnotation())) {
            return null;
        }
        if (ignoreParameterNullabilityInference && owner instanceof PsiParameter && info.isInferred()) {
            List supers = AnnotationUtil.getSuperAnnotationOwners((PsiModifierListOwner)((PsiParameter)owner));
            return StreamEx.of((Collection)supers).map(param -> manager.findEffectiveNullabilityInfo((PsiModifierListOwner)param)).findFirst(i -> i != null && i.getInheritedFrom() == null && i.getNullability() == Nullability.NULLABLE).orElse(null);
        }
        return info;
    }

    private static boolean isMapMethodWithUnknownNullity(@NotNull PsiMethod method) {
        String name;
        if (method == null) {
            DfaPsiUtil.$$$reportNull$$$0(13);
        }
        if (!"get".equals(name = method.getName()) && !"remove".equals(name)) {
            return false;
        }
        PsiMethod superMethod = (PsiMethod)DeepestSuperMethodsSearch.search((PsiMethod)method).findFirst();
        return ("java.util.Map." + name).equals(PsiUtil.getMemberQualifiedName((PsiMember)(superMethod != null ? superMethod : method)));
    }

    @NotNull
    public static Nullability inferParameterNullability(@NotNull PsiParameter parameter) {
        PsiElement parent;
        if (parameter == null) {
            DfaPsiUtil.$$$reportNull$$$0(14);
        }
        if ((parent = parameter.getParent()) instanceof PsiParameterList) {
            PsiElement gParent = parent.getParent();
            if (gParent instanceof PsiLambdaExpression) {
                return DfaPsiUtil.getFunctionalParameterNullability((PsiFunctionalExpression)((PsiLambdaExpression)gParent), ((PsiParameterList)parent).getParameterIndex(parameter));
            }
            if (gParent instanceof PsiMethod && OptionalUtil.OPTIONAL_OF_NULLABLE.methodMatches((PsiMethod)gParent)) {
                Nullability nullability = Nullability.NULLABLE;
                if (nullability == null) {
                    DfaPsiUtil.$$$reportNull$$$0(15);
                }
                return nullability;
            }
        }
        if (parent instanceof PsiForeachStatement) {
            return DfaPsiUtil.getTypeNullability(DfaPsiUtil.inferLoopParameterTypeWithNullability((PsiForeachStatement)parent));
        }
        Nullability nullability = Nullability.UNKNOWN;
        if (nullability == null) {
            DfaPsiUtil.$$$reportNull$$$0(16);
        }
        return nullability;
    }

    @Nullable
    private static PsiType inferLoopParameterTypeWithNullability(PsiForeachStatement loop) {
        PsiForeachStatement targetLoop;
        PsiParameter parameter;
        PsiReferenceExpression refExpr;
        PsiElement psiElement;
        PsiExpression iteratedValue = PsiUtil.skipParenthesizedExprDown((PsiExpression)loop.getIteratedValue());
        if (iteratedValue == null) {
            return null;
        }
        PsiType iteratedType = iteratedValue.getType();
        if (iteratedValue instanceof PsiReferenceExpression && (psiElement = (refExpr = (PsiReferenceExpression)iteratedValue).resolve()) instanceof PsiParameter && (psiElement = (parameter = (PsiParameter)psiElement).getParent()) instanceof PsiForeachStatement && PsiTreeUtil.isAncestor((PsiElement)(targetLoop = (PsiForeachStatement)psiElement), (PsiElement)loop, (boolean)true) && !ControlFlowUtil.isReassigned((PsiVariable)parameter, new HashMap())) {
            iteratedType = DfaPsiUtil.inferLoopParameterTypeWithNullability(targetLoop);
        }
        return JavaGenericsUtil.getCollectionItemType((PsiType)iteratedType, (GlobalSearchScope)iteratedValue.getResolveScope());
    }

    @NotNull
    private static Nullability getTypeNullability(@Nullable PsiType type, boolean forRead) {
        if (type == null) {
            Nullability nullability = Nullability.UNKNOWN;
            if (nullability == null) {
                DfaPsiUtil.$$$reportNull$$$0(17);
            }
            return nullability;
        }
        if (type instanceof PsiCapturedWildcardType) {
            PsiCapturedWildcardType captured = (PsiCapturedWildcardType)type;
            if (!forRead) {
                NullabilityAnnotationInfo defaultNullability;
                PsiElement context;
                NullableNotNullManager manager;
                TypeNullability nullability = captured.getLowerBound().getNullability();
                if (nullability.source() instanceof NullabilitySource.ExtendsBound && (manager = NullableNotNullManager.getInstance((Project)(context = captured.getContext()).getProject())) != null && (defaultNullability = manager.findDefaultTypeUseNullability(context)) != null && defaultNullability.getNullability() == Nullability.NOT_NULL) {
                    Nullability nullability2 = Nullability.NOT_NULL;
                    if (nullability2 == null) {
                        DfaPsiUtil.$$$reportNull$$$0(18);
                    }
                    return nullability2;
                }
                Nullability nullability3 = nullability.nullability();
                if (nullability3 == null) {
                    DfaPsiUtil.$$$reportNull$$$0(19);
                }
                return nullability3;
            }
        }
        Nullability nullability = type.getNullability().nullability();
        if (nullability == null) {
            DfaPsiUtil.$$$reportNull$$$0(20);
        }
        return nullability;
    }

    @NotNull
    public static Nullability getTypeNullability(@Nullable PsiType type) {
        if (type == null) {
            Nullability nullability = Nullability.UNKNOWN;
            if (nullability == null) {
                DfaPsiUtil.$$$reportNull$$$0(21);
            }
            return nullability;
        }
        Nullability nullability = type.getNullability().nullability();
        if (nullability == null) {
            DfaPsiUtil.$$$reportNull$$$0(22);
        }
        return nullability;
    }

    @Nullable
    public static NullabilityAnnotationInfo getTypeNullabilityInfo(@Nullable PsiType type) {
        if (type == null || type instanceof PsiPrimitiveType) {
            return null;
        }
        return type.getNullability().toNullabilityAnnotationInfo();
    }

    private static boolean shouldIgnoreAnnotation(PsiAnnotation annotation) {
        PsiClass containingClass = PsiUtil.getContainingClass((PsiElement)annotation);
        if (containingClass == null || !containingClass.isValid()) {
            return false;
        }
        String qualifiedName = containingClass.getQualifiedName();
        return "com.google.common.base.Predicate".equals(qualifiedName) || "com.google.common.base.Function".equals(qualifiedName);
    }

    @NotNull
    public static Nullability getFunctionalParameterNullability(PsiFunctionalExpression function, int index) {
        PsiParameter parameter;
        PsiClassType type = (PsiClassType)ObjectUtils.tryCast((Object)LambdaUtil.getFunctionalInterfaceType((PsiElement)function, (boolean)true), PsiClassType.class);
        PsiMethod sam = LambdaUtil.getFunctionalInterfaceMethod((PsiType)type);
        if (sam != null && (parameter = sam.getParameterList().getParameter(index)) != null) {
            TypeNullability typeNullability;
            PsiType parameterType = type.resolveGenerics().getSubstitutor().substitute(parameter.getType());
            if (parameterType instanceof PsiWildcardType) {
                PsiWildcardType wildcardType = (PsiWildcardType)parameterType;
                parameterType = wildcardType.getBound();
            }
            if (parameterType != null && !(typeNullability = parameterType.getNullability()).equals((Object)TypeNullability.UNKNOWN)) {
                Nullability nullability = typeNullability.nullability();
                if (nullability == null) {
                    DfaPsiUtil.$$$reportNull$$$0(23);
                }
                return nullability;
            }
            return DfaPsiUtil.getElementNullabilityForWrite(null, (PsiModifierListOwner)parameter);
        }
        Nullability nullability = Nullability.UNKNOWN;
        if (nullability == null) {
            DfaPsiUtil.$$$reportNull$$$0(24);
        }
        return nullability;
    }

    private static boolean isEnumPredefinedMethod(PsiMethod method) {
        return CallMatcher.enumValueOf().methodMatches(method) || CallMatcher.enumValues().methodMatches(method);
    }

    public static boolean isInitializedNotNull(PsiField field) {
        PsiClass containingClass = field.getContainingClass();
        if (containingClass == null) {
            return false;
        }
        boolean staticField = field.hasModifierProperty("static");
        for (PsiClassInitializer initializer : containingClass.getInitializers()) {
            if (!initializer.getLanguage().isKindOf((Language)JavaLanguage.INSTANCE) || initializer.hasModifierProperty("static") != staticField || !DfaPsiUtil.getBlockNotNullFields(initializer.getBody()).contains(field)) continue;
            return true;
        }
        if (staticField) {
            return false;
        }
        PsiMethod[] constructors = containingClass.getConstructors();
        if (constructors.length == 0) {
            return false;
        }
        for (PsiMethod method : constructors) {
            if (method.getLanguage().isKindOf((Language)JavaLanguage.INSTANCE) && DfaPsiUtil.getBlockNotNullFields(method.getBody()).contains(field)) continue;
            return false;
        }
        return true;
    }

    private static Set<PsiField> getBlockNotNullFields(final PsiCodeBlock body) {
        if (body == null) {
            return Collections.emptySet();
        }
        return (Set)CachedValuesManager.getCachedValue((PsiElement)body, (CachedValueProvider)new CachedValueProvider<Set<PsiField>>(){

            @NotNull
            public CachedValueProvider.Result<Set<PsiField>> compute() {
                final PsiClass containingClass = (PsiClass)PsiTreeUtil.getContextOfType((PsiElement)body, (Class[])new Class[]{PsiClass.class});
                LOG.assertTrue(containingClass != null);
                DfaValueFactory factory = new DfaValueFactory(body.getProject());
                ControlFlow flow = ControlFlowAnalyzer.buildFlow((PsiElement)body, factory, true);
                if (flow == null) {
                    CachedValueProvider.Result result = CachedValueProvider.Result.create(Set.of(), (Object[])new Object[]{body, PsiModificationTracker.MODIFICATION_COUNT});
                    if (result == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return result;
                }
                flow.keepVariables(desc -> {
                    PsiField field;
                    PlainDescriptor plainDescriptor;
                    PsiVariable patt0$temp;
                    return desc instanceof PlainDescriptor && (patt0$temp = (plainDescriptor = (PlainDescriptor)desc).getPsiElement()) instanceof PsiField && (field = (PsiField)patt0$temp).getContainingClass() == containingClass;
                });
                var interpreter = new StandardDataFlowInterpreter(this, flow, DfaListener.EMPTY){
                    final Map<PsiField, Boolean> map;
                    {
                        super(arg0, arg1);
                        this.map = new HashMap<PsiField, Boolean>();
                    }

                    private boolean isCallExposingNonInitializedFields(Instruction instruction) {
                        PsiExpression qualifier;
                        if (!(instruction instanceof MethodCallInstruction)) {
                            return false;
                        }
                        PsiCall call = ((MethodCallInstruction)instruction).getCallExpression();
                        if (call == null) {
                            return false;
                        }
                        if (call instanceof PsiNewExpression && this.canAccessFields((PsiExpression)call)) {
                            return true;
                        }
                        if (call instanceof PsiMethodCallExpression && ((qualifier = ((PsiMethodCallExpression)call).getMethodExpression().getQualifierExpression()) == null || this.canAccessFields(qualifier))) {
                            return true;
                        }
                        PsiExpressionList argumentList = call.getArgumentList();
                        if (argumentList != null) {
                            for (PsiExpression expression : argumentList.getExpressions()) {
                                if (!this.canAccessFields(expression)) continue;
                                return true;
                            }
                        }
                        return false;
                    }

                    private boolean canAccessFields(PsiExpression expression) {
                        PsiClass type = PsiUtil.resolveClassInClassTypeOnly((PsiType)expression.getType());
                        JBIterable typeContainers = JBIterable.generate((Object)type, PsiClass::getContainingClass).takeWhile(c -> !c.hasModifierProperty("static"));
                        return typeContainers.contains((Object)containingClass);
                    }

                    protected DfaInstructionState @NotNull [] acceptInstruction(@NotNull DfaInstructionState instructionState) {
                        Instruction instruction;
                        if (instructionState == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (this.isCallExposingNonInitializedFields(instruction = instructionState.getInstruction()) || instruction instanceof ReturnInstruction) {
                            for (PsiField field : containingClass.getFields()) {
                                DfaVariableValue value = PlainDescriptor.createVariableValue(this.getFactory(), (PsiVariable)field);
                                DfType dfType = instructionState.getMemoryState().getDfType((DfaValue)value);
                                if (dfType.isSuperType((DfType)DfTypes.NULL)) {
                                    this.map.put(field, false);
                                    continue;
                                }
                                if (this.map.containsKey(field)) continue;
                                this.map.put(field, true);
                            }
                            if (DfaInstructionState.EMPTY_ARRAY == null) {
                                1.$$$reportNull$$$0(1);
                            }
                            return DfaInstructionState.EMPTY_ARRAY;
                        }
                        DfaInstructionState[] dfaInstructionStateArray = super.acceptInstruction(instructionState);
                        if (dfaInstructionStateArray == null) {
                            1.$$$reportNull$$$0(2);
                        }
                        return dfaInstructionStateArray;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2;
                        Object[] objectArray3 = new Object[switch (n) {
                            default -> 3;
                            case 1, 2 -> 2;
                        }];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "instructionState";
                                break;
                            }
                            case 1: 
                            case 2: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "com/intellij/codeInspection/dataFlow/DfaPsiUtil$1$1";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[1] = "com/intellij/codeInspection/dataFlow/DfaPsiUtil$1$1";
                                break;
                            }
                            case 1: 
                            case 2: {
                                objectArray = objectArray2;
                                objectArray2[1] = "acceptInstruction";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                objectArray = objectArray;
                                objectArray[2] = "acceptInstruction";
                                break;
                            }
                            case 1: 
                            case 2: {
                                break;
                            }
                        }
                        String string = String.format(v0, objectArray);
                        throw switch (n) {
                            default -> new IllegalArgumentException(string);
                            case 1, 2 -> new IllegalStateException(string);
                        };
                    }
                };
                DfaMemoryState state = DfaUtil.createStateWithEnabledAssertions(factory);
                RunnerResult rc = interpreter.interpret(state);
                HashSet notNullFields = new HashSet();
                if (rc == RunnerResult.OK) {
                    interpreter.map.forEach((key, value) -> {
                        if (value.booleanValue()) {
                            notNullFields.add(key);
                        }
                    });
                }
                CachedValueProvider.Result result = CachedValueProvider.Result.create(notNullFields, (Object[])new Object[]{body, PsiModificationTracker.MODIFICATION_COUNT});
                if (result == null) {
                    1.$$$reportNull$$$0(1);
                }
                return result;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DfaPsiUtil$1", "compute"));
            }
        });
    }

    @NotNull
    public static List<PsiExpression> findAllConstructorInitializers(@NotNull PsiField field) {
        if (field == null) {
            DfaPsiUtil.$$$reportNull$$$0(25);
        }
        List result = ContainerUtil.createLockFreeCopyOnWriteList();
        ContainerUtil.addIfNotNull((Collection)result, (Object)field.getInitializer());
        PsiClass containingClass = field.getContainingClass();
        if (containingClass != null && !(containingClass instanceof PsiCompiledElement)) {
            result.addAll(DfaPsiUtil.getAllConstructorFieldInitializers(containingClass).get((Object)field));
        }
        List list = result;
        if (list == null) {
            DfaPsiUtil.$$$reportNull$$$0(26);
        }
        return list;
    }

    @NotNull
    static List<PsiExpression> findAllConstructorInitializers(@NotNull PsiRecordComponent component) {
        PsiClass containingClass;
        if (component == null) {
            DfaPsiUtil.$$$reportNull$$$0(27);
        }
        return (containingClass = component.getContainingClass()) == null || containingClass instanceof PsiCompiledElement ? Collections.emptyList() : new ArrayList(DfaPsiUtil.getAllConstructorFieldInitializers(containingClass).get((Object)component));
    }

    private static MultiMap<PsiVariable, PsiExpression> getAllConstructorFieldInitializers(final PsiClass psiClass) {
        if (psiClass instanceof PsiCompiledElement) {
            return MultiMap.empty();
        }
        return (MultiMap)CachedValuesManager.getCachedValue((PsiElement)psiClass, (CachedValueProvider)new CachedValueProvider<MultiMap<PsiVariable, PsiExpression>>(){

            @NotNull
            public CachedValueProvider.Result<MultiMap<PsiVariable, PsiExpression>> compute() {
                final HashSet fieldNames = new HashSet();
                for (PsiField field : psiClass.getFields()) {
                    ContainerUtil.addIfNotNull(fieldNames, (Object)field.getName());
                }
                final MultiMap result = new MultiMap();
                JavaRecursiveElementWalkingVisitor visitor2 = new JavaRecursiveElementWalkingVisitor(){

                    public void visitAssignmentExpression(@NotNull PsiAssignmentExpression assignment) {
                        PsiReferenceExpression ref;
                        PsiExpression psiExpression;
                        if (assignment == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        super.visitAssignmentExpression(assignment);
                        PsiExpression rExpression = assignment.getRExpression();
                        if (rExpression != null && (psiExpression = assignment.getLExpression()) instanceof PsiReferenceExpression && fieldNames.contains((ref = (PsiReferenceExpression)psiExpression).getReferenceName())) {
                            PsiField field;
                            PsiElement target = ref.resolve();
                            if (target instanceof PsiField && (field = (PsiField)target).getContainingClass() == psiClass) {
                                PsiField psiField;
                                if (field instanceof LightRecordField) {
                                    LightRecordField f = (LightRecordField)field;
                                    psiField = f.getRecordComponent();
                                } else {
                                    psiField = field;
                                }
                                result.putValue((Object)psiField, (Object)rExpression);
                            } else if (target instanceof LightCompactConstructorParameter) {
                                LightCompactConstructorParameter parameter = (LightCompactConstructorParameter)target;
                                result.putValue((Object)parameter.getRecordComponent(), (Object)rExpression);
                            }
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "assignment", "com/intellij/codeInspection/dataFlow/DfaPsiUtil$2$1", "visitAssignmentExpression"));
                    }
                };
                for (PsiMethod psiMethod : psiClass.getConstructors()) {
                    if (!psiMethod.getLanguage().isKindOf((Language)JavaLanguage.INSTANCE)) continue;
                    psiMethod.accept((PsiElementVisitor)visitor2);
                }
                for (PsiMethod psiMethod : psiClass.getInitializers()) {
                    if (!psiMethod.getLanguage().isKindOf((Language)JavaLanguage.INSTANCE)) continue;
                    psiMethod.accept((PsiElementVisitor)visitor2);
                }
                CachedValueProvider.Result result2 = CachedValueProvider.Result.create((Object)result, (Object[])new Object[]{psiClass});
                if (result2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                return result2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DfaPsiUtil$2", "compute"));
            }
        });
    }

    @Nullable
    public static PsiElement getTopmostBlockInSameClass(@NotNull PsiElement position) {
        if (position == null) {
            DfaPsiUtil.$$$reportNull$$$0(28);
        }
        return (PsiElement)JBIterable.generate((Object)position, PsiElement::getParent).takeWhile(e -> !(e instanceof PsiMember) && !(e instanceof PsiFile) && !(e instanceof PsiLambdaExpression)).filter(e -> e instanceof PsiCodeBlock || e instanceof PsiExpression && e.getParent() instanceof PsiLambdaExpression).last();
    }

    @NotNull
    public static Collection<PsiExpression> getVariableAssignmentsInFile(@NotNull PsiVariable psiVariable, boolean literalsOnly, PsiElement place) {
        if (psiVariable == null) {
            DfaPsiUtil.$$$reportNull$$$0(29);
        }
        Ref modificationRef = Ref.create((Object)Boolean.FALSE);
        PsiElement codeBlock = place == null ? null : DfaPsiUtil.getTopmostBlockInSameClass(place);
        int placeOffset = codeBlock != null ? place.getTextRange().getStartOffset() : 0;
        PsiFile containingFile = psiVariable.getContainingFile();
        LocalSearchScope scope = new LocalSearchScope(new PsiElement[]{containingFile}, null, true);
        Collection references = ReferencesSearch.search((PsiElement)psiVariable, (SearchScope)scope).findAll();
        List list = ContainerUtil.mapNotNull((Collection)references, (Function)((NullableFunction)psiReference -> {
            if (((Boolean)modificationRef.get()).booleanValue()) {
                return null;
            }
            PsiElement parent = psiReference.getElement().getParent();
            if (parent instanceof PsiAssignmentExpression) {
                PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)parent;
                IElementType operation = assignmentExpression.getOperationTokenType();
                if (assignmentExpression.getLExpression() == psiReference) {
                    if (JavaTokenType.EQ.equals(operation)) {
                        PsiExpression rValue = assignmentExpression.getRExpression();
                        if (!literalsOnly || DfaPsiUtil.allOperandsAreLiterals(rValue)) {
                            if (PsiTreeUtil.isAncestor((PsiElement)codeBlock, (PsiElement)parent, (boolean)true) && placeOffset < parent.getTextRange().getStartOffset()) {
                                return null;
                            }
                            return rValue;
                        }
                        modificationRef.set((Object)Boolean.TRUE);
                    } else if (JavaTokenType.PLUSEQ.equals(operation)) {
                        modificationRef.set((Object)Boolean.TRUE);
                    }
                }
            }
            return null;
        }));
        if (((Boolean)modificationRef.get()).booleanValue()) {
            List<PsiExpression> list2 = Collections.emptyList();
            if (list2 == null) {
                DfaPsiUtil.$$$reportNull$$$0(30);
            }
            return list2;
        }
        PsiExpression initializer = psiVariable.getInitializer();
        if (initializer != null && (!literalsOnly || DfaPsiUtil.allOperandsAreLiterals(initializer))) {
            list = ContainerUtil.concat((List)list, Collections.singletonList(initializer));
        }
        List list3 = list;
        if (list3 == null) {
            DfaPsiUtil.$$$reportNull$$$0(31);
        }
        return list3;
    }

    private static boolean allOperandsAreLiterals(@Nullable PsiExpression expression) {
        if (expression == null) {
            return false;
        }
        if (expression instanceof PsiLiteralExpression) {
            return true;
        }
        if (expression instanceof PsiPolyadicExpression) {
            Stack stack = new Stack();
            stack.add((Object)expression);
            while (!stack.isEmpty()) {
                PsiExpression psiExpression = (PsiExpression)stack.pop();
                if (psiExpression instanceof PsiPolyadicExpression) {
                    PsiPolyadicExpression binaryExpression = (PsiPolyadicExpression)psiExpression;
                    for (PsiExpression op : binaryExpression.getOperands()) {
                        stack.push((Object)op);
                    }
                    continue;
                }
                if (psiExpression instanceof PsiLiteralExpression) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @NotNull
    static Nullability getVarArgComponentNullability(PsiMethod method) {
        if (method != null) {
            PsiType type;
            if (NON_NULL_VAR_ARG.methodMatches(method)) {
                Nullability nullability = Nullability.NOT_NULL;
                if (nullability == null) {
                    DfaPsiUtil.$$$reportNull$$$0(32);
                }
                return nullability;
            }
            PsiParameter varArg = (PsiParameter)ArrayUtil.getLastElement((Object[])method.getParameterList().getParameters());
            if (varArg != null && (type = varArg.getType()) instanceof PsiEllipsisType) {
                PsiType componentType = ((PsiEllipsisType)type).getComponentType();
                return DfaPsiUtil.getTypeNullability(componentType);
            }
        }
        Nullability nullability = Nullability.UNKNOWN;
        if (nullability == null) {
            DfaPsiUtil.$$$reportNull$$$0(33);
        }
        return nullability;
    }

    public static PsiType tryGenerify(PsiExpression expression, PsiType type) {
        PsiClass aClass;
        if (!(type instanceof PsiClassType)) {
            return type;
        }
        PsiClassType classType = (PsiClassType)type;
        if (!classType.isRaw()) {
            return classType;
        }
        PsiClass psiClass = classType.resolve();
        if (psiClass == null) {
            return classType;
        }
        PsiType psiType = expression.getType();
        if (!(psiType instanceof PsiClassType)) {
            return classType;
        }
        PsiClassType expressionType = (PsiClassType)psiType;
        PsiClassType result = GenericsUtil.getExpectedGenericType((PsiElement)expression, (PsiClass)psiClass, (PsiClassType)expressionType);
        if (result.isRaw() && (aClass = result.resolve()) != null) {
            int length = aClass.getTypeParameters().length;
            PsiWildcardType wildcard = PsiWildcardType.createUnbounded((PsiManager)aClass.getManager());
            Object[] arguments = new PsiType[length];
            Arrays.fill(arguments, wildcard);
            return JavaPsiFacade.getElementFactory((Project)aClass.getProject()).createType(aClass, (PsiType[])arguments);
        }
        return result;
    }

    @NotNull
    public static DfType fromLiteral(@NotNull PsiLiteralExpression expr) {
        PsiType type;
        if (expr == null) {
            DfaPsiUtil.$$$reportNull$$$0(34);
        }
        if ((type = expr.getType()) == null) {
            DfType dfType = DfType.TOP;
            if (dfType == null) {
                DfaPsiUtil.$$$reportNull$$$0(35);
            }
            return dfType;
        }
        if (PsiTypes.nullType().equals(type)) {
            DfNullConstantType dfNullConstantType = DfTypes.NULL;
            if (dfNullConstantType == null) {
                DfaPsiUtil.$$$reportNull$$$0(36);
            }
            return dfNullConstantType;
        }
        Object value = expr.getValue();
        if (value == null) {
            DfType dfType = DfTypes.typedObject(type, Nullability.NOT_NULL);
            if (dfType == null) {
                DfaPsiUtil.$$$reportNull$$$0(37);
            }
            return dfType;
        }
        DfConstantType<?> dfConstantType = DfTypes.constant(value, type);
        if (dfConstantType == null) {
            DfaPsiUtil.$$$reportNull$$$0(38);
        }
        return dfConstantType;
    }

    @Nullable
    public static RelationType getRelationByToken(IElementType type) {
        if (JavaTokenType.EQEQ.equals(type)) {
            return RelationType.EQ;
        }
        if (JavaTokenType.NE.equals(type)) {
            return RelationType.NE;
        }
        if (JavaTokenType.LT.equals(type)) {
            return RelationType.LT;
        }
        if (JavaTokenType.GT.equals(type)) {
            return RelationType.GT;
        }
        if (JavaTokenType.LE.equals(type)) {
            return RelationType.LE;
        }
        if (JavaTokenType.GE.equals(type)) {
            return RelationType.GE;
        }
        if (JavaTokenType.INSTANCEOF_KEYWORD.equals(type)) {
            return RelationType.IS;
        }
        return null;
    }

    @Nullable
    public static PsiType dfTypeToPsiType(@NotNull Project project, @Nullable DfType dfType) {
        if (project == null) {
            DfaPsiUtil.$$$reportNull$$$0(39);
        }
        if (dfType instanceof DfPrimitiveType) {
            return ((DfPrimitiveType)dfType).getPsiType();
        }
        if (dfType instanceof DfReferenceType) {
            return ((DfReferenceType)dfType).getConstraint().getPsiType(project);
        }
        return null;
    }

    @NlsSafe
    public static String renderValue(Object value) {
        if (value == null) {
            return "null";
        }
        if (value instanceof String) {
            return "\"" + StringUtil.escapeStringCharacters((String)((String)value)) + "\"";
        }
        if (value instanceof Float) {
            return String.valueOf(value) + "f";
        }
        if (value instanceof Long) {
            return String.valueOf(value) + "L";
        }
        if (value instanceof PsiField) {
            PsiField field = (PsiField)value;
            PsiClass containingClass = field.getContainingClass();
            return containingClass == null ? field.getName() : containingClass.getName() + "." + field.getName();
        }
        if (value instanceof PsiType) {
            PsiType type = (PsiType)value;
            return type.getPresentableText();
        }
        return value.toString();
    }

    public static boolean isAssertionEffectively(@NotNull PsiExpression anchor, boolean expectedValue) {
        PsiStatement thenBranch;
        PsiIfStatement ifStatement;
        PsiElement parent;
        if (anchor == null) {
            DfaPsiUtil.$$$reportNull$$$0(40);
        }
        while (true) {
            boolean causesShortCircuit;
            PsiPolyadicExpression polyadic;
            IElementType tokenType;
            PsiExpression parentExpr;
            if ((parent = anchor.getParent()) instanceof PsiExpression && BoolUtils.isNegation(parentExpr = (PsiExpression)parent)) {
                expectedValue = !expectedValue;
                anchor = parentExpr;
                continue;
            }
            if (parent instanceof PsiParenthesizedExpression) {
                PsiParenthesizedExpression parenthesized = (PsiParenthesizedExpression)parent;
                anchor = parenthesized;
                continue;
            }
            if (!(parent instanceof PsiPolyadicExpression) || !(tokenType = (polyadic = (PsiPolyadicExpression)parent).getOperationTokenType()).equals(JavaTokenType.ANDAND) && !tokenType.equals(JavaTokenType.OROR)) break;
            boolean bl = causesShortCircuit = tokenType.equals(JavaTokenType.OROR) == expectedValue && ArrayUtil.getLastElement((Object[])polyadic.getOperands()) != anchor;
            if (causesShortCircuit) break;
            anchor = polyadic;
        }
        if (parent instanceof PsiAssertStatement) {
            return expectedValue;
        }
        if (parent instanceof PsiIfStatement && anchor == (ifStatement = (PsiIfStatement)parent).getCondition() && (thenBranch = ControlFlowUtils.stripBraces(ifStatement.getThenBranch())) instanceof PsiThrowStatement) {
            return !expectedValue;
        }
        return DfaPsiUtil.isAssertCallArgument((PsiElement)anchor, ContractValue.booleanValue(expectedValue));
    }

    public static boolean isAssertCallArgument(@NotNull PsiElement anchor, @NotNull ContractValue wantedConstraint) {
        ContractValue condition;
        MethodContract contract;
        PsiMethodCallExpression call;
        int index;
        PsiElement parent;
        if (anchor == null) {
            DfaPsiUtil.$$$reportNull$$$0(41);
        }
        if (wantedConstraint == null) {
            DfaPsiUtil.$$$reportNull$$$0(42);
        }
        if ((parent = PsiUtil.skipParenthesizedExprUp((PsiElement)anchor.getParent())) instanceof PsiExpressionList && (index = ArrayUtil.indexOf((Object[])((PsiExpressionList)parent).getExpressions(), (Object)anchor)) >= 0 && (call = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)parent.getParent(), PsiMethodCallExpression.class)) != null && (contract = (MethodContract)ContainerUtil.getOnlyItem(JavaMethodContractUtil.getMethodCallContracts((PsiCallExpression)call))) != null && contract.getReturnValue().isFail() && (condition = (ContractValue)ContainerUtil.getOnlyItem(contract.getConditions())) != null) {
            return condition.getArgumentComparedTo(wantedConstraint, false).orElse(-1) == index;
        }
        return false;
    }

    public static boolean mutuallyExclusive(@NotNull PsiExpression cond1, @NotNull PsiExpression cond2) {
        if (cond1 == null) {
            DfaPsiUtil.$$$reportNull$$$0(43);
        }
        if (cond2 == null) {
            DfaPsiUtil.$$$reportNull$$$0(44);
        }
        Project project = cond1.getProject();
        final PsiPolyadicExpression expr = (PsiPolyadicExpression)JavaPsiFacade.getElementFactory((Project)project).createExpressionFromText("a && b", (PsiElement)cond1);
        PsiExpression[] operands = expr.getOperands();
        operands[0].replace((PsiElement)cond1);
        operands[1].replace((PsiElement)cond2);
        DfaValueFactory factory = new DfaValueFactory(project);
        ControlFlow flow = ControlFlowAnalyzer.buildFlow((PsiElement)expr, factory, true);
        if (flow == null) {
            return false;
        }
        var listener = new JavaDfaListener(){
            final Set<DfType> results = new HashSet<DfType>();

            @Override
            public void beforeExpressionPush(@NotNull DfaValue value, @NotNull PsiExpression expression, @NotNull DfaMemoryState state) {
                if (value == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (expression == null) {
                    3.$$$reportNull$$$0(1);
                }
                if (state == null) {
                    3.$$$reportNull$$$0(2);
                }
                if (expression == expr) {
                    this.results.add(value.getDfType());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "value";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "expression";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "state";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/codeInspection/dataFlow/DfaPsiUtil$3";
                objectArray[2] = "beforeExpressionPush";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        StandardDataFlowInterpreter interpreter = new StandardDataFlowInterpreter(flow, (DfaListener)listener);
        if (interpreter.interpret((DfaMemoryState)new DfaMemoryStateImpl(factory)) != RunnerResult.OK) {
            return false;
        }
        return DfTypes.FALSE.equals(ContainerUtil.getOnlyItem(listener.results));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 10, 11, 12, 13, 14, 25, 27, 28, 29, 34, 39, 40, 41, 42, 43, 44 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/DfaPsiUtil";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiVariable";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 40: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wantedConstraint";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cond1";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cond2";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementNullability";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 34: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/DfaPsiUtil";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "inferParameterNullability";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeNullability";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunctionalParameterNullability";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "findAllConstructorInitializers";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariableAssignmentsInFile";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getVarArgComponentNullability";
                break;
            }
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "fromLiteral";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getNullabilityFromType";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "hasNullContract";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getNullabilityFromAnnotation";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isMapMethodWithUnknownNullity";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "inferParameterNullability";
                break;
            }
            case 25: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "findAllConstructorInitializers";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getTopmostBlockInSameClass";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getVariableAssignmentsInFile";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "fromLiteral";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "dfTypeToPsiType";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "isAssertionEffectively";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "isAssertCallArgument";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "mutuallyExclusive";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 10, 11, 12, 13, 14, 25, 27, 28, 29, 34, 39, 40, 41, 42, 43, 44 -> new IllegalArgumentException(string);
        };
    }
}

