/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInsight.Nullability;
import com.intellij.codeInspection.dataFlow.CommonDataflow;
import com.intellij.codeInspection.dataFlow.ContractReturnValue;
import com.intellij.codeInspection.dataFlow.ContractValue;
import com.intellij.codeInspection.dataFlow.DfaNullability;
import com.intellij.codeInspection.dataFlow.DfaPsiUtil;
import com.intellij.codeInspection.dataFlow.JavaMethodContractUtil;
import com.intellij.codeInspection.dataFlow.MethodContract;
import com.intellij.codeInspection.dataFlow.StandardDataFlowRunner;
import com.intellij.codeInspection.dataFlow.StandardMethodContract;
import com.intellij.codeInspection.dataFlow.TypeConstraint;
import com.intellij.codeInspection.dataFlow.interpreter.RunnerResult;
import com.intellij.codeInspection.dataFlow.java.JavaDfaListener;
import com.intellij.codeInspection.dataFlow.jvm.JvmDfaMemoryStateImpl;
import com.intellij.codeInspection.dataFlow.jvm.JvmPsiRangeSetUtil;
import com.intellij.codeInspection.dataFlow.jvm.SpecialField;
import com.intellij.codeInspection.dataFlow.jvm.descriptors.AssertionDisabledDescriptor;
import com.intellij.codeInspection.dataFlow.memory.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeSet;
import com.intellij.codeInspection.dataFlow.types.DfPrimitiveType;
import com.intellij.codeInspection.dataFlow.types.DfReferenceType;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.types.DfTypes;
import com.intellij.codeInspection.dataFlow.value.DerivedVariableDescriptor;
import com.intellij.codeInspection.dataFlow.value.DfaTypeValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.codeInspection.dataFlow.value.DfaWrappedValue;
import com.intellij.codeInspection.dataFlow.value.RelationType;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstantInitializer;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterListOwner;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.controlFlow.DefUseUtil;
import com.intellij.psi.impl.source.resolve.JavaResolveUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiPredicate;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public final class DfaUtil {
    @NotNull
    public static Collection<PsiExpression> getVariableValues(@Nullable PsiVariable variable, @Nullable PsiElement context) {
        if (variable == null || context == null) {
            List<PsiExpression> list = Collections.emptyList();
            if (list == null) {
                DfaUtil.$$$reportNull$$$0(0);
            }
            return list;
        }
        PsiCodeBlock codeBlock = (PsiCodeBlock)ObjectUtils.tryCast((Object)DfaUtil.getEnclosingCodeBlock(variable, context), PsiCodeBlock.class);
        if (codeBlock == null) {
            List<PsiExpression> list = Collections.emptyList();
            if (list == null) {
                DfaUtil.$$$reportNull$$$0(1);
            }
            return list;
        }
        PsiElement[] defs = DefUseUtil.getDefs((PsiCodeBlock)codeBlock, (PsiVariable)variable, (PsiElement)context);
        ArrayList<PsiExpression> results = new ArrayList<PsiExpression>();
        for (PsiElement def : defs) {
            if (def instanceof PsiLocalVariable) {
                PsiLocalVariable var = (PsiLocalVariable)def;
                ContainerUtil.addIfNotNull(results, (Object)var.getInitializer());
                continue;
            }
            if (def instanceof PsiReferenceExpression) {
                PsiAssignmentExpression assignment = (PsiAssignmentExpression)ObjectUtils.tryCast((Object)def.getParent(), PsiAssignmentExpression.class);
                if (assignment == null || assignment.getLExpression() != def) continue;
                ContainerUtil.addIfNotNull(results, (Object)DfaUtil.unrollConcatenation(assignment, variable, codeBlock));
                continue;
            }
            if (!(def instanceof PsiExpression)) continue;
            PsiExpression expr = (PsiExpression)def;
            results.add(expr);
        }
        ArrayList<PsiExpression> arrayList = results;
        if (arrayList == null) {
            DfaUtil.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    private static PsiElement getEnclosingCodeBlock(PsiVariable variable, PsiElement context) {
        PsiAnonymousClass anon;
        PsiElement codeBlock;
        if (variable instanceof PsiParameter) {
            PsiParameter parameter = (PsiParameter)variable;
            codeBlock = parameter.getDeclarationScope();
            if (codeBlock instanceof PsiMethod) {
                PsiMethod method = (PsiMethod)codeBlock;
                codeBlock = method.getBody();
            }
        } else {
            codeBlock = variable instanceof PsiLocalVariable ? PsiTreeUtil.getParentOfType((PsiElement)variable, PsiCodeBlock.class) : DfaPsiUtil.getTopmostBlockInSameClass(context);
        }
        while (codeBlock != null && (anon = (PsiAnonymousClass)PsiTreeUtil.getParentOfType((PsiElement)codeBlock, PsiAnonymousClass.class)) != null) {
            codeBlock = PsiTreeUtil.getParentOfType((PsiElement)anon, PsiCodeBlock.class);
        }
        return codeBlock;
    }

    private static PsiExpression unrollConcatenation(PsiAssignmentExpression assignment, PsiVariable variable, PsiCodeBlock block) {
        ArrayList<PsiExpression> operands;
        block8: {
            operands = new ArrayList<PsiExpression>();
            while (true) {
                if (assignment == null) {
                    return null;
                }
                PsiExpression rExpression = assignment.getRExpression();
                if (rExpression == null) {
                    return null;
                }
                operands.add(rExpression);
                IElementType type = assignment.getOperationTokenType();
                if (type.equals(JavaTokenType.EQ)) break block8;
                if (!type.equals(JavaTokenType.PLUSEQ)) {
                    return null;
                }
                PsiElement[] previous = DefUseUtil.getDefs((PsiCodeBlock)block, (PsiVariable)variable, (PsiElement)assignment);
                if (previous.length != 1) {
                    return null;
                }
                PsiElement def = previous[0];
                if (def instanceof PsiLocalVariable) {
                    PsiLocalVariable var = (PsiLocalVariable)def;
                    PsiExpression initializer = var.getInitializer();
                    if (initializer == null) {
                        return null;
                    }
                    operands.add(initializer);
                    break block8;
                }
                if (!(def instanceof PsiReferenceExpression)) break;
                assignment = (PsiAssignmentExpression)ObjectUtils.tryCast((Object)def.getParent(), PsiAssignmentExpression.class);
            }
            return null;
        }
        if (operands.size() == 1) {
            return (PsiExpression)operands.get(0);
        }
        return JavaPsiFacade.getElementFactory((Project)block.getProject()).createExpressionFromText(StreamEx.ofReversed(operands).map(op -> ParenthesesUtils.getText(op, 6)).joining((CharSequence)"+"), (PsiElement)assignment);
    }

    @NotNull
    public static Collection<PsiExpression> getPossibleInitializationElements(@NotNull PsiElement qualifierExpression) {
        if (qualifierExpression == null) {
            DfaUtil.$$$reportNull$$$0(3);
        }
        if (qualifierExpression instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression call = (PsiMethodCallExpression)qualifierExpression;
            List<PsiMethodCallExpression> list = Collections.singletonList(call);
            if (list == null) {
                DfaUtil.$$$reportNull$$$0(4);
            }
            return list;
        }
        if (qualifierExpression instanceof PsiReferenceExpression) {
            PsiReferenceExpression ref = (PsiReferenceExpression)qualifierExpression;
            PsiElement psiElement = ref.resolve();
            if (!(psiElement instanceof PsiVariable)) {
                List<PsiExpression> list = Collections.emptyList();
                if (list == null) {
                    DfaUtil.$$$reportNull$$$0(5);
                }
                return list;
            }
            PsiVariable var = (PsiVariable)psiElement;
            Collection<PsiExpression> variableValues = DfaUtil.getVariableValues(var, qualifierExpression);
            if (variableValues.isEmpty()) {
                Collection<PsiExpression> collection = DfaPsiUtil.getVariableAssignmentsInFile(var, false, qualifierExpression);
                if (collection == null) {
                    DfaUtil.$$$reportNull$$$0(6);
                }
                return collection;
            }
            Collection<PsiExpression> collection = variableValues;
            if (collection == null) {
                DfaUtil.$$$reportNull$$$0(7);
            }
            return collection;
        }
        if (qualifierExpression instanceof PsiLiteralExpression) {
            PsiLiteralExpression literal = (PsiLiteralExpression)qualifierExpression;
            List<PsiLiteralExpression> list = Collections.singletonList(literal);
            if (list == null) {
                DfaUtil.$$$reportNull$$$0(8);
            }
            return list;
        }
        List<PsiExpression> list = Collections.emptyList();
        if (list == null) {
            DfaUtil.$$$reportNull$$$0(9);
        }
        return list;
    }

    @NotNull
    public static Nullability inferMethodNullability(PsiMethod method) {
        if (PsiUtil.resolveClassInType((PsiType)method.getReturnType()) == null) {
            Nullability nullability = Nullability.UNKNOWN;
            if (nullability == null) {
                DfaUtil.$$$reportNull$$$0(10);
            }
            return nullability;
        }
        return DfaUtil.inferBlockNullability((PsiParameterListOwner)method, DfaUtil.suppressNullable(method));
    }

    private static boolean suppressNullable(PsiMethod method) {
        if (method.getParameterList().isEmpty()) {
            return false;
        }
        for (StandardMethodContract contract : JavaMethodContractUtil.getMethodContracts(method)) {
            if (!contract.getReturnValue().isNull()) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static Nullability inferLambdaNullability(PsiLambdaExpression lambda) {
        if (LambdaUtil.getFunctionalInterfaceReturnType((PsiFunctionalExpression)lambda) == null) {
            Nullability nullability = Nullability.UNKNOWN;
            if (nullability == null) {
                DfaUtil.$$$reportNull$$$0(11);
            }
            return nullability;
        }
        return DfaUtil.inferBlockNullability((PsiParameterListOwner)lambda, false);
    }

    @NotNull
    private static Nullability inferBlockNullability(@NotNull PsiParameterListOwner owner, boolean suppressNullable) {
        BlockNullabilityListener interceptor;
        PsiElement body;
        if (owner == null) {
            DfaUtil.$$$reportNull$$$0(12);
        }
        if ((body = owner.getBody()) == null) {
            Nullability nullability = Nullability.UNKNOWN;
            if (nullability == null) {
                DfaUtil.$$$reportNull$$$0(13);
            }
            return nullability;
        }
        StandardDataFlowRunner dfaRunner = new StandardDataFlowRunner(owner.getProject());
        final class BlockNullabilityListener
        implements JavaDfaListener {
            boolean hasNulls = false;
            boolean hasNotNulls = false;
            boolean hasUnknowns = false;
            final /* synthetic */ PsiParameterListOwner val$owner;

            BlockNullabilityListener(PsiParameterListOwner psiParameterListOwner) {
                this.val$owner = psiParameterListOwner;
            }

            @Override
            public void beforeValueReturn(@NotNull DfaValue value, @Nullable PsiExpression expression, @NotNull PsiElement context, @NotNull DfaMemoryState state) {
                if (value == null) {
                    BlockNullabilityListener.$$$reportNull$$$0(0);
                }
                if (context == null) {
                    BlockNullabilityListener.$$$reportNull$$$0(1);
                }
                if (state == null) {
                    BlockNullabilityListener.$$$reportNull$$$0(2);
                }
                if (context == this.val$owner && expression != null) {
                    DfaNullability nullability = DfaNullability.fromDfType(state.getDfType(value));
                    if (TypeConversionUtil.isPrimitiveAndNotNull((PsiType)expression.getType()) || nullability == DfaNullability.NOT_NULL) {
                        this.hasNotNulls = true;
                    } else if (nullability == DfaNullability.NULL) {
                        this.hasNulls = true;
                    } else if (nullability == DfaNullability.NULLABLE) {
                        this.hasNotNulls = true;
                        this.hasNulls = true;
                    } else {
                        this.hasUnknowns = true;
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "value";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "context";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "state";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/codeInspection/dataFlow/DfaUtil$1BlockNullabilityListener";
                objectArray[2] = "beforeValueReturn";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
        RunnerResult rc = dfaRunner.analyzeMethod(body, interceptor = new BlockNullabilityListener(owner));
        if (rc == RunnerResult.OK) {
            if (interceptor.hasNulls) {
                Nullability nullability = suppressNullable ? Nullability.UNKNOWN : Nullability.NULLABLE;
                if (nullability == null) {
                    DfaUtil.$$$reportNull$$$0(14);
                }
                return nullability;
            }
            if (interceptor.hasNotNulls && !interceptor.hasUnknowns) {
                Nullability nullability = Nullability.NOT_NULL;
                if (nullability == null) {
                    DfaUtil.$$$reportNull$$$0(15);
                }
                return nullability;
            }
        }
        Nullability nullability = Nullability.UNKNOWN;
        if (nullability == null) {
            DfaUtil.$$$reportNull$$$0(16);
        }
        return nullability;
    }

    public static boolean hasImplicitImpureSuperCall(PsiClass aClass, PsiMethod constructor) {
        PsiClass superClass = aClass.getSuperClass();
        if (superClass == null) {
            return false;
        }
        PsiElement superCtor = JavaResolveUtil.resolveImaginarySuperCallInThisPlace((PsiMember)constructor, (Project)constructor.getProject(), (PsiClass)superClass);
        if (!(superCtor instanceof PsiMethod)) {
            return false;
        }
        PsiMethod method = (PsiMethod)superCtor;
        return !JavaMethodContractUtil.isPure(method);
    }

    @Nullable
    static PsiElement getDataflowContext(@NotNull PsiElement anchor) {
        if (anchor == null) {
            DfaUtil.$$$reportNull$$$0(17);
        }
        PsiElement element = anchor;
        while (element != null && !(element instanceof PsiAnnotation)) {
            PsiClass psiClass;
            PsiClass containingClass;
            PsiMethod method;
            if (element instanceof PsiMethod && !(method = (PsiMethod)element).isConstructor() && (containingClass = method.getContainingClass()) != null && (!PsiUtil.isLocalOrAnonymousClass((PsiClass)containingClass) || containingClass instanceof PsiEnumConstantInitializer)) {
                return method.getBody();
            }
            if (element instanceof PsiClass && !PsiUtil.isLocalOrAnonymousClass((PsiClass)(psiClass = (PsiClass)element))) {
                return psiClass;
            }
            element = element.getParent();
        }
        return null;
    }

    @Nullable
    public static Boolean evaluateCondition(@Nullable PsiExpression condition) {
        if (condition == null) {
            return null;
        }
        CommonDataflow.DataflowResult result = CommonDataflow.getDataflowResult((PsiElement)condition);
        if (result == null) {
            return null;
        }
        return (Boolean)ObjectUtils.tryCast((Object)ContainerUtil.getOnlyItem(result.getExpressionValues(condition)), Boolean.class);
    }

    public static DfaValue boxUnbox(DfaValue value, @Nullable PsiType type) {
        return DfaUtil.boxUnbox(value, DfTypes.typedObject(type, Nullability.UNKNOWN));
    }

    public static DfaValue boxUnbox(DfaValue value, @NotNull DfType type) {
        if (type == null) {
            DfaUtil.$$$reportNull$$$0(18);
        }
        if (TypeConstraint.fromDfType(type).isPrimitiveWrapper() && value.getDfType() instanceof DfPrimitiveType) {
            return value.getFactory().getWrapperFactory().createWrapper(type.meet((DfType)DfTypes.NOT_NULL_OBJECT), (DerivedVariableDescriptor)SpecialField.UNBOX, value);
        }
        if (type instanceof DfPrimitiveType) {
            DfPrimitiveType primitiveType = (DfPrimitiveType)type;
            DfType dfType = value.getDfType();
            if (dfType instanceof DfPrimitiveType) {
                DfPrimitiveType valueType = (DfPrimitiveType)dfType;
                PsiPrimitiveType psiType = primitiveType.getPsiType();
                if (!valueType.getPsiType().equals((Object)psiType)) {
                    return value.getFactory().fromDfType(valueType.castTo(psiType));
                }
            }
            if (value instanceof DfaWrappedValue || TypeConstraint.fromDfType(value.getDfType()).isPrimitiveWrapper()) {
                return SpecialField.UNBOX.createValue(value.getFactory(), value);
            }
            if (value.getDfType() instanceof DfReferenceType) {
                return value.getFactory().fromDfType(type);
            }
        }
        return value;
    }

    public static @Unmodifiable @NotNull List<? extends MethodContract> addRangeContracts(@Nullable PsiMethod method, @NotNull List<? extends MethodContract> contracts) {
        if (contracts == null) {
            DfaUtil.$$$reportNull$$$0(19);
        }
        if (method == null) {
            List<? extends MethodContract> list = contracts;
            if (list == null) {
                DfaUtil.$$$reportNull$$$0(20);
            }
            return list;
        }
        PsiParameter[] parameters = method.getParameterList().getParameters();
        ArrayList<MethodContract> rangeContracts = new ArrayList<MethodContract>();
        for (int i = 0; i < parameters.length; ++i) {
            MethodContract contract;
            PsiParameter parameter = parameters[i];
            LongRangeSet fromType = JvmPsiRangeSetUtil.typeRange(parameter.getType());
            if (fromType == null) continue;
            LongRangeSet fromAnnotation = JvmPsiRangeSetUtil.fromPsiElement((PsiModifierListOwner)parameter);
            if (fromAnnotation.min() > fromType.min()) {
                contract = MethodContract.singleConditionContract(ContractValue.argument(i), RelationType.LT, ContractValue.constant(fromAnnotation.min(), parameter.getType()), ContractReturnValue.fail());
                rangeContracts.add(contract);
            }
            if (fromAnnotation.max() >= fromType.max()) continue;
            contract = MethodContract.singleConditionContract(ContractValue.argument(i), RelationType.GT, ContractValue.constant(fromAnnotation.max(), parameter.getType()), ContractReturnValue.fail());
            rangeContracts.add(contract);
        }
        List list = ContainerUtil.concat(rangeContracts, contracts);
        if (list == null) {
            DfaUtil.$$$reportNull$$$0(21);
        }
        return list;
    }

    public static boolean isEmptyCollectionConstantField(@Nullable PsiVariable var) {
        if (!(var instanceof PsiField)) {
            return false;
        }
        PsiField field = (PsiField)var;
        return field.getName().startsWith("EMPTY_") && field.getContainingClass() != null && "java.util.Collections".equals(field.getContainingClass().getQualifiedName());
    }

    public static <T, C extends Collection<T>> C upwardsAntichain(@NotNull C poset, @NotNull BiPredicate<T, T> predicate) {
        if (poset == null) {
            DfaUtil.$$$reportNull$$$0(22);
        }
        if (predicate == null) {
            DfaUtil.$$$reportNull$$$0(23);
        }
        Iterator<T> iterator = poset.iterator();
        block0: while (iterator.hasNext()) {
            T left = iterator.next();
            for (T right : poset) {
                ProgressManager.checkCanceled();
                if (right == left || !predicate.test(left, right)) continue;
                iterator.remove();
                continue block0;
            }
        }
        return poset;
    }

    @NotNull
    public static DfaMemoryState createStateWithEnabledAssertions(@NotNull DfaValueFactory factory) {
        if (factory == null) {
            DfaUtil.$$$reportNull$$$0(24);
        }
        JvmDfaMemoryStateImpl initialState = new JvmDfaMemoryStateImpl(factory);
        DfaVariableValue assertionStatus = AssertionDisabledDescriptor.getAssertionsDisabledVar(factory);
        if (assertionStatus != null) {
            initialState.applyCondition(assertionStatus.eq((DfType)DfTypes.FALSE));
        }
        JvmDfaMemoryStateImpl jvmDfaMemoryStateImpl = initialState;
        if (jvmDfaMemoryStateImpl == null) {
            DfaUtil.$$$reportNull$$$0(25);
        }
        return jvmDfaMemoryStateImpl;
    }

    @NotNull
    public static DfType getUnboxedDfType(DfaMemoryState state, @NotNull DfaValue value) {
        DfReferenceType refType;
        DfaWrappedValue wrappedValue;
        if (value == null) {
            DfaUtil.$$$reportNull$$$0(26);
        }
        if (value instanceof DfaWrappedValue && (wrappedValue = (DfaWrappedValue)value).getSpecialField() == SpecialField.UNBOX) {
            DfType dfType = state.getDfType((DfaValue)wrappedValue.getWrappedValue());
            if (dfType == null) {
                DfaUtil.$$$reportNull$$$0(27);
            }
            return dfType;
        }
        if (value instanceof DfaVariableValue && TypeConstraint.fromDfType(value.getDfType()).isPrimitiveWrapper()) {
            DfType dfType = state.getDfType(SpecialField.UNBOX.createValue(value.getFactory(), value));
            if (dfType == null) {
                DfaUtil.$$$reportNull$$$0(28);
            }
            return dfType;
        }
        if (value instanceof DfaTypeValue && (refType = (DfReferenceType)ObjectUtils.tryCast((Object)value.getDfType(), DfReferenceType.class)) != null && refType.getSpecialField() == SpecialField.UNBOX) {
            DfType dfType = refType.getSpecialFieldType();
            if (dfType == null) {
                DfaUtil.$$$reportNull$$$0(29);
            }
            return dfType;
        }
        DfType dfType = state.getDfType(value);
        if (dfType == null) {
            DfaUtil.$$$reportNull$$$0(30);
        }
        return dfType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 3, 12, 17, 18, 19, 22, 23, 24, 26 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/DfaUtil";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifierExpression";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contracts";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "poset";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predicate";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariableValues";
                break;
            }
            case 3: 
            case 12: 
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 24: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/DfaUtil";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getPossibleInitializationElements";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "inferMethodNullability";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "inferLambdaNullability";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "inferBlockNullability";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "addRangeContracts";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "createStateWithEnabledAssertions";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnboxedDfType";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getPossibleInitializationElements";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "inferBlockNullability";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getDataflowContext";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "boxUnbox";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "addRangeContracts";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "upwardsAntichain";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "createStateWithEnabledAssertions";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getUnboxedDfType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 3, 12, 17, 18, 19, 22, 23, 24, 26 -> new IllegalArgumentException(string);
        };
    }
}

