/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.dataFlow.DfaNullability;
import com.intellij.codeInspection.dataFlow.DfaPsiUtil;
import com.intellij.codeInspection.dataFlow.JavaMethodContractUtil;
import com.intellij.codeInspection.dataFlow.MutationSignature;
import com.intellij.codeInspection.dataFlow.TypeConstraints;
import com.intellij.codeInspection.dataFlow.inference.JavaSourceInference;
import com.intellij.codeInspection.dataFlow.types.DfReferenceType;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.types.DfTypes;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiRecordComponent;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.psi.impl.source.PsiMethodImpl;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import java.util.Collections;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

public enum Mutability {
    UNKNOWN("mutability.unknown", null),
    MUTABLE("mutability.modifiable", null),
    MUST_NOT_MODIFY("mutability.must.not.modify", null),
    UNMODIFIABLE_VIEW("mutability.unmodifiable.view", "org.jetbrains.annotations.UnmodifiableView"),
    UNMODIFIABLE("mutability.unmodifiable", "org.jetbrains.annotations.Unmodifiable");

    @NotNull
    public static final String UNMODIFIABLE_ANNOTATION;
    @NotNull
    public static final String UNMODIFIABLE_VIEW_ANNOTATION;
    @PropertyKey(resourceBundle="messages.JavaAnalysisBundle")
    private final @PropertyKey(resourceBundle="messages.JavaAnalysisBundle") String myResourceKey;
    private final String myAnnotation;
    private final Key<CachedValue<PsiAnnotation>> myKey;

    private Mutability(String resourceKey, String annotation) {
        this.myResourceKey = resourceKey;
        this.myAnnotation = annotation;
        this.myKey = annotation == null ? null : Key.create((String)annotation);
    }

    public DfReferenceType asDfType() {
        return DfTypes.customObject(TypeConstraints.TOP, DfaNullability.UNKNOWN, this, null, DfType.BOTTOM);
    }

    @NotNull
    @Nls
    public String getPresentationName() {
        String string = JavaAnalysisBundle.message((String)this.myResourceKey, (Object[])new Object[0]);
        if (string == null) {
            Mutability.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean isUnmodifiable() {
        return this == UNMODIFIABLE || this == UNMODIFIABLE_VIEW;
    }

    public boolean canBeModified() {
        return this == MUTABLE || this == UNKNOWN;
    }

    @NotNull
    public Mutability join(@NotNull Mutability other) {
        if (other == null) {
            Mutability.$$$reportNull$$$0(1);
        }
        if (this == other) {
            Mutability mutability = this;
            if (mutability == null) {
                Mutability.$$$reportNull$$$0(2);
            }
            return mutability;
        }
        if (this == UNKNOWN || other == UNKNOWN) {
            Mutability mutability = UNKNOWN;
            if (mutability == null) {
                Mutability.$$$reportNull$$$0(3);
            }
            return mutability;
        }
        if (this == MUTABLE || other == MUTABLE) {
            Mutability mutability = UNKNOWN;
            if (mutability == null) {
                Mutability.$$$reportNull$$$0(4);
            }
            return mutability;
        }
        if (this == MUST_NOT_MODIFY || other == MUST_NOT_MODIFY) {
            Mutability mutability = MUST_NOT_MODIFY;
            if (mutability == null) {
                Mutability.$$$reportNull$$$0(5);
            }
            return mutability;
        }
        if (this == UNMODIFIABLE_VIEW || other == UNMODIFIABLE_VIEW) {
            Mutability mutability = UNMODIFIABLE_VIEW;
            if (mutability == null) {
                Mutability.$$$reportNull$$$0(6);
            }
            return mutability;
        }
        Mutability mutability = UNMODIFIABLE;
        if (mutability == null) {
            Mutability.$$$reportNull$$$0(7);
        }
        return mutability;
    }

    @Nullable
    public Mutability meet(@NotNull Mutability other) {
        if (other == null) {
            Mutability.$$$reportNull$$$0(8);
        }
        if (this == other) {
            return this;
        }
        if (this == UNKNOWN) {
            return other;
        }
        if (other == UNKNOWN) {
            return this;
        }
        if (this == MUTABLE || other == MUTABLE) {
            return null;
        }
        if (this == UNMODIFIABLE || other == UNMODIFIABLE) {
            return UNMODIFIABLE;
        }
        if (this == UNMODIFIABLE_VIEW || other == UNMODIFIABLE_VIEW) {
            return UNMODIFIABLE_VIEW;
        }
        return MUST_NOT_MODIFY;
    }

    @Nullable
    public PsiAnnotation asAnnotation(Project project) {
        if (this.myAnnotation == null) {
            return null;
        }
        return (PsiAnnotation)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, this.myKey, () -> {
            PsiAnnotation annotation = JavaPsiFacade.getElementFactory((Project)project).createAnnotationFromText("@" + this.myAnnotation, null);
            ((LightVirtualFile)annotation.getContainingFile().getViewProvider().getVirtualFile()).setWritable(false);
            return CachedValueProvider.Result.create((Object)annotation, (Object[])new Object[]{ModificationTracker.NEVER_CHANGED});
        }, false);
    }

    @NotNull
    public static Mutability getMutability(@NotNull PsiModifierListOwner owner) {
        if (owner == null) {
            Mutability.$$$reportNull$$$0(9);
        }
        if (owner instanceof LightElement) {
            Mutability mutability = UNKNOWN;
            if (mutability == null) {
                Mutability.$$$reportNull$$$0(10);
            }
            return mutability;
        }
        Mutability mutability = (Mutability)((Object)CachedValuesManager.getCachedValue((PsiElement)owner, () -> CachedValueProvider.Result.create((Object)((Object)Mutability.calcMutability(owner)), (Object[])new Object[]{owner, PsiModificationTracker.MODIFICATION_COUNT})));
        if (mutability == null) {
            Mutability.$$$reportNull$$$0(11);
        }
        return mutability;
    }

    @NotNull
    private static Mutability calcMutability(@NotNull PsiModifierListOwner owner) {
        Mutability mutability;
        if (owner == null) {
            Mutability.$$$reportNull$$$0(12);
        }
        if (owner instanceof PsiParameter) {
            PsiParameterList list;
            PsiParameter parameter = (PsiParameter)owner;
            PsiElement psiElement = owner.getParent();
            if (psiElement instanceof PsiParameterList && (psiElement = (list = (PsiParameterList)psiElement).getParent()) instanceof PsiMethod) {
                PsiMethod method = (PsiMethod)psiElement;
                JavaMethodContractUtil.ContractInfo contractInfo = JavaMethodContractUtil.getContractInfo(method);
                if (contractInfo.isExplicit()) {
                    int index = list.getParameterIndex(parameter);
                    MutationSignature signature = contractInfo.getMutationSignature();
                    if (signature.mutatesArg(index)) {
                        Mutability mutability2 = MUTABLE;
                        if (mutability2 == null) {
                            Mutability.$$$reportNull$$$0(13);
                        }
                        return mutability2;
                    }
                    if (signature.preservesArg(index)) {
                        Mutability mutability3 = MUST_NOT_MODIFY;
                        if (mutability3 == null) {
                            Mutability.$$$reportNull$$$0(14);
                        }
                        return mutability3;
                    }
                }
                Mutability mutability4 = UNKNOWN;
                if (mutability4 == null) {
                    Mutability.$$$reportNull$$$0(15);
                }
                return mutability4;
            }
        }
        if (AnnotationUtil.isAnnotated((PsiModifierListOwner)owner, Collections.singleton(UNMODIFIABLE_ANNOTATION), (int)7)) {
            Mutability mutability5 = UNMODIFIABLE;
            if (mutability5 == null) {
                Mutability.$$$reportNull$$$0(16);
            }
            return mutability5;
        }
        if (AnnotationUtil.isAnnotated((PsiModifierListOwner)owner, Collections.singleton(UNMODIFIABLE_VIEW_ANNOTATION), (int)7)) {
            Mutability mutability6 = UNMODIFIABLE_VIEW;
            if (mutability6 == null) {
                Mutability.$$$reportNull$$$0(17);
            }
            return mutability6;
        }
        if (owner instanceof PsiField) {
            PsiField field = (PsiField)owner;
            if (owner.hasModifierProperty("final")) {
                List<PsiExpression> initializers = ContainerUtil.createMaybeSingletonList((Object)field.getInitializer());
                if (initializers.isEmpty() && !owner.hasModifierProperty("static")) {
                    initializers = DfaPsiUtil.findAllConstructorInitializers(field);
                }
                return Mutability.calcMutability(initializers);
            }
        }
        if (owner instanceof PsiRecordComponent) {
            PsiRecordComponent component = (PsiRecordComponent)owner;
            return Mutability.calcMutability(DfaPsiUtil.findAllConstructorInitializers(component));
        }
        if (owner instanceof PsiMethodImpl) {
            PsiMethodImpl method = (PsiMethodImpl)owner;
            mutability = JavaSourceInference.inferMutability(method);
        } else {
            mutability = UNKNOWN;
        }
        if (mutability == null) {
            Mutability.$$$reportNull$$$0(18);
        }
        return mutability;
    }

    @NotNull
    private static Mutability calcMutability(List<PsiExpression> expressions) {
        if ((expressions = StreamEx.of(expressions).flatMap(ExpressionUtils::nonStructuralChildren).toList()).isEmpty()) {
            Mutability mutability = UNKNOWN;
            if (mutability == null) {
                Mutability.$$$reportNull$$$0(19);
            }
            return mutability;
        }
        Mutability mutability = UNMODIFIABLE;
        for (PsiExpression initializer : expressions) {
            Mutability newMutability = UNKNOWN;
            PsiType type = initializer.getType();
            if (ClassUtils.isImmutable(type) || type != null && type.hasAnnotation(UNMODIFIABLE_ANNOTATION)) {
                newMutability = UNMODIFIABLE;
            } else if (initializer instanceof PsiMethodCallExpression) {
                PsiMethodCallExpression call = (PsiMethodCallExpression)initializer;
                PsiMethod method = call.resolveMethod();
                Mutability mutability2 = newMutability = method == null ? UNKNOWN : Mutability.getMutability((PsiModifierListOwner)method);
            }
            if ((mutability = mutability.join(newMutability)).isUnmodifiable()) continue;
            break;
        }
        Mutability mutability3 = mutability;
        if (mutability3 == null) {
            Mutability.$$$reportNull$$$0(20);
        }
        return mutability3;
    }

    public static Mutability fromDfType(DfType dfType) {
        Mutability mutability;
        if (dfType instanceof DfReferenceType) {
            DfReferenceType referenceType = (DfReferenceType)dfType;
            mutability = referenceType.getMutability();
        } else {
            mutability = UNKNOWN;
        }
        return mutability;
    }

    static {
        UNMODIFIABLE_ANNOTATION = Mutability.UNMODIFIABLE.myAnnotation;
        UNMODIFIABLE_VIEW_ANNOTATION = Mutability.UNMODIFIABLE_VIEW.myAnnotation;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 8, 9, 12 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/Mutability";
                break;
            }
            case 1: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentationName";
                break;
            }
            case 1: 
            case 8: 
            case 9: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/Mutability";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "join";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getMutability";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "calcMutability";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "join";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "meet";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getMutability";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "calcMutability";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 8, 9, 12 -> new IllegalArgumentException(string);
        };
    }
}

