/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.DfaPsiUtil;
import com.intellij.codeInspection.dataFlow.interpreter.RunnerResult;
import com.intellij.codeInspection.dataFlow.interpreter.StandardDataFlowInterpreter;
import com.intellij.codeInspection.dataFlow.interpreter.StateQueue;
import com.intellij.codeInspection.dataFlow.java.ControlFlowAnalyzer;
import com.intellij.codeInspection.dataFlow.jvm.JvmDfaMemoryStateImpl;
import com.intellij.codeInspection.dataFlow.jvm.descriptors.AssertionDisabledDescriptor;
import com.intellij.codeInspection.dataFlow.lang.DfaListener;
import com.intellij.codeInspection.dataFlow.lang.ir.ControlFlow;
import com.intellij.codeInspection.dataFlow.lang.ir.DfaInstructionState;
import com.intellij.codeInspection.dataFlow.memory.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.types.DfTypes;
import com.intellij.codeInspection.dataFlow.value.DfaCondition;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class StandardDataFlowRunner {
    private static final Logger LOG = Logger.getInstance(StandardDataFlowRunner.class);
    @NotNull
    private final DfaValueFactory myValueFactory;
    @NotNull
    private final ThreeState myIgnoreAssertions;
    private boolean myInlining;
    private StandardDataFlowInterpreter myInterpreter;

    public StandardDataFlowRunner(@NotNull Project project) {
        if (project == null) {
            StandardDataFlowRunner.$$$reportNull$$$0(0);
        }
        this(project, ThreeState.NO);
    }

    public StandardDataFlowRunner(@NotNull Project project, @NotNull ThreeState ignoreAssertions) {
        if (project == null) {
            StandardDataFlowRunner.$$$reportNull$$$0(1);
        }
        if (ignoreAssertions == null) {
            StandardDataFlowRunner.$$$reportNull$$$0(2);
        }
        this.myInlining = true;
        this.myValueFactory = new DfaValueFactory(project);
        this.myIgnoreAssertions = ignoreAssertions;
    }

    @NotNull
    public DfaValueFactory getFactory() {
        DfaValueFactory dfaValueFactory = this.myValueFactory;
        if (dfaValueFactory == null) {
            StandardDataFlowRunner.$$$reportNull$$$0(3);
        }
        return dfaValueFactory;
    }

    public final void cancel() {
        this.myInterpreter.cancel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private Collection<DfaMemoryState> createInitialStates(@NotNull PsiElement psiBlock, @NotNull DfaListener listener, boolean allowInlining) {
        PsiElement block;
        PsiElement container;
        if (psiBlock == null) {
            StandardDataFlowRunner.$$$reportNull$$$0(4);
        }
        if (listener == null) {
            StandardDataFlowRunner.$$$reportNull$$$0(5);
        }
        if ((container = PsiTreeUtil.getParentOfType((PsiElement)psiBlock, (Class[])new Class[]{PsiClass.class, PsiLambdaExpression.class})) != null && (!(container instanceof PsiClass) || PsiUtil.isLocalOrAnonymousClass((PsiClass)((PsiClass)container))) && (block = DfaPsiUtil.getTopmostBlockInSameClass(container.getParent())) != null) {
            RunnerResult result;
            try {
                this.myInlining = allowInlining;
                result = this.analyzeMethod(block, listener);
            }
            finally {
                this.myInlining = true;
            }
            if (result == RunnerResult.OK || result == RunnerResult.CANCELLED) {
                List<DfaMemoryState> closureStates;
                PsiElement topmostBlock = DfaPsiUtil.getTopmostBlockInSameClass(psiBlock);
                Collection<Object> collection = closureStates = topmostBlock == null ? List.of() : this.myInterpreter.getClosures().get((Object)topmostBlock);
                if (allowInlining || !closureStates.isEmpty()) {
                    return closureStates;
                }
            }
            return null;
        }
        return Collections.singletonList(this.createMemoryState());
    }

    @NotNull
    public final RunnerResult analyzeMethod(@NotNull PsiElement psiBlock, @NotNull DfaListener listener) {
        Collection<DfaMemoryState> initialStates;
        if (psiBlock == null) {
            StandardDataFlowRunner.$$$reportNull$$$0(6);
        }
        if (listener == null) {
            StandardDataFlowRunner.$$$reportNull$$$0(7);
        }
        return (initialStates = this.createInitialStates(psiBlock, listener, false)) == null ? RunnerResult.NOT_APPLICABLE : this.analyzeMethod(psiBlock, listener, initialStates);
    }

    @NotNull
    public final RunnerResult analyzeMethodWithInlining(@NotNull PsiElement psiBlock, @NotNull DfaListener listener) {
        Collection<DfaMemoryState> initialStates;
        if (psiBlock == null) {
            StandardDataFlowRunner.$$$reportNull$$$0(8);
        }
        if (listener == null) {
            StandardDataFlowRunner.$$$reportNull$$$0(9);
        }
        if ((initialStates = this.createInitialStates(psiBlock, listener, true)) == null) {
            RunnerResult runnerResult = RunnerResult.NOT_APPLICABLE;
            if (runnerResult == null) {
                StandardDataFlowRunner.$$$reportNull$$$0(10);
            }
            return runnerResult;
        }
        if (initialStates.isEmpty()) {
            RunnerResult runnerResult = RunnerResult.OK;
            if (runnerResult == null) {
                StandardDataFlowRunner.$$$reportNull$$$0(11);
            }
            return runnerResult;
        }
        return this.analyzeMethod(psiBlock, listener, initialStates);
    }

    @NotNull
    final RunnerResult analyzeMethod(@NotNull PsiElement psiBlock, @NotNull DfaListener listener, @NotNull Collection<? extends DfaMemoryState> initialStates) {
        ControlFlow flow;
        if (psiBlock == null) {
            StandardDataFlowRunner.$$$reportNull$$$0(12);
        }
        if (listener == null) {
            StandardDataFlowRunner.$$$reportNull$$$0(13);
        }
        if (initialStates == null) {
            StandardDataFlowRunner.$$$reportNull$$$0(14);
        }
        if ((flow = this.buildFlow(psiBlock)) == null) {
            RunnerResult runnerResult = RunnerResult.NOT_APPLICABLE;
            if (runnerResult == null) {
                StandardDataFlowRunner.$$$reportNull$$$0(15);
            }
            return runnerResult;
        }
        RunnerResult runnerResult = this.analyzeFlow(psiBlock, listener, initialStates, flow);
        if (runnerResult == null) {
            StandardDataFlowRunner.$$$reportNull$$$0(16);
        }
        return runnerResult;
    }

    @NotNull
    RunnerResult analyzeFlow(@NotNull PsiElement psiBlock, @NotNull DfaListener listener, @NotNull Collection<? extends DfaMemoryState> initialStates, ControlFlow flow) {
        List<DfaInstructionState> startingStates;
        if (psiBlock == null) {
            StandardDataFlowRunner.$$$reportNull$$$0(17);
        }
        if (listener == null) {
            StandardDataFlowRunner.$$$reportNull$$$0(18);
        }
        if (initialStates == null) {
            StandardDataFlowRunner.$$$reportNull$$$0(19);
        }
        if ((startingStates = this.createInitialInstructionStates(psiBlock, initialStates, flow)).isEmpty()) {
            RunnerResult runnerResult = RunnerResult.ABORTED;
            if (runnerResult == null) {
                StandardDataFlowRunner.$$$reportNull$$$0(20);
            }
            return runnerResult;
        }
        return this.interpret(listener, flow, startingStates);
    }

    @Nullable
    protected final ControlFlow buildFlow(@NotNull PsiElement psiBlock) {
        if (psiBlock == null) {
            StandardDataFlowRunner.$$$reportNull$$$0(21);
        }
        try {
            return ControlFlowAnalyzer.buildFlow(psiBlock, this.myValueFactory, this.myInlining);
        }
        catch (ProcessCanceledException ex) {
            throw ex;
        }
        catch (AssertionError | RuntimeException e) {
            LOG.error("Error building control flow", (Throwable)e, new Attachment[]{new Attachment("method_body.txt", psiBlock.getText())});
            return null;
        }
    }

    @NotNull
    protected final RunnerResult interpret(@NotNull DfaListener listener, @NotNull ControlFlow flow, @NotNull List<DfaInstructionState> startingStates) {
        if (listener == null) {
            StandardDataFlowRunner.$$$reportNull$$$0(22);
        }
        if (flow == null) {
            StandardDataFlowRunner.$$$reportNull$$$0(23);
        }
        if (startingStates == null) {
            StandardDataFlowRunner.$$$reportNull$$$0(24);
        }
        this.myInterpreter = this.createInterpreter(listener, flow);
        RunnerResult result = this.myInterpreter.interpret(startingStates);
        this.afterInterpretation(flow, this.myInterpreter, result);
        RunnerResult runnerResult = result;
        if (runnerResult == null) {
            StandardDataFlowRunner.$$$reportNull$$$0(25);
        }
        return runnerResult;
    }

    protected void afterInterpretation(@NotNull ControlFlow flow, @NotNull StandardDataFlowInterpreter interpreter, @NotNull RunnerResult result) {
        if (flow == null) {
            StandardDataFlowRunner.$$$reportNull$$$0(26);
        }
        if (interpreter == null) {
            StandardDataFlowRunner.$$$reportNull$$$0(27);
        }
        if (result == null) {
            StandardDataFlowRunner.$$$reportNull$$$0(28);
        }
    }

    @NotNull
    protected StandardDataFlowInterpreter createInterpreter(@NotNull DfaListener listener, @NotNull ControlFlow flow) {
        if (listener == null) {
            StandardDataFlowRunner.$$$reportNull$$$0(29);
        }
        if (flow == null) {
            StandardDataFlowRunner.$$$reportNull$$$0(30);
        }
        return new StandardDataFlowInterpreter(flow, listener);
    }

    protected @Unmodifiable @NotNull List<DfaInstructionState> createInitialInstructionStates(@NotNull PsiElement psiBlock, @NotNull Collection<? extends DfaMemoryState> memStates, @NotNull ControlFlow flow) {
        DfaVariableValue assertionStatus;
        if (psiBlock == null) {
            StandardDataFlowRunner.$$$reportNull$$$0(31);
        }
        if (memStates == null) {
            StandardDataFlowRunner.$$$reportNull$$$0(32);
        }
        if (flow == null) {
            StandardDataFlowRunner.$$$reportNull$$$0(33);
        }
        if ((assertionStatus = AssertionDisabledDescriptor.getAssertionsDisabledVar(this.myValueFactory)) != null && this.myIgnoreAssertions != ThreeState.UNSURE) {
            DfaCondition condition = assertionStatus.eq((DfType)DfTypes.booleanValue(this.myIgnoreAssertions.toBoolean()));
            for (DfaMemoryState dfaMemoryState : memStates) {
                dfaMemoryState.applyCondition(condition);
            }
        }
        List list = ContainerUtil.map(memStates, s -> new DfaInstructionState(flow.getInstruction(0), s));
        if (list == null) {
            StandardDataFlowRunner.$$$reportNull$$$0(34);
        }
        return list;
    }

    public boolean wasForciblyMerged() {
        return this.myInterpreter.wasForciblyMerged();
    }

    @NotNull
    public RunnerResult analyzeMethodRecursively(@NotNull PsiElement block, @NotNull DfaListener listener) {
        Collection<DfaMemoryState> states;
        if (block == null) {
            StandardDataFlowRunner.$$$reportNull$$$0(35);
        }
        if (listener == null) {
            StandardDataFlowRunner.$$$reportNull$$$0(36);
        }
        if ((states = this.createInitialStates(block, listener, false)) == null) {
            RunnerResult runnerResult = RunnerResult.NOT_APPLICABLE;
            if (runnerResult == null) {
                StandardDataFlowRunner.$$$reportNull$$$0(37);
            }
            return runnerResult;
        }
        RunnerResult runnerResult = this.analyzeBlockRecursively(block, states, listener);
        if (runnerResult == null) {
            StandardDataFlowRunner.$$$reportNull$$$0(38);
        }
        return runnerResult;
    }

    @NotNull
    public RunnerResult analyzeBlockRecursively(@NotNull PsiElement block, @NotNull Collection<? extends DfaMemoryState> states, @NotNull DfaListener listener) {
        RunnerResult result;
        if (block == null) {
            StandardDataFlowRunner.$$$reportNull$$$0(39);
        }
        if (states == null) {
            StandardDataFlowRunner.$$$reportNull$$$0(40);
        }
        if (listener == null) {
            StandardDataFlowRunner.$$$reportNull$$$0(41);
        }
        if ((result = this.analyzeMethod(block, listener, states)) != RunnerResult.OK) {
            RunnerResult runnerResult = result;
            if (runnerResult == null) {
                StandardDataFlowRunner.$$$reportNull$$$0(42);
            }
            return runnerResult;
        }
        Ref ref = Ref.create((Object)RunnerResult.OK);
        this.forNestedClosures((closure, nestedStates) -> {
            RunnerResult res = this.analyzeBlockRecursively((PsiElement)closure, (Collection<? extends DfaMemoryState>)nestedStates, listener);
            if (res != RunnerResult.OK) {
                ref.set((Object)res);
            }
        });
        RunnerResult runnerResult = (RunnerResult)ref.get();
        if (runnerResult == null) {
            StandardDataFlowRunner.$$$reportNull$$$0(43);
        }
        return runnerResult;
    }

    @NotNull
    protected DfaMemoryState createMemoryState() {
        return new JvmDfaMemoryStateImpl(this.myValueFactory);
    }

    public void forNestedClosures(BiConsumer<? super PsiElement, ? super Collection<? extends DfaMemoryState>> consumer) {
        MultiMap closures = this.myInterpreter.getClosures();
        for (PsiElement closure : closures.keySet()) {
            List unusedVars = ((StreamEx)((StreamEx)StreamEx.of((Collection)this.getFactory().getValues()).select(DfaVariableValue.class).filter(var -> var.getQualifier() == null)).filter(var -> var.getPsiVariable() instanceof PsiVariable && !VariableAccessUtils.variableIsUsed((PsiVariable)var.getPsiVariable(), closure))).toList();
            Collection states = closures.get((Object)closure);
            if (!unusedVars.isEmpty()) {
                List stateList = ((StreamEx)((StreamEx)StreamEx.of((Collection)states).peek(state -> state.forgetVariables(unusedVars::contains))).distinct()).toList();
                states = StateQueue.squash((List)stateList);
            }
            consumer.accept((PsiElement)closure, states);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 10, 11, 15, 16, 20, 25, 34, 37, 38, 42, 43 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ignoreAssertions";
                break;
            }
            case 3: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 20: 
            case 25: 
            case 34: 
            case 37: 
            case 38: 
            case 42: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/StandardDataFlowRunner";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 12: 
            case 17: 
            case 21: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiBlock";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 13: 
            case 18: 
            case 22: 
            case 29: 
            case 36: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 14: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialStates";
                break;
            }
            case 23: 
            case 26: 
            case 30: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flow";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startingStates";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreter";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "memStates";
                break;
            }
            case 35: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "states";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/StandardDataFlowRunner";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFactory";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "analyzeMethodWithInlining";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "analyzeMethod";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "analyzeFlow";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "interpret";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "createInitialInstructionStates";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "analyzeMethodRecursively";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "analyzeBlockRecursively";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 20: 
            case 25: 
            case 34: 
            case 37: 
            case 38: 
            case 42: 
            case 43: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createInitialStates";
                break;
            }
            case 6: 
            case 7: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "analyzeMethod";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "analyzeMethodWithInlining";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "analyzeFlow";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "buildFlow";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "interpret";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "afterInterpretation";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "createInterpreter";
                break;
            }
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "createInitialInstructionStates";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "analyzeMethodRecursively";
                break;
            }
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "analyzeBlockRecursively";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 10, 11, 15, 16, 20, 25, 34, 37, 38, 42, 43 -> new IllegalStateException(string);
        };
    }
}

