/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.ContractReturnValue;
import com.intellij.codeInspection.dataFlow.ContractValue;
import com.intellij.codeInspection.dataFlow.MethodContract;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.types.DfTypes;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.RelationType;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import one.util.streamex.IntStreamEx;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StandardMethodContract
extends MethodContract {
    @NotNull
    private final @NotNull ValueConstraint @NotNull [] myParameters;

    public StandardMethodContract(@NotNull @NotNull ValueConstraint @NotNull [] parameters, @NotNull ContractReturnValue returnValue) {
        if (returnValue == null) {
            StandardMethodContract.$$$reportNull$$$0(0);
        }
        if (parameters == null) {
            StandardMethodContract.$$$reportNull$$$0(1);
        }
        super(returnValue);
        this.myParameters = parameters;
    }

    public int getParameterCount() {
        return this.myParameters.length;
    }

    public ValueConstraint getParameterConstraint(int parameterIndex) {
        return this.myParameters[parameterIndex];
    }

    public List<ValueConstraint> getConstraints() {
        return List.of(this.myParameters);
    }

    @NotNull
    public StandardMethodContract withReturnValue(@NotNull ContractReturnValue returnValue) {
        if (returnValue == null) {
            StandardMethodContract.$$$reportNull$$$0(2);
        }
        return returnValue.equals(this.getReturnValue()) ? this : new StandardMethodContract(this.myParameters, returnValue);
    }

    public static StandardMethodContract trivialContract(int paramCount, @NotNull ContractReturnValue returnValue) {
        if (returnValue == null) {
            StandardMethodContract.$$$reportNull$$$0(3);
        }
        return new StandardMethodContract(StandardMethodContract.createConstraintArray(paramCount), returnValue);
    }

    @Nullable
    StandardMethodContract intersect(StandardMethodContract contract) {
        ValueConstraint[] result = (ValueConstraint[])this.myParameters.clone();
        assert (contract.getParameterCount() == result.length);
        for (int i = 0; i < result.length; ++i) {
            ValueConstraint condition = result[i];
            ValueConstraint constraint = contract.getParameterConstraint(i);
            if (condition == constraint || condition == ValueConstraint.ANY_VALUE) {
                result[i] = constraint;
                continue;
            }
            if (constraint == ValueConstraint.ANY_VALUE) {
                result[i] = condition;
                continue;
            }
            if (condition == ValueConstraint.NOT_NULL_VALUE && (constraint == ValueConstraint.TRUE_VALUE || constraint == ValueConstraint.FALSE_VALUE)) {
                result[i] = constraint;
                continue;
            }
            if (constraint == ValueConstraint.NOT_NULL_VALUE && (condition == ValueConstraint.TRUE_VALUE || condition == ValueConstraint.FALSE_VALUE)) {
                result[i] = condition;
                continue;
            }
            return null;
        }
        return new StandardMethodContract(result, this.getReturnValue().intersect(contract.getReturnValue()));
    }

    @NotNull
    Stream<StandardMethodContract> excludeContract(StandardMethodContract contract) {
        assert (contract.getParameterCount() == this.myParameters.length);
        List<ValueConstraint> constraints = contract.getConstraints();
        ArrayList<ValueConstraint> template = new ArrayList<ValueConstraint>(StreamEx.constant((Object)((Object)ValueConstraint.ANY_VALUE), (long)this.myParameters.length).toList());
        ArrayList<StandardMethodContract> antiContracts = new ArrayList<StandardMethodContract>();
        for (int i = 0; i < constraints.size(); ++i) {
            ValueConstraint constraint = constraints.get(i);
            if (constraint == ValueConstraint.ANY_VALUE) continue;
            template.set(i, constraint.negate());
            antiContracts.add(new StandardMethodContract(template.toArray(new ValueConstraint[0]), this.getReturnValue()));
            template.set(i, constraint);
        }
        StreamEx streamEx = StreamEx.of(antiContracts).map(this::intersect).nonNull();
        if (streamEx == null) {
            StandardMethodContract.$$$reportNull$$$0(4);
        }
        return streamEx;
    }

    public StandardMethodContract tryCollapse(StandardMethodContract other) {
        if (!other.getReturnValue().equals(this.getReturnValue())) {
            return null;
        }
        ValueConstraint[] thatParameters = other.myParameters;
        ValueConstraint[] thisParameters = this.myParameters;
        if (thatParameters.length != thisParameters.length) {
            return null;
        }
        ValueConstraint[] result = null;
        for (int i = 0; i < thisParameters.length; ++i) {
            ValueConstraint thisConstraint = thisParameters[i];
            ValueConstraint thatConstraint = thatParameters[i];
            if (thisConstraint == thatConstraint) continue;
            if (result != null || !thisConstraint.canBeNegated() || thisConstraint.negate() != thatConstraint) {
                return null;
            }
            result = (ValueConstraint[])thisParameters.clone();
            result[i] = ValueConstraint.ANY_VALUE;
        }
        return result == null ? null : new StandardMethodContract(result, this.getReturnValue());
    }

    @Nullable(value="When result is too big or contracts are erroneous")
    public static @Nullable(value="When result is too big or contracts are erroneous") List<StandardMethodContract> toNonIntersectingStandardContracts(List<StandardMethodContract> contracts) {
        if (contracts.isEmpty()) {
            return contracts;
        }
        int paramCount = contracts.get(0).getParameterCount();
        ArrayList<StandardMethodContract> result = new ArrayList<StandardMethodContract>();
        List leftovers = Collections.singletonList(StandardMethodContract.trivialContract(paramCount, ContractReturnValue.returnAny()));
        for (StandardMethodContract contract : contracts) {
            if (contract.getParameterCount() != paramCount) {
                return null;
            }
            StreamEx.of(leftovers).map(c -> c.intersect(contract)).nonNull().into(result);
            if (result.size() >= 300) {
                return null;
            }
            if (!(leftovers = StreamEx.of(leftovers).flatMap(c -> c.excludeContract(contract)).toList()).isEmpty()) continue;
            break;
        }
        return result;
    }

    public static ValueConstraint @NotNull [] createConstraintArray(int paramCount) {
        ValueConstraint[] args = new ValueConstraint[paramCount];
        Arrays.fill((Object[])args, (Object)ValueConstraint.ANY_VALUE);
        if (args == null) {
            StandardMethodContract.$$$reportNull$$$0(5);
        }
        return args;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        StandardMethodContract contract = (StandardMethodContract)o;
        return Arrays.equals((Object[])this.myParameters, (Object[])contract.myParameters) && this.getReturnValue().equals(contract.getReturnValue());
    }

    public int hashCode() {
        int result = 0;
        for (ValueConstraint argument : this.myParameters) {
            result = 31 * result + argument.ordinal();
        }
        result = 31 * result + this.getReturnValue().hashCode();
        return result;
    }

    @Override
    String getArgumentsPresentation() {
        return StringUtil.join((Object[])this.myParameters, ValueConstraint::toString, (String)", ");
    }

    @Override
    public List<ContractValue> getConditions() {
        return IntStreamEx.ofIndices((Object[])this.myParameters).mapToObj(idx -> this.myParameters[idx].getCondition(idx)).without((Object)ContractValue.booleanValue(true)).toList();
    }

    public static List<StandardMethodContract> parseContract(@NotNull String text) throws ParseException {
        if (text == null) {
            StandardMethodContract.$$$reportNull$$$0(6);
        }
        if (StringUtil.isEmptyOrSpaces((String)text)) {
            return Collections.emptyList();
        }
        ArrayList<StandardMethodContract> result = new ArrayList<StandardMethodContract>();
        String[] split = StringUtil.replace((String)text, (String)" ", (String)"").split(";");
        for (int clauseIndex = 0; clauseIndex < split.length; ++clauseIndex) {
            String clause = split[clauseIndex];
            result.add(StandardMethodContract.fromText(text, clauseIndex, clause));
        }
        return result;
    }

    @NotNull
    static StandardMethodContract fromText(@NotNull String clause) {
        if (clause == null) {
            StandardMethodContract.$$$reportNull$$$0(7);
        }
        try {
            return StandardMethodContract.fromText(clause, 0, clause);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    private static StandardMethodContract fromText(@NotNull String text, int clauseIndex, @NotNull String clause) throws ParseException {
        String returnValueString;
        ContractReturnValue returnValue;
        ValueConstraint[] args;
        String arrow;
        int arrowIndex;
        if (text == null) {
            StandardMethodContract.$$$reportNull$$$0(8);
        }
        if (clause == null) {
            StandardMethodContract.$$$reportNull$$$0(9);
        }
        if ((arrowIndex = clause.indexOf(arrow = "->")) < 0) {
            throw ParseException.forClause(JavaAnalysisBundle.message((String)"inspection.contract.checker.clause.syntax", (Object[])new Object[0]), text, clauseIndex);
        }
        String beforeArrow = clause.substring(0, arrowIndex);
        if (StringUtil.isNotEmpty((String)beforeArrow)) {
            String[] argStrings = beforeArrow.split(",");
            args = new ValueConstraint[argStrings.length];
            for (int i = 0; i < args.length; ++i) {
                args[i] = StandardMethodContract.parseConstraint(argStrings[i], text, clauseIndex, i);
            }
        } else {
            args = new ValueConstraint[]{};
        }
        if ((returnValue = ContractReturnValue.valueOf(returnValueString = clause.substring(arrowIndex + arrow.length()))) == null) {
            String possibleValues = "null, !null, true, false, this, new, paramN, fail, _";
            String message = JavaAnalysisBundle.message((String)"inspection.contract.checker.unknown.return.value", (Object[])new Object[]{possibleValues, returnValueString});
            throw ParseException.forReturnValue(message, text, clauseIndex);
        }
        return new StandardMethodContract(args, returnValue);
    }

    private static ValueConstraint parseConstraint(String name, String text, int clauseIndex, int constraintIndex) throws ParseException {
        if (StringUtil.isEmpty((String)name)) {
            throw new ParseException(JavaAnalysisBundle.message((String)"inspection.contract.checker.empty.constraint", (Object[])new Object[0]));
        }
        for (ValueConstraint constraint : ValueConstraint.values()) {
            if (!constraint.toString().equals(name)) continue;
            return constraint;
        }
        String allowedClause = StreamEx.of((Object[])ValueConstraint.values()).joining((CharSequence)", ");
        String message = JavaAnalysisBundle.message((String)"inspection.contract.checker.unknown.constraint", (Object[])new Object[]{allowedClause, name});
        throw ParseException.forConstraint(message, text, clauseIndex, constraintIndex);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "returnValue";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/StandardMethodContract";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clause";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/StandardMethodContract";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "excludeContract";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createConstraintArray";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "withReturnValue";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "trivialContract";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "parseContract";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "fromText";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5 -> new IllegalStateException(string);
        };
    }

    public static enum ValueConstraint {
        ANY_VALUE("_", ContractReturnValue.returnAny()),
        NULL_VALUE("null", ContractReturnValue.returnNull()),
        NOT_NULL_VALUE("!null", ContractReturnValue.returnNotNull()),
        TRUE_VALUE("true", ContractReturnValue.returnTrue()),
        FALSE_VALUE("false", ContractReturnValue.returnFalse());

        private final String myPresentableName;
        private final ContractReturnValue myCorrespondingReturnValue;

        private ValueConstraint(String presentableName, ContractReturnValue correspondingReturnValue) {
            this.myPresentableName = presentableName;
            this.myCorrespondingReturnValue = correspondingReturnValue;
        }

        public ContractReturnValue asReturnValue() {
            return this.myCorrespondingReturnValue;
        }

        @Nullable
        DfaValue getComparisonValue(DfaValueFactory factory) {
            if (this == NULL_VALUE || this == NOT_NULL_VALUE) {
                return factory.fromDfType((DfType)DfTypes.NULL);
            }
            if (this == TRUE_VALUE || this == FALSE_VALUE) {
                return factory.fromDfType((DfType)DfTypes.TRUE);
            }
            return null;
        }

        boolean shouldUseNonEqComparison() {
            return this == NOT_NULL_VALUE || this == FALSE_VALUE;
        }

        public ContractValue getCondition(int argumentIndex) {
            ContractValue left;
            if (this == NULL_VALUE || this == NOT_NULL_VALUE) {
                left = ContractValue.nullValue();
            } else if (this == TRUE_VALUE || this == FALSE_VALUE) {
                left = ContractValue.booleanValue(true);
            } else {
                return ContractValue.booleanValue(true);
            }
            return ContractValue.condition(left, RelationType.equivalence((!this.shouldUseNonEqComparison() ? 1 : 0) != 0), ContractValue.argument(argumentIndex));
        }

        public boolean canBeNegated() {
            return this != ANY_VALUE;
        }

        public ValueConstraint negate() {
            return switch (this.ordinal()) {
                case 1 -> NOT_NULL_VALUE;
                case 2 -> NULL_VALUE;
                case 3 -> FALSE_VALUE;
                case 4 -> TRUE_VALUE;
                default -> throw new IllegalStateException("ValueConstraint = " + String.valueOf((Object)this));
            };
        }

        public String toString() {
            return this.myPresentableName;
        }
    }

    public static class ParseException
    extends Exception {
        @Nullable
        private final TextRange myRange;

        ParseException(@InspectionMessage String message) {
            this(message, (TextRange)null);
        }

        ParseException(@InspectionMessage String message, @Nullable TextRange range) {
            super(message);
            this.myRange = range != null && range.isEmpty() ? null : range;
        }

        @Override
        @NlsSafe
        public String getMessage() {
            return super.getMessage();
        }

        @Nullable
        public TextRange getRange() {
            return this.myRange;
        }

        static ParseException forConstraint(@InspectionMessage String message, String text, int clauseNumber, int constraintNumber) {
            TextRange range = ParseException.findClauseRange(text, clauseNumber);
            if (range == null) {
                return new ParseException(message);
            }
            int start = range.getStartOffset();
            while (constraintNumber > 0) {
                if ((start = text.indexOf(44, start)) == -1) {
                    return new ParseException(message, range);
                }
                ++start;
                --constraintNumber;
            }
            int end = text.indexOf(44, start);
            if (!(end != -1 && end <= range.getEndOffset() || (end = text.indexOf("->", start)) != -1 && end <= range.getEndOffset())) {
                end = range.getEndOffset();
            }
            if (!text.substring(start, end).trim().isEmpty()) {
                while (text.charAt(start) == ' ') {
                    ++start;
                }
                while (end > start && text.charAt(end - 1) == ' ') {
                    --end;
                }
            }
            return new ParseException(message, new TextRange(start, end));
        }

        static ParseException forReturnValue(@InspectionMessage String message, String text, int clauseNumber) {
            TextRange range = ParseException.findClauseRange(text, clauseNumber);
            if (range == null) {
                return new ParseException(message);
            }
            int index = text.indexOf("->", range.getStartOffset());
            if (index == -1 || index > range.getEndOffset()) {
                return new ParseException(message, range);
            }
            index += "->".length();
            while (index < range.getEndOffset() && text.charAt(index) == ' ') {
                ++index;
            }
            if (index == range.getEndOffset()) {
                return new ParseException(message, range);
            }
            return new ParseException(message, new TextRange(index, range.getEndOffset()));
        }

        static ParseException forClause(@InspectionMessage String message, String text, int clauseNumber) {
            TextRange range = ParseException.findClauseRange(text, clauseNumber);
            return range == null ? new ParseException(message) : new ParseException(message, range);
        }

        private static TextRange findClauseRange(String text, int clauseNumber) {
            int start = 0;
            while (clauseNumber > 0) {
                if ((start = text.indexOf(59, start)) == -1) {
                    return null;
                }
                ++start;
                --clauseNumber;
            }
            int end = text.indexOf(59, start);
            if (end == -1) {
                end = text.length();
            }
            if (text.substring(start, end).trim().isEmpty()) {
                return new TextRange(start, end);
            }
            while (text.charAt(start) == ' ') {
                ++start;
            }
            while (end > start && text.charAt(end - 1) == ' ') {
                --end;
            }
            return new TextRange(start, end);
        }
    }
}

