/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.DfaUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConstantEvaluationHelper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StringExpressionHelper {
    @Nullable
    public static Pair<PsiElement, String> evaluateExpression(@NotNull PsiElement expression) {
        if (expression == null) {
            StringExpressionHelper.$$$reportNull$$$0(0);
        }
        return StringExpressionHelper.evaluateExpression(expression, new HashSet<PsiElement>());
    }

    @Nullable
    public static Pair<PsiElement, String> evaluateExpression(@NotNull PsiElement expression, @NotNull Collection<PsiElement> visited) {
        Pair<PsiElement, String> expr;
        PsiExpression initializer;
        PsiElement resolve;
        if (expression == null) {
            StringExpressionHelper.$$$reportNull$$$0(1);
        }
        if (visited == null) {
            StringExpressionHelper.$$$reportNull$$$0(2);
        }
        if (!visited.add(expression)) {
            return null;
        }
        if (expression instanceof PsiLiteralExpression) {
            return StringExpressionHelper.evaluatePsiLiteralExpression(expression);
        }
        if (expression instanceof PsiReferenceExpression && (resolve = ((PsiReferenceExpression)expression).resolve()) instanceof PsiVariable && (initializer = ((PsiVariable)resolve).getInitializer()) != null && (expr = StringExpressionHelper.evaluateExpression((PsiElement)initializer, visited)) != null) {
            return expr;
        }
        if (expression instanceof PsiMethodCallExpression) {
            PsiElement element = ((PsiMethodCallExpression)expression).getMethodExpression().resolve();
            if (element instanceof PsiMethod) {
                PsiCodeBlock body = ((PsiMethod)element).getBody();
                if (body != null) {
                    final HashSet returns = new HashSet();
                    body.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                        public void visitClass(@NotNull PsiClass aClass) {
                            if (aClass == null) {
                                1.$$$reportNull$$$0(0);
                            }
                        }

                        public void visitLambdaExpression(@NotNull PsiLambdaExpression expression) {
                            if (expression == null) {
                                1.$$$reportNull$$$0(1);
                            }
                        }

                        public void visitReturnStatement(@NotNull PsiReturnStatement statement) {
                            PsiExpression returnValue;
                            if (statement == null) {
                                1.$$$reportNull$$$0(2);
                            }
                            if ((returnValue = statement.getReturnValue()) != null) {
                                returns.add(returnValue);
                            }
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            Object[] objectArray;
                            Object[] objectArray2;
                            Object[] objectArray3 = new Object[3];
                            switch (n) {
                                default: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "aClass";
                                    break;
                                }
                                case 1: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "expression";
                                    break;
                                }
                                case 2: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "statement";
                                    break;
                                }
                            }
                            objectArray2[1] = "com/intellij/codeInspection/dataFlow/StringExpressionHelper$1";
                            switch (n) {
                                default: {
                                    objectArray = objectArray2;
                                    objectArray2[2] = "visitClass";
                                    break;
                                }
                                case 1: {
                                    objectArray = objectArray2;
                                    objectArray2[2] = "visitLambdaExpression";
                                    break;
                                }
                                case 2: {
                                    objectArray = objectArray2;
                                    objectArray2[2] = "visitReturnStatement";
                                    break;
                                }
                            }
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                        }
                    });
                    for (PsiExpression psiExpression : returns) {
                        Pair<PsiElement, String> pair = StringExpressionHelper.evaluateExpression((PsiElement)psiExpression, visited);
                        if (pair == null) continue;
                        return pair;
                    }
                }
                return StringExpressionHelper.evaluateExpression(element, visited);
            }
            return null;
        }
        Pair<PsiElement, String> constantExpression = StringExpressionHelper.evaluateConstantExpression(expression);
        if (constantExpression != null) {
            return constantExpression;
        }
        if (expression instanceof PsiBinaryExpression) {
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)expression;
            return StringExpressionHelper.evaluatePolyadicExpressions(expression, visited, binaryExpression.getLOperand(), binaryExpression.getROperand());
        }
        if (expression instanceof PsiPolyadicExpression) {
            return StringExpressionHelper.evaluatePolyadicExpressions(expression, visited, ((PsiPolyadicExpression)expression).getOperands());
        }
        Collection<PsiExpression> elements = DfaUtil.getPossibleInitializationElements(expression);
        for (PsiElement psiElement : elements) {
            Pair<PsiElement, String> expr2 = StringExpressionHelper.evaluateExpression(psiElement, visited);
            if (expr2 == null) continue;
            return expr2;
        }
        return null;
    }

    @Nullable
    private static Pair<PsiElement, String> evaluatePolyadicExpressions(@NotNull PsiElement expression, @NotNull Collection<PsiElement> visited, PsiExpression ... operands) {
        if (expression == null) {
            StringExpressionHelper.$$$reportNull$$$0(3);
        }
        if (visited == null) {
            StringExpressionHelper.$$$reportNull$$$0(4);
        }
        if (operands == null) {
            StringExpressionHelper.$$$reportNull$$$0(5);
        }
        StringBuilder sb = new StringBuilder();
        for (PsiExpression operand : operands) {
            Pair<PsiElement, String> pair = StringExpressionHelper.evaluateExpression((PsiElement)operand, visited);
            if (pair == null) {
                return null;
            }
            sb.append((String)pair.second);
        }
        return Pair.create((Object)expression, (Object)sb.toString());
    }

    @NotNull
    private static Pair<PsiElement, String> evaluatePsiLiteralExpression(@NotNull PsiElement expression) {
        if (expression == null) {
            StringExpressionHelper.$$$reportNull$$$0(6);
        }
        Pair pair = Pair.create((Object)expression, (Object)ElementManipulators.getValueText((PsiElement)expression));
        if (pair == null) {
            StringExpressionHelper.$$$reportNull$$$0(7);
        }
        return pair;
    }

    @Nullable
    public static Pair<PsiElement, String> evaluateConstantExpression(@NotNull PsiElement expression) {
        PsiConstantEvaluationHelper helper;
        Object result;
        if (expression == null) {
            StringExpressionHelper.$$$reportNull$$$0(8);
        }
        if ((result = (helper = JavaPsiFacade.getInstance((Project)expression.getProject()).getConstantEvaluationHelper()).computeConstantExpression(expression)) instanceof String) {
            return Pair.create((Object)expression, (Object)((String)result));
        }
        return null;
    }

    @NotNull
    public static Set<Pair<PsiElement, String>> searchStringExpressions(@NotNull PsiMethod psiMethod, @NotNull SearchScope searchScope, int expNum) {
        if (psiMethod == null) {
            StringExpressionHelper.$$$reportNull$$$0(9);
        }
        if (searchScope == null) {
            StringExpressionHelper.$$$reportNull$$$0(10);
        }
        HashSet<Pair<PsiElement, String>> pairs = new HashSet<Pair<PsiElement, String>>();
        for (PsiCall methodCallExpression : StringExpressionHelper.searchMethodCalls(psiMethod, searchScope)) {
            PsiExpression expression;
            Pair<PsiElement, String> pair;
            PsiExpression[] expressions;
            PsiExpressionList argumentList = methodCallExpression.getArgumentList();
            if (argumentList == null || (expressions = argumentList.getExpressions()).length <= expNum || (pair = StringExpressionHelper.evaluateExpression((PsiElement)(expression = expressions[expNum]))) == null) continue;
            pairs.add(pair);
        }
        HashSet<Pair<PsiElement, String>> hashSet = pairs;
        if (hashSet == null) {
            StringExpressionHelper.$$$reportNull$$$0(11);
        }
        return hashSet;
    }

    @NotNull
    public static Set<PsiCall> searchMethodCalls(@NotNull PsiMethod psiMethod, @NotNull SearchScope searchScope) {
        if (psiMethod == null) {
            StringExpressionHelper.$$$reportNull$$$0(12);
        }
        if (searchScope == null) {
            StringExpressionHelper.$$$reportNull$$$0(13);
        }
        HashSet<PsiCall> callExpressions = new HashSet<PsiCall>();
        CommonProcessors.CollectUniquesProcessor consumer = new CommonProcessors.CollectUniquesProcessor();
        MethodReferencesSearch.search((PsiMethod)psiMethod, (SearchScope)searchScope, (boolean)true).forEach((Processor)consumer);
        for (PsiReference psiReference : consumer.getResults()) {
            PsiCall methodCallExpression = (PsiCall)PsiTreeUtil.getParentOfType((PsiElement)psiReference.getElement(), PsiCall.class);
            if (methodCallExpression == null) continue;
            callExpressions.add(methodCallExpression);
        }
        HashSet<PsiCall> hashSet = callExpressions;
        if (hashSet == null) {
            StringExpressionHelper.$$$reportNull$$$0(14);
        }
        return hashSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 11, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visited";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operands";
                break;
            }
            case 7: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/StringExpressionHelper";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiMethod";
                break;
            }
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/StringExpressionHelper";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "evaluatePsiLiteralExpression";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "searchStringExpressions";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "searchMethodCalls";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "evaluateExpression";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "evaluatePolyadicExpressions";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "evaluatePsiLiteralExpression";
                break;
            }
            case 7: 
            case 11: 
            case 14: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "evaluateConstantExpression";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "searchStringExpressions";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "searchMethodCalls";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 11, 14 -> new IllegalStateException(string);
        };
    }
}

