/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.DfaNullability;
import com.intellij.codeInspection.dataFlow.TypeConstraint;
import com.intellij.codeInspection.dataFlow.interpreter.DataFlowInterpreter;
import com.intellij.codeInspection.dataFlow.java.anchor.JavaExpressionAnchor;
import com.intellij.codeInspection.dataFlow.java.inst.AssignInstruction;
import com.intellij.codeInspection.dataFlow.jvm.JvmDfaMemoryStateImpl;
import com.intellij.codeInspection.dataFlow.jvm.problems.ContractFailureProblem;
import com.intellij.codeInspection.dataFlow.jvm.problems.JvmDfaProblem;
import com.intellij.codeInspection.dataFlow.lang.DfaAnchor;
import com.intellij.codeInspection.dataFlow.lang.UnsatisfiedConditionProblem;
import com.intellij.codeInspection.dataFlow.lang.ir.ConditionalGotoInstruction;
import com.intellij.codeInspection.dataFlow.lang.ir.DfaInstructionState;
import com.intellij.codeInspection.dataFlow.lang.ir.EnsureInstruction;
import com.intellij.codeInspection.dataFlow.lang.ir.ExpressionPushingInstruction;
import com.intellij.codeInspection.dataFlow.lang.ir.Instruction;
import com.intellij.codeInspection.dataFlow.memory.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.memory.DistinctPairSet;
import com.intellij.codeInspection.dataFlow.memory.EqClass;
import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeBinOp;
import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeSet;
import com.intellij.codeInspection.dataFlow.types.DfAntiConstantType;
import com.intellij.codeInspection.dataFlow.types.DfConstantType;
import com.intellij.codeInspection.dataFlow.types.DfLongType;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.types.DfTypes;
import com.intellij.codeInspection.dataFlow.value.DfaBinOpValue;
import com.intellij.codeInspection.dataFlow.value.DfaTypeValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.codeInspection.dataFlow.value.RelationType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.ExpressionUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import one.util.streamex.EntryStream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TrackingDfaMemoryState
extends JvmDfaMemoryStateImpl {
    private MemoryStateChange myHistory;

    protected TrackingDfaMemoryState(DfaValueFactory factory) {
        super(factory);
        this.myHistory = null;
    }

    protected TrackingDfaMemoryState(TrackingDfaMemoryState toCopy) {
        super(toCopy);
        this.myHistory = toCopy.myHistory;
    }

    @Override
    @NotNull
    public TrackingDfaMemoryState createCopy() {
        return new TrackingDfaMemoryState(this);
    }

    public void afterMerge(@NotNull DfaMemoryState other) {
        if (other == null) {
            TrackingDfaMemoryState.$$$reportNull$$$0(0);
        }
        super.afterMerge(other);
        assert (other instanceof TrackingDfaMemoryState);
        MemoryStateChange otherHistory = ((TrackingDfaMemoryState)other).myHistory;
        this.myHistory = this.myHistory == null ? otherHistory : (otherHistory == null ? this.myHistory : this.myHistory.merge(otherHistory));
    }

    private Map<DfaVariableValue, Set<Relation>> getRelations() {
        HashMap<DfaVariableValue, Set<Relation>> result = new HashMap<DfaVariableValue, Set<Relation>>();
        this.forRecordedVariableTypes((var, type) -> {
            Set notValues;
            if (type instanceof DfConstantType) {
                result.computeIfAbsent((DfaVariableValue)var, k -> new HashSet()).add(new Relation(RelationType.EQ, (DfaValue)this.getFactory().fromDfType(type)));
            }
            if (type instanceof DfAntiConstantType && !(notValues = ((DfAntiConstantType)type).getNotValues()).isEmpty()) {
                DfType dfType = var.getDfType();
                for (Object notValue : notValues) {
                    result.computeIfAbsent((DfaVariableValue)var, k -> new HashSet()).add(new Relation(RelationType.NE, (DfaValue)this.getFactory().fromDfType(DfTypes.constant(notValue, dfType))));
                }
            }
        });
        for (EqClass eqClass : this.getNonTrivialEqClasses()) {
            for (DfaVariableValue var2 : eqClass) {
                Set set = result.computeIfAbsent(var2, k -> new HashSet());
                for (DfaVariableValue eqVar : eqClass) {
                    if (eqVar == var2) continue;
                    set.add(new Relation(RelationType.EQ, (DfaValue)eqVar));
                }
            }
        }
        for (DistinctPairSet.DistinctPair classPair : this.getDistinctClassPairs()) {
            EqClass first = classPair.getFirst();
            EqClass second = classPair.getSecond();
            RelationType plain = classPair.isOrdered() ? RelationType.LT : RelationType.NE;
            RelationType flipped = Objects.requireNonNull(plain.getFlipped());
            for (DfaVariableValue var1 : first) {
                for (DfaVariableValue var2 : second) {
                    result.computeIfAbsent(var1, k -> new HashSet()).add(new Relation(plain, (DfaValue)var2));
                    result.computeIfAbsent(var2, k -> new HashSet()).add(new Relation(flipped, (DfaValue)var1));
                }
            }
        }
        return result;
    }

    void recordChange(Instruction instruction, TrackingDfaMemoryState previous) {
        Map<DfaVariableValue, Change> result = this.getChangeMap(previous);
        DfaValue value = this.isEmptyStack() ? this.getFactory().getUnknown() : this.peek();
        this.myHistory = MemoryStateChange.create(this.myHistory, instruction, result, value);
    }

    @NotNull
    private Map<DfaVariableValue, Change> getChangeMap(TrackingDfaMemoryState previous) {
        HashMap<DfaVariableValue, Change> changeMap = new HashMap<DfaVariableValue, Change>();
        HashSet<DfaVariableValue> varsToCheck = new HashSet<DfaVariableValue>();
        previous.forRecordedVariableTypes((value, state) -> varsToCheck.add((DfaVariableValue)value));
        this.forRecordedVariableTypes((value, state) -> varsToCheck.add((DfaVariableValue)value));
        for (DfaVariableValue value2 : varsToCheck) {
            DfType oldType;
            DfType newType = this.getDfType((DfaValue)value2);
            if (newType.equals((Object)(oldType = previous.getDfType((DfaValue)value2)))) continue;
            changeMap.put(value2, new Change(Collections.emptySet(), Collections.emptySet(), oldType, newType));
        }
        Map<DfaVariableValue, Set<Relation>> oldRelations = previous.getRelations();
        Map<DfaVariableValue, Set<Relation>> newRelations = this.getRelations();
        varsToCheck.clear();
        varsToCheck.addAll(oldRelations.keySet());
        varsToCheck.addAll(newRelations.keySet());
        for (DfaVariableValue value3 : varsToCheck) {
            Set newValueRelations;
            Set oldValueRelations = oldRelations.getOrDefault(value3, Collections.emptySet());
            if (oldValueRelations.equals(newValueRelations = newRelations.getOrDefault(value3, Collections.emptySet()))) continue;
            HashSet added = new HashSet(newValueRelations);
            added.removeAll(oldValueRelations);
            HashSet removed = new HashSet(oldValueRelations);
            removed.removeAll(newValueRelations);
            changeMap.compute(value3, (v, change) -> change == null ? Change.create(removed, added, DfType.BOTTOM, DfType.BOTTOM) : Change.create(removed, added, change.myOldType, change.myNewType));
        }
        HashMap<DfaVariableValue, Change> hashMap = changeMap;
        if (hashMap == null) {
            TrackingDfaMemoryState.$$$reportNull$$$0(1);
        }
        return hashMap;
    }

    MemoryStateChange getHistory() {
        return this.myHistory;
    }

    void addBridge(Instruction instruction, List<TrackingDfaMemoryState> bridgeStates) {
        Map<DfaVariableValue, Change> changeMap = null;
        for (TrackingDfaMemoryState bridge : bridgeStates) {
            Map<DfaVariableValue, Change> newChangeMap = this.getChangeMap(bridge);
            if (changeMap == null) {
                changeMap = newChangeMap;
            } else {
                changeMap.keySet().retainAll(newChangeMap.keySet());
                changeMap.replaceAll((var, old) -> old.unite((Change)newChangeMap.get(var)));
                changeMap.values().removeIf(Objects::isNull);
            }
            if (!changeMap.isEmpty()) continue;
            break;
        }
        if (changeMap != null && !changeMap.isEmpty() && this.myHistory != null) {
            this.myHistory = this.myHistory.withBridge(instruction, changeMap);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/TrackingDfaMemoryState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/TrackingDfaMemoryState";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getChangeMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "afterMerge";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    static final class MemoryStateChange {
        @NotNull
        private final List<MemoryStateChange> myPrevious;
        @NotNull
        final Instruction myInstruction;
        @NotNull
        final Map<DfaVariableValue, Change> myChanges;
        @NotNull
        final DfaValue myTopOfStack;
        @NotNull
        final Map<DfaVariableValue, Change> myBridgeChanges;
        int myCursor;

        private MemoryStateChange(@NotNull List<MemoryStateChange> previous, @NotNull Instruction instruction, @NotNull Map<DfaVariableValue, Change> changes, @NotNull DfaValue topOfStack, @NotNull Map<DfaVariableValue, Change> bridgeChanges) {
            if (previous == null) {
                MemoryStateChange.$$$reportNull$$$0(0);
            }
            if (instruction == null) {
                MemoryStateChange.$$$reportNull$$$0(1);
            }
            if (changes == null) {
                MemoryStateChange.$$$reportNull$$$0(2);
            }
            if (topOfStack == null) {
                MemoryStateChange.$$$reportNull$$$0(3);
            }
            if (bridgeChanges == null) {
                MemoryStateChange.$$$reportNull$$$0(4);
            }
            this.myCursor = 0;
            this.myPrevious = previous;
            this.myInstruction = instruction;
            this.myChanges = changes;
            this.myTopOfStack = topOfStack;
            this.myBridgeChanges = bridgeChanges;
        }

        void reset() {
            for (MemoryStateChange change = this; change != null; change = change.getPrevious()) {
                change.myCursor = 0;
            }
        }

        boolean advance() {
            if (this.myCursor < this.myPrevious.size() && !this.myPrevious.get(this.myCursor).advance()) {
                ++this.myCursor;
                MemoryStateChange previous = this.getPrevious();
                if (previous != null) {
                    previous.reset();
                }
            }
            return this.myCursor < this.myPrevious.size();
        }

        @Contract(value="null -> null")
        @Nullable
        MemoryStateChange findExpressionPush(@Nullable PsiExpression expression) {
            if (expression == null) {
                return null;
            }
            return this.findChange(change -> change.getExpression() == expression, false);
        }

        @Contract(value="null -> null")
        @Nullable
        MemoryStateChange findSubExpressionPush(@Nullable PsiExpression expression) {
            if (expression == null) {
                return null;
            }
            PsiElement topElement = ExpressionUtils.getPassThroughParent(expression);
            return this.findChange(change -> {
                PsiExpression changeExpression = change.getExpression();
                if (changeExpression == null) {
                    return false;
                }
                return changeExpression == expression || PsiTreeUtil.isAncestor((PsiElement)expression, (PsiElement)changeExpression, (boolean)true) && ExpressionUtils.getPassThroughParent(changeExpression) == topElement;
            }, false);
        }

        MemoryStateChange findRelation(DfaVariableValue value, @NotNull Predicate<? super Relation> relationPredicate, boolean startFromSelf) {
            if (relationPredicate == null) {
                MemoryStateChange.$$$reportNull$$$0(5);
            }
            return this.findChange(change -> {
                if (change.myInstruction instanceof AssignInstruction && change.myTopOfStack == value) {
                    return true;
                }
                Change varChange = change.myChanges.get(value);
                if (varChange != null && varChange.myAddedRelations.stream().anyMatch(relationPredicate)) {
                    return true;
                }
                Change bridgeVarChange = change.myBridgeChanges.get(value);
                return bridgeVarChange != null && bridgeVarChange.myAddedRelations.stream().anyMatch(relationPredicate);
            }, startFromSelf);
        }

        @NotNull
        <T> FactDefinition<T> findFact(DfaValue value, FactExtractor<T> extractor) {
            if (value instanceof DfaVariableValue) {
                for (MemoryStateChange change = this; change != null; change = change.getPrevious()) {
                    FactDefinition<T> factPair = MemoryStateChange.factFromChange(extractor, change, change.myChanges.get(value));
                    if (factPair != null) {
                        FactDefinition<T> factDefinition = factPair;
                        if (factDefinition == null) {
                            MemoryStateChange.$$$reportNull$$$0(6);
                        }
                        return factDefinition;
                    }
                    if (!(change.myInstruction instanceof ConditionalGotoInstruction) && (factPair = MemoryStateChange.factFromChange(extractor, change, change.myBridgeChanges.get(value))) != null) {
                        FactDefinition<T> factDefinition = factPair;
                        if (factDefinition == null) {
                            MemoryStateChange.$$$reportNull$$$0(7);
                        }
                        return factDefinition;
                    }
                    if (!(change.myInstruction instanceof AssignInstruction) || change.myTopOfStack != value || change.getPrevious() == null) continue;
                    FactDefinition<T> fact = change.getPrevious().findFact(value, extractor);
                    return new FactDefinition(change, fact.myFact, fact.myOldFact);
                }
                return new FactDefinition<Object>(null, extractor.extract(((DfaVariableValue)value).getInherentType()), null);
            }
            if (value instanceof DfaBinOpValue) {
                DfaBinOpValue binOp = (DfaBinOpValue)value;
                FactDefinition<T> left = this.findFact((DfaValue)binOp.getLeft(), extractor);
                FactDefinition<T> right = this.findFact(binOp.getRight(), extractor);
                if (left.myFact instanceof LongRangeSet && right.myFact instanceof LongRangeSet) {
                    LongRangeBinOp op = binOp.getOperation();
                    LongRangeSet result = op.eval((LongRangeSet)left.myFact, (LongRangeSet)right.myFact, binOp.getDfType().getLongRangeType());
                    LongRangeSet oldFact = null;
                    if (left.myOldFact != null && right.myOldFact != null) {
                        oldFact = op.eval((LongRangeSet)left.myOldFact, (LongRangeSet)right.myOldFact, binOp.getDfType().getLongRangeType());
                    }
                    return new FactDefinition<Object>(null, Objects.requireNonNull(result), oldFact);
                }
            }
            return new FactDefinition<Object>(null, extractor.extract(value.getDfType()), null);
        }

        @Nullable
        MemoryStateChange getPrevious() {
            return this.myCursor == this.myPrevious.size() ? null : this.myPrevious.get(this.myCursor);
        }

        public MemoryStateChange getNonMerge() {
            MemoryStateChange change;
            MemoryStateChange memoryStateChange = change = this.myInstruction instanceof MergeInstruction ? this.getPrevious() : this;
            assert (change == null || !(change.myInstruction instanceof MergeInstruction));
            return change;
        }

        @Nullable
        private static <T> FactDefinition<T> factFromChange(FactExtractor<T> extractor, MemoryStateChange change, Change varChange) {
            T oldFact;
            T newFact;
            if (varChange != null && !(newFact = extractor.extract(varChange.myNewType)).equals(oldFact = extractor.extract(varChange.myOldType))) {
                if (change.myInstruction instanceof EnsureInstruction && ((EnsureInstruction)change.myInstruction).getProblem() instanceof ContractFailureProblem) {
                    change = change.getPrevious();
                }
                return new FactDefinition<T>(change, newFact, oldFact);
            }
            return null;
        }

        @Nullable
        private MemoryStateChange findChange(@NotNull Predicate<? super MemoryStateChange> predicate, boolean startFromSelf) {
            MemoryStateChange change;
            if (predicate == null) {
                MemoryStateChange.$$$reportNull$$$0(8);
            }
            MemoryStateChange memoryStateChange = change = startFromSelf ? this : this.getPrevious();
            while (change != null) {
                if (predicate.test(change)) {
                    return change;
                }
                change = change.getPrevious();
            }
            return null;
        }

        @Nullable
        PsiExpression getExpression() {
            UnsatisfiedConditionProblem problem;
            DfaAnchor anchor;
            if (this.myInstruction instanceof ExpressionPushingInstruction && (anchor = ((ExpressionPushingInstruction)this.myInstruction).getDfaAnchor()) instanceof JavaExpressionAnchor) {
                return ((JavaExpressionAnchor)anchor).getExpression();
            }
            if (this.myInstruction instanceof ConditionalGotoInstruction) {
                return (PsiExpression)ObjectUtils.tryCast((Object)((ConditionalGotoInstruction)this.myInstruction).getPsiAnchor(), PsiExpression.class);
            }
            if (this.myInstruction instanceof EnsureInstruction && (problem = ((EnsureInstruction)this.myInstruction).getProblem()) instanceof JvmDfaProblem) {
                return (PsiExpression)ObjectUtils.tryCast(((JvmDfaProblem)problem).getAnchor(), PsiExpression.class);
            }
            return null;
        }

        @NotNull
        public MemoryStateChange merge(@NotNull MemoryStateChange change) {
            if (change == null) {
                MemoryStateChange.$$$reportNull$$$0(9);
            }
            if (change == this) {
                MemoryStateChange memoryStateChange = this;
                if (memoryStateChange == null) {
                    MemoryStateChange.$$$reportNull$$$0(10);
                }
                return memoryStateChange;
            }
            LinkedHashSet<MemoryStateChange> previous = new LinkedHashSet<MemoryStateChange>();
            if (this.myInstruction instanceof MergeInstruction) {
                previous.addAll(this.myPrevious);
            } else {
                previous.add(this);
            }
            if (change.myInstruction instanceof MergeInstruction) {
                previous.addAll(change.myPrevious);
            } else {
                previous.add(change);
            }
            if (previous.size() == 1) {
                MemoryStateChange memoryStateChange = (MemoryStateChange)previous.iterator().next();
                if (memoryStateChange == null) {
                    MemoryStateChange.$$$reportNull$$$0(11);
                }
                return memoryStateChange;
            }
            return new MemoryStateChange(new ArrayList<MemoryStateChange>(previous), new MergeInstruction(), Collections.emptyMap(), (DfaValue)this.myTopOfStack.getFactory().getUnknown(), Collections.emptyMap());
        }

        MemoryStateChange withBridge(@NotNull Instruction instruction, @NotNull Map<DfaVariableValue, Change> bridge) {
            if (instruction == null) {
                MemoryStateChange.$$$reportNull$$$0(12);
            }
            if (bridge == null) {
                MemoryStateChange.$$$reportNull$$$0(13);
            }
            if (this.myInstruction != instruction) {
                if (instruction instanceof ConditionalGotoInstruction && this.getExpression() == ((ConditionalGotoInstruction)instruction).getPsiAnchor()) {
                    instruction = this.myInstruction;
                } else {
                    return new MemoryStateChange(Collections.singletonList(this), instruction, Collections.emptyMap(), (DfaValue)this.myTopOfStack.getFactory().getUnknown(), bridge);
                }
            }
            assert (this.myBridgeChanges.isEmpty());
            return new MemoryStateChange(this.myPrevious, instruction, this.myChanges, this.myTopOfStack, bridge);
        }

        @Nullable
        static MemoryStateChange create(@Nullable MemoryStateChange previous, @NotNull Instruction instruction, @NotNull Map<DfaVariableValue, Change> result, @NotNull DfaValue value) {
            if (instruction == null) {
                MemoryStateChange.$$$reportNull$$$0(14);
            }
            if (result == null) {
                MemoryStateChange.$$$reportNull$$$0(15);
            }
            if (value == null) {
                MemoryStateChange.$$$reportNull$$$0(16);
            }
            if (result.isEmpty() && DfaTypeValue.isUnknown((DfaValue)value)) {
                return previous;
            }
            return new MemoryStateChange(ContainerUtil.createMaybeSingletonList((Object)previous), instruction, result, value, Collections.emptyMap());
        }

        MemoryStateChange[] flatten() {
            List changes = StreamEx.iterate((Object)this, Objects::nonNull, change -> change.getPrevious()).toList();
            return (MemoryStateChange[])ArrayUtil.reverseArray((Object[])changes.toArray(new MemoryStateChange[0]));
        }

        String dump() {
            return StreamEx.of((Object[])this.flatten()).joining((CharSequence)"\n");
        }

        public String toString() {
            return this.myInstruction.getIndex() + " " + String.valueOf(this.myInstruction) + ": " + String.valueOf(this.myTopOfStack) + (String)(this.myChanges.isEmpty() ? "" : "; Changes: " + EntryStream.of(this.myChanges).join((CharSequence)": ", (CharSequence)"\n\t", (CharSequence)"").joining()) + (String)(this.myBridgeChanges.isEmpty() ? "" : "; Bridge changes: " + EntryStream.of(this.myBridgeChanges).join((CharSequence)": ", (CharSequence)"\n\t", (CharSequence)"").joining());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 6, 7, 10, 11 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "previous";
                    break;
                }
                case 1: 
                case 12: 
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "instruction";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "changes";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "topOfStack";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "bridgeChanges";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "relationPredicate";
                    break;
                }
                case 6: 
                case 7: 
                case 10: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/dataFlow/TrackingDfaMemoryState$MemoryStateChange";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "predicate";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "change";
                    break;
                }
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "bridge";
                    break;
                }
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/dataFlow/TrackingDfaMemoryState$MemoryStateChange";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "findFact";
                    break;
                }
                case 10: 
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "merge";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "findRelation";
                    break;
                }
                case 6: 
                case 7: 
                case 10: 
                case 11: {
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "findChange";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "merge";
                    break;
                }
                case 12: 
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "withBridge";
                    break;
                }
                case 14: 
                case 15: 
                case 16: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 6, 7, 10, 11 -> new IllegalStateException(string);
            };
        }
    }

    static class Relation {
        @NotNull
        final RelationType myRelationType;
        @NotNull
        final DfaValue myCounterpart;

        Relation(@NotNull RelationType type, @NotNull DfaValue counterpart) {
            if (type == null) {
                Relation.$$$reportNull$$$0(0);
            }
            if (counterpart == null) {
                Relation.$$$reportNull$$$0(1);
            }
            this.myRelationType = type;
            this.myCounterpart = counterpart;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Relation relation = (Relation)o;
            return this.myRelationType == relation.myRelationType && this.myCounterpart.equals((Object)relation.myCounterpart);
        }

        public int hashCode() {
            return Objects.hash(this.myRelationType, this.myCounterpart);
        }

        public String toString() {
            return String.valueOf(this.myRelationType) + " " + String.valueOf(this.myCounterpart);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "type";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "counterpart";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInspection/dataFlow/TrackingDfaMemoryState$Relation";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static final class Change {
        @NotNull
        final Set<Relation> myRemovedRelations;
        @NotNull
        final Set<Relation> myAddedRelations;
        @NotNull
        final DfType myOldType;
        @NotNull
        final DfType myNewType;

        private Change(@NotNull Set<Relation> removedRelations, @NotNull Set<Relation> addedRelations, @NotNull DfType oldType, @NotNull DfType newType) {
            if (removedRelations == null) {
                Change.$$$reportNull$$$0(0);
            }
            if (addedRelations == null) {
                Change.$$$reportNull$$$0(1);
            }
            if (oldType == null) {
                Change.$$$reportNull$$$0(2);
            }
            if (newType == null) {
                Change.$$$reportNull$$$0(3);
            }
            this.myRemovedRelations = removedRelations.isEmpty() ? Collections.emptySet() : removedRelations;
            this.myAddedRelations = addedRelations.isEmpty() ? Collections.emptySet() : addedRelations;
            this.myOldType = oldType;
            this.myNewType = newType;
        }

        @Nullable
        static Change create(Set<Relation> removedRelations, Set<Relation> addedRelations, DfType oldType, DfType newType) {
            if (removedRelations.isEmpty() && addedRelations.isEmpty() && oldType == DfType.BOTTOM && newType == DfType.BOTTOM) {
                return null;
            }
            return new Change(removedRelations, addedRelations, oldType, newType);
        }

        @Nullable
        Change unite(Change other) {
            DfType newType;
            HashSet<Relation> added = new HashSet<Relation>(ContainerUtil.intersection(this.myAddedRelations, other.myAddedRelations));
            HashSet<Relation> removed = new HashSet<Relation>(ContainerUtil.intersection(this.myRemovedRelations, other.myRemovedRelations));
            DfType oldType = this.myOldType.join(other.myOldType);
            if (oldType.equals((Object)(newType = this.myNewType.join(other.myNewType)))) {
                oldType = newType = DfType.BOTTOM;
            }
            return Change.create(removed, added, oldType, newType);
        }

        public String toString() {
            String removed = StreamEx.of(this.myRemovedRelations).map(Object::toString).append((Object)this.myOldType.toString()).without((Object)"").joining((CharSequence)", ");
            String added = StreamEx.of(this.myAddedRelations).map(Object::toString).append((Object)this.myNewType.toString()).without((Object)"").joining((CharSequence)", ");
            return (String)(removed.isEmpty() ? "" : "-{" + removed + "} ") + (String)(added.isEmpty() ? "" : "+{" + added + "}");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "removedRelations";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "addedRelations";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "oldType";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "newType";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInspection/dataFlow/TrackingDfaMemoryState$Change";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static interface FactExtractor<T> {
        @NotNull
        public T extract(DfType var1);

        public static FactExtractor<DfaNullability> nullability() {
            return DfaNullability::fromDfType;
        }

        public static FactExtractor<TypeConstraint> constraint() {
            return TypeConstraint::fromDfType;
        }

        public static FactExtractor<LongRangeSet> range() {
            return DfLongType::extractRange;
        }
    }

    static class FactDefinition<T> {
        @Nullable
        final MemoryStateChange myChange;
        @NotNull
        final T myFact;
        @Nullable
        final T myOldFact;

        FactDefinition(@Nullable MemoryStateChange change, @NotNull T fact, @Nullable T oldFact) {
            if (fact == null) {
                FactDefinition.$$$reportNull$$$0(0);
            }
            this.myChange = change;
            this.myFact = fact;
            this.myOldFact = oldFact;
        }

        public String toString() {
            return String.valueOf(this.myFact) + " @ " + String.valueOf(this.myChange);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fact", "com/intellij/codeInspection/dataFlow/TrackingDfaMemoryState$FactDefinition", "<init>"));
        }
    }

    private static class MergeInstruction
    extends Instruction {
        private MergeInstruction() {
        }

        public DfaInstructionState[] accept(@NotNull DataFlowInterpreter interpreter, @NotNull DfaMemoryState stateBefore) {
            if (interpreter == null) {
                MergeInstruction.$$$reportNull$$$0(0);
            }
            if (stateBefore == null) {
                MergeInstruction.$$$reportNull$$$0(1);
            }
            return DfaInstructionState.EMPTY_ARRAY;
        }

        public String toString() {
            return "STATE_MERGE";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "interpreter";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "stateBefore";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInspection/dataFlow/TrackingDfaMemoryState$MergeInstruction";
            objectArray[2] = "accept";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

