/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.ibm.icu.text.ListFormatter;
import com.intellij.DynamicBundle;
import com.intellij.codeInsight.Nullability;
import com.intellij.codeInsight.NullabilityAnnotationInfo;
import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInspection.dataFlow.ContractReturnValue;
import com.intellij.codeInspection.dataFlow.ContractValue;
import com.intellij.codeInspection.dataFlow.DfaCallArguments;
import com.intellij.codeInspection.dataFlow.DfaNullability;
import com.intellij.codeInspection.dataFlow.DfaPsiUtil;
import com.intellij.codeInspection.dataFlow.DfaUtil;
import com.intellij.codeInspection.dataFlow.JavaMethodContractUtil;
import com.intellij.codeInspection.dataFlow.MethodContract;
import com.intellij.codeInspection.dataFlow.NullabilityProblemKind;
import com.intellij.codeInspection.dataFlow.NullabilityUtil;
import com.intellij.codeInspection.dataFlow.StandardDataFlowRunner;
import com.intellij.codeInspection.dataFlow.StandardMethodContract;
import com.intellij.codeInspection.dataFlow.TrackingDfaMemoryState;
import com.intellij.codeInspection.dataFlow.TypeConstraint;
import com.intellij.codeInspection.dataFlow.TypeConstraints;
import com.intellij.codeInspection.dataFlow.interpreter.RunnerResult;
import com.intellij.codeInspection.dataFlow.interpreter.StandardDataFlowInterpreter;
import com.intellij.codeInspection.dataFlow.java.JavaDfaListener;
import com.intellij.codeInspection.dataFlow.java.anchor.JavaExpressionAnchor;
import com.intellij.codeInspection.dataFlow.java.inst.AssignInstruction;
import com.intellij.codeInspection.dataFlow.java.inst.CheckNotNullInstruction;
import com.intellij.codeInspection.dataFlow.java.inst.InstanceofInstruction;
import com.intellij.codeInspection.dataFlow.jvm.FieldChecker;
import com.intellij.codeInspection.dataFlow.jvm.JvmPsiRangeSetUtil;
import com.intellij.codeInspection.dataFlow.jvm.SpecialField;
import com.intellij.codeInspection.dataFlow.lang.DfaAnchor;
import com.intellij.codeInspection.dataFlow.lang.DfaListener;
import com.intellij.codeInspection.dataFlow.lang.ir.ConditionalGotoInstruction;
import com.intellij.codeInspection.dataFlow.lang.ir.ControlFlow;
import com.intellij.codeInspection.dataFlow.lang.ir.DfaInstructionState;
import com.intellij.codeInspection.dataFlow.lang.ir.ExpressionPushingInstruction;
import com.intellij.codeInspection.dataFlow.lang.ir.GotoInstruction;
import com.intellij.codeInspection.dataFlow.lang.ir.Instruction;
import com.intellij.codeInspection.dataFlow.lang.ir.PushInstruction;
import com.intellij.codeInspection.dataFlow.lang.ir.PushValueInstruction;
import com.intellij.codeInspection.dataFlow.lang.ir.ResultOfInstruction;
import com.intellij.codeInspection.dataFlow.lang.ir.WrapDerivedVariableInstruction;
import com.intellij.codeInspection.dataFlow.memory.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeBinOp;
import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeSet;
import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeType;
import com.intellij.codeInspection.dataFlow.types.DfConstantType;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.types.DfTypes;
import com.intellij.codeInspection.dataFlow.value.DerivedVariableDescriptor;
import com.intellij.codeInspection.dataFlow.value.DfaCondition;
import com.intellij.codeInspection.dataFlow.value.DfaRelation;
import com.intellij.codeInspection.dataFlow.value.DfaTypeValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.codeInspection.dataFlow.value.RelationType;
import com.intellij.codeInspection.dataFlow.value.VariableDescriptor;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiFileRange;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.JavaElementKind;
import com.intellij.psi.util.PsiExpressionTrimRenderer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.JavaPsiConstructorUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import one.util.streamex.IntStreamEx;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TrackingRunner
extends StandardDataFlowRunner {
    private TrackingDfaMemoryState.MemoryStateChange myHistoryForContext;
    private final PsiExpression myExpression;
    private final List<DfaInstructionState> afterStates;
    private final List<TrackingDfaMemoryState> killedStates;

    private TrackingRunner(@NotNull PsiElement context, PsiExpression expression, boolean ignoreAssertions) {
        if (context == null) {
            TrackingRunner.$$$reportNull$$$0(0);
        }
        super(context.getProject(), ThreeState.fromBoolean((boolean)ignoreAssertions));
        this.myHistoryForContext = null;
        this.afterStates = new ArrayList<DfaInstructionState>();
        this.killedStates = new ArrayList<TrackingDfaMemoryState>();
        this.myExpression = expression;
    }

    @Override
    @NotNull
    protected StandardDataFlowInterpreter createInterpreter(@NotNull DfaListener listener, @NotNull ControlFlow flow) {
        if (listener == null) {
            TrackingRunner.$$$reportNull$$$0(1);
        }
        if (flow == null) {
            TrackingRunner.$$$reportNull$$$0(2);
        }
        return new StandardDataFlowInterpreter(flow, listener, true){

            protected void beforeInstruction(Instruction instruction) {
                TrackingRunner.this.afterStates.clear();
                TrackingRunner.this.killedStates.clear();
            }

            protected DfaInstructionState @NotNull [] acceptInstruction(@NotNull DfaInstructionState instructionState) {
                JavaExpressionAnchor anchor;
                ExpressionPushingInstruction pushing;
                DfaInstructionState[] dfaInstructionStateArray;
                DfaInstructionState[] states;
                if (instructionState == null) {
                    1.$$$reportNull$$$0(0);
                }
                Instruction instruction = instructionState.getInstruction();
                TrackingDfaMemoryState memState = (TrackingDfaMemoryState)instructionState.getMemoryState().createCopy();
                for (DfaInstructionState state : states = super.acceptInstruction(instructionState)) {
                    TrackingRunner.this.afterStates.add(state);
                    ((TrackingDfaMemoryState)state.getMemoryState()).recordChange(instruction, memState);
                }
                if (states.length == 0) {
                    TrackingRunner.this.killedStates.add(memState);
                }
                if (instruction instanceof ExpressionPushingInstruction && (dfaInstructionStateArray = (pushing = (ExpressionPushingInstruction)instruction).getDfaAnchor()) instanceof JavaExpressionAnchor && (anchor = (JavaExpressionAnchor)dfaInstructionStateArray).getExpression() == TrackingRunner.this.myExpression) {
                    for (DfaInstructionState state : states) {
                        TrackingDfaMemoryState.MemoryStateChange history = ((TrackingDfaMemoryState)state.getMemoryState()).getHistory();
                        TrackingRunner.this.myHistoryForContext = TrackingRunner.this.myHistoryForContext == null ? history : TrackingRunner.this.myHistoryForContext.merge(history);
                    }
                }
                if (states == null) {
                    1.$$$reportNull$$$0(1);
                }
                return states;
            }

            protected void afterInstruction(Instruction instruction) {
                if (TrackingRunner.this.afterStates.size() <= 1 && TrackingRunner.this.killedStates.isEmpty()) {
                    return;
                }
                Map instructionToState = StreamEx.of(TrackingRunner.this.afterStates).mapToEntry(s -> s.getInstruction(), s -> (TrackingDfaMemoryState)s.getMemoryState()).grouping();
                if (instructionToState.size() <= 1 && TrackingRunner.this.killedStates.isEmpty()) {
                    return;
                }
                instructionToState.forEach((target, memStates) -> {
                    List bridgeChanges = ((StreamEx)StreamEx.of(TrackingRunner.this.afterStates).filter(s -> s.getInstruction() != target)).map(s -> (TrackingDfaMemoryState)s.getMemoryState()).append(TrackingRunner.this.killedStates).toList();
                    for (TrackingDfaMemoryState state : memStates) {
                        state.addBridge(instruction, bridgeChanges);
                    }
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "instructionState";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/codeInspection/dataFlow/TrackingRunner$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/codeInspection/dataFlow/TrackingRunner$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "acceptInstruction";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "acceptInstruction";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1 -> new IllegalStateException(string);
                };
            }
        };
    }

    @Override
    @NotNull
    protected DfaMemoryState createMemoryState() {
        return new TrackingDfaMemoryState(this.getFactory());
    }

    @Nullable
    public static CauseItem findProblemCause(boolean ignoreAssertions, PsiExpression expression, DfaProblemType type) {
        PsiElement body = DfaUtil.getDataflowContext((PsiElement)expression);
        if (body == null) {
            return null;
        }
        TrackingRunner runner = new TrackingRunner(body, expression, ignoreAssertions);
        if (!runner.analyze(expression, body)) {
            return null;
        }
        return runner.findProblemCause(expression, type);
    }

    private boolean analyze(PsiExpression expression, PsiElement body) {
        PsiCodeBlock ctorBody;
        PsiMethod ctor;
        final ArrayList endOfInitializerStates = new ArrayList();
        JavaDfaListener interceptor = new JavaDfaListener(){

            @Override
            public void beforeInstanceInitializerEnd(@NotNull DfaMemoryState state) {
                if (state == null) {
                    2.$$$reportNull$$$0(0);
                }
                endOfInitializerStates.add(state.createCopy());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/codeInspection/dataFlow/TrackingRunner$2", "beforeInstanceInitializerEnd"));
            }
        };
        RunnerResult result = this.analyzeMethodRecursively(body, interceptor);
        if (result != RunnerResult.OK) {
            return false;
        }
        if (body instanceof PsiClass && (ctor = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)expression, PsiMethod.class, (boolean)true, (Class[])new Class[]{PsiClass.class, PsiLambdaExpression.class})) != null && ctor.isConstructor() && (ctorBody = ctor.getBody()) != null) {
            PsiMethodCallExpression call = JavaPsiConstructorUtil.findThisOrSuperCallInConstructor((PsiMethod)ctor);
            List initialStates = JavaPsiConstructorUtil.isChainedConstructorCall((PsiElement)call) || call == null && DfaUtil.hasImplicitImpureSuperCall((PsiClass)body, ctor) ? Collections.singletonList(this.createMemoryState()) : ContainerUtil.map(endOfInitializerStates, DfaMemoryState::createCopy);
            return this.analyzeBlockRecursively((PsiElement)ctorBody, initialStates, interceptor) == RunnerResult.OK;
        }
        return true;
    }

    @Nullable
    private CauseItem findProblemCause(PsiExpression expression, DfaProblemType type) {
        if (this.myHistoryForContext == null) {
            return null;
        }
        CauseItem cause = null;
        do {
            CauseItem item = new CauseItem(type, (PsiElement)expression);
            TrackingDfaMemoryState.MemoryStateChange history = this.myHistoryForContext.getNonMerge();
            if (history.getExpression() == expression) {
                item.addChildren(type.findCauses(this, expression, history));
            }
            if (cause == null) {
                cause = item;
                continue;
            }
            if ((cause = cause.merge(item)) != null) continue;
            return null;
        } while (this.myHistoryForContext.advance());
        return cause;
    }

    private CauseItem @NotNull [] findConstantValueCause(@Nullable PsiExpression expression, TrackingDfaMemoryState.MemoryStateChange history, Object expectedValue) {
        TrackingDfaMemoryState.MemoryStateChange change;
        if (expression instanceof PsiLiteralExpression) {
            return new CauseItem[0];
        }
        Object constantExpressionValue = ExpressionUtils.computeConstantExpression(expression);
        DfaValue value = history.myTopOfStack;
        if (constantExpressionValue != null && constantExpressionValue.equals(expectedValue)) {
            CauseItem[] causeItemArray = new CauseItem[]{new CauseItem(JavaAnalysisBundle.message((String)"dfa.find.cause.compile.time.constant", (Object[])new Object[]{value}), (PsiElement)expression)};
            if (causeItemArray == null) {
                TrackingRunner.$$$reportNull$$$0(3);
            }
            return causeItemArray;
        }
        Boolean boolConst = (Boolean)value.getDfType().getConstantOfType(Boolean.class);
        if (boolConst != null && expression != null && boolConst.equals(expectedValue)) {
            CauseItem[] causeItemArray = this.findBooleanResultCauses(expression, history, boolConst);
            if (causeItemArray == null) {
                TrackingRunner.$$$reportNull$$$0(4);
            }
            return causeItemArray;
        }
        if (value instanceof DfaVariableValue && (change = history.findRelation((DfaVariableValue)value, rel -> rel.myRelationType == RelationType.EQ && rel.myCounterpart.getDfType().isConst(expectedValue), false)) != null) {
            PsiExpression varSourceExpression = change.getExpression();
            Instruction instruction = change.myInstruction;
            if (instruction instanceof AssignInstruction && change.myTopOfStack == value) {
                PsiExpression rValue = ((AssignInstruction)instruction).getRExpression();
                CauseItem item = TrackingRunner.createAssignmentCause((AssignInstruction)instruction, value);
                TrackingDfaMemoryState.MemoryStateChange push = change.findSubExpressionPush(rValue);
                if (push != null) {
                    item.addChildren(this.findConstantValueCause(rValue, push, expectedValue));
                }
                CauseItem[] causeItemArray = new CauseItem[]{item};
                if (causeItemArray == null) {
                    TrackingRunner.$$$reportNull$$$0(5);
                }
                return causeItemArray;
            }
            if (varSourceExpression != null) {
                CauseItem[] causeItemArray = new CauseItem[]{new CauseItem(JavaAnalysisBundle.message((String)"dfa.find.cause.equality.established.from.condition", (Object[])new Object[]{String.valueOf(value) + " == " + String.valueOf(expectedValue)}), (PsiElement)varSourceExpression)};
                if (causeItemArray == null) {
                    TrackingRunner.$$$reportNull$$$0(6);
                }
                return causeItemArray;
            }
        }
        return new CauseItem[0];
    }

    @Contract(value="_, _ -> new")
    @NotNull
    private static CauseItem createAssignmentCause(AssignInstruction instruction, DfaValue target) {
        PsiExpression stripped;
        PsiExpression rExpression = instruction.getRExpression();
        PsiJavaToken anchor = null;
        String targetName = target.toString();
        if (rExpression != null) {
            PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)rExpression.getParent());
            if (parent instanceof PsiAssignmentExpression) {
                anchor = ((PsiAssignmentExpression)parent).getOperationSign();
                targetName = ((PsiAssignmentExpression)parent).getLExpression().getText();
            } else if (parent instanceof PsiVariable) {
                ASTNode node = parent.getNode();
                if (node instanceof CompositeElement) {
                    anchor = ((CompositeElement)node).findChildByRoleAsPsiElement(20);
                }
                targetName = ((PsiVariable)parent).getName();
            }
            if (anchor == null) {
                anchor = rExpression;
            }
        }
        String message = (stripped = PsiUtil.skipParenthesizedExprDown((PsiExpression)rExpression)) instanceof PsiLiteralExpression ? JavaAnalysisBundle.message((String)"dfa.find.cause.was.assigned.to", (Object[])new Object[]{targetName, StringUtil.shortenTextWithEllipsis((String)stripped.getText(), (int)40, (int)5)}) : JavaAnalysisBundle.message((String)"dfa.find.cause.was.assigned", (Object[])new Object[]{targetName});
        return new CauseItem(message, (PsiElement)anchor);
    }

    private CauseItem[] findBooleanResultCauses(@NotNull PsiExpression expression, @NotNull TrackingDfaMemoryState.MemoryStateChange history, boolean value) {
        PsiInstanceOfExpression instanceOfExpression;
        PsiExpression operand;
        TrackingDfaMemoryState.MemoryStateChange operandHistory;
        PsiBinaryExpression binOp;
        RelationType relationType;
        IElementType tokenType;
        boolean and;
        TrackingDfaMemoryState.MemoryStateChange negatedPush;
        PsiExpression negated;
        if (expression == null) {
            TrackingRunner.$$$reportNull$$$0(7);
        }
        if (history == null) {
            TrackingRunner.$$$reportNull$$$0(8);
        }
        if (BoolUtils.isNegation(expression) && (negated = BoolUtils.getNegated(expression)) != null && (negatedPush = history.findExpressionPush(negated)) != null) {
            CauseItem cause = new CauseItem(JavaAnalysisBundle.message((String)"dfa.find.cause.value.x.is.always.the.same", (Object[])new Object[]{negated.getText(), !value}), (PsiElement)negated);
            cause.addChildren(this.findConstantValueCause(negated, negatedPush, !value));
            return new CauseItem[]{cause};
        }
        if (expression instanceof PsiPolyadicExpression && ((and = (tokenType = ((PsiPolyadicExpression)expression).getOperationTokenType()).equals(JavaTokenType.ANDAND)) || tokenType.equals(JavaTokenType.OROR))) {
            if (value != and) {
                int i;
                PsiExpression operand2;
                ExpressionPushingInstruction instruction;
                JavaExpressionAnchor anchor;
                PushValueInstruction pushValueInstruction;
                Instruction instruction2;
                TrackingDfaMemoryState.MemoryStateChange push = history;
                if (history.myInstruction instanceof ResultOfInstruction) {
                    TrackingDfaMemoryState.MemoryStateChange previous = history.getPrevious();
                    if (previous != null) {
                        previous = previous.getNonMerge();
                    }
                    if (previous != null && previous.myInstruction instanceof GotoInstruction) {
                        previous = previous.getPrevious();
                    }
                    if (previous != null) {
                        push = previous;
                    }
                }
                if ((instruction2 = push.myInstruction) instanceof PushValueInstruction && (pushValueInstruction = (PushValueInstruction)instruction2).getValue().isConst((Object)value) && (instruction2 = pushValueInstruction.getDfaAnchor()) instanceof JavaExpressionAnchor && (anchor = (JavaExpressionAnchor)instruction2).getExpression() == expression) {
                    push = push.getPrevious();
                }
                if (push != null) {
                    push = push.getNonMerge();
                }
                if (push != null && push.myInstruction instanceof ConditionalGotoInstruction) {
                    push = push.getPrevious();
                }
                if (push != null && (instruction2 = push.myInstruction) instanceof ExpressionPushingInstruction && (instruction2 = (instruction = (ExpressionPushingInstruction)instruction2).getDfaAnchor()) instanceof JavaExpressionAnchor && expression.equals((Object)PsiUtil.skipParenthesizedExprUp((PsiElement)(operand2 = (anchor = (JavaExpressionAnchor)instruction2).getExpression()).getParent())) && (i = IntStreamEx.ofIndices((Object[])((PsiPolyadicExpression)expression).getOperands(), e -> PsiTreeUtil.isAncestor((PsiElement)e, (PsiElement)operand2, (boolean)false)).findFirst().orElse(-1)) >= 0) {
                    CauseItem cause = new CauseItem(JavaAnalysisBundle.message((String)"dfa.find.cause.operand.of.boolean.expression.is.the.same", (Object[])new Object[]{i + 1, and ? 0 : 1, value}), (PsiElement)operand2);
                    cause.addChildren(this.findConstantValueCause(operand2, push, value));
                    return new CauseItem[]{cause};
                }
                return new CauseItem[0];
            }
            PsiExpression[] operands = ((PsiPolyadicExpression)expression).getOperands();
            ArrayList<CauseItem> operandCauses = new ArrayList<CauseItem>();
            for (int i = 0; i < operands.length; ++i) {
                ConditionalGotoInstruction gotoInstruction;
                Instruction instruction;
                PsiExpression operand3 = operands[i];
                TrackingDfaMemoryState.MemoryStateChange push = history.findExpressionPush(operand3 = PsiUtil.skipParenthesizedExprDown((PsiExpression)operand3));
                if (push == null || (!((instruction = push.myInstruction) instanceof ConditionalGotoInstruction) || !(gotoInstruction = (ConditionalGotoInstruction)instruction).isTarget((DfType)DfTypes.booleanValue(value), history.myInstruction)) && !push.myTopOfStack.getDfType().isConst((Object)value)) continue;
                boolean andVal = and;
                CauseItem cause = new CauseItem(JavaAnalysisBundle.message((String)"dfa.find.cause.operand.of.boolean.expression.is.the.same", (Object[])new Object[]{i + 1, andVal ? 0 : 1, value}), (PsiElement)operand3);
                cause.addChildren(this.findBooleanResultCauses(operand3, push, value));
                operandCauses.add(cause);
            }
            if (operandCauses.size() == operands.length) {
                return operandCauses.toArray(new CauseItem[0]);
            }
        }
        if (expression instanceof PsiBinaryExpression && (relationType = DfaPsiUtil.getRelationByToken((binOp = (PsiBinaryExpression)expression).getOperationTokenType())) != null) {
            if (!value) {
                relationType = relationType.getNegated();
            }
            PsiExpression leftOperand = PsiUtil.skipParenthesizedExprDown((PsiExpression)binOp.getLOperand());
            PsiExpression rightOperand = PsiUtil.skipParenthesizedExprDown((PsiExpression)binOp.getROperand());
            TrackingDfaMemoryState.MemoryStateChange leftChange = history.findExpressionPush(leftOperand);
            TrackingDfaMemoryState.MemoryStateChange rightChange = history.findExpressionPush(rightOperand);
            if (leftChange != null && rightChange != null) {
                DfaValue leftValue = leftChange.myTopOfStack;
                DfaValue rightValue = rightChange.myTopOfStack;
                CauseItem[] causes = this.findRelationCause(relationType, leftChange, rightChange);
                if (causes.length > 0) {
                    return causes;
                }
                if (leftValue == rightValue && (leftValue instanceof DfaVariableValue || leftValue.getDfType() instanceof DfConstantType)) {
                    ArrayList constCauses = new ArrayList();
                    CauseItem leftCause = TrackingRunner.constantInitializerCause(leftValue, leftChange.getExpression());
                    CauseItem rightCause = TrackingRunner.constantInitializerCause(rightValue, rightChange.getExpression());
                    ContainerUtil.addAllNotNull(constCauses, (Object[])new CauseItem[]{leftCause, rightCause});
                    if (constCauses.isEmpty()) {
                        return new CauseItem[]{new CauseItem(JavaAnalysisBundle.message((String)"dfa.find.cause.comparison.arguments.are.the.same", (Object[])new Object[0]), (PsiElement)binOp.getOperationSign())};
                    }
                    return constCauses.toArray(new CauseItem[0]);
                }
                if (leftValue != rightValue && relationType.isInequality() && leftValue.getDfType() instanceof DfConstantType && rightValue.getDfType() instanceof DfConstantType) {
                    CauseItem causeItem = new CauseItem(JavaAnalysisBundle.message((String)"dfa.find.cause.comparison.arguments.are.different.constants", (Object[])new Object[0]), (PsiElement)binOp.getOperationSign());
                    causeItem.addChildren(TrackingRunner.constantInitializerCause(leftValue, leftChange.getExpression()), TrackingRunner.constantInitializerCause(rightValue, rightChange.getExpression()));
                    return new CauseItem[]{causeItem};
                }
            }
        }
        if (expression instanceof PsiInstanceOfExpression && (operandHistory = history.findExpressionPush(operand = (instanceOfExpression = (PsiInstanceOfExpression)expression).getOperand())) != null) {
            PsiType type;
            CauseItem causeItem;
            PsiTypeElement typeElement;
            DfaValue operandValue = operandHistory.myTopOfStack;
            if (!value) {
                TrackingDfaMemoryState.FactDefinition<DfaNullability> nullability = operandHistory.findFact(operandValue, TrackingDfaMemoryState.FactExtractor.nullability());
                if (nullability.myFact == DfaNullability.NULL) {
                    CauseItem causeItem2 = new CauseItem(JavaAnalysisBundle.message((String)"dfa.find.cause.value.x.is.always.the.same", (Object[])new Object[]{operand.getText(), "null"}), (PsiElement)operand);
                    causeItem2.addChildren(this.findConstantValueCause(operand, operandHistory, null));
                    return new CauseItem[]{causeItem2};
                }
            }
            if ((typeElement = instanceOfExpression.getCheckType()) != null && (causeItem = TrackingRunner.findTypeCause(operandHistory, type = typeElement.getType(), value)) != null) {
                return new CauseItem[]{causeItem};
            }
        }
        if (expression instanceof PsiMethodCallExpression) {
            return new CauseItem[]{this.fromCallContract(history, (PsiCallExpression)((PsiMethodCallExpression)expression), ContractReturnValue.returnBoolean(value))};
        }
        return new CauseItem[0];
    }

    private static CauseItem constantInitializerCause(DfaValue value, PsiExpression ref) {
        PsiExpression initializer;
        PsiElement target;
        if (!(value.getDfType() instanceof DfConstantType)) {
            return null;
        }
        if (ref instanceof PsiReferenceExpression && (target = ((PsiReferenceExpression)ref).resolve()) instanceof PsiVariable && ((PsiVariable)target).hasModifierProperty("final") && (initializer = PsiUtil.skipParenthesizedExprDown((PsiExpression)((PsiVariable)target).getInitializer())) != null) {
            return new CauseItem(JavaAnalysisBundle.message((String)"dfa.find.cause.variable.is.initialized", (Object[])new Object[]{JavaElementKind.fromElement((PsiElement)target).subject(), ((PsiVariable)target).getName(), initializer.getText()}), (PsiElement)(initializer.getContainingFile() == ref.getContainingFile() ? initializer : ref));
        }
        return null;
    }

    @Nullable
    private static CauseItem findTypeCause(TrackingDfaMemoryState.MemoryStateChange operandHistory, PsiType type, boolean isInstance) {
        TrackingDfaMemoryState.MemoryStateChange prevHistory;
        TrackingDfaMemoryState.MemoryStateChange causeLocation;
        String explanation;
        PsiExpression operand = Objects.requireNonNull(operandHistory.getExpression());
        TypeConstraint wanted = TypeConstraints.instanceOf(type);
        PsiType operandType = operand.getType();
        if (operandType != null) {
            PsiElement target;
            TypeConstraint constraint = TypeConstraints.instanceOf(operandType);
            String name = JavaAnalysisBundle.message((String)"dfa.find.cause.object.kind.expression", (Object[])new Object[0]);
            if (operand instanceof PsiMethodCallExpression) {
                name = JavaAnalysisBundle.message((String)"dfa.find.cause.object.kind.method.return", (Object[])new Object[0]);
            } else if (operand instanceof PsiReferenceExpression && (target = ((PsiReferenceExpression)operand).resolve()) != null) {
                name = JavaElementKind.fromElement((PsiElement)target).subject();
            }
            explanation = constraint.getAssignabilityExplanation(wanted, isInstance, name);
            if (explanation != null) {
                if (constraint.equals(wanted)) {
                    explanation = JavaAnalysisBundle.message((String)"dfa.find.cause.type.known", (Object[])new Object[]{name, constraint.toShortString()});
                }
                return new CauseItem(explanation, (PsiElement)operand);
            }
        }
        DfaValue operandValue = operandHistory.myTopOfStack;
        TrackingDfaMemoryState.FactDefinition<TypeConstraint> fact = operandHistory.findFact(operandValue, TrackingDfaMemoryState.FactExtractor.constraint());
        explanation = ((TypeConstraint)fact.myFact).getAssignabilityExplanation(wanted, isInstance, JavaAnalysisBundle.message((String)"dfa.find.cause.object.kind.generic", (Object[])new Object[0]));
        while (explanation != null && (causeLocation = fact.myChange) != null && (prevHistory = causeLocation.getPrevious()) != null) {
            fact = prevHistory.findFact(operandValue, TrackingDfaMemoryState.FactExtractor.constraint());
            TypeConstraint prevConstraint = (TypeConstraint)fact.myFact;
            String prevExplanation = prevConstraint.getAssignabilityExplanation(wanted, isInstance, JavaAnalysisBundle.message((String)"dfa.find.cause.object.kind.generic", (Object[])new Object[0]));
            if (prevExplanation == null) {
                TrackingDfaMemoryState.MemoryStateChange rValuePush;
                PsiExpression rExpression;
                if (causeLocation.myInstruction instanceof AssignInstruction && causeLocation.myTopOfStack == operandValue && (rExpression = ((AssignInstruction)causeLocation.myInstruction).getRExpression()) != null && (rValuePush = causeLocation.findSubExpressionPush(rExpression)) != null) {
                    CauseItem assignmentItem = TrackingRunner.createAssignmentCause((AssignInstruction)causeLocation.myInstruction, operandValue);
                    assignmentItem.addChildren(TrackingRunner.findTypeCause(rValuePush, type, isInstance));
                    return assignmentItem;
                }
                CauseItem causeItem = new CauseItem(explanation, (PsiElement)operand);
                causeItem.addChildren(new CauseItem(JavaAnalysisBundle.message((String)"dfa.find.cause.type.is.known.from.place", (Object[])new Object[]{operand.getText()}), causeLocation));
                return causeItem;
            }
            explanation = prevExplanation;
        }
        return null;
    }

    private CauseItem @NotNull [] findRelationCause(RelationType relationType, TrackingDfaMemoryState.MemoryStateChange leftChange, TrackingDfaMemoryState.MemoryStateChange rightChange) {
        return this.findRelationCause(relationType, leftChange, leftChange.myTopOfStack, rightChange, rightChange.myTopOfStack);
    }

    private CauseItem @NotNull [] findRelationCause(RelationType relationType, TrackingDfaMemoryState.MemoryStateChange leftChange, DfaValue leftValue, TrackingDfaMemoryState.MemoryStateChange rightChange, DfaValue rightValue) {
        TrackingDfaMemoryState.Relation relation;
        TrackingDfaMemoryState.MemoryStateChange change;
        ProgressManager.checkCanceled();
        TrackingDfaMemoryState.FactDefinition<DfaNullability> leftNullability = leftChange.findFact(leftValue, TrackingDfaMemoryState.FactExtractor.nullability());
        TrackingDfaMemoryState.FactDefinition<DfaNullability> rightNullability = rightChange.findFact(rightValue, TrackingDfaMemoryState.FactExtractor.nullability());
        if (leftNullability.myFact == DfaNullability.NULL && rightNullability.myFact == DfaNullability.NOT_NULL || rightNullability.myFact == DfaNullability.NULL && leftNullability.myFact == DfaNullability.NOT_NULL) {
            CauseItem[] causeItemArray = new CauseItem[]{this.findNullabilityCause(leftChange, (DfaNullability)((Object)leftNullability.myFact)), this.findNullabilityCause(rightChange, (DfaNullability)((Object)rightNullability.myFact))};
            if (causeItemArray == null) {
                TrackingRunner.$$$reportNull$$$0(9);
            }
            return causeItemArray;
        }
        TrackingDfaMemoryState.FactDefinition<LongRangeSet> leftRange = leftChange.findFact(leftValue, TrackingDfaMemoryState.FactExtractor.range());
        TrackingDfaMemoryState.FactDefinition<LongRangeSet> rightRange = rightChange.findFact(rightValue, TrackingDfaMemoryState.FactExtractor.range());
        LongRangeSet fromRelation = ((LongRangeSet)rightRange.myFact).fromRelation(relationType.getNegated());
        if (fromRelation != null && !fromRelation.intersects((LongRangeSet)leftRange.myFact)) {
            TrackingDfaMemoryState.MemoryStateChange previous;
            while (leftRange.myOldFact != null && !fromRelation.intersects((LongRangeSet)leftRange.myOldFact) && leftRange.myChange != null && !(leftRange.myChange.myInstruction instanceof AssignInstruction) && (previous = leftRange.myChange.getPrevious()) != null) {
                leftRange = previous.findFact(leftValue, TrackingDfaMemoryState.FactExtractor.range());
            }
            CauseItem[] causeItemArray = new CauseItem[]{TrackingRunner.findRangeCause(leftChange, leftValue, (LongRangeSet)leftRange.myFact, JavaAnalysisBundle.message((String)"dfa.find.cause.left.operand.range.template", (Object[])new Object[0])), TrackingRunner.findRangeCause(rightChange, rightValue, (LongRangeSet)rightRange.myFact, JavaAnalysisBundle.message((String)"dfa.find.cause.right.operand.range.template", (Object[])new Object[0]))};
            if (causeItemArray == null) {
                TrackingRunner.$$$reportNull$$$0(10);
            }
            return causeItemArray;
        }
        if (leftValue instanceof DfaVariableValue) {
            CauseItem cause;
            if (leftValue == rightValue) {
                PsiExpression leftExpression = leftChange.getExpression();
                PsiExpression rightExpression = rightChange.getExpression();
                if (leftExpression instanceof PsiMethodCallExpression && (cause = this.fromCallContract(leftChange, (PsiMethodCallExpression)leftExpression, rightExpression)) != null) {
                    CauseItem[] causeItemArray = new CauseItem[]{cause};
                    if (causeItemArray == null) {
                        TrackingRunner.$$$reportNull$$$0(11);
                    }
                    return causeItemArray;
                }
                if (rightExpression instanceof PsiMethodCallExpression && (cause = this.fromCallContract(rightChange, (PsiMethodCallExpression)rightExpression, leftExpression)) != null) {
                    CauseItem[] causeItemArray = new CauseItem[]{cause};
                    if (causeItemArray == null) {
                        TrackingRunner.$$$reportNull$$$0(12);
                    }
                    return causeItemArray;
                }
            }
            if ((change = TrackingRunner.findRelationAddedChange(leftChange, (DfaVariableValue)leftValue, relation = new TrackingDfaMemoryState.Relation(relationType, rightValue))) != null) {
                DfaValue target;
                PsiExpression expression;
                TrackingDfaMemoryState.MemoryStateChange assignmentChange;
                Instruction instruction;
                cause = this.findRelationCause(change, (DfaVariableValue)leftValue, relation, rightChange);
                if (cause != null && (instruction = change.myInstruction) instanceof AssignInstruction && (assignmentChange = change.findExpressionPush(expression = ((AssignInstruction)instruction).getRExpression())) != null && (target = change.myTopOfStack) == rightValue) {
                    CauseItem[] causeItemArray = (CauseItem[])ArrayUtil.prepend((Object)cause, (Object[])this.findRelationCause(relationType, leftChange, assignmentChange));
                    if (causeItemArray == null) {
                        TrackingRunner.$$$reportNull$$$0(13);
                    }
                    return causeItemArray;
                }
                CauseItem[] causeItemArray = new CauseItem[]{cause};
                if (causeItemArray == null) {
                    TrackingRunner.$$$reportNull$$$0(14);
                }
                return causeItemArray;
            }
        }
        if (rightValue instanceof DfaVariableValue && (change = TrackingRunner.findRelationAddedChange(rightChange, (DfaVariableValue)rightValue, relation = new TrackingDfaMemoryState.Relation(Objects.requireNonNull(relationType.getFlipped()), leftValue))) != null) {
            CauseItem[] causeItemArray = new CauseItem[]{this.findRelationCause(change, (DfaVariableValue)rightValue, relation, leftChange)};
            if (causeItemArray == null) {
                TrackingRunner.$$$reportNull$$$0(15);
            }
            return causeItemArray;
        }
        if (relationType == RelationType.NE) {
            DfaValue rightSpecial;
            DfaValue leftSpecial;
            CauseItem[] specialCause;
            SpecialField leftField = SpecialField.fromQualifierType(leftValue.getDfType());
            SpecialField rightField = SpecialField.fromQualifierType(rightValue.getDfType());
            if (leftField != null && leftField == rightField && (specialCause = this.findRelationCause(relationType, leftChange, leftSpecial = leftField.createValue(this.getFactory(), leftValue), rightChange, rightSpecial = rightField.createValue(this.getFactory(), rightValue))).length > 0) {
                CauseItem item = new CauseItem(JavaAnalysisBundle.message((String)"dfa.find.cause.values.cannot.be.equal.because", (Object[])new Object[]{String.valueOf(leftValue) + "." + String.valueOf((Object)leftField) + " != " + String.valueOf(rightValue) + "." + String.valueOf((Object)rightField)}), (PsiElement)null);
                item.addChildren(specialCause);
                CauseItem[] causeItemArray = new CauseItem[]{item};
                if (causeItemArray == null) {
                    TrackingRunner.$$$reportNull$$$0(16);
                }
                return causeItemArray;
            }
        }
        return new CauseItem[0];
    }

    private CauseItem findRelationCause(TrackingDfaMemoryState.MemoryStateChange change, DfaVariableValue value, TrackingDfaMemoryState.Relation relation, TrackingDfaMemoryState.MemoryStateChange counterPartChange) {
        PsiExpression expression;
        Instruction instruction = change.myInstruction;
        String condition = String.valueOf(value) + " " + String.valueOf(relation);
        if (instruction instanceof AssignInstruction) {
            DfaValue target = change.myTopOfStack;
            PsiExpression rValue = ((AssignInstruction)instruction).getRExpression();
            CauseItem item = TrackingRunner.createAssignmentCause((AssignInstruction)instruction, target);
            if (target == value) {
                TrackingDfaMemoryState.MemoryStateChange rValuePush = change.findSubExpressionPush(rValue);
                if (rValuePush != null) {
                    item.addChildren(this.findRelationCause(relation.myRelationType, rValuePush, counterPartChange));
                }
                return item;
            }
            if (target == relation.myCounterpart) {
                return item;
            }
        }
        if ((expression = change.getExpression()) != null) {
            List<DfaRelation> chain;
            DfaRelation rel;
            Collection<DfaRelation> relations = Collections.emptyList();
            if (expression instanceof PsiBinaryExpression && (rel = TrackingRunner.getBinaryExpressionRelation(change, (PsiBinaryExpression)expression)) != null) {
                if (TrackingRunner.isSameRelation(rel, value, relation)) {
                    return new CauseItem((DfaProblemType)new CustomDfaProblemType(JavaAnalysisBundle.message((String)"dfa.find.cause.condition.was.checked.before", (Object[])new Object[]{condition})), (PsiElement)expression);
                }
                relations = Collections.singleton(rel);
            }
            if (expression instanceof PsiCallExpression) {
                relations = this.getCallRelations((PsiCallExpression)expression);
            }
            if (!(chain = TrackingRunner.findDeductionChain(change, relations, value, relation)).isEmpty()) {
                Object[] result = new CauseItem[]{};
                for (DfaRelation deduced : chain) {
                    Object[] cause = this.findRelationCause(deduced.relationType(), change, deduced.leftOperand(), change, deduced.rightOperand());
                    result = (CauseItem[])ArrayUtil.mergeArrays((Object[])result, (Object[])cause);
                }
                if (result.length > 1) {
                    CauseItem item = new CauseItem((DfaProblemType)new CustomDfaProblemType(JavaAnalysisBundle.message((String)"dfa.find.cause.condition.was.deduced", (Object[])new Object[]{condition})), (PsiElement)null);
                    item.addChildren((CauseItem[])result);
                    return item;
                }
            }
            return new CauseItem((DfaProblemType)new CustomDfaProblemType(JavaAnalysisBundle.message((String)"dfa.find.cause.condition.is.known.from.place", (Object[])new Object[]{condition})), (PsiElement)expression);
        }
        return null;
    }

    private static List<DfaRelation> findDeductionChain(TrackingDfaMemoryState.MemoryStateChange change, Collection<DfaRelation> knownRelations, DfaVariableValue value, TrackingDfaMemoryState.Relation relation) {
        for (DfaRelation rel : knownRelations) {
            if (TrackingRunner.isSameRelation(rel, value, relation)) continue;
            for (Map.Entry<DfaVariableValue, TrackingDfaMemoryState.Change> entry : change.myChanges.entrySet()) {
                DfaVariableValue actualVar = entry.getKey();
                for (TrackingDfaMemoryState.Relation actualRelation : entry.getValue().myAddedRelations) {
                    DfaValue right;
                    DfaValue left;
                    RelationType type;
                    if (!TrackingRunner.isSameRelation(rel, actualVar, actualRelation)) continue;
                    if (actualRelation.myRelationType == RelationType.EQ || relation.myRelationType != RelationType.NE && relation.myRelationType == actualRelation.myRelationType) {
                        type = relation.myRelationType;
                    } else {
                        if (relation.myRelationType != RelationType.EQ) continue;
                        type = actualRelation.myRelationType;
                    }
                    if (actualVar == value) {
                        left = actualRelation.myCounterpart;
                        right = relation.myCounterpart;
                    } else if (actualVar == relation.myCounterpart) {
                        left = value;
                        right = actualRelation.myCounterpart;
                    } else if (actualRelation.myCounterpart == relation.myCounterpart) {
                        left = value;
                        right = actualVar;
                    } else {
                        if (actualRelation.myCounterpart != value) continue;
                        left = actualVar;
                        right = relation.myCounterpart;
                    }
                    DfaRelation rel1 = DfaRelation.createRelation((DfaValue)left, (RelationType)type, (DfaValue)right);
                    DfaRelation rel2 = DfaRelation.createRelation((DfaValue)actualVar, (RelationType)actualRelation.myRelationType, (DfaValue)actualRelation.myCounterpart);
                    return StreamEx.of((Object[])new DfaRelation[]{rel1, rel2}).nonNull().toImmutableList();
                }
            }
        }
        return Collections.emptyList();
    }

    private static boolean isSameRelation(DfaRelation dfaRel, DfaVariableValue var, TrackingDfaMemoryState.Relation relation) {
        DfaValue counterpart;
        RelationType type;
        if (dfaRel.leftOperand() == var) {
            type = dfaRel.relationType();
            counterpart = dfaRel.rightOperand();
        } else if (dfaRel.rightOperand() == var) {
            type = dfaRel.relationType().getFlipped();
            counterpart = dfaRel.leftOperand();
        } else {
            return false;
        }
        return counterpart == relation.myCounterpart && type != null;
    }

    @Nullable
    private static DfaRelation getBinaryExpressionRelation(TrackingDfaMemoryState.MemoryStateChange change, PsiBinaryExpression binOp) {
        PsiExpression lOperand = binOp.getLOperand();
        PsiExpression rOperand = binOp.getROperand();
        TrackingDfaMemoryState.MemoryStateChange leftPos = change.findExpressionPush(lOperand);
        TrackingDfaMemoryState.MemoryStateChange rightPos = change.findExpressionPush(rOperand);
        if (leftPos != null && rightPos != null) {
            DfaValue leftValue = leftPos.myTopOfStack;
            DfaValue rightValue = rightPos.myTopOfStack;
            RelationType type = DfaPsiUtil.getRelationByToken(binOp.getOperationTokenType());
            if (type != null) {
                return DfaRelation.createRelation((DfaValue)leftValue, (RelationType)type, (DfaValue)rightValue);
            }
        }
        return null;
    }

    private Collection<DfaRelation> getCallRelations(PsiCallExpression callExpression) {
        List<? extends MethodContract> contracts = JavaMethodContractUtil.getMethodCallContracts(callExpression);
        LinkedHashSet<DfaRelation> results = new LinkedHashSet<DfaRelation>();
        for (MethodContract methodContract : contracts) {
            for (ContractValue condition : methodContract.getConditions()) {
                DfaCondition rel = condition.fromCall(this.getFactory(), callExpression);
                ContainerUtil.addIfNotNull(results, (Object)((DfaRelation)ObjectUtils.tryCast((Object)rel, DfaRelation.class)));
            }
        }
        return results;
    }

    private CauseItem findNullabilityCause(TrackingDfaMemoryState.MemoryStateChange factUse, DfaNullability nullability) {
        TrackingDfaMemoryState.MemoryStateChange factDef;
        CauseItem causeItem;
        PsiVariable variable;
        TrackingDfaMemoryState.MemoryStateChange operandPush;
        PsiExpression expression = factUse.getExpression();
        if (expression instanceof PsiTypeCastExpression && (operandPush = factUse.findSubExpressionPush(((PsiTypeCastExpression)expression).getOperand())) != null) {
            return this.findNullabilityCause(operandPush, nullability);
        }
        if (expression instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression call = (PsiMethodCallExpression)expression;
            PsiMethod method = call.resolveMethod();
            CauseItem causeItem2 = this.fromMemberNullability(nullability, (PsiModifierListOwner)method, JavaElementKind.METHOD, call.getMethodExpression().getReferenceNameElement());
            if (causeItem2 == null) {
                switch (nullability) {
                    case NULL: 
                    case NULLABLE: {
                        CauseItem causeItem3 = this.fromCallContract(factUse, (PsiCallExpression)call, ContractReturnValue.returnNull());
                        break;
                    }
                    case NOT_NULL: {
                        CauseItem causeItem3 = this.fromCallContract(factUse, (PsiCallExpression)call, ContractReturnValue.returnNotNull());
                        break;
                    }
                    default: {
                        CauseItem causeItem3 = causeItem2 = null;
                    }
                }
            }
            if (causeItem2 != null) {
                return causeItem2;
            }
        }
        if (expression instanceof PsiReferenceExpression && (variable = (PsiVariable)ObjectUtils.tryCast((Object)((PsiReferenceExpression)expression).resolve(), PsiVariable.class)) != null && (causeItem = this.fromMemberNullability(nullability, (PsiModifierListOwner)variable, JavaElementKind.fromElement((PsiElement)variable), (PsiElement)expression)) != null) {
            return causeItem;
        }
        TrackingDfaMemoryState.FactDefinition<DfaNullability> info = factUse.findFact(factUse.myTopOfStack, TrackingDfaMemoryState.FactExtractor.nullability());
        TrackingDfaMemoryState.MemoryStateChange memoryStateChange = factDef = info.myFact == nullability ? info.myChange : null;
        if (nullability == DfaNullability.NOT_NULL) {
            String explanation = TrackingRunner.getObviouslyNonNullExplanation(expression);
            if (explanation != null) {
                return new CauseItem(JavaAnalysisBundle.message((String)"dfa.find.cause.obviously.non.null.expression", (Object[])new Object[]{explanation}), (PsiElement)expression);
            }
            if (factDef != null) {
                DfaAnchor anchor;
                if (factDef.myInstruction instanceof CheckNotNullInstruction) {
                    String text;
                    NullabilityProblemKind.NullabilityProblem<?> problem = ((CheckNotNullInstruction)factDef.myInstruction).getProblem();
                    PsiExpression dereferenced = problem.getDereferencedExpression();
                    String string = text = dereferenced == null ? factUse.myTopOfStack.toString() : dereferenced.getText();
                    if (dereferenced != null && problem.getKind() == NullabilityProblemKind.passingToNotNullParameter) {
                        PsiExpression arg = dereferenced;
                        while (arg.getParent() instanceof PsiParenthesizedExpression) {
                            arg = (PsiExpression)arg.getParent();
                        }
                        PsiParameter parameter = MethodCallUtils.getParameterForArgument(dereferenced);
                        if (parameter != null) {
                            CauseItem item = new CauseItem(JavaAnalysisBundle.message((String)"dfa.find.cause.was.passed.as.non.null.parameter", (Object[])new Object[]{text}), (PsiElement)dereferenced);
                            item.addChildren(this.fromMemberNullability(DfaNullability.NOT_NULL, (PsiModifierListOwner)parameter, JavaElementKind.PARAMETER, (PsiElement)dereferenced));
                            return item;
                        }
                    }
                    return new CauseItem(JavaAnalysisBundle.message((String)"dfa.find.cause.was.dereferenced", (Object[])new Object[]{text}), (PsiElement)dereferenced);
                }
                if (factDef.myInstruction instanceof InstanceofInstruction && (anchor = ((InstanceofInstruction)factDef.myInstruction).getDfaAnchor()) instanceof JavaExpressionAnchor) {
                    PsiExpression operand = ((JavaExpressionAnchor)anchor).getExpression();
                    return new CauseItem(JavaAnalysisBundle.message((String)"dfa.find.cause.instanceof.implies.non.nullity", (Object[])new Object[0]), (PsiElement)operand);
                }
            }
        }
        if (factDef != null && expression != null) {
            TrackingDfaMemoryState.MemoryStateChange rValuePush;
            PsiExpression rExpression;
            DfaValue value = factUse.myTopOfStack;
            if (factDef.myInstruction instanceof AssignInstruction && factDef.myTopOfStack == value && (rExpression = ((AssignInstruction)factDef.myInstruction).getRExpression()) != null && (rValuePush = factDef.findSubExpressionPush(rExpression)) != null) {
                WrapDerivedVariableInstruction instruction;
                DerivedVariableDescriptor descriptor;
                Instruction item;
                CauseItem assignmentItem = TrackingRunner.createAssignmentCause((AssignInstruction)factDef.myInstruction, value);
                TrackingDfaMemoryState.MemoryStateChange previous = factDef.getPrevious();
                if (previous != null && (item = previous.myInstruction) instanceof WrapDerivedVariableInstruction && (descriptor = (instruction = (WrapDerivedVariableInstruction)item).getDerivedVariableDescriptor()) == SpecialField.UNBOX) {
                    DfaAnchor anchor = instruction.getDfaAnchor();
                    assignmentItem.addChildren(new CauseItem(JavaAnalysisBundle.message((String)"dfa.find.cause.primitive.boxed", (Object[])new Object[0]), (PsiElement)(anchor instanceof JavaExpressionAnchor ? ((JavaExpressionAnchor)anchor).getExpression() : rExpression)));
                }
                assignmentItem.addChildren(this.findNullabilityCause(rValuePush, nullability));
                return assignmentItem;
            }
            PsiExpression defExpression = factDef.getExpression();
            if (defExpression != null) {
                return new CauseItem(JavaAnalysisBundle.message((String)"dfa.find.cause.value.is.known.from.place", (Object[])new Object[]{expression.getText(), nullability.getPresentationName()}), (PsiElement)defExpression);
            }
        }
        return null;
    }

    private CauseItem fromMemberNullability(DfaNullability nullability, PsiModifierListOwner owner, JavaElementKind memberKind, PsiElement anchor) {
        if (owner != null) {
            NullabilityAnnotationInfo info = NullableNotNullManager.getInstance((Project)owner.getProject()).findEffectiveNullabilityInfo(owner);
            String name = ((PsiNamedElement)owner).getName();
            if (info != null && DfaNullability.fromNullability(info.getNullability()) == nullability) {
                String message;
                if (info.isInferred()) {
                    if (owner instanceof PsiParameter && anchor instanceof PsiReferenceExpression && ((PsiReferenceExpression)anchor).isReferenceTo((PsiElement)owner)) {
                        return null;
                    }
                    message = JavaAnalysisBundle.message((String)"dfa.find.cause.nullability.inferred", (Object[])new Object[]{memberKind.subject(), name, nullability.getPresentationName()});
                } else if (info.isExternal()) {
                    message = JavaAnalysisBundle.message((String)"dfa.find.cause.nullability.externally.annotated", (Object[])new Object[]{memberKind.subject(), name, nullability.getPresentationName()});
                } else if (info.isContainer()) {
                    PsiModifierList modifierList;
                    PsiElement psiElement;
                    PsiAnnotationOwner annoOwner = info.getAnnotation().getOwner();
                    message = JavaAnalysisBundle.message((String)"dfa.find.cause.nullability.inherited.from.container", (Object[])new Object[]{memberKind.subject(), name, nullability.getPresentationName()});
                    if (annoOwner instanceof PsiModifierList && (psiElement = (modifierList = (PsiModifierList)annoOwner).getParent()) instanceof PsiClass) {
                        PsiFile file;
                        PsiClass aClass = (PsiClass)psiElement;
                        message = JavaAnalysisBundle.message((String)"dfa.find.cause.nullability.inherited.from.class", (Object[])new Object[]{memberKind.subject(), name, aClass.getName(), nullability.getPresentationName()});
                        if ("package-info".equals(aClass.getName()) && (file = aClass.getContainingFile()) instanceof PsiJavaFile) {
                            message = JavaAnalysisBundle.message((String)"dfa.find.cause.nullability.inherited.from.package", (Object[])new Object[]{memberKind.subject(), name, ((PsiJavaFile)file).getPackageName(), nullability.getPresentationName()});
                        }
                    }
                    if (annoOwner instanceof PsiNamedElement) {
                        message = JavaAnalysisBundle.message((String)"dfa.find.cause.nullability.inherited.from.named.element", (Object[])new Object[]{memberKind.subject(), name, ((PsiNamedElement)annoOwner).getName(), nullability.getPresentationName()});
                    }
                } else {
                    message = JavaAnalysisBundle.message((String)"dfa.find.cause.nullability.explicitly.annotated", (Object[])new Object[]{memberKind.subject(), name, nullability.getPresentationName()});
                }
                if (info.getAnnotation().getContainingFile() == anchor.getContainingFile()) {
                    anchor = info.getAnnotation();
                } else if (owner.getContainingFile() == anchor.getContainingFile() && (anchor = owner.getNavigationElement()) instanceof PsiNameIdentifierOwner) {
                    anchor = ((PsiNameIdentifierOwner)anchor).getNameIdentifier();
                }
                return new CauseItem(message, anchor);
            }
            if (owner instanceof PsiField && FieldChecker.getChecker(this.getFactory().getContext()).canTrustFieldInitializer((PsiField)owner)) {
                Pair<PsiExpression, Nullability> fieldNullability = NullabilityUtil.getNullabilityFromFieldInitializers((PsiField)owner);
                if (fieldNullability.second == DfaNullability.toNullability(nullability)) {
                    PsiExpression initializer = (PsiExpression)fieldNullability.first;
                    if (initializer != null) {
                        if (initializer.getContainingFile() == anchor.getContainingFile()) {
                            anchor = initializer;
                        }
                        return new CauseItem(JavaAnalysisBundle.message((String)"dfa.find.cause.field.initializer.nullability", (Object[])new Object[]{name, DfaNullability.fromNullability((Nullability)fieldNullability.second).getPresentationName()}), anchor);
                    }
                    if (owner.getContainingFile() == anchor.getContainingFile()) {
                        anchor = owner;
                    }
                    return new CauseItem(JavaAnalysisBundle.message((String)"dfa.find.cause.field.assigned.nullability", (Object[])new Object[]{name, DfaNullability.fromNullability((Nullability)fieldNullability.second).getPresentationName()}), anchor);
                }
            }
        }
        return null;
    }

    private CauseItem fromCallContract(TrackingDfaMemoryState.MemoryStateChange history, PsiMethodCallExpression call, PsiExpression target) {
        PsiExpression[] args = call.getArgumentList().getExpressions();
        for (int i = 0; i < args.length; ++i) {
            if (!EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(args[i], target)) continue;
            return this.fromCallContract(history, (PsiCallExpression)call, ContractReturnValue.returnParameter(i));
        }
        PsiExpression qualifier = call.getMethodExpression().getQualifierExpression();
        if (EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(qualifier, target)) {
            return this.fromCallContract(history, (PsiCallExpression)call, ContractReturnValue.returnThis());
        }
        return null;
    }

    private CauseItem fromCallContract(TrackingDfaMemoryState.MemoryStateChange history, PsiCallExpression call, ContractReturnValue contractReturnValue) {
        MethodContract c;
        Condition condition;
        Object onlyContract;
        PsiMethod method = call.resolveMethod();
        if (method == null) {
            return null;
        }
        List<? extends MethodContract> contracts = JavaMethodContractUtil.getMethodCallContracts(method, call);
        if (contracts.isEmpty()) {
            return null;
        }
        MethodContract contract = contracts.get(0);
        PsiElement anchor = TrackingRunner.getCallAnchor(call);
        if (anchor == null) {
            return null;
        }
        if (contracts.size() == 1 && contract.isTrivial() && contractReturnValue.isSuperValueOf(contract.getReturnValue())) {
            String message = JavaAnalysisBundle.message((String)"dfa.find.cause.contract.trivial", (Object[])new Object[]{TrackingRunner.getContractKind(call), JavaElementKind.fromElement((PsiElement)method).lessDescriptive().subject(), method.getName(), contract.getReturnValue()});
            return new CauseItem(message, anchor);
        }
        List<? extends MethodContract> nonIntersecting = MethodContract.toNonIntersectingContracts(contracts);
        if (nonIntersecting != null && (onlyContract = (MethodContract)ContainerUtil.getOnlyItem((Collection)ContainerUtil.filter(nonIntersecting, (Condition)(condition = contractReturnValue instanceof ContractReturnValue.ParameterReturnValue ? mc -> contractReturnValue.equals(mc.getReturnValue()) : mc -> contractReturnValue.isSuperValueOf(mc.getReturnValue()))))) != null) {
            return this.fromSingleContract(history, call, method, (MethodContract)onlyContract);
        }
        ArrayList<MethodContract> unsureContracts = new ArrayList<MethodContract>();
        for (MethodContract methodContract : contracts) {
            ThreeState applies = this.contractApplies(call, methodContract);
            switch (applies) {
                case NO: {
                    break;
                }
                case UNSURE: {
                    unsureContracts.add(methodContract);
                    break;
                }
                case YES: {
                    if (!unsureContracts.isEmpty() || !contractReturnValue.isSuperValueOf(methodContract.getReturnValue())) break;
                    return this.fromSingleContract(history, call, method, methodContract);
                }
            }
        }
        if (unsureContracts.size() == 1 && contractReturnValue.isSuperValueOf((c = (MethodContract)unsureContracts.get(0)).getReturnValue())) {
            return this.fromSingleContract(history, call, method, c);
        }
        return null;
    }

    @Nullable
    private static PsiElement getCallAnchor(PsiCallExpression call) {
        if (call instanceof PsiMethodCallExpression) {
            return ((PsiMethodCallExpression)call).getMethodExpression().getReferenceNameElement();
        }
        if (call instanceof PsiNewExpression) {
            return ((PsiNewExpression)call).getClassOrAnonymousClassReference();
        }
        return null;
    }

    @NotNull
    @Nls
    private static String getContractKind(PsiCallExpression call) {
        PsiMethod method = call.resolveMethod();
        if (method == null || JavaMethodContractUtil.hasExplicitContractAnnotation(method)) {
            String string = JavaAnalysisBundle.message((String)"dfa.find.cause.contract.kind.explicit", (Object[])new Object[0]);
            if (string == null) {
                TrackingRunner.$$$reportNull$$$0(17);
            }
            return string;
        }
        List<? extends MethodContract> contracts = JavaMethodContractUtil.getMethodCallContracts(method, call);
        if (contracts.isEmpty()) {
            String string = JavaAnalysisBundle.message((String)"dfa.find.cause.contract.kind.explicit", (Object[])new Object[0]);
            if (string == null) {
                TrackingRunner.$$$reportNull$$$0(18);
            }
            return string;
        }
        if (ContainerUtil.and(contracts, c -> c instanceof StandardMethodContract)) {
            String string = JavaAnalysisBundle.message((String)"dfa.find.cause.contract.kind.inferred", (Object[])new Object[0]);
            if (string == null) {
                TrackingRunner.$$$reportNull$$$0(19);
            }
            return string;
        }
        String string = JavaAnalysisBundle.message((String)"dfa.find.cause.contract.kind.hard.coded", (Object[])new Object[0]);
        if (string == null) {
            TrackingRunner.$$$reportNull$$$0(20);
        }
        return string;
    }

    @NotNull
    private ThreeState contractApplies(@NotNull PsiCallExpression call, @NotNull MethodContract contract) {
        if (call == null) {
            TrackingRunner.$$$reportNull$$$0(21);
        }
        if (contract == null) {
            TrackingRunner.$$$reportNull$$$0(22);
        }
        List<ContractValue> conditions = contract.getConditions();
        for (ContractValue condition : conditions) {
            DfaCondition cond = condition.fromCall(this.getFactory(), call);
            if (cond == DfaCondition.getTrue()) {
                ThreeState threeState = ThreeState.YES;
                if (threeState == null) {
                    TrackingRunner.$$$reportNull$$$0(23);
                }
                return threeState;
            }
            if (cond != DfaCondition.getFalse()) continue;
            ThreeState threeState = ThreeState.NO;
            if (threeState == null) {
                TrackingRunner.$$$reportNull$$$0(24);
            }
            return threeState;
        }
        ThreeState threeState = ThreeState.UNSURE;
        if (threeState == null) {
            TrackingRunner.$$$reportNull$$$0(25);
        }
        return threeState;
    }

    @NotNull
    private CauseItem fromSingleContract(@NotNull TrackingDfaMemoryState.MemoryStateChange history, @NotNull PsiCallExpression call, @NotNull PsiMethod method, @NotNull MethodContract contract) {
        String message;
        if (history == null) {
            TrackingRunner.$$$reportNull$$$0(26);
        }
        if (call == null) {
            TrackingRunner.$$$reportNull$$$0(27);
        }
        if (method == null) {
            TrackingRunner.$$$reportNull$$$0(28);
        }
        if (contract == null) {
            TrackingRunner.$$$reportNull$$$0(29);
        }
        List<ContractValue> conditions = contract.getConditions();
        Collector<T, ?, @Nls String> collector = Collectors.collectingAndThen(Collectors.toList(), list -> ListFormatter.getInstance((Locale)DynamicBundle.getLocale(), (ListFormatter.Type)ListFormatter.Type.AND, (ListFormatter.Width)ListFormatter.Width.WIDE).format((Collection)list));
        String conditionsText = conditions.stream().map(c -> c.getPresentationText(call)).collect(collector);
        String objectType = JavaElementKind.fromElement((PsiElement)method).lessDescriptive().subject();
        if (contract.getReturnValue().isFail()) {
            message = JavaAnalysisBundle.message((String)"dfa.find.cause.contract.throws.on.condition", (Object[])new Object[]{TrackingRunner.getContractKind(call), objectType, method.getName(), conditionsText});
        } else {
            PsiExpression place = contract.getReturnValue().findPlace(call);
            String placeText = place == null ? contract.getReturnValue().toString() : PsiExpressionTrimRenderer.render((PsiExpression)place);
            message = JavaAnalysisBundle.message((String)"dfa.find.cause.contract.returns.on.condition", (Object[])new Object[]{TrackingRunner.getContractKind(call), objectType, method.getName(), placeText, conditionsText});
        }
        CauseItem causeItem = new CauseItem(message, TrackingRunner.getCallAnchor(call));
        for (ContractValue contractValue : conditions) {
            PsiExpression rightPlace;
            TrackingDfaMemoryState.MemoryStateChange rightPush;
            DfaTypeValue top;
            if (!(contractValue instanceof ContractValue.Condition)) continue;
            ContractValue.Condition condition = (ContractValue.Condition)contractValue;
            ContractValue leftVal = condition.getLeft();
            ContractValue rightVal = condition.getRight();
            RelationType type = condition.getRelationType();
            DfaCallArguments arguments = DfaCallArguments.fromCall(this.getFactory(), call);
            PsiExpression leftPlace = leftVal.findPlace(call);
            TrackingDfaMemoryState.MemoryStateChange leftPush = history.findSubExpressionPush(leftPlace);
            DfaTypeValue left = top = this.getFactory().getUnknown();
            DfaTypeValue right = top;
            if (arguments != null) {
                left = leftVal.makeDfaValue(this.getFactory(), arguments);
                right = rightVal.makeDfaValue(this.getFactory(), arguments);
            }
            if (leftPush == null && left != top) {
                leftPush = TrackingDfaMemoryState.MemoryStateChange.create(history.getPrevious(), (Instruction)new PushInstruction((DfaValue)left, null), Collections.emptyMap(), (DfaValue)left);
            }
            if ((rightPush = history.findSubExpressionPush(rightPlace = rightVal.findPlace(call))) == null && right != top) {
                rightPush = TrackingDfaMemoryState.MemoryStateChange.create(history.getPrevious(), (Instruction)new PushInstruction((DfaValue)right, null), Collections.emptyMap(), (DfaValue)right);
            }
            if (leftPush == null || rightPush == null) continue;
            causeItem.addChildren(this.findRelationCause(type, leftPush, (DfaValue)(left == top ? leftPush.myTopOfStack : left), rightPush, (DfaValue)(right == top ? rightPush.myTopOfStack : right)));
        }
        CauseItem causeItem2 = causeItem;
        if (causeItem2 == null) {
            TrackingRunner.$$$reportNull$$$0(30);
        }
        return causeItem2;
    }

    private static CauseItem findRangeCause(TrackingDfaMemoryState.MemoryStateChange factUse, DfaValue value, LongRangeSet range, @Nls String template) {
        TrackingDfaMemoryState.MemoryStateChange factDef;
        TrackingDfaMemoryState.MemoryStateChange previous;
        PsiType type;
        PsiExpression expression;
        VariableDescriptor descriptor;
        if (value instanceof DfaTypeValue && factUse.myInstruction.getIndex() == -1) {
            return null;
        }
        if (value instanceof DfaVariableValue && (descriptor = ((DfaVariableValue)value).getDescriptor()) instanceof SpecialField && range.equals(JvmPsiRangeSetUtil.indexRange())) {
            switch ((SpecialField)descriptor) {
                case ARRAY_LENGTH: {
                    return new CauseItem(JavaAnalysisBundle.message((String)"dfa.find.cause.array.length.is.always.non.negative", (Object[])new Object[0]), factUse);
                }
                case STRING_LENGTH: {
                    return new CauseItem(JavaAnalysisBundle.message((String)"dfa.find.cause.string.length.is.always.non.negative", (Object[])new Object[0]), factUse);
                }
                case COLLECTION_SIZE: {
                    return new CauseItem(JavaAnalysisBundle.message((String)"dfa.find.cause.collection.size.is.always.non.negative", (Object[])new Object[0]), factUse);
                }
            }
        }
        PsiExpression psiExpression = expression = factUse.myTopOfStack == value ? factUse.getExpression() : null;
        if (expression != null) {
            PsiExpression operand;
            TrackingDfaMemoryState.MemoryStateChange operandPush;
            LongRangeSet fromAnnotation;
            PsiMethodCallExpression call;
            PsiMethod method;
            type = expression.getType();
            if (expression instanceof PsiLiteralExpression) {
                return null;
            }
            if (expression instanceof PsiMethodCallExpression && (method = (call = (PsiMethodCallExpression)expression).resolveMethod()) != null && (fromAnnotation = JvmPsiRangeSetUtil.fromPsiElement((PsiModifierListOwner)method)).equals(range)) {
                return new CauseItem(JavaAnalysisBundle.message((String)"dfa.find.cause.range.is.specified.by.annotation", (Object[])new Object[]{method.getName(), range}), call.getMethodExpression().getReferenceNameElement());
            }
            if (expression instanceof PsiTypeCastExpression && type instanceof PsiPrimitiveType && TypeConversionUtil.isNumericType((PsiType)type) && (operandPush = factUse.findExpressionPush(operand = ((PsiTypeCastExpression)expression).getOperand())) != null) {
                DfaValue castedValue = operandPush.myTopOfStack;
                TrackingDfaMemoryState.FactDefinition<LongRangeSet> operandInfo = operandPush.findFact(castedValue, TrackingDfaMemoryState.FactExtractor.range());
                LongRangeSet operandRange = (LongRangeSet)operandInfo.myFact;
                LongRangeSet result = JvmPsiRangeSetUtil.castTo(operandRange, (PsiPrimitiveType)type);
                if (range.equals(result)) {
                    CauseItem cause = new CauseItem((DfaProblemType)new RangeDfaProblemType(JavaAnalysisBundle.message((String)"dfa.find.cause.result.of.primitive.cast.template", (Object[])new Object[]{type.getCanonicalText()}), range, null), (PsiElement)expression);
                    if (!operandRange.equals(JvmPsiRangeSetUtil.typeRange(operand.getType()))) {
                        cause.addChildren(TrackingRunner.findRangeCause(operandPush, castedValue, operandRange, JavaAnalysisBundle.message((String)"dfa.find.cause.numeric.cast.operand.template", (Object[])new Object[0])));
                    }
                    return cause;
                }
            }
            if (range.equals(JvmPsiRangeSetUtil.typeRange(type))) {
                return null;
            }
            if ((PsiTypes.longType().equals((Object)type) || PsiTypes.intType().equals((Object)type)) && expression instanceof PsiBinaryExpression) {
                PsiBinaryExpression binOp = (PsiBinaryExpression)expression;
                LongRangeType lrType = PsiTypes.longType().equals((Object)type) ? LongRangeType.INT64 : LongRangeType.INT32;
                PsiExpression left = PsiUtil.skipParenthesizedExprDown((PsiExpression)binOp.getLOperand());
                PsiExpression right = PsiUtil.skipParenthesizedExprDown((PsiExpression)binOp.getROperand());
                TrackingDfaMemoryState.MemoryStateChange leftPush = factUse.findExpressionPush(left);
                TrackingDfaMemoryState.MemoryStateChange rightPush = factUse.findExpressionPush(right);
                if (leftPush != null && rightPush != null) {
                    LongRangeSet result;
                    DfaValue leftVal = leftPush.myTopOfStack;
                    TrackingDfaMemoryState.FactDefinition<LongRangeSet> leftSet = leftPush.findFact(leftVal, TrackingDfaMemoryState.FactExtractor.range());
                    DfaValue rightVal = rightPush.myTopOfStack;
                    TrackingDfaMemoryState.FactDefinition<LongRangeSet> rightSet = rightPush.findFact(rightVal, TrackingDfaMemoryState.FactExtractor.range());
                    LongRangeSet fromType = Objects.requireNonNull(JvmPsiRangeSetUtil.typeRange(type));
                    LongRangeSet leftRange = ((LongRangeSet)leftSet.myFact).meet(fromType);
                    LongRangeSet rightRange = ((LongRangeSet)rightSet.myFact).meet(fromType);
                    LongRangeBinOp op = JvmPsiRangeSetUtil.binOpFromToken(binOp.getOperationTokenType());
                    if (op != null && range.equals(result = op.eval(leftRange, rightRange, lrType))) {
                        String sign = binOp.getOperationSign().getText();
                        CauseItem cause = new CauseItem((DfaProblemType)new RangeDfaProblemType(JavaAnalysisBundle.message((String)"dfa.find.cause.result.of.numeric.operation.template", (Object[])new Object[]{sign.equals("%") ? "%%" : sign}), range, (PsiPrimitiveType)ObjectUtils.tryCast((Object)type, PsiPrimitiveType.class)), factUse);
                        CauseItem leftCause = null;
                        CauseItem rightCause = null;
                        if (!leftRange.equals(fromType)) {
                            leftCause = TrackingRunner.findRangeCause(leftPush, leftVal, leftRange, JavaAnalysisBundle.message((String)"dfa.find.cause.left.operand.range.template", (Object[])new Object[0]));
                        }
                        if (!rightRange.equals(fromType)) {
                            rightCause = TrackingRunner.findRangeCause(rightPush, rightVal, rightRange, JavaAnalysisBundle.message((String)"dfa.find.cause.right.operand.range.template", (Object[])new Object[0]));
                        }
                        cause.addChildren(leftCause, rightCause);
                        return cause;
                    }
                }
            }
        }
        type = expression != null ? (PsiPrimitiveType)ObjectUtils.tryCast((Object)expression.getType(), PsiPrimitiveType.class) : null;
        CauseItem item = new CauseItem((DfaProblemType)new RangeDfaProblemType(template, range, (PsiPrimitiveType)type), factUse);
        TrackingDfaMemoryState.FactDefinition<LongRangeSet> info = factUse.findFact(value, TrackingDfaMemoryState.FactExtractor.range());
        while (!((LongRangeSet)info.myFact).equals(range) && info.myChange != null && (previous = info.myChange.getPrevious()) != null) {
            info = previous.findFact(value, TrackingDfaMemoryState.FactExtractor.range());
        }
        TrackingDfaMemoryState.MemoryStateChange memoryStateChange = factDef = range.equals(info.myFact) ? info.myChange : null;
        if (factDef != null) {
            TrackingDfaMemoryState.MemoryStateChange rValuePush;
            PsiExpression rExpression;
            if (factDef.myInstruction instanceof AssignInstruction && factDef.myTopOfStack == value && (rExpression = ((AssignInstruction)factDef.myInstruction).getRExpression()) != null && (rValuePush = factDef.findSubExpressionPush(rExpression)) != null) {
                CauseItem assignmentItem = TrackingRunner.createAssignmentCause((AssignInstruction)factDef.myInstruction, value);
                assignmentItem.addChildren(TrackingRunner.findRangeCause(rValuePush, rValuePush.myTopOfStack, range, JavaAnalysisBundle.message((String)"dfa.find.cause.numeric.range.generic.template", (Object[])new Object[0])));
                item.addChildren(assignmentItem);
                return item;
            }
            PsiExpression defExpression = factDef.getExpression();
            if (defExpression != null) {
                item.addChildren(new CauseItem(JavaAnalysisBundle.message((String)"dfa.find.cause.range.is.known.from.place", (Object[])new Object[0]), (PsiElement)defExpression));
            }
        }
        return item;
    }

    @Nullable
    @Nls
    public static String getObviouslyNonNullExplanation(PsiExpression arg) {
        if (arg == null || ExpressionUtils.isNullLiteral(arg)) {
            return null;
        }
        if (arg instanceof PsiNewExpression) {
            return JavaAnalysisBundle.message((String)"dfa.find.cause.nonnull.expression.kind.newly.created.object", (Object[])new Object[0]);
        }
        if (arg instanceof PsiLiteralExpression) {
            return JavaAnalysisBundle.message((String)"dfa.find.cause.nonnull.expression.kind.literal", (Object[])new Object[0]);
        }
        if (arg.getType() instanceof PsiPrimitiveType) {
            return JavaAnalysisBundle.message((String)"dfa.find.cause.nonnull.expression.kind.primitive.type", (Object[])new Object[]{arg.getType().getCanonicalText()});
        }
        if (arg instanceof PsiPolyadicExpression && ((PsiPolyadicExpression)arg).getOperationTokenType() == JavaTokenType.PLUS) {
            return JavaAnalysisBundle.message((String)"dfa.find.cause.nonnull.expression.kind.concatenation", (Object[])new Object[0]);
        }
        if (arg instanceof PsiThisExpression) {
            return JavaAnalysisBundle.message((String)"dfa.find.cause.nonnull.expression.kind.this.object", (Object[])new Object[0]);
        }
        return null;
    }

    private static TrackingDfaMemoryState.MemoryStateChange findRelationAddedChange(TrackingDfaMemoryState.MemoryStateChange history, DfaVariableValue var, TrackingDfaMemoryState.Relation relation) {
        if (relation.myRelationType == RelationType.NE && relation.myCounterpart.getDfType() instanceof DfConstantType) {
            return history.findRelation(var, rel -> rel.equals(relation) || rel.myRelationType == RelationType.EQ && rel.myCounterpart.getDfType() instanceof DfConstantType, true);
        }
        TrackingDfaMemoryState.MemoryStateChange exact = history.findRelation(var, rel -> rel.myCounterpart == relation.myCounterpart && relation.myRelationType.equals((Object)rel.myRelationType), true);
        if (exact != null) {
            return exact;
        }
        return history.findRelation(var, rel -> rel.myCounterpart == relation.myCounterpart && relation.myRelationType.isSubRelation(rel.myRelationType), true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 6, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 23, 24, 25, 30 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flow";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 23: 
            case 24: 
            case 25: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/TrackingRunner";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 8: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "history";
                break;
            }
            case 21: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 22: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contract";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/TrackingRunner";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "findConstantValueCause";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "findRelationCause";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getContractKind";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "contractApplies";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "fromSingleContract";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createInterpreter";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 23: 
            case 24: 
            case 25: 
            case 30: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findBooleanResultCauses";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "contractApplies";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "fromSingleContract";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 6, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 23, 24, 25, 30 -> new IllegalStateException(string);
        };
    }

    public static abstract class DfaProblemType {
        @Nls
        public abstract String toString();

        CauseItem[] findCauses(TrackingRunner runner, PsiExpression expression, TrackingDfaMemoryState.MemoryStateChange history) {
            return new CauseItem[0];
        }

        @Nullable
        DfaProblemType tryMerge(DfaProblemType other) {
            return this.toString().equals(other.toString()) ? this : null;
        }
    }

    public static class CauseItem {
        @NlsSafe
        private static final String PLACE_POINTER = "___PLACE___";
        @NotNull
        final List<CauseItem> myChildren;
        @NotNull
        final DfaProblemType myProblem;
        @Nullable
        final SmartPsiFileRange myTarget;

        private CauseItem(@NotNull List<CauseItem> children, @NotNull DfaProblemType problem, @Nullable SmartPsiFileRange target) {
            if (children == null) {
                CauseItem.$$$reportNull$$$0(0);
            }
            if (problem == null) {
                CauseItem.$$$reportNull$$$0(1);
            }
            this.myChildren = children;
            this.myProblem = problem;
            this.myTarget = target;
        }

        CauseItem(@NotNull @Nls String problem, @Nullable PsiElement target) {
            if (problem == null) {
                CauseItem.$$$reportNull$$$0(2);
            }
            this((DfaProblemType)new CustomDfaProblemType(problem), target);
        }

        CauseItem(@NotNull DfaProblemType problem, @Nullable PsiElement target) {
            if (problem == null) {
                CauseItem.$$$reportNull$$$0(3);
            }
            this.myChildren = new ArrayList<CauseItem>();
            this.myProblem = problem;
            if (target != null) {
                PsiFile file = target.getContainingFile();
                this.myTarget = SmartPointerManager.getInstance((Project)file.getProject()).createSmartPsiFileRangePointer(file, target.getTextRange());
            } else {
                this.myTarget = null;
            }
        }

        CauseItem(@NotNull @Nls String problem, @NotNull TrackingDfaMemoryState.MemoryStateChange change) {
            if (problem == null) {
                CauseItem.$$$reportNull$$$0(4);
            }
            if (change == null) {
                CauseItem.$$$reportNull$$$0(5);
            }
            this((DfaProblemType)new CustomDfaProblemType(problem), change);
        }

        CauseItem(@NotNull DfaProblemType problem, @NotNull TrackingDfaMemoryState.MemoryStateChange change) {
            if (problem == null) {
                CauseItem.$$$reportNull$$$0(6);
            }
            if (change == null) {
                CauseItem.$$$reportNull$$$0(7);
            }
            this(problem, (PsiElement)change.getExpression());
        }

        void addChildren(CauseItem ... causes) {
            ContainerUtil.addAllNotNull(this.myChildren, (Object[])causes);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CauseItem item = (CauseItem)o;
            return this.myChildren.equals(item.myChildren) && this.getProblemName().equals(item.getProblemName()) && Objects.equals(this.myTarget, item.myTarget);
        }

        @Nls
        private String getProblemName() {
            return this.myProblem.toString();
        }

        public int hashCode() {
            return Objects.hash(this.myChildren, this.getProblemName(), this.myTarget);
        }

        public String dump(Document doc) {
            return this.dump(doc, 0, null);
        }

        private String dump(Document doc, int indent, CauseItem parent) {
            Segment range;
            Object text = null;
            if (this.myTarget != null && (range = this.myTarget.getRange()) != null) {
                text = doc.getText(TextRange.create((Segment)range));
                int lineNumber = doc.getLineNumber(range.getStartOffset());
                text = (String)text + "; line#" + (lineNumber + 1);
            }
            return StringUtil.repeat((String)"  ", (int)indent) + this.render(doc, parent) + (String)(text == null ? "" : " (" + (String)text + ")") + "\n" + StreamEx.of(this.myChildren).map(child -> child.dump(doc, indent + 1, this)).joining();
        }

        public Stream<CauseItem> children() {
            return StreamEx.of(this.myChildren);
        }

        @Nullable
        public PsiFile getFile() {
            return this.myTarget != null ? this.myTarget.getContainingFile() : null;
        }

        public Segment getTargetSegment() {
            return this.myTarget == null ? null : this.myTarget.getRange();
        }

        @Nls
        public String render(Document doc, CauseItem parent) {
            int childIndex;
            String cause;
            String title = null;
            Segment range = this.getTargetSegment();
            if (range != null && (cause = this.getProblemName()).contains(PLACE_POINTER)) {
                int offset = range.getStartOffset();
                int number = doc.getLineNumber(offset);
                title = cause.replaceFirst(PLACE_POINTER, JavaAnalysisBundle.message((String)"dfa.find.cause.place.line.number", (Object[])new Object[]{number + 1}));
            }
            if (title == null) {
                title = this.toString();
            }
            int n = childIndex = parent == null ? 0 : parent.myChildren.indexOf(this);
            title = childIndex > 0 ? (parent.myProblem instanceof PossibleExecutionDfaProblemType ? JavaAnalysisBundle.message((String)"dfa.find.cause.or.another", (Object[])new Object[]{title}) : JavaAnalysisBundle.message((String)"dfa.find.cause.and.another", (Object[])new Object[]{title})) : StringUtil.capitalize((String)title);
            return title;
        }

        @Nls
        public String toString() {
            return this.getProblemName().replaceFirst(PLACE_POINTER, JavaAnalysisBundle.message((String)"dfa.find.cause.place.here", (Object[])new Object[0]));
        }

        public CauseItem merge(CauseItem other) {
            if (this.equals(other)) {
                return this;
            }
            if (Objects.equals(this.myTarget, other.myTarget)) {
                DfaProblemType mergedProblem;
                if (this.myChildren.equals(other.myChildren) && (mergedProblem = this.myProblem.tryMerge(other.myProblem)) != null) {
                    return new CauseItem(this.myChildren, mergedProblem, this.myTarget);
                }
                if (this.getProblemName().equals(other.getProblemName())) {
                    if (this.tryMergeChildren(other.myChildren)) {
                        return this;
                    }
                    if (other.tryMergeChildren(this.myChildren)) {
                        return other;
                    }
                }
            }
            return null;
        }

        private boolean tryMergeChildren(List<CauseItem> children) {
            if (this.myChildren.isEmpty()) {
                return false;
            }
            if (this.myChildren.size() != 1 || !(this.myChildren.get((int)0).myProblem instanceof PossibleExecutionDfaProblemType)) {
                if (children.size() == this.myChildren.size()) {
                    List merged = StreamEx.zip(this.myChildren, children, CauseItem::merge).toList();
                    int nullPos = merged.indexOf(null);
                    if (nullPos == -1) {
                        this.myChildren.clear();
                        this.myChildren.addAll(merged);
                        return true;
                    }
                    if (merged.lastIndexOf(null) == nullPos) {
                        CauseItem merge = new CauseItem((DfaProblemType)new PossibleExecutionDfaProblemType(), (PsiElement)null);
                        merge.addChildren(this.myChildren.get(nullPos), children.get(nullPos));
                        this.myChildren.clear();
                        this.myChildren.addAll(merged);
                        this.myChildren.set(nullPos, merge);
                        return true;
                    }
                }
                this.insertIntoHierarchy(new CauseItem((DfaProblemType)new PossibleExecutionDfaProblemType(), (PsiElement)null));
            }
            CauseItem mergePoint = this.myChildren.get(0);
            if (children.isEmpty()) {
                ((PossibleExecutionDfaProblemType)mergePoint.myProblem).myComplete = false;
            }
            List<CauseItem> mergeChildren = mergePoint.myChildren;
            for (CauseItem child : children) {
                if (mergeChildren.contains(child)) continue;
                boolean merged = false;
                for (int i = 0; i < mergeChildren.size(); ++i) {
                    CauseItem mergeChild = mergeChildren.get(i);
                    CauseItem result = mergeChild.merge(child);
                    if (result == null) continue;
                    mergeChildren.set(i, result);
                    merged = true;
                    break;
                }
                if (merged) continue;
                mergeChildren.add(child);
            }
            return true;
        }

        private void insertIntoHierarchy(CauseItem intermediate) {
            intermediate.myChildren.addAll(this.myChildren);
            this.myChildren.clear();
            this.myChildren.add(intermediate);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "children";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[0] = "problem";
                    break;
                }
                case 5: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[0] = "change";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInspection/dataFlow/TrackingRunner$CauseItem";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class CustomDfaProblemType
    extends DfaProblemType {
        @Nls
        private final String myMessage;

        CustomDfaProblemType(@Nls String message) {
            this.myMessage = message;
        }

        @Override
        public String toString() {
            return this.myMessage;
        }
    }

    public static class RangeDfaProblemType
    extends DfaProblemType {
        @NotNull
        @Nls
        final String myTemplate;
        @NotNull
        final LongRangeSet myRangeSet;
        @Nullable
        final PsiPrimitiveType myType;

        public RangeDfaProblemType(@NotNull LongRangeSet set, @Nullable PsiPrimitiveType type) {
            if (set == null) {
                RangeDfaProblemType.$$$reportNull$$$0(0);
            }
            this(JavaAnalysisBundle.message((String)"dfa.find.cause.numeric.range.generic.template", (Object[])new Object[0]), set, type);
        }

        RangeDfaProblemType(@NotNull @Nls String template, @NotNull LongRangeSet set, @Nullable PsiPrimitiveType type) {
            if (template == null) {
                RangeDfaProblemType.$$$reportNull$$$0(1);
            }
            if (set == null) {
                RangeDfaProblemType.$$$reportNull$$$0(2);
            }
            this.myTemplate = template;
            this.myRangeSet = set;
            this.myType = type;
        }

        @Override
        CauseItem[] findCauses(TrackingRunner runner, PsiExpression expression, TrackingDfaMemoryState.MemoryStateChange history) {
            CauseItem[] causeItemArray;
            CauseItem cause = TrackingRunner.findRangeCause(history, history.myTopOfStack, this.myRangeSet, this.myTemplate);
            if (cause == null) {
                causeItemArray = new CauseItem[]{};
            } else {
                CauseItem[] causeItemArray2 = new CauseItem[1];
                causeItemArray = causeItemArray2;
                causeItemArray2[0] = cause;
            }
            return causeItemArray;
        }

        @Override
        @Nullable
        DfaProblemType tryMerge(DfaProblemType other) {
            if (other instanceof RangeDfaProblemType) {
                RangeDfaProblemType rangeProblem = (RangeDfaProblemType)other;
                if (this.myTemplate.equals(rangeProblem.myTemplate) && Objects.equals(this.myType, rangeProblem.myType)) {
                    return new RangeDfaProblemType(this.myTemplate, this.myRangeSet.join(rangeProblem.myRangeSet), this.myType);
                }
            }
            return super.tryMerge(other);
        }

        @Override
        public String toString() {
            return String.format(this.myTemplate, JvmPsiRangeSetUtil.getPresentationText(this.myRangeSet, (PsiType)this.myType));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "set";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "template";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInspection/dataFlow/TrackingRunner$RangeDfaProblemType";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class ZeroSizeDfaProblemType
    extends DfaProblemType {
        final SpecialField myField;

        public ZeroSizeDfaProblemType(@NotNull SpecialField field) {
            if (field == null) {
                ZeroSizeDfaProblemType.$$$reportNull$$$0(0);
            }
            this.myField = field;
        }

        @Override
        public CauseItem[] findCauses(TrackingRunner runner, PsiExpression expression, TrackingDfaMemoryState.MemoryStateChange history) {
            DfaValue topOfStack = history.myTopOfStack;
            DfaValue value = this.myField.createValue(runner.getFactory(), topOfStack);
            TrackingDfaMemoryState.MemoryStateChange change = TrackingDfaMemoryState.MemoryStateChange.create(history, (Instruction)new PushInstruction(value, null), Map.of(), value);
            return runner.findConstantValueCause(expression, change, 0);
        }

        @Override
        public String toString() {
            return JavaAnalysisBundle.message((String)"dfa.find.cause.size.is.always.zero", (Object[])new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/intellij/codeInspection/dataFlow/TrackingRunner$ZeroSizeDfaProblemType", "<init>"));
        }
    }

    public static class ValueDfaProblemType
    extends DfaProblemType {
        final Object myValue;

        public ValueDfaProblemType(Object value) {
            this.myValue = value;
        }

        @Override
        public CauseItem[] findCauses(TrackingRunner runner, PsiExpression expression, TrackingDfaMemoryState.MemoryStateChange history) {
            return runner.findConstantValueCause(expression, history, this.myValue);
        }

        @Override
        public String toString() {
            return JavaAnalysisBundle.message((String)"dfa.find.cause.value.is.always.the.same", (Object[])new Object[]{this.myValue});
        }
    }

    static class PossibleExecutionDfaProblemType
    extends DfaProblemType {
        boolean myComplete = true;

        PossibleExecutionDfaProblemType() {
        }

        @Override
        public String toString() {
            return this.myComplete ? JavaAnalysisBundle.message((String)"dfa.find.cause.one.of.the.following.happens", (Object[])new Object[0]) : JavaAnalysisBundle.message((String)"dfa.find.cause.an.execution.might.exist.where", (Object[])new Object[0]);
        }
    }

    public static class FailingCallDfaProblemType
    extends DfaProblemType {
        @Override
        CauseItem[] findCauses(TrackingRunner runner, PsiExpression expression, TrackingDfaMemoryState.MemoryStateChange history) {
            if (expression instanceof PsiCallExpression) {
                return new CauseItem[]{runner.fromCallContract(history, (PsiCallExpression)expression, ContractReturnValue.fail())};
            }
            return super.findCauses(runner, expression, history);
        }

        @Override
        public String toString() {
            return JavaAnalysisBundle.message((String)"dfa.find.cause.call.always.fails", (Object[])new Object[0]);
        }
    }

    public static class NullableDfaProblemType
    extends DfaProblemType {
        @Override
        public CauseItem[] findCauses(TrackingRunner runner, PsiExpression expression, TrackingDfaMemoryState.MemoryStateChange history) {
            TrackingDfaMemoryState.FactDefinition<DfaNullability> nullability = history.findFact(history.myTopOfStack, TrackingDfaMemoryState.FactExtractor.nullability());
            if (nullability.myFact == DfaNullability.NULLABLE || nullability.myFact == DfaNullability.NULL) {
                return new CauseItem[]{runner.findNullabilityCause(history, (DfaNullability)((Object)nullability.myFact))};
            }
            return new CauseItem[0];
        }

        @Override
        public String toString() {
            return JavaAnalysisBundle.message((String)"dfa.find.cause.may.be.null", (Object[])new Object[0]);
        }
    }

    public static class CastDfaProblemType
    extends DfaProblemType {
        @Override
        public CauseItem[] findCauses(TrackingRunner runner, PsiExpression expression, TrackingDfaMemoryState.MemoryStateChange history) {
            if (expression instanceof PsiTypeCastExpression) {
                PsiType expressionType = expression.getType();
                TrackingDfaMemoryState.MemoryStateChange operandPush = history.findExpressionPush(((PsiTypeCastExpression)expression).getOperand());
                if (operandPush != null) {
                    return new CauseItem[]{TrackingRunner.findTypeCause(operandPush, expressionType, false)};
                }
            }
            return new CauseItem[0];
        }

        @Override
        public String toString() {
            return JavaAnalysisBundle.message((String)"dfa.find.cause.cast.may.fail", (Object[])new Object[0]);
        }
    }
}

