/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.fix;

import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import org.jetbrains.annotations.NotNull;

public class RedundantInstanceofFix
extends PsiUpdateModCommandAction<PsiElement> {
    public RedundantInstanceofFix(@NotNull PsiElement element) {
        if (element == null) {
            RedundantInstanceofFix.$$$reportNull$$$0(0);
        }
        super(element);
    }

    @NotNull
    public String getFamilyName() {
        String string = JavaAnalysisBundle.message((String)"inspection.data.flow.redundant.instanceof.quickfix", (Object[])new Object[0]);
        if (string == null) {
            RedundantInstanceofFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    protected void invoke(@NotNull ActionContext context, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
        String replacement;
        PsiExpression expression;
        if (context == null) {
            RedundantInstanceofFix.$$$reportNull$$$0(2);
        }
        if (element == null) {
            RedundantInstanceofFix.$$$reportNull$$$0(3);
        }
        if (updater == null) {
            RedundantInstanceofFix.$$$reportNull$$$0(4);
        }
        PsiElement psiElement = element;
        CommentTracker ct = new CommentTracker();
        JavaCodeStyleManager javaCodeStyleManager = JavaCodeStyleManager.getInstance((Project)context.project());
        if (psiElement instanceof PsiMethodReferenceExpression) {
            String replacement2 = "java.util.Objects::nonNull";
            javaCodeStyleManager.shortenClassReferences(ct.replaceAndRestoreComments(psiElement, replacement2));
            return;
        }
        String nonNullExpression = null;
        if (psiElement instanceof PsiInstanceOfExpression) {
            PsiInstanceOfExpression instanceOf = (PsiInstanceOfExpression)psiElement;
            nonNullExpression = ct.text((PsiElement)instanceOf.getOperand());
        } else if (psiElement instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression call = (PsiMethodCallExpression)psiElement;
            PsiExpression arg = (PsiExpression)ArrayUtil.getFirstElement((Object[])call.getArgumentList().getExpressions());
            if (arg == null) {
                return;
            }
            nonNullExpression = ct.text((PsiElement)arg);
        }
        if (nonNullExpression == null) {
            return;
        }
        PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)psiElement.getParent());
        if (parent instanceof PsiExpression && BoolUtils.isNegation(expression = (PsiExpression)parent)) {
            replacement = nonNullExpression + "==null";
            psiElement = parent;
        } else {
            replacement = nonNullExpression + "!=null";
        }
        javaCodeStyleManager.shortenClassReferences(ct.replaceAndRestoreComments(psiElement, replacement));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/fix/RedundantInstanceofFix";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/fix/RedundantInstanceofFix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

