/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.fix;

import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.util.PsiExpressionTrimRenderer;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.psiutils.CommentTracker;
import org.jetbrains.annotations.NotNull;

public class ReplaceWithArgumentFix
extends PsiUpdateModCommandQuickFix {
    private final String myText;
    private final int myArgNum;

    public ReplaceWithArgumentFix(PsiExpression argument, int argNum) {
        this.myText = PsiExpressionTrimRenderer.render((PsiExpression)argument);
        this.myArgNum = argNum;
    }

    @IntentionName
    @NotNull
    public String getName() {
        String string = CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{this.myText});
        if (string == null) {
            ReplaceWithArgumentFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @IntentionFamilyName
    @NotNull
    public String getFamilyName() {
        String string = InspectionGadgetsBundle.message("inspection.redundant.string.replace.with.arg.fix.name", new Object[0]);
        if (string == null) {
            ReplaceWithArgumentFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
        PsiMethodCallExpression call;
        if (project == null) {
            ReplaceWithArgumentFix.$$$reportNull$$$0(2);
        }
        if (element == null) {
            ReplaceWithArgumentFix.$$$reportNull$$$0(3);
        }
        if (updater == null) {
            ReplaceWithArgumentFix.$$$reportNull$$$0(4);
        }
        if ((call = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethodCallExpression.class)) == null) {
            return;
        }
        PsiExpression[] args = call.getArgumentList().getExpressions();
        if (args.length <= this.myArgNum) {
            return;
        }
        new CommentTracker().replaceAndRestoreComments((PsiElement)call, (PsiElement)args[this.myArgNum]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/fix/ReplaceWithArgumentFix";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/fix/ReplaceWithArgumentFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4 -> new IllegalArgumentException(string);
        };
    }
}

