/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.fix;

import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import org.jetbrains.annotations.NotNull;

public class ReplaceWithBooleanEqualsFix
extends PsiUpdateModCommandQuickFix {
    private final String myOldExprText;
    private final boolean myFalseIsAcceptable;

    public ReplaceWithBooleanEqualsFix(@NotNull PsiExpression qualifier) {
        if (qualifier == null) {
            ReplaceWithBooleanEqualsFix.$$$reportNull$$$0(0);
        }
        this.myOldExprText = qualifier.getText();
        PsiPrefixExpression parent = (PsiPrefixExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprUp((PsiElement)qualifier.getParent()), PsiPrefixExpression.class);
        this.myFalseIsAcceptable = parent != null && parent.getOperationTokenType() == JavaTokenType.EXCL;
    }

    @NotNull
    public String getName() {
        String string = CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{this.createNewExprText()});
        if (string == null) {
            ReplaceWithBooleanEqualsFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = JavaAnalysisBundle.message((String)"replace.with.boolean.equals", (Object[])new Object[0]);
        if (string == null) {
            ReplaceWithBooleanEqualsFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
        PsiExpression oldExpr;
        PsiElement qualifier;
        if (project == null) {
            ReplaceWithBooleanEqualsFix.$$$reportNull$$$0(3);
        }
        if (element == null) {
            ReplaceWithBooleanEqualsFix.$$$reportNull$$$0(4);
        }
        if (updater == null) {
            ReplaceWithBooleanEqualsFix.$$$reportNull$$$0(5);
        }
        if ((qualifier = (PsiElement)ObjectUtils.tryCast((Object)element, PsiExpression.class)) == null) {
            return;
        }
        if (this.myFalseIsAcceptable) {
            qualifier = qualifier.getParent();
        }
        if ((oldExpr = (PsiExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprUp((PsiElement)qualifier), PsiExpression.class)) == null) {
            return;
        }
        PsiReplacementUtil.replaceExpression(oldExpr, this.createNewExprText(), new CommentTracker());
    }

    @NotNull
    private String createNewExprText() {
        String string = "Boolean." + (this.myFalseIsAcceptable ? "FALSE" : "TRUE") + ".equals(" + this.myOldExprText + ")";
        if (string == null) {
            ReplaceWithBooleanEqualsFix.$$$reportNull$$$0(6);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 1: 
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/fix/ReplaceWithBooleanEqualsFix";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/fix/ReplaceWithBooleanEqualsFix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createNewExprText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 6: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 6 -> new IllegalStateException(string);
        };
    }
}

