/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.fix;

import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class SurroundWithRequireNonNullFix
extends PsiUpdateModCommandQuickFix {
    private final String myText;
    private final SmartPsiElementPointer<PsiExpression> myQualifierPointer;

    public SurroundWithRequireNonNullFix(@NotNull PsiExpression expressionToSurround) {
        if (expressionToSurround == null) {
            SurroundWithRequireNonNullFix.$$$reportNull$$$0(0);
        }
        this.myText = expressionToSurround.getText();
        this.myQualifierPointer = SmartPointerManager.getInstance((Project)expressionToSurround.getProject()).createSmartPsiElementPointer((PsiElement)expressionToSurround);
    }

    @Nls
    @NotNull
    public String getName() {
        String string = JavaAnalysisBundle.message((String)"inspection.surround.requirenonnull.quickfix", (Object[])new Object[]{this.myText});
        if (string == null) {
            SurroundWithRequireNonNullFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = JavaAnalysisBundle.message((String)"inspection.surround.requirenonnull.quickfix", (Object[])new Object[]{""});
        if (string == null) {
            SurroundWithRequireNonNullFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
        PsiExpression qualifier;
        if (project == null) {
            SurroundWithRequireNonNullFix.$$$reportNull$$$0(3);
        }
        if (element == null) {
            SurroundWithRequireNonNullFix.$$$reportNull$$$0(4);
        }
        if (updater == null) {
            SurroundWithRequireNonNullFix.$$$reportNull$$$0(5);
        }
        if ((qualifier = (PsiExpression)updater.getWritable((PsiElement)((PsiExpression)this.myQualifierPointer.getElement()))) == null) {
            return;
        }
        PsiExpression replacement = JavaPsiFacade.getElementFactory((Project)project).createExpressionFromText("java.util.Objects.requireNonNull(" + qualifier.getText() + ")", (PsiElement)qualifier);
        JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(qualifier.replace((PsiElement)replacement));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressionToSurround";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/fix/SurroundWithRequireNonNullFix";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/fix/SurroundWithRequireNonNullFix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }
}

