/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.inference;

import com.intellij.codeInsight.Nullability;
import com.intellij.codeInspection.dataFlow.ContractReturnValue;
import com.intellij.codeInspection.dataFlow.StandardMethodContract;
import com.intellij.codeInspection.dataFlow.inference.DelegationContract;
import com.intellij.codeInspection.dataFlow.inference.ExpressionRange;
import com.intellij.codeInspection.dataFlow.inference.KnownContract;
import com.intellij.codeInspection.dataFlow.inference.MethodCallContract;
import com.intellij.codeInspection.dataFlow.inference.MethodData;
import com.intellij.codeInspection.dataFlow.inference.MethodReturnInferenceResult;
import com.intellij.codeInspection.dataFlow.inference.NegatingContract;
import com.intellij.codeInspection.dataFlow.inference.PreContract;
import com.intellij.codeInspection.dataFlow.inference.PurityInferenceResult;
import com.intellij.codeInspection.dataFlow.inference.SideEffectFilter;
import com.intellij.openapi.util.io.DataInputOutputUtilRt;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J&\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0014\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0002H\u0016J\u001c\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00022\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0004H\u0002J\u0010\u0010\u0011\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u0012\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u0016\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u00182\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001e\u0010\u001a\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cH\u0002J<\u0010\u001e\u001a.\u0012\f\u0012\n  *\u0004\u0018\u00010\u001d0\u001d  *\u0015\u0012\f\u0012\n  *\u0004\u0018\u00010\u001d0\u001d0\u001c\u00a2\u0006\u0002\b!0\u001f\u00a2\u0006\u0002\b!2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\"\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010#\u001a\u00020\u001dH\u0002J\u0010\u0010$\u001a\u00020\u001d2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010%\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010&\u001a\u00020'H\u0002J\u0010\u0010(\u001a\u00020'2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010)\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010*\u001a\u00020+H\u0002J\u0010\u0010,\u001a\u00020+2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001e\u0010-\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020/0\u001cH\u0002J\u0016\u00100\u001a\b\u0012\u0004\u0012\u00020/0\u001f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u00101\u001a\u00020/2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0015\u00102\u001a\u000703\u00a2\u0006\u0002\b!2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u00064"}, d2={"Lcom/intellij/codeInspection/dataFlow/inference/MethodDataExternalizer;", "Lcom/intellij/util/io/DataExternalizer;", "", "", "Lcom/intellij/codeInspection/dataFlow/inference/MethodData;", "<init>", "()V", "save", "", "out", "Ljava/io/DataOutput;", "value", "read", "input", "Ljava/io/DataInput;", "writeMethod", "data", "readMethod", "writeBitSet", "bitSet", "Ljava/util/BitSet;", "readBitSet", "writeNullity", "methodReturn", "Lcom/intellij/codeInspection/dataFlow/inference/MethodReturnInferenceResult;", "readNullity", "writeRanges", "ranges", "", "Lcom/intellij/codeInspection/dataFlow/inference/ExpressionRange;", "readRanges", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "writeRange", "range", "readRange", "writePurity", "purity", "Lcom/intellij/codeInspection/dataFlow/inference/PurityInferenceResult;", "readPurity", "writeContract", "contract", "Lcom/intellij/codeInspection/dataFlow/inference/PreContract;", "readContract", "writeContractArguments", "arguments", "Lcom/intellij/codeInspection/dataFlow/StandardMethodContract$ValueConstraint;", "readContractArguments", "readValueConstraint", "readReturnValue", "Lcom/intellij/codeInspection/dataFlow/ContractReturnValue;", "intellij.java.analysis.impl"})
@SourceDebugExtension(value={"SMAP\nMethodDataExternalizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MethodDataExternalizer.kt\ncom/intellij/codeInspection/dataFlow/inference/MethodDataExternalizer\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,162:1\n37#2,2:163\n*S KotlinDebug\n*F\n+ 1 MethodDataExternalizer.kt\ncom/intellij/codeInspection/dataFlow/inference/MethodDataExternalizer\n*L\n141#1:163,2\n*E\n"})
public final class MethodDataExternalizer
implements DataExternalizer<Map<Integer, ? extends MethodData>> {
    @NotNull
    public static final MethodDataExternalizer INSTANCE = new MethodDataExternalizer();

    private MethodDataExternalizer() {
    }

    public void save(@NotNull DataOutput out, @Nullable Map<Integer, MethodData> value) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        Map<Integer, MethodData> map = value;
        Intrinsics.checkNotNull(map);
        DataInputOutputUtilRt.writeSeq((DataOutput)out, (Collection)MapsKt.toList(map), arg_0 -> MethodDataExternalizer.save$lambda$0(out, arg_0));
    }

    @NotNull
    public Map<Integer, MethodData> read(@NotNull DataInput input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        List list = DataInputOutputUtilRt.readSeq((DataInput)input, () -> MethodDataExternalizer.read$lambda$0(input));
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"readSeq(...)");
        return MapsKt.toMap((Iterable)list);
    }

    private final void writeMethod(DataOutput out, MethodData data) {
        DataInputOutputUtil.writeNullable((DataOutput)out, (Object)data.getMethodReturn(), arg_0 -> MethodDataExternalizer.writeMethod$lambda$1(arg_0 -> MethodDataExternalizer.writeMethod$lambda$0(out, arg_0), arg_0));
        DataInputOutputUtil.writeNullable((DataOutput)out, (Object)data.getPurity(), arg_0 -> MethodDataExternalizer.writeMethod$lambda$3(arg_0 -> MethodDataExternalizer.writeMethod$lambda$2(out, arg_0), arg_0));
        DataInputOutputUtilRt.writeSeq((DataOutput)out, (Collection)data.getContracts(), arg_0 -> MethodDataExternalizer.writeMethod$lambda$4(out, arg_0));
        this.writeBitSet(out, data.getNotNullParameters());
        DataInputOutputUtilRt.writeINT((DataOutput)out, (int)data.getBodyStart$intellij_java_analysis_impl());
        DataInputOutputUtilRt.writeINT((DataOutput)out, (int)data.getBodyEnd$intellij_java_analysis_impl());
    }

    private final MethodData readMethod(DataInput input) {
        MethodReturnInferenceResult nullity = (MethodReturnInferenceResult)DataInputOutputUtil.readNullable((DataInput)input, () -> MethodDataExternalizer.readMethod$lambda$0(input));
        PurityInferenceResult purity = (PurityInferenceResult)DataInputOutputUtil.readNullable((DataInput)input, () -> MethodDataExternalizer.readMethod$lambda$1(input));
        List list = DataInputOutputUtilRt.readSeq((DataInput)input, () -> MethodDataExternalizer.readMethod$lambda$2(input));
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"readSeq(...)");
        List contracts = list;
        BitSet notNullParameters = this.readBitSet(input);
        return new MethodData(nullity, purity, contracts, notNullParameters, DataInputOutputUtilRt.readINT((DataInput)input), DataInputOutputUtilRt.readINT((DataInput)input));
    }

    private final void writeBitSet(DataOutput out, BitSet bitSet) {
        boolean bl;
        byte[] bytes = bitSet.toByteArray();
        int size = bytes.length;
        boolean bl2 = 0 <= size ? size < 256 : (bl = false);
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        out.writeByte(size);
        out.write(bytes);
    }

    private final BitSet readBitSet(DataInput input) {
        int size = input.readUnsignedByte();
        byte[] bytes = new byte[size];
        input.readFully(bytes);
        BitSet bitSet = BitSet.valueOf(bytes);
        Intrinsics.checkNotNullExpressionValue((Object)bitSet, (String)"valueOf(...)");
        return bitSet;
    }

    private final void writeNullity(DataOutput out, MethodReturnInferenceResult methodReturn) {
        MethodReturnInferenceResult methodReturnInferenceResult = methodReturn;
        if (methodReturnInferenceResult instanceof MethodReturnInferenceResult.Predefined) {
            out.writeByte(0);
            out.writeByte(((MethodReturnInferenceResult.Predefined)methodReturn).getValue$intellij_java_analysis_impl().ordinal());
        } else if (methodReturnInferenceResult instanceof MethodReturnInferenceResult.FromDelegate) {
            out.writeByte(1);
            out.writeByte(((MethodReturnInferenceResult.FromDelegate)methodReturn).getValue$intellij_java_analysis_impl().ordinal());
            this.writeRanges(out, ((MethodReturnInferenceResult.FromDelegate)methodReturn).getDelegateCalls$intellij_java_analysis_impl());
        } else {
            throw new IllegalArgumentException(methodReturn.toString());
        }
    }

    private final MethodReturnInferenceResult readNullity(DataInput input) {
        return input.readByte() == 0 ? (MethodReturnInferenceResult)new MethodReturnInferenceResult.Predefined(Nullability.values()[input.readByte()]) : (MethodReturnInferenceResult)new MethodReturnInferenceResult.FromDelegate(Nullability.values()[input.readByte()], this.readRanges(input));
    }

    private final void writeRanges(DataOutput out, List<ExpressionRange> ranges) {
        DataInputOutputUtilRt.writeSeq((DataOutput)out, (Collection)ranges, arg_0 -> MethodDataExternalizer.writeRanges$lambda$0(out, arg_0));
    }

    private final List<ExpressionRange> readRanges(DataInput input) {
        List list = DataInputOutputUtilRt.readSeq((DataInput)input, () -> MethodDataExternalizer.readRanges$lambda$0(input));
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"readSeq(...)");
        return list;
    }

    private final void writeRange(DataOutput out, ExpressionRange range) {
        DataInputOutputUtilRt.writeINT((DataOutput)out, (int)range.getStartOffset());
        DataInputOutputUtilRt.writeINT((DataOutput)out, (int)range.getEndOffset());
    }

    private final ExpressionRange readRange(DataInput input) {
        return new ExpressionRange(DataInputOutputUtilRt.readINT((DataInput)input), DataInputOutputUtilRt.readINT((DataInput)input));
    }

    private final void writePurity(DataOutput out, PurityInferenceResult purity) {
        out.writeBoolean(purity.getMutatesThis$intellij_java_analysis_impl());
        this.writeRanges(out, purity.getMutatedRefs$intellij_java_analysis_impl());
        DataInputOutputUtil.writeNullable((DataOutput)out, (Object)purity.getSingleCall$intellij_java_analysis_impl(), arg_0 -> MethodDataExternalizer.writePurity$lambda$1(arg_0 -> MethodDataExternalizer.writePurity$lambda$0(out, arg_0), arg_0));
    }

    private final PurityInferenceResult readPurity(DataInput input) {
        return new PurityInferenceResult(input.readBoolean(), this.readRanges(input), (ExpressionRange)DataInputOutputUtil.readNullable((DataInput)input, () -> MethodDataExternalizer.readPurity$lambda$0(input)));
    }

    private final void writeContract(DataOutput out, PreContract contract) {
        PreContract preContract = contract;
        if (preContract instanceof DelegationContract) {
            out.writeByte(0);
            this.writeRange(out, ((DelegationContract)contract).getExpression$intellij_java_analysis_impl());
            out.writeBoolean(((DelegationContract)contract).getNegated$intellij_java_analysis_impl());
        } else if (preContract instanceof KnownContract) {
            out.writeByte(1);
            List<StandardMethodContract.ValueConstraint> list = ((KnownContract)contract).getContract().getConstraints();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getConstraints(...)");
            this.writeContractArguments(out, list);
            out.writeByte(((KnownContract)contract).getContract().getReturnValue().ordinal());
        } else if (preContract instanceof MethodCallContract) {
            out.writeByte(2);
            this.writeRange(out, ((MethodCallContract)contract).getCall$intellij_java_analysis_impl());
            DataInputOutputUtilRt.writeSeq((DataOutput)out, (Collection)((MethodCallContract)contract).getStates$intellij_java_analysis_impl(), arg_0 -> MethodDataExternalizer.writeContract$lambda$0(out, arg_0));
        } else if (preContract instanceof NegatingContract) {
            out.writeByte(3);
            this.writeContract(out, ((NegatingContract)contract).getNegated$intellij_java_analysis_impl());
        } else if (preContract instanceof SideEffectFilter) {
            out.writeByte(4);
            this.writeRanges(out, ((SideEffectFilter)contract).getExpressionsToCheck$intellij_java_analysis_impl());
            DataInputOutputUtilRt.writeSeq((DataOutput)out, (Collection)((SideEffectFilter)contract).getContracts$intellij_java_analysis_impl(), arg_0 -> MethodDataExternalizer.writeContract$lambda$1(out, arg_0));
        } else {
            throw new IllegalArgumentException(contract.toString());
        }
    }

    private final PreContract readContract(DataInput input) {
        return switch (input.readByte()) {
            case 0 -> new DelegationContract(this.readRange(input), input.readBoolean());
            case 1 -> {
                Collection $this$toTypedArray$iv = this.readContractArguments(input);
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                yield new KnownContract(new StandardMethodContract(thisCollection$iv.toArray(new StandardMethodContract.ValueConstraint[0]), this.readReturnValue(input)));
            }
            case 2 -> {
                ExpressionRange v1 = this.readRange(input);
                List v2 = DataInputOutputUtilRt.readSeq((DataInput)input, () -> MethodDataExternalizer.readContract$lambda$0(input));
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"readSeq(...)");
                yield new MethodCallContract(v1, v2);
            }
            case 3 -> new NegatingContract(this.readContract(input));
            default -> {
                List<ExpressionRange> v3 = this.readRanges(input);
                List v4 = DataInputOutputUtilRt.readSeq((DataInput)input, () -> MethodDataExternalizer.readContract$lambda$1(input));
                Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"readSeq(...)");
                yield new SideEffectFilter(v3, v4);
            }
        };
    }

    private final void writeContractArguments(DataOutput out, List<? extends StandardMethodContract.ValueConstraint> arguments) {
        DataInputOutputUtilRt.writeSeq((DataOutput)out, (Collection)arguments, arg_0 -> MethodDataExternalizer.writeContractArguments$lambda$0(out, arg_0));
    }

    private final List<StandardMethodContract.ValueConstraint> readContractArguments(DataInput input) {
        List list = DataInputOutputUtilRt.readSeq((DataInput)input, () -> MethodDataExternalizer.readContractArguments$lambda$0(input));
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"readSeq(...)");
        return list;
    }

    private final StandardMethodContract.ValueConstraint readValueConstraint(DataInput input) {
        return StandardMethodContract.ValueConstraint.values()[input.readByte()];
    }

    private final ContractReturnValue readReturnValue(DataInput input) {
        ContractReturnValue contractReturnValue = ContractReturnValue.valueOf(input.readByte());
        Intrinsics.checkNotNullExpressionValue((Object)contractReturnValue, (String)"valueOf(...)");
        return contractReturnValue;
    }

    private static final void save$lambda$0(DataOutput $out, Pair it) {
        DataInputOutputUtilRt.writeINT((DataOutput)$out, (int)((Number)it.getFirst()).intValue());
        INSTANCE.writeMethod($out, (MethodData)it.getSecond());
    }

    private static final Pair read$lambda$0(DataInput $input) {
        return TuplesKt.to((Object)DataInputOutputUtilRt.readINT((DataInput)$input), (Object)INSTANCE.readMethod($input));
    }

    private static final Unit writeMethod$lambda$0(DataOutput $out, MethodReturnInferenceResult it) {
        Intrinsics.checkNotNull((Object)it);
        INSTANCE.writeNullity($out, it);
        return Unit.INSTANCE;
    }

    private static final void writeMethod$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit writeMethod$lambda$2(DataOutput $out, PurityInferenceResult it) {
        Intrinsics.checkNotNull((Object)it);
        INSTANCE.writePurity($out, it);
        return Unit.INSTANCE;
    }

    private static final void writeMethod$lambda$3(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void writeMethod$lambda$4(DataOutput $out, PreContract it) {
        Intrinsics.checkNotNull((Object)it);
        INSTANCE.writeContract($out, it);
    }

    private static final MethodReturnInferenceResult readMethod$lambda$0(DataInput $input) {
        return INSTANCE.readNullity($input);
    }

    private static final PurityInferenceResult readMethod$lambda$1(DataInput $input) {
        return INSTANCE.readPurity($input);
    }

    private static final PreContract readMethod$lambda$2(DataInput $input) {
        return INSTANCE.readContract($input);
    }

    private static final void writeRanges$lambda$0(DataOutput $out, ExpressionRange it) {
        Intrinsics.checkNotNull((Object)it);
        INSTANCE.writeRange($out, it);
    }

    private static final ExpressionRange readRanges$lambda$0(DataInput $input) {
        return INSTANCE.readRange($input);
    }

    private static final Unit writePurity$lambda$0(DataOutput $out, ExpressionRange it) {
        Intrinsics.checkNotNull((Object)it);
        INSTANCE.writeRange($out, it);
        return Unit.INSTANCE;
    }

    private static final void writePurity$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final ExpressionRange readPurity$lambda$0(DataInput $input) {
        return INSTANCE.readRange($input);
    }

    private static final void writeContract$lambda$0(DataOutput $out, List it) {
        Intrinsics.checkNotNull((Object)it);
        INSTANCE.writeContractArguments($out, it);
    }

    private static final void writeContract$lambda$1(DataOutput $out, PreContract it) {
        Intrinsics.checkNotNull((Object)it);
        INSTANCE.writeContract($out, it);
    }

    private static final List readContract$lambda$0(DataInput $input) {
        return INSTANCE.readContractArguments($input);
    }

    private static final PreContract readContract$lambda$1(DataInput $input) {
        return INSTANCE.readContract($input);
    }

    private static final void writeContractArguments$lambda$0(DataOutput $out, StandardMethodContract.ValueConstraint it) {
        $out.writeByte(it.ordinal());
    }

    private static final StandardMethodContract.ValueConstraint readContractArguments$lambda$0(DataInput $input) {
        return INSTANCE.readValueConstraint($input);
    }
}

