/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.inference;

import com.intellij.codeInsight.Nullability;
import com.intellij.codeInspection.dataFlow.inference.ExpressionRange;
import com.intellij.codeInspection.dataFlow.inference.MethodReturnInferenceResult;
import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.source.FileLocalResolver;
import com.intellij.psi.impl.source.JavaLightTreeUtil;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.LightTreeUtil;
import com.intellij.psi.impl.source.tree.RecursiveLighterASTNodeWalkingVisitor;
import com.intellij.psi.impl.source.tree.java.PsiSwitchLabeledRuleStatementImpl;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class MethodReturnInferenceVisitor {
    private static final TokenSet SHORT_CIRCUIT = TokenSet.create((IElementType[])new IElementType[]{JavaTokenType.ANDAND, JavaTokenType.OROR});
    private final LighterAST tree;
    private final List<LighterASTNode> myParameters;
    private final LighterASTNode myBody;
    private boolean hasErrors;
    private ReturnValue myReturnValue = ReturnValue.TOP;
    private boolean hasSystemExit;

    MethodReturnInferenceVisitor(LighterAST tree, List<LighterASTNode> parameters, LighterASTNode body) {
        this.tree = tree;
        this.myParameters = parameters;
        this.myBody = body;
    }

    void visitNode(LighterASTNode element) {
        LighterASTNode qualifier;
        LighterASTNode reference;
        IElementType type = element.getTokenType();
        if (type == TokenType.ERROR_ELEMENT) {
            this.hasErrors = true;
        } else if (type == JavaElementType.RETURN_STATEMENT) {
            LighterASTNode value = JavaLightTreeUtil.findExpressionChild((LighterAST)this.tree, (LighterASTNode)element);
            if (value == null) {
                this.hasErrors = true;
            } else {
                this.myReturnValue = ReturnValue.merge(this.myReturnValue, this.getExpressionValue(value));
            }
        } else if (type == JavaElementType.METHOD_CALL_EXPRESSION && "exit".equals(JavaLightTreeUtil.getNameIdentifierText((LighterAST)this.tree, (LighterASTNode)(reference = JavaLightTreeUtil.findExpressionChild((LighterAST)this.tree, (LighterASTNode)element)))) && "System".equals(JavaLightTreeUtil.getNameIdentifierText((LighterAST)this.tree, (LighterASTNode)(qualifier = JavaLightTreeUtil.findExpressionChild((LighterAST)this.tree, (LighterASTNode)reference)))) && JavaLightTreeUtil.findExpressionChild((LighterAST)this.tree, (LighterASTNode)qualifier) == null) {
            this.hasSystemExit = true;
        }
    }

    @NotNull
    private ReturnValue getExpressionValue(@Nullable LighterASTNode expr) {
        LighterASTNode target;
        String calledMethod;
        if ((expr = JavaLightTreeUtil.skipParenthesesCastsDown((LighterAST)this.tree, (LighterASTNode)expr)) == null) {
            ReturnValue returnValue = ReturnValue.UNKNOWN;
            if (returnValue == null) {
                MethodReturnInferenceVisitor.$$$reportNull$$$0(0);
            }
            return returnValue;
        }
        IElementType type = expr.getTokenType();
        if (JavaLightTreeUtil.isNullLiteralExpression((LighterAST)this.tree, (LighterASTNode)expr)) {
            ReturnValue returnValue = ReturnValue.NULLABLE;
            if (returnValue == null) {
                MethodReturnInferenceVisitor.$$$reportNull$$$0(1);
            }
            return returnValue;
        }
        if (type == JavaElementType.LAMBDA_EXPRESSION || type == JavaElementType.NEW_EXPRESSION || type == JavaElementType.METHOD_REF_EXPRESSION || type == JavaElementType.LITERAL_EXPRESSION || type == JavaElementType.BINARY_EXPRESSION || type == JavaElementType.POLYADIC_EXPRESSION) {
            ReturnValue returnValue = ReturnValue.NOT_NULL;
            if (returnValue == null) {
                MethodReturnInferenceVisitor.$$$reportNull$$$0(2);
            }
            return returnValue;
        }
        if (type == JavaElementType.METHOD_CALL_EXPRESSION && (calledMethod = JavaLightTreeUtil.getNameIdentifierText((LighterAST)this.tree, (LighterASTNode)((LighterASTNode)this.tree.getChildren(expr).get(0)))) != null) {
            ReturnValue returnValue = ReturnValue.delegate(calledMethod, ExpressionRange.create(expr, this.myBody.getStartOffset()));
            if (returnValue == null) {
                MethodReturnInferenceVisitor.$$$reportNull$$$0(3);
            }
            return returnValue;
        }
        if (type == JavaElementType.SWITCH_EXPRESSION) {
            return this.findValueInSwitchExpression(expr);
        }
        if (type == JavaElementType.CONDITIONAL_EXPRESSION) {
            List expressionChildren = JavaLightTreeUtil.getExpressionChildren((LighterAST)this.tree, (LighterASTNode)expr);
            if (expressionChildren.size() == 3) {
                ReturnValue returnValue = ReturnValue.merge(this.getExpressionValue((LighterASTNode)expressionChildren.get(1)), this.getExpressionValue((LighterASTNode)expressionChildren.get(2)));
                if (returnValue == null) {
                    MethodReturnInferenceVisitor.$$$reportNull$$$0(4);
                }
                return returnValue;
            }
        } else if (type == JavaElementType.REFERENCE_EXPRESSION && (target = new FileLocalResolver(this.tree).resolveLocally(expr).getTarget()) != null && (target.getTokenType() == JavaElementType.LOCAL_VARIABLE || target.getTokenType() == JavaElementType.PARAMETER)) {
            return this.findVariableValue(expr, target);
        }
        ReturnValue returnValue = ReturnValue.UNKNOWN;
        if (returnValue == null) {
            MethodReturnInferenceVisitor.$$$reportNull$$$0(5);
        }
        return returnValue;
    }

    @NotNull
    private ReturnValue findValueInSwitchExpression(@NotNull LighterASTNode expr) {
        if (expr == null) {
            MethodReturnInferenceVisitor.$$$reportNull$$$0(6);
        }
        if (expr.getTokenType() != JavaElementType.SWITCH_EXPRESSION) {
            ReturnValue returnValue = ReturnValue.UNKNOWN;
            if (returnValue == null) {
                MethodReturnInferenceVisitor.$$$reportNull$$$0(7);
            }
            return returnValue;
        }
        LighterASTNode block = LightTreeUtil.firstChildOfType((LighterAST)this.tree, (LighterASTNode)expr, (IElementType)JavaElementType.CODE_BLOCK);
        if (block == null) {
            ReturnValue returnValue = ReturnValue.UNKNOWN;
            if (returnValue == null) {
                MethodReturnInferenceVisitor.$$$reportNull$$$0(8);
            }
            return returnValue;
        }
        List rules = LightTreeUtil.getChildrenOfType((LighterAST)this.tree, (LighterASTNode)block, (IElementType)JavaElementType.SWITCH_LABELED_RULE);
        ArrayList<ReturnValue> values = new ArrayList<ReturnValue>();
        if (!rules.isEmpty()) {
            for (LighterASTNode rule : rules) {
                ReturnValue ruleReturnValue = this.findValueInRule(rule);
                if (ruleReturnValue == null) continue;
                values.add(ruleReturnValue);
            }
        } else {
            values.addAll(this.findValueInSwitchBlock(block));
        }
        ReturnValue returnValue = values.stream().reduce(ReturnValue::merge).orElse(ReturnValue.UNKNOWN);
        if (returnValue == null) {
            MethodReturnInferenceVisitor.$$$reportNull$$$0(9);
        }
        return returnValue;
    }

    @NotNull
    private List<ReturnValue> findValueInSwitchBlock(@NotNull LighterASTNode expr) {
        if (expr == null) {
            MethodReturnInferenceVisitor.$$$reportNull$$$0(10);
        }
        var visitor2 = new RecursiveLighterASTNodeWalkingVisitor(this.tree){
            private final List<ReturnValue> values;
            {
                this.values = new ArrayList<ReturnValue>();
            }

            public void visitNode(LighterASTNode element) {
                IElementType type = element.getTokenType();
                if (type == JavaElementType.YIELD_STATEMENT) {
                    this.values.add(MethodReturnInferenceVisitor.this.getExpressionValue(JavaLightTreeUtil.findExpressionChild((LighterAST)MethodReturnInferenceVisitor.this.tree, (LighterASTNode)element)));
                    return;
                }
                if (ElementType.JAVA_STATEMENT_BIT_SET.contains(type) || type == JavaElementType.CODE_BLOCK) {
                    super.visitNode(element);
                }
            }
        };
        visitor2.visitNode(expr);
        List<ReturnValue> list = visitor2.values;
        if (list == null) {
            MethodReturnInferenceVisitor.$$$reportNull$$$0(11);
        }
        return list;
    }

    @Nullable
    private ReturnValue findValueInRule(@NotNull LighterASTNode rule) {
        LighterASTNode body;
        if (rule == null) {
            MethodReturnInferenceVisitor.$$$reportNull$$$0(12);
        }
        if ((body = LightTreeUtil.firstChildOfType((LighterAST)this.tree, (LighterASTNode)rule, (TokenSet)PsiSwitchLabeledRuleStatementImpl.BODY_STATEMENTS)) == null) {
            return ReturnValue.UNKNOWN;
        }
        if (body.getTokenType() == JavaElementType.EXPRESSION_STATEMENT) {
            return this.getExpressionValue(JavaLightTreeUtil.findExpressionChild((LighterAST)this.tree, (LighterASTNode)body));
        }
        if (body.getTokenType() == JavaElementType.THROW_STATEMENT) {
            return null;
        }
        if (body.getTokenType() == JavaElementType.BLOCK_STATEMENT) {
            List<ReturnValue> values = this.findValueInSwitchBlock(body);
            return values.stream().reduce(ReturnValue::merge).orElse(ReturnValue.UNKNOWN);
        }
        return ReturnValue.UNKNOWN;
    }

    @NotNull
    private ReturnValue findVariableValue(LighterASTNode expr, LighterASTNode target) {
        LighterASTNode parent;
        while (true) {
            List operands;
            if ((parent = this.tree.getParent(expr)) == null) {
                ReturnValue returnValue = ReturnValue.UNKNOWN;
                if (returnValue == null) {
                    MethodReturnInferenceVisitor.$$$reportNull$$$0(13);
                }
                return returnValue;
            }
            IElementType type = parent.getTokenType();
            if (!ElementType.EXPRESSION_BIT_SET.contains(type)) break;
            if (type == JavaElementType.CONDITIONAL_EXPRESSION && (operands = JavaLightTreeUtil.getExpressionChildren((LighterAST)this.tree, (LighterASTNode)parent)).size() == 3) {
                LighterASTNode condition = (LighterASTNode)operands.get(0);
                if (expr.equals(operands.get(1)) && this.isNullCheck(condition, target, false) || expr.equals(operands.get(2)) && this.isNullCheck(condition, target, true)) {
                    ReturnValue returnValue = ReturnValue.NOT_NULL;
                    if (returnValue == null) {
                        MethodReturnInferenceVisitor.$$$reportNull$$$0(14);
                    }
                    return returnValue;
                }
            }
            expr = parent;
        }
        if (ElementType.JAVA_STATEMENT_BIT_SET.contains(parent.getTokenType())) {
            ReturnValue value = this.findValueBeforeStatement(parent, target);
            if (!this.myParameters.isEmpty()) {
                value = value.dropNullable();
            }
            ReturnValue returnValue = value;
            if (returnValue == null) {
                MethodReturnInferenceVisitor.$$$reportNull$$$0(15);
            }
            return returnValue;
        }
        ReturnValue returnValue = ReturnValue.UNKNOWN;
        if (returnValue == null) {
            MethodReturnInferenceVisitor.$$$reportNull$$$0(16);
        }
        return returnValue;
    }

    @NotNull
    private ReturnValue findValueBeforeStatement(LighterASTNode statement, LighterASTNode target) {
        LighterASTNode parent = this.tree.getParent(statement);
        if (parent == null) {
            ReturnValue returnValue = ReturnValue.UNKNOWN;
            if (returnValue == null) {
                MethodReturnInferenceVisitor.$$$reportNull$$$0(17);
            }
            return returnValue;
        }
        if (parent.getTokenType() == JavaElementType.CODE_BLOCK) {
            List children = this.tree.getChildren(parent);
            for (int i = children.lastIndexOf(statement) - 1; i >= 0; --i) {
                ReturnValue value;
                LighterASTNode child = (LighterASTNode)children.get(i);
                if (!ElementType.JAVA_STATEMENT_BIT_SET.contains(child.getTokenType()) || (value = this.findValueInStatement(child, target)) == null) continue;
                ReturnValue returnValue = value;
                if (returnValue == null) {
                    MethodReturnInferenceVisitor.$$$reportNull$$$0(18);
                }
                return returnValue;
            }
            LighterASTNode grandParent = this.tree.getParent(parent);
            if (grandParent == null || grandParent.getTokenType() != JavaElementType.BLOCK_STATEMENT) {
                ReturnValue returnValue = ReturnValue.UNKNOWN;
                if (returnValue == null) {
                    MethodReturnInferenceVisitor.$$$reportNull$$$0(19);
                }
                return returnValue;
            }
            return this.findValueBeforeStatement(grandParent, target);
        }
        if (parent.getTokenType() == JavaElementType.IF_STATEMENT) {
            LighterASTNode condition = JavaLightTreeUtil.findExpressionChild((LighterAST)this.tree, (LighterASTNode)parent);
            List branches = LightTreeUtil.getChildrenOfType((LighterAST)this.tree, (LighterASTNode)parent, (TokenSet)ElementType.JAVA_STATEMENT_BIT_SET);
            int index = branches.indexOf(statement);
            if (index == 0 && this.isNullCheck(condition, target, false) || index == 1 && this.isNullCheck(condition, target, true)) {
                ReturnValue returnValue = ReturnValue.NOT_NULL;
                if (returnValue == null) {
                    MethodReturnInferenceVisitor.$$$reportNull$$$0(20);
                }
                return returnValue;
            }
            ReturnValue value = this.findValueInExpression(condition, target);
            if (value != null) {
                ReturnValue returnValue = value;
                if (returnValue == null) {
                    MethodReturnInferenceVisitor.$$$reportNull$$$0(21);
                }
                return returnValue;
            }
            return this.findValueBeforeStatement(parent, target);
        }
        if (parent.getTokenType() == JavaElementType.WHILE_STATEMENT) {
            LighterASTNode condition = JavaLightTreeUtil.findExpressionChild((LighterAST)this.tree, (LighterASTNode)parent);
            if (this.isNullCheck(condition, target, false)) {
                ReturnValue returnValue = ReturnValue.NOT_NULL;
                if (returnValue == null) {
                    MethodReturnInferenceVisitor.$$$reportNull$$$0(22);
                }
                return returnValue;
            }
            ReturnValue returnValue = ReturnValue.UNKNOWN;
            if (returnValue == null) {
                MethodReturnInferenceVisitor.$$$reportNull$$$0(23);
            }
            return returnValue;
        }
        if (parent.getTokenType() == JavaElementType.SYNCHRONIZED_STATEMENT) {
            ReturnValue value = this.findValueInExpression(JavaLightTreeUtil.findExpressionChild((LighterAST)this.tree, (LighterASTNode)parent), target);
            if (value != null) {
                ReturnValue returnValue = value;
                if (returnValue == null) {
                    MethodReturnInferenceVisitor.$$$reportNull$$$0(24);
                }
                return returnValue;
            }
            return this.findValueBeforeStatement(parent, target);
        }
        ReturnValue returnValue = ReturnValue.UNKNOWN;
        if (returnValue == null) {
            MethodReturnInferenceVisitor.$$$reportNull$$$0(25);
        }
        return returnValue;
    }

    @Nullable
    private ReturnValue findValueInStatement(LighterASTNode statement, LighterASTNode target) {
        ReturnValue value;
        if (statement == null) {
            return null;
        }
        IElementType tokenType = statement.getTokenType();
        if (tokenType == JavaElementType.EXPRESSION_STATEMENT) {
            LighterASTNode expression = JavaLightTreeUtil.findExpressionChild((LighterAST)this.tree, (LighterASTNode)statement);
            return this.findValueInExpression(expression, target);
        }
        if (tokenType == JavaElementType.DECLARATION_STATEMENT) {
            List declaredElements = this.tree.getChildren(statement);
            for (LighterASTNode declared : declaredElements.reversed()) {
                if (declared.getTokenType() != JavaElementType.LOCAL_VARIABLE) continue;
                LighterASTNode initializer = JavaLightTreeUtil.findExpressionChild((LighterAST)this.tree, (LighterASTNode)declared);
                if (declared.equals((Object)target)) {
                    return this.getExpressionValue(initializer);
                }
                ReturnValue value2 = this.findValueInExpression(initializer, target);
                if (value2 == null) continue;
                return value2;
            }
        }
        if (tokenType == JavaElementType.BLOCK_STATEMENT) {
            LighterASTNode block = LightTreeUtil.firstChildOfType((LighterAST)this.tree, (LighterASTNode)statement, (IElementType)JavaElementType.CODE_BLOCK);
            if (block != null) {
                List children = LightTreeUtil.getChildrenOfType((LighterAST)this.tree, (LighterASTNode)block, (TokenSet)ElementType.JAVA_STATEMENT_BIT_SET);
                return StreamEx.ofReversed((List)children).map(node -> this.findValueInStatement((LighterASTNode)node, target)).nonNull().findFirst().orElse(null);
            }
            return null;
        }
        if (tokenType == JavaElementType.IF_STATEMENT && (value = this.findValueInIfStatement(statement, target)) != null) {
            return value;
        }
        if (this.isAssignedInside(statement, target)) {
            return ReturnValue.UNKNOWN;
        }
        return null;
    }

    @Nullable
    private ReturnValue findValueInIfStatement(LighterASTNode statement, LighterASTNode target) {
        List branches = LightTreeUtil.getChildrenOfType((LighterAST)this.tree, (LighterASTNode)statement, (TokenSet)ElementType.JAVA_STATEMENT_BIT_SET);
        LighterASTNode condition = JavaLightTreeUtil.findExpressionChild((LighterAST)this.tree, (LighterASTNode)statement);
        LighterASTNode thenBranch = (LighterASTNode)ContainerUtil.getFirstItem((List)branches);
        LighterASTNode elseBranch = branches.size() == 2 ? (LighterASTNode)branches.get(1) : null;
        boolean thenBreaks = this.completesAbruptly(thenBranch);
        boolean elseBreaks = this.completesAbruptly(elseBranch);
        ReturnValue thenValue = this.findValueInStatement(thenBranch, target);
        ReturnValue elseValue = this.findValueInStatement(elseBranch, target);
        if (elseValue == null && thenBreaks && !elseBreaks && this.isNullCheck(condition, target, true)) {
            elseValue = ReturnValue.NOT_NULL;
        }
        if (thenValue == null && elseBreaks && !thenBreaks && this.isNullCheck(condition, target, false)) {
            thenValue = ReturnValue.NOT_NULL;
        }
        if (thenBreaks && !elseBreaks) {
            thenValue = elseValue;
        }
        if (elseBreaks && !thenBreaks) {
            elseValue = thenValue;
        }
        if (thenValue == null) {
            ReturnValue returnValue = thenValue = this.isNullCheck(condition, target, false) ? ReturnValue.NOT_NULL : this.findValueInExpression(condition, target);
        }
        if (elseValue == null) {
            ReturnValue returnValue = elseValue = this.isNullCheck(condition, target, true) ? ReturnValue.NOT_NULL : this.findValueInExpression(condition, target);
        }
        if (thenValue == null || elseValue == null) {
            return null;
        }
        return ReturnValue.merge(thenValue, elseValue);
    }

    @Nullable
    private ReturnValue findValueInExpression(LighterASTNode expression, LighterASTNode target) {
        List children;
        if (expression == null) {
            return null;
        }
        IElementType type = expression.getTokenType();
        if (type == JavaElementType.ASSIGNMENT_EXPRESSION && (children = JavaLightTreeUtil.getExpressionChildren((LighterAST)this.tree, (LighterASTNode)expression)).size() == 2 && this.isReferenceToLocal((LighterASTNode)children.get(0), target)) {
            if (LightTreeUtil.firstChildOfType((LighterAST)this.tree, (LighterASTNode)expression, (IElementType)JavaTokenType.EQ) == null) {
                return ReturnValue.NOT_NULL;
            }
            return this.getExpressionValue((LighterASTNode)children.get(1));
        }
        if (this.isAssignedInside(expression, target)) {
            return ReturnValue.UNKNOWN;
        }
        if (this.isDereferencedInside(expression, target)) {
            return ReturnValue.NOT_NULL;
        }
        return null;
    }

    private boolean completesAbruptly(LighterASTNode statement) {
        LighterASTNode block;
        if (statement == null) {
            return false;
        }
        if (statement.getTokenType() == JavaElementType.BLOCK_STATEMENT && (block = LightTreeUtil.firstChildOfType((LighterAST)this.tree, (LighterASTNode)statement, (IElementType)JavaElementType.CODE_BLOCK)) != null) {
            LighterASTNode lastStatement = (LighterASTNode)ContainerUtil.getLastItem((List)LightTreeUtil.getChildrenOfType((LighterAST)this.tree, (LighterASTNode)block, (TokenSet)ElementType.JAVA_STATEMENT_BIT_SET));
            return lastStatement != null && this.completesAbruptly(lastStatement);
        }
        return statement.getTokenType() == JavaElementType.BREAK_STATEMENT || statement.getTokenType() == JavaElementType.CONTINUE_STATEMENT || statement.getTokenType() == JavaElementType.RETURN_STATEMENT || statement.getTokenType() == JavaElementType.THROW_STATEMENT;
    }

    private boolean isAssignedInside(LighterASTNode element, LighterASTNode target) {
        ArrayDeque<LighterASTNode> workList = new ArrayDeque<LighterASTNode>();
        workList.add(element);
        while (!workList.isEmpty()) {
            IElementType tokenType;
            LighterASTNode parent;
            LighterASTNode node = (LighterASTNode)workList.poll();
            if (this.isReferenceToLocal(node, target) && (parent = this.tree.getParent(node)) != null) {
                IElementType type = parent.getTokenType();
                if (type == JavaElementType.ASSIGNMENT_EXPRESSION && node.equals((Object)JavaLightTreeUtil.findExpressionChild((LighterAST)this.tree, (LighterASTNode)parent))) {
                    return true;
                }
                if (type == JavaElementType.POSTFIX_EXPRESSION || type == JavaElementType.PREFIX_EXPRESSION) {
                    return true;
                }
            }
            if ((tokenType = node.getTokenType()) == JavaElementType.LAMBDA_EXPRESSION || tokenType == JavaElementType.TYPE_PARAMETER_LIST || tokenType == JavaElementType.ANONYMOUS_CLASS) continue;
            workList.addAll(this.tree.getChildren(node));
        }
        return false;
    }

    private boolean isDereferencedInside(LighterASTNode expression, LighterASTNode target) {
        ArrayDeque<LighterASTNode> workList = new ArrayDeque<LighterASTNode>();
        workList.add(expression);
        while (!workList.isEmpty()) {
            IElementType type;
            LighterASTNode parent;
            LighterASTNode node = (LighterASTNode)workList.poll();
            if (this.isReferenceToLocal(node, target) && (parent = this.tree.getParent(node)) != null && ((type = parent.getTokenType()) == JavaElementType.REFERENCE_EXPRESSION || type == JavaElementType.ARRAY_ACCESS_EXPRESSION)) {
                return true;
            }
            IElementType tokenType = node.getTokenType();
            if (tokenType == JavaElementType.CONDITIONAL_EXPRESSION || tokenType == JavaElementType.SWITCH_EXPRESSION || (tokenType == JavaElementType.POLYADIC_EXPRESSION || tokenType == JavaElementType.BINARY_EXPRESSION) && LightTreeUtil.firstChildOfType((LighterAST)this.tree, (LighterASTNode)node, (TokenSet)SHORT_CIRCUIT) != null) {
                ContainerUtil.addIfNotNull(workList, (Object)JavaLightTreeUtil.findExpressionChild((LighterAST)this.tree, (LighterASTNode)node));
                continue;
            }
            if (tokenType == JavaElementType.LAMBDA_EXPRESSION || tokenType == JavaElementType.TYPE_PARAMETER_LIST || tokenType == JavaElementType.ANONYMOUS_CLASS) continue;
            workList.addAll(this.tree.getChildren(node));
        }
        return false;
    }

    private boolean isNullCheck(@Nullable LighterASTNode expr, LighterASTNode var, boolean negated) {
        if ((expr = JavaLightTreeUtil.skipParenthesesCastsDown((LighterAST)this.tree, (LighterASTNode)expr)) == null || this.isAssignedInside(expr, var)) {
            return false;
        }
        IElementType type = expr.getTokenType();
        if (type == JavaElementType.BINARY_EXPRESSION || type == JavaElementType.POLYADIC_EXPRESSION) {
            List operands = JavaLightTreeUtil.getExpressionChildren((LighterAST)this.tree, (LighterASTNode)expr);
            if (LightTreeUtil.firstChildOfType((LighterAST)this.tree, (LighterASTNode)expr, (IElementType)(negated ? JavaTokenType.EQEQ : JavaTokenType.NE)) != null) {
                return operands.size() == 2 && JavaLightTreeUtil.isNullLiteralExpression((LighterAST)this.tree, (LighterASTNode)((LighterASTNode)operands.get(1))) && this.isReferenceToLocal((LighterASTNode)operands.get(0), var);
            }
            if (LightTreeUtil.firstChildOfType((LighterAST)this.tree, (LighterASTNode)expr, (IElementType)(negated ? JavaTokenType.OROR : JavaTokenType.ANDAND)) == null) {
                return false;
            }
            for (LighterASTNode t : operands) {
                if (!this.isNullCheck(t, var, negated)) continue;
                return true;
            }
            return false;
        }
        if (type == JavaElementType.PREFIX_EXPRESSION && LightTreeUtil.firstChildOfType((LighterAST)this.tree, (LighterASTNode)expr, (IElementType)JavaTokenType.EXCL) != null) {
            return this.isNullCheck(JavaLightTreeUtil.findExpressionChild((LighterAST)this.tree, (LighterASTNode)expr), var, !negated);
        }
        return !negated && type == JavaElementType.INSTANCE_OF_EXPRESSION && this.isReferenceToLocal(JavaLightTreeUtil.findExpressionChild((LighterAST)this.tree, (LighterASTNode)expr), var);
    }

    private boolean isReferenceToLocal(@Nullable LighterASTNode operand, @NotNull LighterASTNode var) {
        if (var == null) {
            MethodReturnInferenceVisitor.$$$reportNull$$$0(26);
        }
        return operand != null && operand.getTokenType() == JavaElementType.REFERENCE_EXPRESSION && Objects.requireNonNull(this.tree.getParent(operand)).getTokenType() != JavaElementType.METHOD_CALL_EXPRESSION && JavaLightTreeUtil.findExpressionChild((LighterAST)this.tree, (LighterASTNode)operand) == null && Objects.equals(JavaLightTreeUtil.getNameIdentifierText((LighterAST)this.tree, (LighterASTNode)operand), JavaLightTreeUtil.getNameIdentifierText((LighterAST)this.tree, (LighterASTNode)var));
    }

    @Nullable
    MethodReturnInferenceResult getResult() {
        List<ExpressionRange> delegateCalls = this.myReturnValue.myCalledMethod == null ? null : this.myReturnValue.myRanges;
        boolean hasNulls = this.myReturnValue.myNullability.contains(Nullability.NULLABLE);
        boolean hasNotNulls = this.myReturnValue.myNullability.contains(Nullability.NOT_NULL);
        boolean hasUnknowns = this.myReturnValue.myNullability.contains(Nullability.UNKNOWN);
        if (hasNulls) {
            if (this.hasSystemExit) {
                return new MethodReturnInferenceResult.Predefined(Nullability.UNKNOWN);
            }
            return delegateCalls == null || hasNotNulls || this.hasErrors || hasUnknowns ? new MethodReturnInferenceResult.Predefined(Nullability.NULLABLE) : new MethodReturnInferenceResult.FromDelegate(Nullability.NULLABLE, delegateCalls);
        }
        if (this.hasErrors || hasUnknowns) {
            return null;
        }
        if (delegateCalls != null) {
            return new MethodReturnInferenceResult.FromDelegate(hasNotNulls ? Nullability.NOT_NULL : Nullability.UNKNOWN, delegateCalls);
        }
        if (hasNotNulls) {
            return new MethodReturnInferenceResult.Predefined(Nullability.NOT_NULL);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 6, 10, 12, 26 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/inference/MethodReturnInferenceVisitor";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rule";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "var";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpressionValue";
                break;
            }
            case 6: 
            case 10: 
            case 12: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/inference/MethodReturnInferenceVisitor";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "findValueInSwitchExpression";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "findValueInSwitchBlock";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "findVariableValue";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "findValueBeforeStatement";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findValueInSwitchExpression";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findValueInSwitchBlock";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findValueInRule";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceToLocal";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 6, 10, 12, 26 -> new IllegalArgumentException(string);
        };
    }

    private static final class ReturnValue {
        static final ReturnValue TOP = new ReturnValue(EnumSet.noneOf(Nullability.class), null, Collections.emptyList());
        static final ReturnValue UNKNOWN = new ReturnValue(EnumSet.of(Nullability.UNKNOWN), null, Collections.emptyList());
        static final ReturnValue NULLABLE = new ReturnValue(EnumSet.of(Nullability.NULLABLE), null, Collections.emptyList());
        static final ReturnValue NOT_NULL = new ReturnValue(EnumSet.of(Nullability.NOT_NULL), null, Collections.emptyList());
        @NotNull
        final EnumSet<Nullability> myNullability;
        @Nullable
        final String myCalledMethod;
        @NotNull
        final List<ExpressionRange> myRanges;

        private ReturnValue(@NotNull EnumSet<Nullability> nullability, @Nullable String method, @NotNull List<ExpressionRange> ranges) {
            if (nullability == null) {
                ReturnValue.$$$reportNull$$$0(0);
            }
            if (ranges == null) {
                ReturnValue.$$$reportNull$$$0(1);
            }
            this.myNullability = nullability;
            this.myCalledMethod = method;
            this.myRanges = ranges;
        }

        public ReturnValue dropNullable() {
            if (!this.myNullability.contains(Nullability.NULLABLE)) {
                return this;
            }
            EnumSet<Nullability> copy = EnumSet.copyOf(this.myNullability);
            copy.remove(Nullability.NULLABLE);
            copy.add(Nullability.UNKNOWN);
            return new ReturnValue(copy, this.myCalledMethod, this.myRanges);
        }

        static ReturnValue delegate(@NotNull String method, @NotNull ExpressionRange range) {
            if (method == null) {
                ReturnValue.$$$reportNull$$$0(2);
            }
            if (range == null) {
                ReturnValue.$$$reportNull$$$0(3);
            }
            return new ReturnValue(EnumSet.noneOf(Nullability.class), method, Collections.singletonList(range));
        }

        static ReturnValue merge(@NotNull ReturnValue left, @NotNull ReturnValue right) {
            List range;
            String calledMethod;
            if (left == null) {
                ReturnValue.$$$reportNull$$$0(4);
            }
            if (right == null) {
                ReturnValue.$$$reportNull$$$0(5);
            }
            EnumSet<Nullability> nullability = EnumSet.copyOf(left.myNullability);
            nullability.addAll(right.myNullability);
            if (left.myCalledMethod == null) {
                calledMethod = right.myCalledMethod;
                range = right.myRanges;
            } else if (right.myCalledMethod == null) {
                calledMethod = left.myCalledMethod;
                range = left.myRanges;
            } else if (left.myCalledMethod.equals(right.myCalledMethod)) {
                calledMethod = left.myCalledMethod;
                range = ContainerUtil.concat(left.myRanges, right.myRanges);
            } else {
                calledMethod = "";
                range = Collections.emptyList();
                nullability.add(Nullability.UNKNOWN);
            }
            return new ReturnValue(nullability, calledMethod, range);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "nullability";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ranges";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "method";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "range";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "left";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "right";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInspection/dataFlow/inference/MethodReturnInferenceVisitor$ReturnValue";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "delegate";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "merge";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

