/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.inference;

import com.intellij.codeInsight.ExpressionUtil;
import com.intellij.codeInspection.dataFlow.MutationSignature;
import com.intellij.codeInspection.dataFlow.inference.CannotRestoreExpressionException;
import com.intellij.codeInspection.dataFlow.inference.ExpressionRange;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u001c\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015J\u001e\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0002J\u001e\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0002J\u001a\u0010\u001a\u001a\u00020\u00032\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u0013H\u0002J\u0018\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020 H\u0002J\u000e\u0010!\u001a\u00020\u0003H\u00c0\u0003\u00a2\u0006\u0002\b\"J\u0014\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c0\u0003\u00a2\u0006\u0002\b$J\u0010\u0010%\u001a\u0004\u0018\u00010\u0006H\u00c0\u0003\u00a2\u0006\u0002\b&J/\u0010'\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0006H\u00c6\u0001J\u0014\u0010(\u001a\u00020\u00032\b\u0010)\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010*\u001a\u00020+H\u00d6\u0081\u0004J\n\u0010,\u001a\u00020-H\u00d6\u0081\u0004R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0016\u0010\u0007\u001a\u0004\u0018\u00010\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006."}, d2={"Lcom/intellij/codeInspection/dataFlow/inference/PurityInferenceResult;", "", "mutatesThis", "", "mutatedRefs", "", "Lcom/intellij/codeInspection/dataFlow/inference/ExpressionRange;", "singleCall", "<init>", "(ZLjava/util/List;Lcom/intellij/codeInspection/dataFlow/inference/ExpressionRange;)V", "getMutatesThis$intellij_java_analysis_impl", "()Z", "getMutatedRefs$intellij_java_analysis_impl", "()Ljava/util/List;", "getSingleCall$intellij_java_analysis_impl", "()Lcom/intellij/codeInspection/dataFlow/inference/ExpressionRange;", "getMutationSignature", "Lcom/intellij/codeInspection/dataFlow/MutationSignature;", "method", "Lcom/intellij/psi/PsiMethod;", "body", "Lkotlin/Function0;", "Lcom/intellij/psi/PsiCodeBlock;", "mutatesNonLocals", "fromCalls", "currentMethod", "isLocalVarReference", "expression", "Lcom/intellij/psi/PsiExpression;", "scope", "isLocallyCreatedArray", "target", "Lcom/intellij/psi/PsiLocalVariable;", "component1", "component1$intellij_java_analysis_impl", "component2", "component2$intellij_java_analysis_impl", "component3", "component3$intellij_java_analysis_impl", "copy", "equals", "other", "hashCode", "", "toString", "", "intellij.java.analysis.impl"})
@SourceDebugExtension(value={"SMAP\ninferenceResults.kt\nKotlin\n*S Kotlin\n*F\n+ 1 inferenceResults.kt\ncom/intellij/codeInspection/dataFlow/inference/PurityInferenceResult\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 inferenceResults.kt\ncom/intellij/codeInspection/dataFlow/inference/ExpressionRange\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,203:1\n1807#2,2:204\n1809#2:214\n42#3,8:206\n42#3,8:215\n1#4:223\n*S KotlinDebug\n*F\n+ 1 inferenceResults.kt\ncom/intellij/codeInspection/dataFlow/inference/PurityInferenceResult\n*L\n66#1:204,2\n66#1:214\n66#1:206,8\n72#1:215,8\n*E\n"})
public final class PurityInferenceResult {
    private final boolean mutatesThis;
    @NotNull
    private final List<ExpressionRange> mutatedRefs;
    @Nullable
    private final ExpressionRange singleCall;

    public PurityInferenceResult(boolean mutatesThis, @NotNull List<ExpressionRange> mutatedRefs, @Nullable ExpressionRange singleCall) {
        Intrinsics.checkNotNullParameter(mutatedRefs, (String)"mutatedRefs");
        this.mutatesThis = mutatesThis;
        this.mutatedRefs = mutatedRefs;
        this.singleCall = singleCall;
    }

    public final boolean getMutatesThis$intellij_java_analysis_impl() {
        return this.mutatesThis;
    }

    @NotNull
    public final List<ExpressionRange> getMutatedRefs$intellij_java_analysis_impl() {
        return this.mutatedRefs;
    }

    @Nullable
    public final ExpressionRange getSingleCall$intellij_java_analysis_impl() {
        return this.singleCall;
    }

    @NotNull
    public final MutationSignature getMutationSignature(@NotNull PsiMethod method, @NotNull Function0<? extends PsiCodeBlock> body) {
        MutationSignature mutationSignature;
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter(body, (String)"body");
        if (this.mutatesNonLocals(method, body)) {
            MutationSignature mutationSignature2 = MutationSignature.unknown();
            mutationSignature = mutationSignature2;
            Intrinsics.checkNotNullExpressionValue((Object)mutationSignature2, (String)"unknown(...)");
        } else if (this.mutatesThis) {
            MutationSignature mutationSignature3 = this.fromCalls(method, body).alsoMutatesThis();
            mutationSignature = mutationSignature3;
            Intrinsics.checkNotNullExpressionValue((Object)mutationSignature3, (String)"alsoMutatesThis(...)");
        } else {
            mutationSignature = this.fromCalls(method, body);
        }
        return mutationSignature;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean mutatesNonLocals(PsiMethod method, Function0<? extends PsiCodeBlock> body) {
        boolean bl;
        block4: {
            Iterable $this$any$iv = this.mutatedRefs;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    void this_$iv;
                    ExpressionRange range = (ExpressionRange)element$iv;
                    boolean bl2 = false;
                    ExpressionRange expressionRange = range;
                    PsiCodeBlock scope$iv = (PsiCodeBlock)body.invoke();
                    boolean $i$f$restoreExpression = false;
                    int scopeStart$iv = scope$iv.getTextRange().getStartOffset();
                    PsiExpression element$iv2 = (PsiExpression)PsiTreeUtil.findElementOfClassAtRange((PsiFile)scope$iv.getContainingFile(), (int)(this_$iv.getStartOffset() + scopeStart$iv), (int)(this_$iv.getEndOffset() + scopeStart$iv), PsiExpression.class);
                    if (element$iv2 == null) {
                        throw new CannotRestoreExpressionException("No expression of type " + Reflection.getOrCreateKotlinClass(PsiExpression.class) + " found");
                    }
                    if (!(!this.isLocalVarReference(element$iv2, method))) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final MutationSignature fromCalls(PsiMethod currentMethod, Function0<? extends PsiCodeBlock> body) {
        void this_$iv;
        if (this.singleCall == null) {
            MutationSignature mutationSignature = MutationSignature.transparent();
            Intrinsics.checkNotNullExpressionValue((Object)mutationSignature, (String)"transparent(...)");
            return mutationSignature;
        }
        ExpressionRange expressionRange = this.singleCall;
        PsiCodeBlock scope$iv = (PsiCodeBlock)body.invoke();
        boolean $i$f$restoreExpression = false;
        int scopeStart$iv = scope$iv.getTextRange().getStartOffset();
        PsiExpression element$iv = (PsiExpression)PsiTreeUtil.findElementOfClassAtRange((PsiFile)scope$iv.getContainingFile(), (int)(this_$iv.getStartOffset() + scopeStart$iv), (int)(this_$iv.getEndOffset() + scopeStart$iv), PsiCallExpression.class);
        if (element$iv == null) {
            throw new CannotRestoreExpressionException("No expression of type " + Reflection.getOrCreateKotlinClass(PsiCallExpression.class) + " found");
        }
        PsiCallExpression psiCall = (PsiCallExpression)element$iv;
        PsiMethod method = psiCall.resolveMethod();
        if (Intrinsics.areEqual((Object)method, (Object)currentMethod)) {
            if (!this.mutatesThis || psiCall instanceof PsiMethodCallExpression && ExpressionUtil.isEffectivelyUnqualified((PsiReferenceExpression)((PsiMethodCallExpression)psiCall).getMethodExpression())) {
                MutationSignature mutationSignature = MutationSignature.pure();
                Intrinsics.checkNotNullExpressionValue((Object)mutationSignature, (String)"pure(...)");
                return mutationSignature;
            }
            MutationSignature mutationSignature = MutationSignature.unknown();
            Intrinsics.checkNotNullExpressionValue((Object)mutationSignature, (String)"unknown(...)");
            return mutationSignature;
        }
        MutationSignature mutationSignature = MutationSignature.fromCall((PsiCall)psiCall);
        Intrinsics.checkNotNullExpressionValue((Object)mutationSignature, (String)"fromCall(...)");
        MutationSignature signature = mutationSignature;
        if (signature.isPure() || Intrinsics.areEqual((Object)signature, (Object)MutationSignature.pure().alsoMutatesThis()) && psiCall instanceof PsiMethodCallExpression && ExpressionUtil.isEffectivelyUnqualified((PsiReferenceExpression)((PsiMethodCallExpression)psiCall).getMethodExpression())) {
            MutationSignature mutationSignature2;
            if (currentMethod.isConstructor()) {
                MutationSignature mutationSignature3 = MutationSignature.pure();
                mutationSignature2 = mutationSignature3;
                Intrinsics.checkNotNullExpressionValue((Object)mutationSignature3, (String)"pure(...)");
            } else {
                mutationSignature2 = signature;
            }
            return mutationSignature2;
        }
        MutationSignature mutationSignature4 = MutationSignature.unknown();
        Intrinsics.checkNotNullExpressionValue((Object)mutationSignature4, (String)"unknown(...)");
        return mutationSignature4;
    }

    private final boolean isLocalVarReference(PsiExpression expression, PsiMethod scope) {
        boolean bl;
        PsiExpression psiExpression = expression;
        if (psiExpression instanceof PsiReferenceExpression) {
            PsiElement it = ((PsiReferenceExpression)expression).resolve();
            boolean bl2 = false;
            bl = it instanceof PsiLocalVariable || it instanceof PsiParameter;
        } else if (psiExpression instanceof PsiArrayAccessExpression) {
            PsiExpression it = ((PsiArrayAccessExpression)expression).getArrayExpression();
            PsiReferenceExpression psiReferenceExpression = it instanceof PsiReferenceExpression ? (PsiReferenceExpression)it : null;
            PsiElement target = psiReferenceExpression != null ? psiReferenceExpression.resolve() : null;
            boolean bl3 = false;
            bl = target instanceof PsiLocalVariable && this.isLocallyCreatedArray(scope, (PsiLocalVariable)target);
        } else {
            bl = false;
        }
        return bl;
    }

    private final boolean isLocallyCreatedArray(PsiMethod scope, PsiLocalVariable target) {
        PsiExpression initializer = target.getInitializer();
        if (initializer != null && !(initializer instanceof PsiNewExpression)) {
            return false;
        }
        for (PsiReference ref : ReferencesSearch.search((PsiElement)((PsiElement)target), (SearchScope)((SearchScope)new LocalSearchScope((PsiElement)scope))).findAll()) {
            PsiAssignmentExpression assign;
            if (!(ref instanceof PsiReferenceExpression) || !PsiUtil.isAccessedForWriting((PsiExpression)((PsiExpression)ref)) || (assign = (PsiAssignmentExpression)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)ref), PsiAssignmentExpression.class)) != null && assign.getRExpression() instanceof PsiNewExpression) continue;
            return false;
        }
        return true;
    }

    public final boolean component1$intellij_java_analysis_impl() {
        return this.mutatesThis;
    }

    @NotNull
    public final List<ExpressionRange> component2$intellij_java_analysis_impl() {
        return this.mutatedRefs;
    }

    @Nullable
    public final ExpressionRange component3$intellij_java_analysis_impl() {
        return this.singleCall;
    }

    @NotNull
    public final PurityInferenceResult copy(boolean mutatesThis, @NotNull List<ExpressionRange> mutatedRefs, @Nullable ExpressionRange singleCall) {
        Intrinsics.checkNotNullParameter(mutatedRefs, (String)"mutatedRefs");
        return new PurityInferenceResult(mutatesThis, mutatedRefs, singleCall);
    }

    public static /* synthetic */ PurityInferenceResult copy$default(PurityInferenceResult purityInferenceResult, boolean bl, List list, ExpressionRange expressionRange, int n, Object object) {
        if ((n & 1) != 0) {
            bl = purityInferenceResult.mutatesThis;
        }
        if ((n & 2) != 0) {
            list = purityInferenceResult.mutatedRefs;
        }
        if ((n & 4) != 0) {
            expressionRange = purityInferenceResult.singleCall;
        }
        return purityInferenceResult.copy(bl, list, expressionRange);
    }

    @NotNull
    public String toString() {
        return "PurityInferenceResult(mutatesThis=" + this.mutatesThis + ", mutatedRefs=" + this.mutatedRefs + ", singleCall=" + this.singleCall + ")";
    }

    public int hashCode() {
        int result = Boolean.hashCode(this.mutatesThis);
        result = result * 31 + ((Object)this.mutatedRefs).hashCode();
        result = result * 31 + (this.singleCall == null ? 0 : this.singleCall.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PurityInferenceResult)) {
            return false;
        }
        PurityInferenceResult purityInferenceResult = (PurityInferenceResult)other;
        if (this.mutatesThis != purityInferenceResult.mutatesThis) {
            return false;
        }
        if (!Intrinsics.areEqual(this.mutatedRefs, purityInferenceResult.mutatedRefs)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.singleCall, (Object)purityInferenceResult.singleCall);
    }
}

