/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.java;

import com.intellij.codeInsight.Nullability;
import com.intellij.codeInspection.dataFlow.DfaPsiUtil;
import com.intellij.codeInspection.dataFlow.NullabilityProblemKind;
import com.intellij.codeInspection.dataFlow.java.ControlFlowAnalyzer;
import com.intellij.codeInspection.dataFlow.java.JavaDfaValueFactory;
import com.intellij.codeInspection.dataFlow.java.anchor.JavaExpressionAnchor;
import com.intellij.codeInspection.dataFlow.java.anchor.JavaMethodReferenceArgumentAnchor;
import com.intellij.codeInspection.dataFlow.java.anchor.JavaMethodReferenceReturnAnchor;
import com.intellij.codeInspection.dataFlow.java.inst.AssignInstruction;
import com.intellij.codeInspection.dataFlow.java.inst.BooleanBinaryInstruction;
import com.intellij.codeInspection.dataFlow.java.inst.InstanceofInstruction;
import com.intellij.codeInspection.dataFlow.java.inst.IsAssignableInstruction;
import com.intellij.codeInspection.dataFlow.java.inst.JvmPushForWriteInstruction;
import com.intellij.codeInspection.dataFlow.java.inst.NotInstruction;
import com.intellij.codeInspection.dataFlow.java.inst.NumericBinaryInstruction;
import com.intellij.codeInspection.dataFlow.jvm.descriptors.PlainDescriptor;
import com.intellij.codeInspection.dataFlow.jvm.transfer.TryCatchAllTrap;
import com.intellij.codeInspection.dataFlow.lang.DfaAnchor;
import com.intellij.codeInspection.dataFlow.lang.UnsatisfiedConditionProblem;
import com.intellij.codeInspection.dataFlow.lang.ir.ConditionalGotoInstruction;
import com.intellij.codeInspection.dataFlow.lang.ir.ControlFlow;
import com.intellij.codeInspection.dataFlow.lang.ir.DupInstruction;
import com.intellij.codeInspection.dataFlow.lang.ir.EnsureInstruction;
import com.intellij.codeInspection.dataFlow.lang.ir.FlushFieldsInstruction;
import com.intellij.codeInspection.dataFlow.lang.ir.FlushVariableInstruction;
import com.intellij.codeInspection.dataFlow.lang.ir.GetQualifiedValueInstruction;
import com.intellij.codeInspection.dataFlow.lang.ir.GotoInstruction;
import com.intellij.codeInspection.dataFlow.lang.ir.Instruction;
import com.intellij.codeInspection.dataFlow.lang.ir.PopInstruction;
import com.intellij.codeInspection.dataFlow.lang.ir.PushInstruction;
import com.intellij.codeInspection.dataFlow.lang.ir.PushValueInstruction;
import com.intellij.codeInspection.dataFlow.lang.ir.ResultOfInstruction;
import com.intellij.codeInspection.dataFlow.lang.ir.SimpleAssignmentInstruction;
import com.intellij.codeInspection.dataFlow.lang.ir.SpliceInstruction;
import com.intellij.codeInspection.dataFlow.lang.ir.SwapInstruction;
import com.intellij.codeInspection.dataFlow.lang.ir.WrapDerivedVariableInstruction;
import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeBinOp;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.types.DfTypes;
import com.intellij.codeInspection.dataFlow.value.DerivedVariableDescriptor;
import com.intellij.codeInspection.dataFlow.value.DfaControlTransferValue;
import com.intellij.codeInspection.dataFlow.value.DfaTypeValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.codeInspection.dataFlow.value.RelationType;
import com.intellij.codeInspection.dataFlow.value.VariableDescriptor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiMethodReferenceUtil;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import one.util.streamex.IntStreamEx;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CFGBuilder {
    private static final CallMatcher PREDICATE_NOT = CallMatcher.staticCall("java.util.function.Predicate", "not").parameterTypes("java.util.function.Predicate");
    private final ControlFlowAnalyzer myAnalyzer;
    private final Deque<Runnable> myBranches = new ArrayDeque<Runnable>();
    private final Map<PsiExpression, DfaVariableValue> myMethodRefQualifiers = new HashMap<PsiExpression, DfaVariableValue>();

    CFGBuilder(ControlFlowAnalyzer analyzer) {
        this.myAnalyzer = analyzer;
    }

    @Contract(value="_ -> this")
    private CFGBuilder add(Instruction instruction) {
        this.myAnalyzer.addInstruction(instruction);
        return this;
    }

    public CFGBuilder pushUnknown() {
        this.myAnalyzer.pushUnknown();
        return this;
    }

    public CFGBuilder pushNull() {
        return this.push(DfTypes.NULL);
    }

    public CFGBuilder pushExpression(@NotNull PsiExpression expression) {
        if (expression == null) {
            CFGBuilder.$$$reportNull$$$0(0);
        }
        expression.accept((PsiElementVisitor)this.myAnalyzer);
        return this;
    }

    public CFGBuilder pushExpression(@NotNull PsiExpression expression, @Nullable NullabilityProblemKind<? super PsiExpression> kind) {
        if (expression == null) {
            CFGBuilder.$$$reportNull$$$0(1);
        }
        if (kind == null) {
            return this.pushExpression(expression);
        }
        this.myAnalyzer.addCustomNullabilityProblem(expression, kind);
        expression.accept((PsiElementVisitor)this.myAnalyzer);
        this.myAnalyzer.removeCustomNullabilityProblem(expression);
        return this;
    }

    @Contract(value="_ -> this")
    @NotNull
    public CFGBuilder unwrap(@NotNull DerivedVariableDescriptor descriptor) {
        if (descriptor == null) {
            CFGBuilder.$$$reportNull$$$0(2);
        }
        CFGBuilder cFGBuilder = this.add((Instruction)new GetQualifiedValueInstruction((VariableDescriptor)descriptor));
        if (cFGBuilder == null) {
            CFGBuilder.$$$reportNull$$$0(3);
        }
        return cFGBuilder;
    }

    public CFGBuilder wrap(@NotNull DfType targetType, @NotNull DerivedVariableDescriptor descriptor) {
        if (targetType == null) {
            CFGBuilder.$$$reportNull$$$0(4);
        }
        if (descriptor == null) {
            CFGBuilder.$$$reportNull$$$0(5);
        }
        return this.add((Instruction)new WrapDerivedVariableInstruction(targetType, descriptor));
    }

    public CFGBuilder pushForWrite(DfaVariableValue variable) {
        return this.add((Instruction)new JvmPushForWriteInstruction((DfaValue)variable));
    }

    public CFGBuilder push(DfaValue value) {
        return this.add((Instruction)new PushInstruction(value, null));
    }

    public CFGBuilder push(DfaValue value, PsiExpression expression) {
        return this.add((Instruction)new PushInstruction(value, (DfaAnchor)(expression == null ? null : new JavaExpressionAnchor(expression))));
    }

    public CFGBuilder nullCheck(NullabilityProblemKind.NullabilityProblem<?> problem) {
        this.myAnalyzer.addNullCheck(problem);
        return this;
    }

    public CFGBuilder push(DfType value) {
        return this.add((Instruction)new PushValueInstruction(value));
    }

    public CFGBuilder push(DfType value, PsiExpression expression) {
        return this.add((Instruction)new PushValueInstruction(value, (DfaAnchor)(expression == null ? null : new JavaExpressionAnchor(expression))));
    }

    public CFGBuilder pop() {
        return this.add((Instruction)new PopInstruction());
    }

    public CFGBuilder dup() {
        return this.add((Instruction)new DupInstruction());
    }

    public CFGBuilder splice(int count, int ... replacement) {
        if (count == 0 && replacement.length == 0) {
            return this;
        }
        return this.add((Instruction)new SpliceInstruction(count, replacement));
    }

    public CFGBuilder swap() {
        return this.add((Instruction)new SwapInstruction());
    }

    public CFGBuilder resultOf(@NotNull PsiExpression expression) {
        if (expression == null) {
            CFGBuilder.$$$reportNull$$$0(6);
        }
        return this.add((Instruction)new ResultOfInstruction((DfaAnchor)new JavaExpressionAnchor(expression)));
    }

    public CFGBuilder not() {
        this.add((Instruction)new NotInstruction(null));
        return this;
    }

    public CFGBuilder isInstance(@Nullable PsiMethodCallExpression anchor) {
        return this.add((Instruction)new InstanceofInstruction(anchor == null ? null : new JavaExpressionAnchor((PsiExpression)anchor), true));
    }

    public CFGBuilder isAssignableFrom(PsiMethodCallExpression anchor) {
        return this.add((Instruction)new IsAssignableInstruction(anchor));
    }

    public CFGBuilder isInstance(PsiExpression anchor) {
        return this.add((Instruction)new InstanceofInstruction(new JavaExpressionAnchor(anchor), false));
    }

    public CFGBuilder compare(RelationType relation) {
        return this.add((Instruction)new BooleanBinaryInstruction(relation, false, null));
    }

    public CFGBuilder ifConditionIs(boolean value) {
        ConditionalGotoInstruction gotoInstruction = new ConditionalGotoInstruction(null, (DfType)DfTypes.booleanValue(!value));
        this.myBranches.add(() -> gotoInstruction.setOffset(this.myAnalyzer.getInstructionCount()));
        return this.add((Instruction)gotoInstruction);
    }

    public CFGBuilder ifCondition(RelationType relation) {
        return this.compare(relation).ifConditionIs(true);
    }

    public CFGBuilder ifNotNull() {
        ConditionalGotoInstruction gotoInstruction = new ConditionalGotoInstruction(null, (DfType)DfTypes.NULL);
        this.myBranches.add(() -> gotoInstruction.setOffset(this.myAnalyzer.getInstructionCount()));
        return this.add((Instruction)gotoInstruction);
    }

    public CFGBuilder ifNull() {
        return this.pushNull().ifCondition(RelationType.EQ);
    }

    public CFGBuilder end() {
        this.myBranches.removeLast().run();
        return this;
    }

    public CFGBuilder elseBranch() {
        GotoInstruction gotoInstruction = new GotoInstruction(null);
        this.add((Instruction)gotoInstruction).end();
        this.myBranches.add(() -> gotoInstruction.setOffset(this.myAnalyzer.getInstructionCount()));
        return this;
    }

    public CFGBuilder doWhileUnknown() {
        ConditionalGotoInstruction jump = new ConditionalGotoInstruction(null, DfType.TOP, null);
        jump.setOffset(this.myAnalyzer.getInstructionCount());
        this.myBranches.add(() -> this.pushUnknown().add((Instruction)jump));
        return this;
    }

    public CFGBuilder boxUnbox(@NotNull PsiExpression expression, PsiType expectedType) {
        if (expression == null) {
            CFGBuilder.$$$reportNull$$$0(7);
        }
        this.myAnalyzer.generateBoxingUnboxingInstructionFor(expression, expectedType);
        return this;
    }

    public CFGBuilder boxUnbox(PsiExpression expression, PsiType expressionType, PsiType expectedType) {
        this.myAnalyzer.generateBoxingUnboxingInstructionFor((PsiElement)expression, expressionType, expectedType, false);
        return this;
    }

    public CFGBuilder flushFields() {
        return this.add((Instruction)new FlushFieldsInstruction());
    }

    public CFGBuilder flush(DfaValue value) {
        if (value instanceof DfaVariableValue) {
            this.add((Instruction)new FlushVariableInstruction((DfaVariableValue)value));
        }
        return this;
    }

    public CFGBuilder assign() {
        return this.add((Instruction)new AssignInstruction(null, null));
    }

    public CFGBuilder assignAndPop(DfaValue target, DfType source) {
        if (target instanceof DfaVariableValue) {
            if (source == DfType.TOP) {
                this.add((Instruction)new FlushVariableInstruction((DfaVariableValue)target));
            } else {
                this.push(source).assignTo((DfaVariableValue)target).pop();
            }
        }
        return this;
    }

    public CFGBuilder assign(DfaValue target, DfType source) {
        if (target instanceof DfaVariableValue) {
            if (source == DfType.TOP) {
                this.flush(target).push(target);
            } else {
                this.push(source).assignTo((DfaVariableValue)target);
            }
        } else {
            this.push(source);
        }
        return this;
    }

    public CFGBuilder ensure(@NotNull RelationType relation, @NotNull DfType operand, @NotNull UnsatisfiedConditionProblem problem, @Nullable String exceptionType) {
        if (relation == null) {
            CFGBuilder.$$$reportNull$$$0(8);
        }
        if (operand == null) {
            CFGBuilder.$$$reportNull$$$0(9);
        }
        if (problem == null) {
            CFGBuilder.$$$reportNull$$$0(10);
        }
        DfaControlTransferValue transfer = exceptionType == null ? null : this.myAnalyzer.createTransfer(exceptionType);
        this.add((Instruction)new EnsureInstruction(problem, relation, operand, transfer));
        return this;
    }

    public CFGBuilder doTry(@NotNull PsiElement anchor) {
        if (anchor == null) {
            CFGBuilder.$$$reportNull$$$0(11);
        }
        ControlFlow.DeferredOffset offset = new ControlFlow.DeferredOffset();
        this.myAnalyzer.pushTrap(new TryCatchAllTrap(anchor, (ControlFlow.ControlFlowOffset)offset));
        this.myBranches.add(() -> offset.setOffset(this.myAnalyzer.getInstructionCount()));
        return this;
    }

    public CFGBuilder catchAll() {
        this.myAnalyzer.popTrap(TryCatchAllTrap.class);
        GotoInstruction gotoInstruction = new GotoInstruction(null);
        this.add((Instruction)gotoInstruction).end();
        this.myBranches.add(() -> gotoInstruction.setOffset(this.myAnalyzer.getInstructionCount()));
        return this;
    }

    public CFGBuilder doThrow(@NotNull PsiType exceptionType) {
        if (exceptionType == null) {
            CFGBuilder.$$$reportNull$$$0(12);
        }
        this.myAnalyzer.throwException(exceptionType, null);
        return this;
    }

    public CFGBuilder call(PsiMethodCallExpression call) {
        this.myAnalyzer.addBareCall(call, call.getMethodExpression());
        return this;
    }

    public CFGBuilder mathOp(@NotNull LongRangeBinOp binOp, @Nullable PsiExpression expression) {
        if (binOp == null) {
            CFGBuilder.$$$reportNull$$$0(13);
        }
        this.myAnalyzer.addInstruction((Instruction)new NumericBinaryInstruction(binOp, expression == null ? null : new JavaExpressionAnchor(expression)));
        return this;
    }

    public CFGBuilder assignTo(PsiVariable var) {
        return this.assignTo(PlainDescriptor.createVariableValue(this.getFactory(), var));
    }

    public CFGBuilder assignTo(DfaVariableValue var) {
        return this.add((Instruction)new SimpleAssignmentInstruction(null, var));
    }

    public DfaValueFactory getFactory() {
        return this.myAnalyzer.getFactory();
    }

    public CFGBuilder evaluateFunction(@Nullable PsiExpression functionalExpression) {
        PsiExpression stripped = PsiUtil.deparenthesizeExpression((PsiExpression)functionalExpression);
        if (stripped == null || stripped instanceof PsiLambdaExpression) {
            return this;
        }
        if (stripped instanceof PsiMethodReferenceExpression) {
            PsiMethodReferenceExpression methodRef = (PsiMethodReferenceExpression)stripped;
            PsiExpression qualifier = methodRef.getQualifierExpression();
            if (qualifier != null && !PsiMethodReferenceUtil.isStaticallyReferenced((PsiMethodReferenceExpression)methodRef)) {
                DfaVariableValue qualifierBinding = this.createTempVariable(qualifier.getType());
                this.pushForWrite(qualifierBinding).pushExpression(qualifier).assign().pop();
                this.myMethodRefQualifiers.put((PsiExpression)methodRef, qualifierBinding);
            }
            return this;
        }
        if (stripped instanceof PsiMethodCallExpression && PREDICATE_NOT.test((PsiMethodCallExpression)stripped)) {
            this.evaluateFunction(((PsiMethodCallExpression)stripped).getArgumentList().getExpressions()[0]);
            return this;
        }
        return this.pushExpression(functionalExpression, NullabilityProblemKind.passingToNotNullParameter).pop();
    }

    public CFGBuilder invokeFunction(int argCount, @Nullable PsiExpression functionalExpression) {
        return this.invokeFunction(argCount, functionalExpression, Nullability.UNKNOWN);
    }

    public CFGBuilder invokeFunction(int argCount, @Nullable PsiExpression functionalExpression, Nullability resultNullability) {
        PsiExpression stripped = PsiUtil.deparenthesizeExpression((PsiExpression)functionalExpression);
        if (this.tryInlineLambda(argCount, functionalExpression, resultNullability, () -> {})) {
            return this;
        }
        if (stripped instanceof PsiMethodReferenceExpression) {
            PsiElement qualifier;
            PsiMethodReferenceExpression methodRef = (PsiMethodReferenceExpression)stripped;
            JavaResolveResult resolveResult = methodRef.advancedResolve(false);
            PsiMethod method = (PsiMethod)ObjectUtils.tryCast((Object)resolveResult.getElement(), PsiMethod.class);
            if (method != null && !method.isVarArgs()) {
                if (argCount == 1) {
                    this.add((Instruction)new ResultOfInstruction((DfaAnchor)new JavaMethodReferenceArgumentAnchor(methodRef)));
                }
                if (this.processKnownMethodReference(argCount, methodRef, method)) {
                    return this;
                }
                int expectedArgCount = method.getParameterList().getParametersCount();
                boolean pushQualifier = true;
                if (!method.hasModifierProperty("static") && !method.isConstructor()) {
                    boolean bl = pushQualifier = !PsiMethodReferenceUtil.isStaticallyReferenced((PsiMethodReferenceExpression)methodRef);
                    if (!pushQualifier) {
                        ++expectedArgCount;
                    }
                }
                if (argCount == expectedArgCount) {
                    if (pushQualifier) {
                        DfaValue qualifierValue = (DfaValue)this.myMethodRefQualifiers.remove(methodRef);
                        this.push((DfaValue)(qualifierValue == null ? this.getFactory().getUnknown() : qualifierValue));
                        this.moveTopValue(argCount);
                    }
                    this.myAnalyzer.addBareCall(null, (PsiReferenceExpression)methodRef);
                    this.myAnalyzer.generateBoxingUnboxingInstructionFor((PsiElement)methodRef, resolveResult.getSubstitutor().substitute(method.getReturnType()), LambdaUtil.getFunctionalInterfaceReturnType((PsiFunctionalExpression)methodRef), false);
                    if (resultNullability == Nullability.NOT_NULL) {
                        this.myAnalyzer.addNullCheck(NullabilityProblemKind.nullableFunctionReturn.problem((PsiExpression)methodRef, null));
                    }
                    return this;
                }
            }
            if ((qualifier = methodRef.getQualifier()) instanceof PsiTypeElement && ((PsiTypeElement)qualifier).getType() instanceof PsiArrayType) {
                this.splice(argCount, new int[0]).push(DfTypes.typedObject(((PsiTypeElement)qualifier).getType(), Nullability.NOT_NULL));
                return this;
            }
        }
        if (stripped instanceof PsiMethodCallExpression && PREDICATE_NOT.test((PsiMethodCallExpression)stripped)) {
            this.invokeFunction(argCount, ((PsiMethodCallExpression)stripped).getArgumentList().getExpressions()[0], resultNullability);
            this.myAnalyzer.addInstruction((Instruction)new NotInstruction(null));
            return this;
        }
        this.splice(argCount, new int[0]);
        if (functionalExpression == null) {
            this.pushUnknown();
            return this;
        }
        this.flushFields();
        this.myAnalyzer.addConditionalErrorThrow();
        PsiType functionalInterfaceType = functionalExpression.getType();
        this.myAnalyzer.addMethodThrows((PsiMember)LambdaUtil.getFunctionalInterfaceMethod((PsiType)functionalInterfaceType));
        PsiType returnType = LambdaUtil.getFunctionalInterfaceReturnType((PsiType)functionalInterfaceType);
        if (returnType != null) {
            this.push(DfTypes.typedObject(returnType, DfaPsiUtil.getTypeNullability(returnType)));
        } else {
            this.pushUnknown();
        }
        return this;
    }

    public boolean tryInlineLambda(int argCount, @Nullable PsiExpression functionalExpression, Nullability resultNullability, Runnable pushArgs) {
        List<PsiReferenceExpression> refs;
        PsiLambdaExpression localLambda;
        PsiElement parent;
        PsiLambdaExpression lambda;
        Object[] parameters;
        PsiExpression stripped = PsiUtil.deparenthesizeExpression((PsiExpression)functionalExpression);
        if (stripped instanceof PsiLambdaExpression && (parameters = (lambda = (PsiLambdaExpression)stripped).getParameterList().getParameters()).length == argCount && lambda.getBody() != null) {
            pushArgs.run();
            StreamEx.ofReversed((Object[])parameters).forEach(p -> this.assignTo((PsiVariable)p).pop());
            this.inlineLambda(lambda, resultNullability);
            StreamEx.of((Object[])parameters).forEach(p -> this.add((Instruction)new FlushVariableInstruction(PlainDescriptor.createVariableValue(this.getFactory(), (PsiVariable)p))));
            return true;
        }
        PsiLocalVariable localFn = ExpressionUtils.resolveLocalVariable(stripped);
        if (localFn != null && PsiTreeUtil.isAncestor((PsiElement)(parent = PsiTreeUtil.getParentOfType((PsiElement)functionalExpression, (Class[])new Class[]{PsiLambdaExpression.class, PsiClass.class, PsiMethod.class})), (PsiElement)localFn, (boolean)true) && this.myAnalyzer.wasAdded((PsiElement)(localLambda = (PsiLambdaExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)localFn.getInitializer()), PsiLambdaExpression.class))) && ContainerUtil.getOnlyItem(refs = VariableAccessUtils.getVariableReferences((PsiVariable)localFn)) == stripped) {
            this.myAnalyzer.removeLambda(localLambda);
            return this.tryInlineLambda(argCount, (PsiExpression)localLambda, resultNullability, pushArgs);
        }
        return false;
    }

    private boolean processKnownMethodReference(int argCount, PsiMethodReferenceExpression methodRef, PsiMethod method) {
        if (argCount != 1 || !method.getName().equals("isInstance")) {
            return false;
        }
        PsiClassObjectAccessExpression qualifier = (PsiClassObjectAccessExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)methodRef.getQualifierExpression()), PsiClassObjectAccessExpression.class);
        if (qualifier == null) {
            return false;
        }
        PsiType type = qualifier.getOperand().getType();
        this.push(DfTypes.typedObject(type, Nullability.NOT_NULL));
        this.add((Instruction)new InstanceofInstruction(new JavaMethodReferenceReturnAnchor(methodRef), false));
        return true;
    }

    private void moveTopValue(int depth) {
        if (depth > 0) {
            int[] permutation = new int[depth + 1];
            for (int i = 1; i < permutation.length; ++i) {
                permutation[i] = depth + 1 - i;
            }
            this.splice(depth + 1, permutation);
        }
    }

    private CFGBuilder inlineLambda(PsiLambdaExpression lambda, Nullability resultNullability) {
        PsiElement body = lambda.getBody();
        PsiExpression expression = LambdaUtil.extractSingleExpressionFromBody((PsiElement)body);
        PsiType psiType = LambdaUtil.getFunctionalInterfaceReturnType((PsiFunctionalExpression)lambda);
        if (expression != null) {
            NullabilityProblemKind<PsiExpression> kind = resultNullability == Nullability.NOT_NULL ? NullabilityProblemKind.nullableFunctionReturn : NullabilityProblemKind.noProblem;
            this.myAnalyzer.addCustomNullabilityProblem(expression, kind);
            this.pushExpression(expression);
            this.myAnalyzer.removeCustomNullabilityProblem(expression);
            this.boxUnbox(expression, psiType);
        } else if (body instanceof PsiCodeBlock) {
            DfaVariableValue variable = this.createTempVariable(psiType);
            this.myAnalyzer.inlineBlock((PsiCodeBlock)body, resultNullability, variable, psiType);
            this.push((DfaValue)variable);
        } else {
            this.pushUnknown();
        }
        return this;
    }

    public CFGBuilder loopOver(PsiExpression[] expressions, DfaVariableValue targetVariable, @Nullable PsiType type) {
        DfaValueFactory factory = this.getFactory();
        if (expressions.length > 3) {
            for (PsiExpression expression : expressions) {
                this.pushExpression(expression);
                this.pop();
            }
            ConditionalGotoInstruction condGoto = new ConditionalGotoInstruction(null, (DfType)DfTypes.TRUE, null);
            condGoto.setOffset(this.myAnalyzer.getInstructionCount());
            this.myBranches.add(() -> this.pushUnknown().add((Instruction)condGoto));
            DfaValue commonValue = JavaDfaValueFactory.createCommonValue(factory, expressions, type);
            if (DfaTypeValue.isUnknown((DfaValue)commonValue)) {
                this.flush((DfaValue)targetVariable).push((DfaValue)targetVariable);
            } else {
                this.pushForWrite(targetVariable).push(commonValue).assign();
            }
        } else {
            this.push(factory.getSentinel());
            for (PsiExpression expression : expressions) {
                this.pushExpression(expression);
                this.boxUnbox(expression, type);
            }
            this.add((Instruction)new SpliceInstruction(expressions.length, IntStreamEx.ofIndices((Object[])expressions).toArray()));
            GotoInstruction gotoInstruction = new GotoInstruction(null, false);
            gotoInstruction.setOffset(this.myAnalyzer.getInstructionCount());
            this.dup().push(factory.getSentinel()).compare(RelationType.EQ);
            ConditionalGotoInstruction condGoto = new ConditionalGotoInstruction(null, (DfType)DfTypes.TRUE);
            this.add((Instruction)condGoto);
            this.assignTo(targetVariable);
            this.myBranches.add(() -> {
                this.add((Instruction)gotoInstruction);
                condGoto.setOffset(this.myAnalyzer.getInstructionCount());
                this.pop();
            });
        }
        return this;
    }

    @NotNull
    public DfaVariableValue createTempVariable(@Nullable PsiType type) {
        DfaVariableValue dfaVariableValue = this.myAnalyzer.createTempVariable(type);
        if (dfaVariableValue == null) {
            CFGBuilder.$$$reportNull$$$0(14);
        }
        return dfaVariableValue;
    }

    public CFGBuilder chain(Consumer<? super CFGBuilder> operation) {
        operation.accept(this);
        return this;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 3: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/java/CFGBuilder";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetType";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relation";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operand";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problem";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptionType";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binOp";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/java/CFGBuilder";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "unwrap";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createTempVariable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "pushExpression";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "unwrap";
                break;
            }
            case 3: 
            case 14: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "wrap";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "resultOf";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "boxUnbox";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "ensure";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "doTry";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "doThrow";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "mathOp";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 14 -> new IllegalStateException(string);
        };
    }
}

