/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.java;

import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.codeInsight.Nullability;
import com.intellij.codeInsight.daemon.ImplicitUsageProvider;
import com.intellij.codeInsight.daemon.impl.UnusedSymbolUtil;
import com.intellij.codeInsight.daemon.impl.analysis.JavaGenericsUtil;
import com.intellij.codeInspection.dataFlow.ConsumedStreamUtils;
import com.intellij.codeInspection.dataFlow.ContractReturnValue;
import com.intellij.codeInspection.dataFlow.CustomMethodHandlers;
import com.intellij.codeInspection.dataFlow.DfaPsiUtil;
import com.intellij.codeInspection.dataFlow.DfaUtil;
import com.intellij.codeInspection.dataFlow.JavaMethodContractUtil;
import com.intellij.codeInspection.dataFlow.MethodContract;
import com.intellij.codeInspection.dataFlow.NullabilityProblemKind;
import com.intellij.codeInspection.dataFlow.TypeConstraint;
import com.intellij.codeInspection.dataFlow.TypeConstraints;
import com.intellij.codeInspection.dataFlow.java.CFGBuilder;
import com.intellij.codeInspection.dataFlow.java.JavaClassDef;
import com.intellij.codeInspection.dataFlow.java.JavaDfaHelpers;
import com.intellij.codeInspection.dataFlow.java.JavaDfaValueFactory;
import com.intellij.codeInspection.dataFlow.java.anchor.JavaDfaAnchor;
import com.intellij.codeInspection.dataFlow.java.anchor.JavaExpressionAnchor;
import com.intellij.codeInspection.dataFlow.java.anchor.JavaPolyadicPartAnchor;
import com.intellij.codeInspection.dataFlow.java.anchor.JavaSwitchLabelTakenAnchor;
import com.intellij.codeInspection.dataFlow.java.inliner.AccessorInliner;
import com.intellij.codeInspection.dataFlow.java.inliner.AllNotNullInliner;
import com.intellij.codeInspection.dataFlow.java.inliner.AssertAllInliner;
import com.intellij.codeInspection.dataFlow.java.inliner.AssertInstanceOfInliner;
import com.intellij.codeInspection.dataFlow.java.inliner.AssertJInliner;
import com.intellij.codeInspection.dataFlow.java.inliner.AssumeInliner;
import com.intellij.codeInspection.dataFlow.java.inliner.BoxingInliner;
import com.intellij.codeInspection.dataFlow.java.inliner.CallInliner;
import com.intellij.codeInspection.dataFlow.java.inliner.ClassMethodsInliner;
import com.intellij.codeInspection.dataFlow.java.inliner.CollectionUpdateInliner;
import com.intellij.codeInspection.dataFlow.java.inliner.EnumCompareInliner;
import com.intellij.codeInspection.dataFlow.java.inliner.IndexOfInliner;
import com.intellij.codeInspection.dataFlow.java.inliner.LambdaInliner;
import com.intellij.codeInspection.dataFlow.java.inliner.MapUpdateInliner;
import com.intellij.codeInspection.dataFlow.java.inliner.OptionalChainInliner;
import com.intellij.codeInspection.dataFlow.java.inliner.SimpleMethodInliner;
import com.intellij.codeInspection.dataFlow.java.inliner.StreamChainInliner;
import com.intellij.codeInspection.dataFlow.java.inliner.TransformInliner;
import com.intellij.codeInspection.dataFlow.java.inst.ArrayAccessInstruction;
import com.intellij.codeInspection.dataFlow.java.inst.AssignInstruction;
import com.intellij.codeInspection.dataFlow.java.inst.BooleanAndOrInstruction;
import com.intellij.codeInspection.dataFlow.java.inst.BooleanBinaryInstruction;
import com.intellij.codeInspection.dataFlow.java.inst.CheckNotNullInstruction;
import com.intellij.codeInspection.dataFlow.java.inst.EndOfInstanceInitializerInstruction;
import com.intellij.codeInspection.dataFlow.java.inst.EscapeInstruction;
import com.intellij.codeInspection.dataFlow.java.inst.FoldArrayInstruction;
import com.intellij.codeInspection.dataFlow.java.inst.InstanceofInstruction;
import com.intellij.codeInspection.dataFlow.java.inst.JavaArrayStoreInstruction;
import com.intellij.codeInspection.dataFlow.java.inst.JvmPushForWriteInstruction;
import com.intellij.codeInspection.dataFlow.java.inst.MethodCallInstruction;
import com.intellij.codeInspection.dataFlow.java.inst.MethodReferenceInstruction;
import com.intellij.codeInspection.dataFlow.java.inst.NotInstruction;
import com.intellij.codeInspection.dataFlow.java.inst.NumericBinaryInstruction;
import com.intellij.codeInspection.dataFlow.java.inst.PrimitiveConversionInstruction;
import com.intellij.codeInspection.dataFlow.java.inst.StringConcatInstruction;
import com.intellij.codeInspection.dataFlow.java.inst.ThrowInstruction;
import com.intellij.codeInspection.dataFlow.java.inst.TypeCastInstruction;
import com.intellij.codeInspection.dataFlow.jvm.JvmPsiRangeSetUtil;
import com.intellij.codeInspection.dataFlow.jvm.SpecialField;
import com.intellij.codeInspection.dataFlow.jvm.TrapTracker;
import com.intellij.codeInspection.dataFlow.jvm.descriptors.ArrayElementDescriptor;
import com.intellij.codeInspection.dataFlow.jvm.descriptors.AssertionDisabledDescriptor;
import com.intellij.codeInspection.dataFlow.jvm.descriptors.GetterDescriptor;
import com.intellij.codeInspection.dataFlow.jvm.descriptors.PlainDescriptor;
import com.intellij.codeInspection.dataFlow.jvm.descriptors.PsiVarDescriptor;
import com.intellij.codeInspection.dataFlow.jvm.descriptors.ThisDescriptor;
import com.intellij.codeInspection.dataFlow.jvm.problems.ArrayIndexProblem;
import com.intellij.codeInspection.dataFlow.jvm.problems.ConsumedStreamProblem;
import com.intellij.codeInspection.dataFlow.jvm.problems.ContractFailureProblem;
import com.intellij.codeInspection.dataFlow.jvm.problems.NegativeArraySizeProblem;
import com.intellij.codeInspection.dataFlow.jvm.transfer.EnterFinallyTrap;
import com.intellij.codeInspection.dataFlow.jvm.transfer.ExceptionTransfer;
import com.intellij.codeInspection.dataFlow.jvm.transfer.ExitFinallyTransfer;
import com.intellij.codeInspection.dataFlow.jvm.transfer.InsideFinallyTrap;
import com.intellij.codeInspection.dataFlow.jvm.transfer.InsideInlinedBlockTrap;
import com.intellij.codeInspection.dataFlow.jvm.transfer.InstructionTransfer;
import com.intellij.codeInspection.dataFlow.jvm.transfer.TryCatchTrap;
import com.intellij.codeInspection.dataFlow.lang.DfaAnchor;
import com.intellij.codeInspection.dataFlow.lang.UnsatisfiedConditionProblem;
import com.intellij.codeInspection.dataFlow.lang.ir.ClosureInstruction;
import com.intellij.codeInspection.dataFlow.lang.ir.ConditionalGotoInstruction;
import com.intellij.codeInspection.dataFlow.lang.ir.ControlFlow;
import com.intellij.codeInspection.dataFlow.lang.ir.ControlTransferInstruction;
import com.intellij.codeInspection.dataFlow.lang.ir.DataFlowIRProvider;
import com.intellij.codeInspection.dataFlow.lang.ir.DupInstruction;
import com.intellij.codeInspection.dataFlow.lang.ir.EnsureInstruction;
import com.intellij.codeInspection.dataFlow.lang.ir.EvalUnknownInstruction;
import com.intellij.codeInspection.dataFlow.lang.ir.FinishElementInstruction;
import com.intellij.codeInspection.dataFlow.lang.ir.FlushFieldsInstruction;
import com.intellij.codeInspection.dataFlow.lang.ir.FlushVariableInstruction;
import com.intellij.codeInspection.dataFlow.lang.ir.GetQualifiedValueInstruction;
import com.intellij.codeInspection.dataFlow.lang.ir.GotoInstruction;
import com.intellij.codeInspection.dataFlow.lang.ir.Instruction;
import com.intellij.codeInspection.dataFlow.lang.ir.PopInstruction;
import com.intellij.codeInspection.dataFlow.lang.ir.PushInstruction;
import com.intellij.codeInspection.dataFlow.lang.ir.PushValueInstruction;
import com.intellij.codeInspection.dataFlow.lang.ir.ResultOfInstruction;
import com.intellij.codeInspection.dataFlow.lang.ir.ReturnInstruction;
import com.intellij.codeInspection.dataFlow.lang.ir.SimpleAssignmentInstruction;
import com.intellij.codeInspection.dataFlow.lang.ir.SpliceInstruction;
import com.intellij.codeInspection.dataFlow.lang.ir.SwapInstruction;
import com.intellij.codeInspection.dataFlow.lang.ir.WrapDerivedVariableInstruction;
import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeBinOp;
import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeSet;
import com.intellij.codeInspection.dataFlow.types.DfConstantType;
import com.intellij.codeInspection.dataFlow.types.DfStreamStateType;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.types.DfTypes;
import com.intellij.codeInspection.dataFlow.value.DerivedVariableDescriptor;
import com.intellij.codeInspection.dataFlow.value.DfaControlTransferValue;
import com.intellij.codeInspection.dataFlow.value.DfaTypeValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.codeInspection.dataFlow.value.RelationType;
import com.intellij.codeInspection.dataFlow.value.VariableDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.pom.java.JavaFeature;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiCaseLabelElement;
import com.intellij.psi.PsiCaseLabelElementList;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiConstructorCall;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDeconstructionPattern;
import com.intellij.psi.PsiDefaultCaseLabelElement;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEmptyStatement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionCodeFragment;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionListStatement;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachPatternStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiForeachStatementBase;
import com.intellij.psi.PsiFragment;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLambdaExpressionType;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiMethodReferenceType;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPattern;
import com.intellij.psi.PsiPatternVariable;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiPrimaryPattern;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiRecordComponent;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResourceExpression;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiResourceListElement;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSwitchBlock;
import com.intellij.psi.PsiSwitchExpression;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchLabelStatementBase;
import com.intellij.psi.PsiSwitchLabeledRuleStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiTemplate;
import com.intellij.psi.PsiTemplateExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeTestPattern;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.PsiUnaryExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.PsiYieldStatement;
import com.intellij.psi.augment.PsiAugmentProvider;
import com.intellij.psi.impl.source.tree.java.PsiEmptyExpressionImpl;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.JavaPsiPatternUtil;
import com.intellij.psi.util.JavaPsiRecordUtil;
import com.intellij.psi.util.JavaPsiStringTemplateUtil;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FList;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.ComparisonUtils;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.CountingLoop;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.InstanceOfUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ControlFlowAnalyzer
extends JavaElementVisitor {
    private static final Logger LOG = Logger.getInstance(ControlFlowAnalyzer.class);
    private static final CallMatcher LIST_INITIALIZER = CallMatcher.anyOf(CallMatcher.staticCall("java.util.Arrays", "asList"), CallMatcher.staticCall("java.util.List", "of"));
    static final int MAX_UNROLL_SIZE = 3;
    private static final int MAX_ARRAY_INDEX_FOR_INITIALIZER = 32;
    private final PsiElement myCodeFragment;
    private final boolean myInlining;
    private final DfaValueFactory myFactory;
    private final TrapTracker myTrapTracker;
    private ControlFlow myCurrentFlow;
    private final Map<PsiExpression, NullabilityProblemKind<? super PsiExpression>> myCustomNullabilityProblems;
    private ExpressionBlockContext myExpressionBlockContext;
    private static final CallInliner[] INLINERS = new CallInliner[]{new AssertJInliner(), new OptionalChainInliner(), new LambdaInliner(), new CollectionUpdateInliner(), new StreamChainInliner(), new MapUpdateInliner(), new AssumeInliner(), new ClassMethodsInliner(), new AssertAllInliner(), new AllNotNullInliner(), new BoxingInliner(), new SimpleMethodInliner(), new AccessorInliner(), new TransformInliner(), new EnumCompareInliner(), new IndexOfInliner(), new AssertInstanceOfInliner()};

    ControlFlowAnalyzer(@NotNull DfaValueFactory valueFactory, @NotNull PsiElement codeFragment, boolean inlining) {
        if (valueFactory == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(0);
        }
        if (codeFragment == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(1);
        }
        this.myCustomNullabilityProblems = new HashMap<PsiExpression, NullabilityProblemKind<? super PsiExpression>>();
        this.myInlining = inlining;
        this.myFactory = valueFactory;
        this.myCodeFragment = codeFragment;
        this.myTrapTracker = new TrapTracker(valueFactory, JavaClassDef.typeConstraintFactory(codeFragment));
    }

    private void buildClassInitializerFlow(PsiClass psiClass, boolean isStatic) {
        PsiField field;
        PsiElement element;
        for (element = psiClass.getFirstChild(); element != null; element = element.getNextSibling()) {
            if (!(element instanceof PsiField) || (field = (PsiField)element).hasInitializer() || field.hasModifierProperty("static") != isStatic) continue;
            this.visitField(field);
        }
        if (!isStatic && ContainerUtil.exists((Iterable)ImplicitUsageProvider.EP_NAME.getExtensionList(), p -> p.isClassWithCustomizedInitialization((PsiElement)psiClass))) {
            this.addInstruction(new EscapeInstruction(List.of(new ThisDescriptor(psiClass))));
            this.addInstruction((Instruction)new FlushFieldsInstruction());
        }
        for (element = psiClass.getFirstChild(); element != null; element = element.getNextSibling()) {
            if ((!(element instanceof PsiField) || !(field = (PsiField)element).hasInitializer() || !PsiAugmentProvider.canTrustFieldInitializer((PsiField)field)) && !(element instanceof PsiClassInitializer) || ((PsiMember)element).hasModifierProperty("static") != isStatic) continue;
            element.accept((PsiElementVisitor)this);
        }
        if (!isStatic) {
            this.addInstruction(new EndOfInstanceInitializerInstruction());
        }
        this.addInstruction((Instruction)new FlushFieldsInstruction());
    }

    @Nullable
    ControlFlow buildControlFlow() {
        this.myCurrentFlow = new ControlFlow(this.myFactory, this.myCodeFragment);
        this.addInstruction((Instruction)new FinishElementInstruction(null));
        try {
            PsiElement psiElement = this.myCodeFragment;
            if (psiElement instanceof PsiClass) {
                PsiClass psiClass = (PsiClass)psiElement;
                this.pushUnknown();
                ConditionalGotoInstruction conditionalGoto = new ConditionalGotoInstruction(null, DfType.TOP);
                this.addInstruction((Instruction)conditionalGoto);
                this.buildClassInitializerFlow(psiClass, true);
                GotoInstruction unconditionalGoto = new GotoInstruction(null);
                this.addInstruction((Instruction)unconditionalGoto);
                conditionalGoto.setOffset(this.getInstructionCount());
                this.buildClassInitializerFlow(psiClass, false);
                unconditionalGoto.setOffset(this.getInstructionCount());
            } else {
                this.myCodeFragment.accept((PsiElementVisitor)this);
            }
        }
        catch (CannotAnalyzeException e) {
            return null;
        }
        this.myCurrentFlow.finish();
        return this.myCurrentFlow;
    }

    DfaValueFactory getFactory() {
        return this.myFactory;
    }

    private void removeVariable(@Nullable PsiVariable variable) {
        if (variable == null) {
            return;
        }
        this.myCurrentFlow.addInstruction((Instruction)new FlushVariableInstruction(PlainDescriptor.createVariableValue(this.getFactory(), variable)));
    }

    void addInstruction(Instruction i) {
        this.myCurrentFlow.addInstruction(i);
    }

    int getInstructionCount() {
        return this.myCurrentFlow.getInstructionCount();
    }

    private ControlFlow.ControlFlowOffset getEndOffset(PsiElement element) {
        assert (!(element instanceof PsiExpression) || element instanceof PsiSwitchExpression);
        return this.myCurrentFlow.getEndOffset(element);
    }

    private ControlFlow.ControlFlowOffset getStartOffset(PsiElement element) {
        assert (!(element instanceof PsiExpression) || element instanceof PsiSwitchExpression);
        return this.myCurrentFlow.getStartOffset(element);
    }

    private void startElement(@NotNull PsiElement element) {
        if (element == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(2);
        }
        this.myCurrentFlow.startElement(element);
    }

    private void finishElement(@NotNull PsiElement element) {
        if (element == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(3);
        }
        this.myCurrentFlow.finishElement(element);
        if (element instanceof PsiField || element instanceof PsiStatement && !(element instanceof PsiReturnStatement) && !(element instanceof PsiSwitchLabeledRuleStatement)) {
            int startOffset = this.myCurrentFlow.getStartOffset(element).getInstructionOffset();
            List synthetics = this.myFactory.getTempVariableDescriptorsFrom(startOffset);
            FinishElementInstruction instruction = new FinishElementInstruction(element);
            instruction.flushVars((Collection)synthetics);
            this.addInstruction((Instruction)instruction);
        }
    }

    public void visitErrorElement(@NotNull PsiErrorElement element) {
        if (element == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(4);
        }
        throw new CannotAnalyzeException();
    }

    public void visitAssignmentExpression(@NotNull PsiAssignmentExpression expression) {
        if (expression == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(5);
        }
        PsiExpression rExpr = expression.getRExpression();
        this.startElement((PsiElement)expression);
        if (rExpr == null) {
            this.pushUnknown();
            this.finishElement((PsiElement)expression);
            return;
        }
        IElementType op = expression.getOperationTokenType();
        PsiType type = expression.getType();
        PsiExpression lExpr = expression.getLExpression();
        PsiArrayAccessExpression arrayStore = (PsiArrayAccessExpression)ObjectUtils.tryCast((Object)lExpr, PsiArrayAccessExpression.class);
        if (arrayStore != null) {
            this.pushArrayAndIndex(arrayStore);
        } else {
            lExpr.accept((PsiElementVisitor)this);
        }
        if (op == JavaTokenType.EQ) {
            rExpr.accept((PsiElementVisitor)this);
            this.generateBoxingUnboxingInstructionFor(rExpr, type);
        } else {
            if (arrayStore != null) {
                this.addInstruction((Instruction)new SpliceInstruction(2, new int[]{1, 0, 1, 0}));
                this.readArrayElement(arrayStore);
            } else {
                this.addInstruction((Instruction)new DupInstruction());
            }
            IElementType sign = TypeConversionUtil.convertEQtoOperation((IElementType)op);
            PsiType resType = TypeConversionUtil.calcTypeForBinaryExpression((PsiType)lExpr.getType(), (PsiType)rExpr.getType(), (IElementType)sign, (boolean)true);
            this.generateBoxingUnboxingInstructionFor(lExpr, resType);
            rExpr.accept((PsiElementVisitor)this);
            this.generateBoxingUnboxingInstructionFor(rExpr, resType);
            this.generateBinOp(new JavaExpressionAnchor((PsiExpression)expression), sign, rExpr, resType);
            this.generateBoxingUnboxingInstructionFor((PsiElement)rExpr, resType, type, false);
        }
        if (arrayStore != null) {
            DfaControlTransferValue transfer = this.createTransfer("java.lang.ArrayIndexOutOfBoundsException");
            ArrayElementDescriptor staticDescriptor = ArrayElementDescriptor.fromArrayAccess(arrayStore);
            this.addInstruction((Instruction)new JavaArrayStoreInstruction(arrayStore, rExpr, transfer, (VariableDescriptor)staticDescriptor));
        } else {
            this.addInstruction((Instruction)new AssignInstruction(rExpr, JavaDfaValueFactory.getExpressionDfaValue(this.myFactory, lExpr)));
        }
        this.addNullCheck((PsiExpression)expression);
        this.finishElement((PsiElement)expression);
    }

    public void visitAssertStatement(@NotNull PsiAssertStatement statement) {
        if (statement == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(6);
        }
        this.startElement((PsiElement)statement);
        this.addInstruction((Instruction)new PushInstruction((DfaValue)AssertionDisabledDescriptor.createAssertionsDisabledVar(this.myFactory), null));
        ConditionalGotoInstruction jump = new ConditionalGotoInstruction(null, (DfType)DfTypes.TRUE);
        this.addInstruction((Instruction)jump);
        PsiExpression condition = statement.getAssertCondition();
        if (condition != null) {
            condition.accept((PsiElementVisitor)this);
            this.generateBoxingUnboxingInstructionFor(condition, (PsiType)PsiTypes.booleanType());
            this.addInstruction((Instruction)new ConditionalGotoInstruction(this.getEndOffset((PsiElement)statement), (DfType)DfTypes.TRUE, (PsiElement)condition));
            PsiExpression description = statement.getAssertDescription();
            if (description != null) {
                description.accept((PsiElementVisitor)this);
            }
            this.addInstruction((Instruction)new ThrowInstruction(this.myTrapTracker.transferValue("java.lang.AssertionError"), (PsiElement)statement));
        }
        jump.setOffset(this.getInstructionCount());
        this.finishElement((PsiElement)statement);
    }

    public void visitDeclarationStatement(@NotNull PsiDeclarationStatement statement) {
        PsiElement[] elements;
        if (statement == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(7);
        }
        this.startElement((PsiElement)statement);
        int startSize = this.getInstructionCount();
        for (PsiElement element : elements = statement.getDeclaredElements()) {
            PsiVariable variable;
            PsiExpression initializer;
            if (element instanceof PsiClass) {
                this.handleClosure(element);
                continue;
            }
            if (!(element instanceof PsiVariable) || (initializer = (variable = (PsiVariable)element).getInitializer()) == null) continue;
            this.initializeVariable(variable, initializer);
        }
        if (this.getInstructionCount() == startSize) {
            this.addInstruction((Instruction)new SpliceInstruction(0, new int[0]));
        }
        this.finishElement((PsiElement)statement);
    }

    public void visitField(@NotNull PsiField field) {
        PsiExpression initializer;
        if (field == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(8);
        }
        if ((initializer = field.getInitializer()) != null) {
            this.startElement((PsiElement)field);
            this.initializeVariable((PsiVariable)field, initializer);
            this.finishElement((PsiElement)field);
        } else if (!field.hasModifierProperty("final") && !UnusedSymbolUtil.isImplicitWrite((PsiVariable)field)) {
            DfaVariableValue dfaVariable = PlainDescriptor.createVariableValue(this.myFactory, (PsiVariable)field);
            new CFGBuilder(this).assignAndPop((DfaValue)dfaVariable, (DfType)DfTypes.defaultValue(field.getType()));
        }
    }

    public void visitClassInitializer(@NotNull PsiClassInitializer initializer) {
        if (initializer == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(9);
        }
        this.visitCodeBlock(initializer.getBody());
    }

    private void initializeVariable(PsiVariable variable, PsiExpression initializer) {
        if (JavaDfaValueFactory.ignoreInitializer(variable)) {
            return;
        }
        DfaVariableValue dfaVariable = PlainDescriptor.createVariableValue(this.myFactory, variable);
        this.addInstruction((Instruction)new JvmPushForWriteInstruction((DfaValue)dfaVariable));
        initializer.accept((PsiElementVisitor)this);
        this.generateBoxingUnboxingInstructionFor(initializer, variable.getType());
        this.addInstruction((Instruction)new AssignInstruction(initializer, (DfaValue)dfaVariable));
        this.addInstruction((Instruction)new PopInstruction());
    }

    public void visitCodeFragment(@NotNull JavaCodeFragment codeFragment) {
        PsiExpressionCodeFragment expressionCodeFragment;
        PsiExpression expression;
        if (codeFragment == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(10);
        }
        this.startElement((PsiElement)codeFragment);
        if (codeFragment instanceof PsiExpressionCodeFragment && (expression = (expressionCodeFragment = (PsiExpressionCodeFragment)codeFragment).getExpression()) != null) {
            expression.accept((PsiElementVisitor)this);
        }
        this.finishElement((PsiElement)codeFragment);
    }

    public void visitCodeBlock(@NotNull PsiCodeBlock block) {
        PsiStatement[] blockStatements;
        if (block == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(11);
        }
        this.startElement((PsiElement)block);
        for (PsiStatement statement : blockStatements = block.getStatements()) {
            statement.accept((PsiElementVisitor)this);
        }
        this.flushCodeBlockVariables(blockStatements, block.getParent());
        this.finishElement((PsiElement)block);
    }

    private void flushCodeBlockVariables(PsiStatement @NotNull [] statements, @Nullable PsiElement parent) {
        block7: {
            PsiTryStatement tryStatement;
            PsiResourceList list;
            block9: {
                block8: {
                    block6: {
                        if (statements == null) {
                            ControlFlowAnalyzer.$$$reportNull$$$0(12);
                        }
                        for (PsiStatement statement : statements) {
                            if (!(statement instanceof PsiDeclarationStatement)) continue;
                            PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)statement;
                            for (PsiElement declaration : declarationStatement.getDeclaredElements()) {
                                if (!(declaration instanceof PsiVariable)) continue;
                                PsiVariable variable = (PsiVariable)declaration;
                                this.removeVariable(variable);
                            }
                        }
                        if (!(parent instanceof PsiCatchSection)) break block6;
                        PsiCatchSection catchSection = (PsiCatchSection)parent;
                        this.removeVariable((PsiVariable)catchSection.getParameter());
                        break block7;
                    }
                    if (!(parent instanceof PsiForeachStatement)) break block8;
                    PsiForeachStatement forEach = (PsiForeachStatement)parent;
                    this.removeVariable((PsiVariable)forEach.getIterationParameter());
                    break block7;
                }
                if (!(parent instanceof PsiForStatement)) break block9;
                PsiForStatement forStatement = (PsiForStatement)parent;
                PsiStatement statement = forStatement.getInitialization();
                if (!(statement instanceof PsiDeclarationStatement)) break block7;
                PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)statement;
                for (PsiElement declaration : declarationStatement.getDeclaredElements()) {
                    if (!(declaration instanceof PsiVariable)) continue;
                    PsiVariable variable = (PsiVariable)declaration;
                    this.removeVariable(variable);
                }
                break block7;
            }
            if (parent instanceof PsiTryStatement && (list = (tryStatement = (PsiTryStatement)parent).getResourceList()) != null) {
                for (PsiResourceListElement resource : list) {
                    if (!(resource instanceof PsiResourceVariable)) continue;
                    PsiResourceVariable variable = (PsiResourceVariable)resource;
                    this.removeVariable((PsiVariable)variable);
                }
            }
        }
    }

    public void visitBlockStatement(@NotNull PsiBlockStatement statement) {
        if (statement == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(13);
        }
        this.startElement((PsiElement)statement);
        statement.getCodeBlock().accept((PsiElementVisitor)this);
        this.finishElement((PsiElement)statement);
    }

    public void visitBreakStatement(@NotNull PsiBreakStatement statement) {
        if (statement == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(14);
        }
        this.startElement((PsiElement)statement);
        this.jumpOut((PsiElement)statement.findExitedStatement());
        this.finishElement((PsiElement)statement);
    }

    public void visitYieldStatement(@NotNull PsiYieldStatement statement) {
        if (statement == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(15);
        }
        this.startElement((PsiElement)statement);
        PsiSwitchExpression enclosing = statement.findEnclosingExpression();
        PsiExpression expression = statement.getExpression();
        if (enclosing != null && this.myExpressionBlockContext != null && this.myExpressionBlockContext.myCodeBlock == enclosing.getBody()) {
            this.myExpressionBlockContext.generateReturn(expression, this);
        } else {
            if (expression != null) {
                expression.accept((PsiElementVisitor)this);
                this.addInstruction((Instruction)new PopInstruction());
            }
            this.jumpOut((PsiElement)enclosing);
        }
        this.finishElement((PsiElement)statement);
    }

    void addNullCheck(@NotNull PsiExpression expression) {
        if (expression == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(16);
        }
        this.addNullCheck(NullabilityProblemKind.fromContext(expression, this.myCustomNullabilityProblems));
    }

    void addNullCheck(@Nullable NullabilityProblemKind.NullabilityProblem<?> problem) {
        if (problem != null) {
            DfaControlTransferValue transfer = problem.thrownException() != null ? this.myTrapTracker.maybeTransferValue(problem.thrownException()) : null;
            this.addInstruction(new CheckNotNullInstruction(problem, transfer));
        }
    }

    private void jumpOut(PsiElement exitedStatement) {
        if (exitedStatement != null && PsiTreeUtil.isAncestor((PsiElement)this.myCodeFragment, (PsiElement)exitedStatement, (boolean)false)) {
            this.controlTransfer(this.createTransfer(exitedStatement, exitedStatement), this.myTrapTracker.getTrapsInsideElement(exitedStatement));
        } else {
            this.controlTransfer(DfaControlTransferValue.RETURN_TRANSFER, this.myTrapTracker.getTrapsInsideElement(this.myCodeFragment));
        }
    }

    private void controlTransfer(@NotNull DfaControlTransferValue.TransferTarget target, FList<DfaControlTransferValue.Trap> traps) {
        if (target == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(17);
        }
        this.addInstruction((Instruction)new ControlTransferInstruction(this.myFactory.controlTransfer(target, traps)));
    }

    /*
     * Unable to fully structure code
     */
    public void visitContinueStatement(@NotNull PsiContinueStatement statement) {
        if (statement == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(18);
        }
        this.startElement((PsiElement)statement);
        continuedStatement = statement.findContinuedStatement();
        if (!(continuedStatement instanceof PsiLoopStatement)) ** GOTO lbl-1000
        loopStatement = (PsiLoopStatement)continuedStatement;
        if (PsiTreeUtil.isAncestor((PsiElement)this.myCodeFragment, (PsiElement)continuedStatement, (boolean)true)) {
            body = loopStatement.getBody();
            this.controlTransfer(this.createTransfer((PsiElement)body, (PsiElement)body), this.myTrapTracker.getTrapsInsideElement((PsiElement)body));
        } else lbl-1000:
        // 2 sources

        {
            this.controlTransfer(DfaControlTransferValue.RETURN_TRANSFER, this.myTrapTracker.getTrapsInsideElement(this.myCodeFragment));
        }
        this.finishElement((PsiElement)statement);
    }

    public void visitDoWhileStatement(@NotNull PsiDoWhileStatement statement) {
        if (statement == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(19);
        }
        this.startElement((PsiElement)statement);
        PsiStatement body = statement.getBody();
        if (body != null) {
            body.accept((PsiElementVisitor)this);
            PsiExpression condition = statement.getCondition();
            if (condition != null) {
                condition.accept((PsiElementVisitor)this);
                this.generateBoxingUnboxingInstructionFor(condition, (PsiType)PsiTypes.booleanType());
                if (statement == this.myCodeFragment) {
                    this.addInstruction((Instruction)new PopInstruction());
                } else {
                    this.addInstruction((Instruction)new ConditionalGotoInstruction(this.getStartOffset((PsiElement)statement), (DfType)DfTypes.TRUE, (PsiElement)condition));
                }
            }
        }
        this.finishElement((PsiElement)statement);
    }

    public void visitEmptyStatement(@NotNull PsiEmptyStatement statement) {
        if (statement == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(20);
        }
        this.startElement((PsiElement)statement);
        this.finishElement((PsiElement)statement);
    }

    public void visitExpressionStatement(@NotNull PsiExpressionStatement statement) {
        if (statement == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(21);
        }
        this.startElement((PsiElement)statement);
        PsiExpression expr = statement.getExpression();
        expr.accept((PsiElementVisitor)this);
        this.addInstruction((Instruction)new PopInstruction());
        this.finishElement((PsiElement)statement);
    }

    public void visitExpressionListStatement(@NotNull PsiExpressionListStatement statement) {
        PsiExpression[] expressions;
        if (statement == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(22);
        }
        this.startElement((PsiElement)statement);
        for (PsiExpression expr : expressions = statement.getExpressionList().getExpressions()) {
            expr.accept((PsiElementVisitor)this);
            this.addInstruction((Instruction)new PopInstruction());
        }
        this.finishElement((PsiElement)statement);
    }

    private DfaValue getIteratedElement(PsiType type, PsiExpression iteratedValue) {
        PsiMethodCallExpression call;
        PsiReferenceExpression ref;
        PsiElement psiElement;
        PsiExpression[] expressions = null;
        if (iteratedValue instanceof PsiNewExpression) {
            PsiNewExpression newExpression = (PsiNewExpression)iteratedValue;
            PsiArrayInitializerExpression initializer = newExpression.getArrayInitializer();
            if (initializer != null) {
                expressions = initializer.getInitializers();
            }
        } else if (iteratedValue instanceof PsiReferenceExpression && (psiElement = (ref = (PsiReferenceExpression)iteratedValue).resolve()) instanceof PsiVariable) {
            PsiVariable arrayVar = (PsiVariable)psiElement;
            expressions = ExpressionUtils.getConstantArrayElements(arrayVar);
        }
        if (iteratedValue instanceof PsiMethodCallExpression && LIST_INITIALIZER.test(call = (PsiMethodCallExpression)iteratedValue)) {
            expressions = call.getArgumentList().getExpressions();
        }
        return expressions == null ? this.getFactory().getUnknown() : JavaDfaValueFactory.createCommonValue(this.getFactory(), expressions, type);
    }

    public void visitForeachPatternStatement(@NotNull PsiForeachPatternStatement statement) {
        if (statement == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(23);
        }
        this.processForeach((PsiForeachStatementBase)statement);
    }

    public void visitForeachStatement(@NotNull PsiForeachStatement statement) {
        if (statement == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(24);
        }
        this.processForeach((PsiForeachStatementBase)statement);
    }

    private void processForeach(@NotNull PsiForeachStatementBase statement) {
        PsiStatement body;
        PsiForeachPatternStatement patternForeach;
        PsiPattern parameter2;
        if (statement == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(25);
        }
        this.startElement((PsiElement)statement);
        PsiExpression iteratedValue = PsiUtil.skipParenthesizedExprDown((PsiExpression)statement.getIteratedValue());
        ControlFlow.ControlFlowOffset loopEndOffset = this.getEndOffset((PsiElement)statement);
        boolean hasSizeCheck = false;
        if (iteratedValue != null) {
            iteratedValue.accept((PsiElementVisitor)this);
            PsiType type = iteratedValue.getType();
            SpecialField length = null;
            if (type instanceof PsiArrayType) {
                length = SpecialField.ARRAY_LENGTH;
            } else if (InheritanceUtil.isInheritor((PsiType)type, (String)"java.util.Collection")) {
                length = SpecialField.COLLECTION_SIZE;
            }
            if (length != null) {
                this.addInstruction((Instruction)new GetQualifiedValueInstruction((VariableDescriptor)length));
                this.addInstruction((Instruction)new ConditionalGotoInstruction(loopEndOffset, (DfType)DfTypes.intValue(0)));
                hasSizeCheck = true;
            } else {
                this.addInstruction((Instruction)new PopInstruction());
            }
        }
        ControlFlow.ControlFlowOffset offset = this.myCurrentFlow.getNextOffset();
        if (statement instanceof PsiForeachStatement) {
            PsiForeachStatement normalForeach = (PsiForeachStatement)statement;
            PsiParameter parameter2 = normalForeach.getIterationParameter();
            DfaVariableValue dfaVariable = PlainDescriptor.createVariableValue(this.myFactory, (PsiVariable)parameter2);
            DfaValue commonValue = this.getIteratedElement(parameter2.getType(), iteratedValue);
            if (DfaTypeValue.isUnknown((DfaValue)commonValue)) {
                this.addInstruction((Instruction)new FlushVariableInstruction(dfaVariable));
            } else {
                new CFGBuilder(this).pushForWrite(dfaVariable).push(commonValue).assign().pop();
            }
        } else if (statement instanceof PsiForeachPatternStatement && (parameter2 = (patternForeach = (PsiForeachPatternStatement)statement).getIterationPattern()) instanceof PsiDeconstructionPattern) {
            PsiDeconstructionPattern pattern = (PsiDeconstructionPattern)parameter2;
            PsiType contextType = JavaPsiPatternUtil.getContextType((PsiPattern)pattern);
            if (contextType == null) {
                contextType = TypeUtils.getObjectType((PsiElement)statement);
            }
            DfaValue commonValue = this.getIteratedElement(contextType, iteratedValue);
            this.addInstruction((Instruction)new PushInstruction(commonValue, null));
            ControlFlow.DeferredOffset endPattern = new ControlFlow.DeferredOffset();
            this.processPattern((PsiPattern)pattern, (PsiPattern)pattern, contextType, null, endPattern);
            endPattern.setOffset(this.getInstructionCount());
            this.addInstruction((Instruction)new EnsureInstruction(null, RelationType.EQ, (DfType)DfTypes.TRUE, null));
            this.addInstruction((Instruction)new PopInstruction());
        }
        if (!hasSizeCheck) {
            this.pushUnknown();
            this.addInstruction((Instruction)new ConditionalGotoInstruction(loopEndOffset, DfType.TOP));
        }
        if ((body = statement.getBody()) != null) {
            body.accept((PsiElementVisitor)this);
        }
        if (hasSizeCheck) {
            this.pushUnknown();
            this.addInstruction((Instruction)new ConditionalGotoInstruction(loopEndOffset, DfType.TOP));
        }
        this.addInstruction((Instruction)new GotoInstruction(offset));
        this.finishElement((PsiElement)statement);
    }

    public void visitForStatement(@NotNull PsiForStatement statement) {
        ControlFlow.ControlFlowOffset offset;
        PsiExpression condition;
        if (statement == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(26);
        }
        this.startElement((PsiElement)statement);
        final ArrayList declaredVariables = new ArrayList();
        PsiStatement initialization = statement.getInitialization();
        if (initialization != null) {
            initialization.accept((PsiElementVisitor)this);
            initialization.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(this){

                public void visitReferenceExpression(@NotNull PsiReferenceExpression expression) {
                    if (expression == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    this.visitElement((PsiElement)expression);
                }

                public void visitDeclarationStatement(@NotNull PsiDeclarationStatement statement) {
                    PsiElement[] declaredElements;
                    if (statement == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    for (PsiElement element : declaredElements = statement.getDeclaredElements()) {
                        if (!(element instanceof PsiVariable)) continue;
                        declaredVariables.add(element);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "expression";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "statement";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/codeInspection/dataFlow/java/ControlFlowAnalyzer$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitReferenceExpression";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitDeclarationStatement";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
        if ((condition = statement.getCondition()) != null) {
            condition.accept((PsiElementVisitor)this);
            this.generateBoxingUnboxingInstructionFor(condition, (PsiType)PsiTypes.booleanType());
        } else {
            this.addInstruction((Instruction)new PushValueInstruction((DfType)(statement.getRParenth() == null ? DfTypes.BOOLEAN : DfTypes.TRUE)));
        }
        this.addInstruction((Instruction)new ConditionalGotoInstruction(this.getEndOffset((PsiElement)statement), (DfType)DfTypes.FALSE, (PsiElement)condition));
        PsiStatement body = statement.getBody();
        if (body != null) {
            body.accept((PsiElementVisitor)this);
        }
        ControlFlow.ControlFlowOffset controlFlowOffset = offset = initialization != null ? this.getEndOffset((PsiElement)initialization) : this.getStartOffset((PsiElement)statement);
        if (!this.addCountingLoopBound(statement, offset)) {
            PsiStatement update = statement.getUpdate();
            if (update != null) {
                update.accept((PsiElementVisitor)this);
            }
            this.addInstruction((Instruction)new GotoInstruction(offset));
        }
        this.finishElement((PsiElement)statement);
        for (PsiElement declaredVariable : declaredVariables) {
            PsiVariable psiVariable = (PsiVariable)declaredVariable;
            this.removeVariable(psiVariable);
        }
    }

    @Nullable
    private static Long asLong(PsiExpression expression) {
        Object value = ExpressionUtils.computeConstantExpression(expression);
        if (value instanceof Integer || value instanceof Long) {
            return ((Number)value).longValue();
        }
        return null;
    }

    private boolean addCountingLoopBound(PsiForStatement statement, ControlFlow.ControlFlowOffset startOffset) {
        PsiReferenceExpression ref;
        PsiVariable initialVariable;
        CountingLoop loop = CountingLoop.from(statement);
        if (loop == null || loop.isDescending()) {
            return false;
        }
        PsiLocalVariable counter = loop.getCounter();
        PsiType counterType = counter.getType();
        Long end = ControlFlowAnalyzer.asLong(loop.getBound());
        if (!(!loop.isIncluding() || PsiTypes.longType().equals((Object)counterType) && PsiTypes.intType().equals((Object)loop.getBound().getType()) || end != null && end != Long.MAX_VALUE && end != Integer.MAX_VALUE)) {
            return false;
        }
        PsiExpression initializer = loop.getInitializer();
        if (!PsiTypes.intType().equals((Object)counterType) && !PsiTypes.longType().equals((Object)counterType)) {
            return false;
        }
        DfaTypeValue origin = null;
        Object initialValue = ExpressionUtils.computeConstantExpression(initializer);
        if (initialValue instanceof Number) {
            origin = this.myFactory.fromDfType(DfTypes.constant(initialValue, counterType));
        } else if (initializer instanceof PsiReferenceExpression && PsiUtil.isJvmLocalVariable((PsiElement)(initialVariable = (PsiVariable)ObjectUtils.tryCast((Object)(ref = (PsiReferenceExpression)initializer).resolve(), PsiVariable.class))) && !VariableAccessUtils.variableIsAssigned(initialVariable, (PsiElement)statement.getBody())) {
            origin = PlainDescriptor.createVariableValue(this.myFactory, initialVariable);
        }
        if (origin == null) {
            return false;
        }
        Long start = ControlFlowAnalyzer.asLong(initializer);
        long diff = start == null || end == null ? -1L : end - start;
        DfaVariableValue loopVar = PlainDescriptor.createVariableValue(this.myFactory, (PsiVariable)counter);
        if (diff >= 0L && diff <= 3L) {
            Objects.requireNonNull(statement.getUpdate()).accept((PsiElementVisitor)this);
            this.addInstruction((Instruction)new PushInstruction((DfaValue)loopVar, null));
            DfConstantType startBound = PsiTypes.intType().equals((Object)counterType) ? DfTypes.intValue(Math.toIntExact(start)) : DfTypes.longValue(start);
            this.addInstruction((Instruction)new EnsureInstruction(null, RelationType.GE, (DfType)startBound, null));
            this.addInstruction((Instruction)new PopInstruction());
            this.addInstruction((Instruction)new GotoInstruction(startOffset, false));
            return true;
        }
        if (start != null) {
            long maxValue;
            long l = end == null ? Long.MAX_VALUE : (maxValue = loop.isIncluding() ? end + 1L : end);
            if (start >= maxValue && !loop.mayOverflow()) {
                this.addInstruction((Instruction)new GotoInstruction(this.getEndOffset((PsiElement)statement)));
            } else {
                LongRangeSet rangeSet = start >= maxValue ? LongRangeSet.all().subtract(LongRangeSet.range((long)(maxValue + 1L), (long)start)) : LongRangeSet.range((long)(start + 1L), (long)maxValue);
                DfType range = DfTypes.rangeClamped(rangeSet, JvmPsiRangeSetUtil.getLongRangeType(counterType));
                new CFGBuilder(this).assignAndPop((DfaValue)loopVar, range);
            }
        } else {
            if (loop.mayOverflow()) {
                return false;
            }
            new CFGBuilder(this).assign((DfaValue)loopVar, DfType.TOP).push((DfaValue)origin).compare(RelationType.LE);
            this.addInstruction((Instruction)new ConditionalGotoInstruction(this.getEndOffset((PsiElement)statement), (DfType)DfTypes.TRUE, null));
        }
        this.addInstruction((Instruction)new GotoInstruction(startOffset));
        return true;
    }

    public void visitIfStatement(@NotNull PsiIfStatement statement) {
        if (statement == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(27);
        }
        this.startElement((PsiElement)statement);
        PsiExpression condition = statement.getCondition();
        PsiStatement thenStatement = statement.getThenBranch();
        PsiStatement elseStatement = statement.getElseBranch();
        ControlFlow.DeferredOffset skipThenOffset = new ControlFlow.DeferredOffset();
        if (condition != null) {
            condition.accept((PsiElementVisitor)this);
            this.generateBoxingUnboxingInstructionFor(condition, (PsiType)PsiTypes.booleanType());
            this.addInstruction((Instruction)new ConditionalGotoInstruction((ControlFlow.ControlFlowOffset)skipThenOffset, (DfType)DfTypes.FALSE, (PsiElement)condition));
        }
        if (thenStatement != null) {
            this.addInstruction((Instruction)new FinishElementInstruction(null));
            thenStatement.accept((PsiElementVisitor)this);
        }
        if (elseStatement != null) {
            ControlFlow.DeferredOffset skipElseOffset = new ControlFlow.DeferredOffset();
            GotoInstruction instruction = new GotoInstruction((ControlFlow.ControlFlowOffset)skipElseOffset);
            this.addInstruction((Instruction)instruction);
            skipThenOffset.setOffset(this.getInstructionCount());
            this.addInstruction((Instruction)new FinishElementInstruction(null));
            elseStatement.accept((PsiElementVisitor)this);
            skipElseOffset.setOffset(this.getInstructionCount());
        } else {
            skipThenOffset.setOffset(this.getInstructionCount());
        }
        this.finishElement((PsiElement)statement);
    }

    public void visitStatement(@NotNull PsiStatement statement) {
        if (statement == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(28);
        }
        this.startElement((PsiElement)statement);
        this.finishElement((PsiElement)statement);
    }

    public void visitLabeledStatement(@NotNull PsiLabeledStatement statement) {
        if (statement == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(29);
        }
        this.startElement((PsiElement)statement);
        PsiStatement childStatement = statement.getStatement();
        if (childStatement != null) {
            childStatement.accept((PsiElementVisitor)this);
        }
        this.finishElement((PsiElement)statement);
    }

    public void visitLambdaExpression(@NotNull PsiLambdaExpression expression) {
        if (expression == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(30);
        }
        this.startElement((PsiElement)expression);
        DfaValue dfaValue = JavaDfaValueFactory.getExpressionDfaValue(this.myFactory, (PsiExpression)expression);
        this.push((DfaValue)(dfaValue == null ? this.myFactory.getUnknown() : dfaValue), (PsiExpression)expression);
        this.handleClosure((PsiElement)expression);
        this.finishElement((PsiElement)expression);
    }

    private void handleClosure(PsiElement closure) {
        List<Object> closures;
        final HashSet descriptors = new HashSet();
        closure.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitReferenceExpression(@NotNull PsiReferenceExpression expression) {
                DfaValue dfaValue;
                if (expression == null) {
                    2.$$$reportNull$$$0(0);
                }
                super.visitReferenceExpression(expression);
                PsiElement target = expression.resolve();
                VariableDescriptor descriptor = JavaDfaValueFactory.getAccessedVariableOrGetter(target);
                if (descriptor != null) {
                    descriptors.add(descriptor);
                }
                if ((dfaValue = JavaDfaValueFactory.getQualifierOrThisValue(ControlFlowAnalyzer.this.myFactory, expression)) instanceof DfaVariableValue) {
                    DfaVariableValue dfaVar = (DfaVariableValue)dfaValue;
                    descriptors.add(dfaVar.getDescriptor());
                }
            }

            public void visitThisExpression(@NotNull PsiThisExpression expression) {
                if (expression == null) {
                    2.$$$reportNull$$$0(1);
                }
                super.visitThisExpression(expression);
                DfaValue value = JavaDfaValueFactory.getExpressionDfaValue(ControlFlowAnalyzer.this.getFactory(), (PsiExpression)expression);
                if (value instanceof DfaVariableValue) {
                    DfaVariableValue dfaVar = (DfaVariableValue)value;
                    descriptors.add(dfaVar.getDescriptor());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "expression";
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/java/ControlFlowAnalyzer$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitReferenceExpression";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitThisExpression";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        if (!descriptors.isEmpty()) {
            this.addInstruction(new EscapeInstruction(List.copyOf(descriptors)));
        }
        if (closure instanceof PsiClass) {
            PsiClass psiClass = (PsiClass)closure;
            closures = ControlFlowAnalyzer.getClosures(psiClass);
        } else if (closure instanceof PsiLambdaExpression) {
            PsiLambdaExpression lambda = (PsiLambdaExpression)closure;
            closures = ContainerUtil.createMaybeSingletonList((Object)lambda.getBody());
        } else {
            closures = List.of();
        }
        if (!closures.isEmpty()) {
            this.addInstruction((Instruction)new ClosureInstruction(closures));
        }
    }

    public void visitReturnStatement(@NotNull PsiReturnStatement statement) {
        if (statement == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(31);
        }
        this.startElement((PsiElement)statement);
        PsiExpression returnValue = statement.getReturnValue();
        if (this.myExpressionBlockContext != null) {
            this.myExpressionBlockContext.generateReturn(returnValue, this);
        } else {
            if (returnValue != null) {
                returnValue.accept((PsiElementVisitor)this);
                PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)statement, PsiMethod.class, (boolean)true, (Class[])new Class[]{PsiMember.class, PsiLambdaExpression.class});
                if (method != null) {
                    this.generateBoxingUnboxingInstructionFor(returnValue, method.getReturnType());
                } else {
                    PsiLambdaExpression lambdaExpression = (PsiLambdaExpression)PsiTreeUtil.getParentOfType((PsiElement)statement, PsiLambdaExpression.class, (boolean)true, (Class[])new Class[]{PsiMember.class});
                    if (lambdaExpression != null) {
                        this.generateBoxingUnboxingInstructionFor(returnValue, LambdaUtil.getFunctionalInterfaceReturnType((PsiFunctionalExpression)lambdaExpression));
                    }
                }
                if (InheritanceUtil.isInheritor((PsiType)returnValue.getType(), (String)"java.util.stream.BaseStream")) {
                    this.addConsumedStreamCheckInstructions(returnValue, null);
                }
                this.addInstruction((Instruction)new PopInstruction());
            }
            this.addInstruction((Instruction)new ReturnInstruction(this.myFactory, this.myTrapTracker.trapStack(), (PsiElement)statement));
        }
        this.finishElement((PsiElement)statement);
    }

    private void addConsumedStreamCheckInstructions(@Nullable PsiExpression reference, @Nullable String exception) {
        if (reference == null) {
            return;
        }
        DfaControlTransferValue transferValue = exception != null ? this.createTransfer(exception) : null;
        this.addInstruction((Instruction)new DupInstruction());
        this.addInstruction((Instruction)new GetQualifiedValueInstruction((VariableDescriptor)SpecialField.CONSUMED_STREAM));
        this.addInstruction((Instruction)new EnsureInstruction((UnsatisfiedConditionProblem)new ConsumedStreamProblem((PsiElement)reference), RelationType.NE, (DfType)DfStreamStateType.CONSUMED, transferValue));
        this.addInstruction((Instruction)new PopInstruction());
    }

    public void visitSwitchLabelStatement(@NotNull PsiSwitchLabelStatement statement) {
        if (statement == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(32);
        }
        this.startElement((PsiElement)statement);
        PsiCaseLabelElementList labelElementList = statement.getCaseLabelElementList();
        if (labelElementList != null) {
            for (PsiCaseLabelElement element : labelElementList.getElements()) {
                if (!(element instanceof PsiDefaultCaseLabelElement)) continue;
                element.accept((PsiElementVisitor)this);
            }
        }
        this.finishElement((PsiElement)statement);
    }

    public void visitDefaultCaseLabelElement(@NotNull PsiDefaultCaseLabelElement element) {
        if (element == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(33);
        }
        this.startElement((PsiElement)element);
        this.finishElement((PsiElement)element);
    }

    public void visitSwitchLabeledRuleStatement(@NotNull PsiSwitchLabeledRuleStatement statement) {
        boolean expressionSwitch;
        PsiSwitchBlock switchBlock;
        if (statement == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(34);
        }
        if ((switchBlock = statement.getEnclosingSwitchBlock()) == null) {
            return;
        }
        this.startElement((PsiElement)statement);
        PsiCaseLabelElementList labelElementList = statement.getCaseLabelElementList();
        if (labelElementList != null) {
            for (PsiCaseLabelElement element : labelElementList.getElements()) {
                if (!(element instanceof PsiDefaultCaseLabelElement)) continue;
                element.accept((PsiElementVisitor)this);
            }
        }
        PsiStatement body = statement.getBody();
        PsiCodeBlock switchBody = switchBlock.getBody();
        boolean bl = expressionSwitch = this.myExpressionBlockContext != null && this.myExpressionBlockContext.myCodeBlock == switchBody;
        if (expressionSwitch && body instanceof PsiExpressionStatement) {
            PsiExpressionStatement expressionStatement = (PsiExpressionStatement)body;
            this.myExpressionBlockContext.generateReturn(expressionStatement.getExpression(), this);
        } else {
            if (body != null) {
                body.accept((PsiElementVisitor)this);
            }
            if (ControlFlowUtils.statementMayCompleteNormally(body)) {
                this.jumpOut((PsiElement)(expressionSwitch ? switchBody : switchBlock));
            }
        }
        this.finishElement((PsiElement)statement);
    }

    public void visitSwitchStatement(@NotNull PsiSwitchStatement switchStmt) {
        if (switchStmt == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(35);
        }
        this.startElement((PsiElement)switchStmt);
        this.processSwitch((PsiSwitchBlock)switchStmt);
        this.finishElement((PsiElement)switchStmt);
    }

    public void visitSwitchExpression(@NotNull PsiSwitchExpression expression) {
        PsiCodeBlock body;
        if (expression == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(36);
        }
        if ((body = expression.getBody()) == null) {
            this.processSwitch((PsiSwitchBlock)expression);
            this.pushUnknown();
        } else {
            this.startElement((PsiElement)expression);
            PsiType expressionType = expression.getType();
            DfaVariableValue resultVariable = this.createTempVariable(expressionType);
            this.enterExpressionBlock(body, Nullability.UNKNOWN, resultVariable, expressionType);
            this.processSwitch((PsiSwitchBlock)expression);
            this.exitExpressionBlock();
            this.push((DfaValue)resultVariable, (PsiExpression)expression);
            this.finishElement((PsiElement)expression);
        }
    }

    private void push(@NotNull DfaValue value, @NotNull PsiExpression expression) {
        if (value == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(37);
        }
        if (expression == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(38);
        }
        this.addInstruction((Instruction)new PushInstruction(value, (DfaAnchor)new JavaExpressionAnchor(expression)));
    }

    private void push(@NotNull DfType dfType, @NotNull PsiExpression expression) {
        if (dfType == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(39);
        }
        if (expression == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(40);
        }
        this.addInstruction((Instruction)new PushValueInstruction(dfType, (DfaAnchor)new JavaExpressionAnchor(expression)));
    }

    private void processSwitch(@NotNull PsiSwitchBlock switchBlock) {
        PsiCodeBlock body;
        if (switchBlock == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(41);
        }
        PsiExpression selector = PsiUtil.skipParenthesizedExprDown((PsiExpression)switchBlock.getExpression());
        DfaVariableValue expressionValue = null;
        boolean syntheticVar = true;
        PsiType targetType = null;
        if (selector != null) {
            DfaVariableValue dfaVar;
            targetType = selector.getType();
            DfaValue selectorValue = JavaDfaValueFactory.getExpressionDfaValue(this.myFactory, selector);
            if (selectorValue instanceof DfaVariableValue && !(dfaVar = (DfaVariableValue)selectorValue).isFlushableByCalls()) {
                expressionValue = dfaVar;
                syntheticVar = false;
            }
            selector.accept((PsiElementVisitor)this);
            if (syntheticVar) {
                expressionValue = targetType == null ? this.myCurrentFlow.createTempVariable(DfType.TOP) : this.createTempVariable(targetType);
                this.addInstruction((Instruction)new SimpleAssignmentInstruction(null, expressionValue));
            }
            this.addInstruction((Instruction)new PopInstruction());
        }
        if ((body = switchBlock.getBody()) != null) {
            PsiStatement[] statements = body.getStatements();
            PsiSwitchLabelStatementBase defaultLabel = null;
            for (PsiStatement statement : statements) {
                if (!(statement instanceof PsiSwitchLabelStatementBase)) continue;
                PsiSwitchLabelStatementBase psiLabelStatement = (PsiSwitchLabelStatementBase)statement;
                if (psiLabelStatement.isDefaultCase()) {
                    defaultLabel = psiLabelStatement;
                    continue;
                }
                try {
                    PsiExpression guard = psiLabelStatement.getGuardExpression();
                    ControlFlow.ControlFlowOffset offset = this.getStartOffset((PsiElement)statement);
                    ControlFlow.ControlFlowOffset targetOffset = guard == null ? offset : new ControlFlow.DeferredOffset();
                    PsiCaseLabelElementList labelElementList = psiLabelStatement.getCaseLabelElementList();
                    if (labelElementList != null) {
                        for (PsiCaseLabelElement labelElement : labelElementList.getElements()) {
                            if (labelElement instanceof PsiDefaultCaseLabelElement) {
                                defaultLabel = labelElement;
                                continue;
                            }
                            if (labelElement instanceof PsiExpression) {
                                PsiReferenceExpression ref;
                                boolean enumConstant;
                                PsiExpression expr = (PsiExpression)labelElement;
                                boolean bl = enumConstant = expr instanceof PsiReferenceExpression && (ref = (PsiReferenceExpression)expr).resolve() instanceof PsiEnumConstant;
                                if (expressionValue != null && (enumConstant || PsiUtil.isConstantExpression((PsiExpression)expr))) {
                                    if (PsiPrimitiveType.getUnboxedType((PsiType)targetType) == null) {
                                        this.addInstruction((Instruction)new PushInstruction((DfaValue)expressionValue, null));
                                        expr.accept((PsiElementVisitor)this);
                                        this.addInstruction((Instruction)new BooleanBinaryInstruction(RelationType.EQ, true, new JavaSwitchLabelTakenAnchor((PsiCaseLabelElement)expr)));
                                        this.addInstruction((Instruction)new ConditionalGotoInstruction(targetOffset, (DfType)DfTypes.TRUE));
                                        continue;
                                    }
                                    this.addInstruction((Instruction)new PushInstruction((DfaValue)expressionValue, null));
                                    ControlFlow.DeferredOffset condGotoOffset = new ControlFlow.DeferredOffset();
                                    this.addInstruction((Instruction)new ConditionalGotoInstruction((ControlFlow.ControlFlowOffset)condGotoOffset, (DfType)DfTypes.NULL));
                                    this.addInstruction((Instruction)new PushInstruction((DfaValue)expressionValue, null));
                                    this.generateBoxingUnboxingInstructionFor(selector, (PsiType)PsiPrimitiveType.getUnboxedType((PsiType)targetType));
                                    expr.accept((PsiElementVisitor)this);
                                    this.addInstruction((Instruction)new BooleanBinaryInstruction(RelationType.EQ, true, new JavaSwitchLabelTakenAnchor((PsiCaseLabelElement)expr)));
                                    ControlFlow.DeferredOffset gotoOffset = new ControlFlow.DeferredOffset();
                                    this.addInstruction((Instruction)new GotoInstruction((ControlFlow.ControlFlowOffset)gotoOffset));
                                    PushValueInstruction pushValInstr = new PushValueInstruction((DfType)DfTypes.FALSE, (DfaAnchor)new JavaSwitchLabelTakenAnchor((PsiCaseLabelElement)expr));
                                    this.addInstruction((Instruction)pushValInstr);
                                    condGotoOffset.setOffset(pushValInstr.getIndex());
                                    ConditionalGotoInstruction exitFromSwitchBranchInstr = new ConditionalGotoInstruction(targetOffset, (DfType)DfTypes.TRUE);
                                    this.addInstruction((Instruction)exitFromSwitchBranchInstr);
                                    gotoOffset.setOffset(exitFromSwitchBranchInstr.getIndex());
                                    continue;
                                }
                                if (expressionValue != null && ExpressionUtils.isNullLiteral(expr)) {
                                    this.addInstruction((Instruction)new PushInstruction((DfaValue)expressionValue, null));
                                    expr.accept((PsiElementVisitor)this);
                                    this.addInstruction((Instruction)new BooleanBinaryInstruction(RelationType.EQ, true, new JavaSwitchLabelTakenAnchor((PsiCaseLabelElement)expr)));
                                    this.addInstruction((Instruction)new ConditionalGotoInstruction(targetOffset, (DfType)DfTypes.TRUE));
                                    continue;
                                }
                                this.pushUnknown();
                                this.addInstruction((Instruction)new ConditionalGotoInstruction(targetOffset, (DfType)DfTypes.TRUE));
                                continue;
                            }
                            if (expressionValue == null || targetType == null || !(labelElement instanceof PsiPattern)) continue;
                            PsiPattern pattern = (PsiPattern)labelElement;
                            this.processPatternInSwitch(pattern, expressionValue, targetType);
                            this.addInstruction((Instruction)new ResultOfInstruction((DfaAnchor)new JavaSwitchLabelTakenAnchor((PsiCaseLabelElement)pattern)));
                            this.addInstruction((Instruction)new ConditionalGotoInstruction(targetOffset, (DfType)DfTypes.TRUE));
                        }
                    }
                    if (guard == null) continue;
                    ControlFlow.DeferredOffset endGuardOffset = new ControlFlow.DeferredOffset();
                    this.addInstruction((Instruction)new GotoInstruction((ControlFlow.ControlFlowOffset)endGuardOffset));
                    ((ControlFlow.DeferredOffset)targetOffset).setOffset(this.getInstructionCount());
                    guard.accept((PsiElementVisitor)this);
                    this.generateBoxingUnboxingInstructionFor(guard, (PsiType)PsiTypes.booleanType());
                    this.addInstruction((Instruction)new ResultOfInstruction((DfaAnchor)new JavaSwitchLabelTakenAnchor((PsiCaseLabelElement)guard)));
                    this.addInstruction((Instruction)new ConditionalGotoInstruction(offset, (DfType)DfTypes.TRUE));
                    endGuardOffset.setOffset(this.getInstructionCount());
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
            }
            if (defaultLabel != null) {
                this.addInstruction((Instruction)new GotoInstruction(this.getStartOffset((PsiElement)defaultLabel)));
            } else if (switchBlock instanceof PsiSwitchExpression) {
                this.addInstruction((Instruction)new ThrowInstruction(this.myTrapTracker.transferValue("java.lang.IncompatibleClassChangeError"), null));
            } else {
                this.addInstruction((Instruction)new GotoInstruction(this.getEndOffset((PsiElement)body)));
            }
            body.accept((PsiElementVisitor)this);
        }
        if (syntheticVar && expressionValue != null) {
            this.addInstruction((Instruction)new FlushVariableInstruction(expressionValue));
        }
    }

    private void processPatternInSwitch(@NotNull PsiPattern pattern, @NotNull DfaVariableValue expressionValue, @NotNull PsiType checkType) {
        if (pattern == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(42);
        }
        if (expressionValue == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(43);
        }
        if (checkType == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(44);
        }
        ControlFlow.DeferredOffset endPatternOffset = new ControlFlow.DeferredOffset();
        this.addInstruction((Instruction)new PushInstruction((DfaValue)expressionValue, null));
        this.processPattern(pattern, pattern, checkType, null, endPatternOffset);
        endPatternOffset.setOffset(this.getInstructionCount());
    }

    private void processPatternInInstanceof(@NotNull PsiPattern pattern, @NotNull PsiInstanceOfExpression expression, @NotNull PsiType checkType) {
        PsiDeconstructionPattern dec;
        if (pattern == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(45);
        }
        if (expression == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(46);
        }
        if (checkType == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(47);
        }
        boolean potentiallyRedundantInstanceOf = pattern instanceof PsiTypeTestPattern || pattern instanceof PsiDeconstructionPattern && JavaPsiPatternUtil.hasUnconditionalComponents((PsiDeconstructionPattern)(dec = (PsiDeconstructionPattern)pattern));
        JavaExpressionAnchor instanceofAnchor = potentiallyRedundantInstanceOf ? new JavaExpressionAnchor((PsiExpression)expression) : null;
        ControlFlow.DeferredOffset endPatternOffset = new ControlFlow.DeferredOffset();
        this.processPattern(pattern, pattern, checkType, instanceofAnchor, endPatternOffset);
        endPatternOffset.setOffset(this.getInstructionCount());
        if (!potentiallyRedundantInstanceOf) {
            this.addInstruction((Instruction)new ResultOfInstruction((DfaAnchor)new JavaExpressionAnchor((PsiExpression)expression)));
        }
    }

    private void processPattern(@NotNull PsiPattern sourcePattern, @Nullable PsiPattern innerPattern, @NotNull PsiType checkType, @Nullable DfaAnchor instanceofAnchor, @NotNull ControlFlow.DeferredOffset endPatternOffset) {
        if (sourcePattern == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(48);
        }
        if (checkType == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(49);
        }
        if (endPatternOffset == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(50);
        }
        if (innerPattern == null) {
            return;
        }
        if (innerPattern instanceof PsiDeconstructionPattern) {
            PsiDeconstructionPattern deconstructionPattern = (PsiDeconstructionPattern)innerPattern;
            PsiPatternVariable variable = deconstructionPattern.getPatternVariable();
            PsiType patternType = deconstructionPattern.getTypeElement().getType();
            DfaVariableValue patternDfaVar = variable == null ? this.createTempVariable(patternType) : PlainDescriptor.createVariableValue(this.getFactory(), (PsiVariable)variable);
            this.addTypeCheckPattern(sourcePattern, innerPattern, checkType, endPatternOffset, patternDfaVar, instanceofAnchor);
            this.addInstruction((Instruction)new PopInstruction());
            PsiPattern[] components = deconstructionPattern.getDeconstructionList().getDeconstructionComponents();
            if (patternType instanceof PsiClassType) {
                PsiRecordComponent[] recordComponents;
                PsiSubstitutor substitutor;
                PsiClassType patternClassType = (PsiClassType)patternType;
                PsiClassType.ClassResolveResult resolveResult = patternClassType.resolveGenerics();
                PsiClass recordClass = resolveResult.getElement();
                boolean unchecked = JavaGenericsUtil.isUncheckedCast((PsiType)patternClassType, (PsiType)checkType);
                PsiSubstitutor psiSubstitutor = substitutor = unchecked ? PsiSubstitutor.EMPTY : resolveResult.getSubstitutor();
                if (recordClass != null && recordClass.isRecord() && components.length == (recordComponents = recordClass.getRecordComponents()).length) {
                    for (int i = 0; i < components.length; ++i) {
                        PsiRecordComponent recordComponent = recordComponents[i];
                        PsiPattern patternComponent = components[i];
                        PsiMethod accessor = JavaPsiRecordUtil.getAccessorForRecordComponent((PsiRecordComponent)recordComponent);
                        if (accessor == null) continue;
                        PsiField field = PropertyUtil.getFieldOfGetter(accessor);
                        PsiVarDescriptor descriptor = field == null ? new GetterDescriptor(accessor) : new PlainDescriptor((PsiVariable)field);
                        DfaVariableValue accessorDfaVar = this.getFactory().getVarFactory().createVariableValue((VariableDescriptor)descriptor, patternDfaVar);
                        this.addInstruction((Instruction)new PushInstruction((DfaValue)accessorDfaVar, null));
                        this.processPattern(sourcePattern, patternComponent, substitutor.substitute(recordComponent.getType()), null, endPatternOffset);
                    }
                }
            }
        } else if (innerPattern instanceof PsiTypeTestPattern) {
            PsiTypeTestPattern typeTestPattern = (PsiTypeTestPattern)innerPattern;
            PsiPatternVariable variable = typeTestPattern.getPatternVariable();
            if (variable == null) {
                return;
            }
            DfaVariableValue patternDfaVar = PlainDescriptor.createVariableValue(this.getFactory(), (PsiVariable)variable);
            this.addTypeCheckPattern(sourcePattern, innerPattern, checkType, endPatternOffset, patternDfaVar, instanceofAnchor);
            this.addInstruction((Instruction)new PopInstruction());
        }
        if (sourcePattern == innerPattern) {
            this.addInstruction((Instruction)new PushValueInstruction((DfType)DfTypes.TRUE));
        }
    }

    private void addTypeCheckPattern(@NotNull PsiPattern sourcePattern, @NotNull PsiPattern innerPattern, @NotNull PsiType checkType, @NotNull ControlFlow.DeferredOffset endPatternOffset, @NotNull DfaVariableValue patternDfaVar, @Nullable DfaAnchor instanceofAnchor) {
        if (sourcePattern == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(51);
        }
        if (innerPattern == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(52);
        }
        if (checkType == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(53);
        }
        if (endPatternOffset == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(54);
        }
        if (patternDfaVar == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(55);
        }
        if (sourcePattern == innerPattern || !JavaPsiPatternUtil.isUnconditionalForType((PsiCaseLabelElement)innerPattern, (PsiType)checkType)) {
            this.addPatternTypeTest(innerPattern, instanceofAnchor, endPatternOffset, patternDfaVar, checkType);
        } else {
            this.addInstruction((Instruction)new SimpleAssignmentInstruction(null, patternDfaVar));
        }
    }

    private void addPatternTypeTest(@NotNull PsiPattern pattern, @Nullable DfaAnchor instanceofAnchor, @NotNull ControlFlow.DeferredOffset endPatternOffset, @NotNull DfaVariableValue patternDfaVar, @NotNull PsiType checkType) {
        if (pattern == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(56);
        }
        if (endPatternOffset == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(57);
        }
        if (patternDfaVar == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(58);
        }
        if (checkType == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(59);
        }
        this.addInstruction((Instruction)new DupInstruction());
        PsiType patternType = JavaPsiPatternUtil.getPatternType((PsiCaseLabelElement)pattern);
        this.generateInstanceOfInstructions((PsiElement)pattern, instanceofAnchor, checkType, patternType);
        ControlFlow.DeferredOffset condGotoOffset = new ControlFlow.DeferredOffset();
        this.addInstruction((Instruction)new ConditionalGotoInstruction((ControlFlow.ControlFlowOffset)condGotoOffset, (DfType)DfTypes.TRUE));
        this.addInstruction((Instruction)new PopInstruction());
        this.addInstruction((Instruction)new PushValueInstruction((DfType)DfTypes.FALSE));
        this.addInstruction((Instruction)new GotoInstruction((ControlFlow.ControlFlowOffset)endPatternOffset));
        SimpleAssignmentInstruction assignmentInstr = new SimpleAssignmentInstruction(null, patternDfaVar);
        this.addInstruction((Instruction)assignmentInstr);
        condGotoOffset.setOffset(assignmentInstr.getIndex());
    }

    private void generateInstanceOfInstructions(@NotNull PsiElement context, @Nullable DfaAnchor instanceofAnchor, @NotNull PsiType checkType, @Nullable PsiType patternType) {
        if (context == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(60);
        }
        if (checkType == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(61);
        }
        checkType = TypeConversionUtil.erasure((PsiType)checkType);
        if (patternType == null || (checkType instanceof PsiPrimitiveType || patternType instanceof PsiPrimitiveType) && (!PsiUtil.isAvailable((JavaFeature)JavaFeature.PRIMITIVE_TYPES_IN_PATTERNS, (PsiElement)context) || !TypeConversionUtil.areTypesConvertible((PsiType)checkType, (PsiType)patternType)) || ControlFlowAnalyzer.isUnresolvedType(checkType) || ControlFlowAnalyzer.isUnresolvedType(patternType)) {
            this.addInstruction((Instruction)new PopInstruction());
            this.pushUnknown();
            return;
        }
        if (checkType instanceof PsiPrimitiveType && patternType instanceof PsiPrimitiveType) {
            if (checkType.equals(patternType) || JavaPsiPatternUtil.isExactPrimitiveWideningConversion((PsiType)checkType, (PsiType)patternType)) {
                this.addInstruction((Instruction)new PopInstruction());
                this.addInstruction((Instruction)new PushValueInstruction((DfType)DfTypes.booleanValue(true)));
                if (instanceofAnchor != null) {
                    this.addInstruction((Instruction)new ResultOfInstruction(instanceofAnchor));
                }
            } else {
                this.generateExactTestingConversion(context, checkType, patternType, instanceofAnchor);
            }
        } else if (patternType instanceof PsiPrimitiveType) {
            PsiPrimitiveType patternPrimitiveType = (PsiPrimitiveType)patternType;
            PsiPrimitiveType unboxedCheckedType = PsiPrimitiveType.getUnboxedType((PsiType)checkType);
            if (unboxedCheckedType != null) {
                boolean isWideningConversion;
                boolean bl = isWideningConversion = JavaPsiPatternUtil.isExactPrimitiveWideningConversion((PsiType)unboxedCheckedType, (PsiType)patternPrimitiveType) || unboxedCheckedType.equals((Object)patternPrimitiveType);
                if (!isWideningConversion) {
                    this.addInstruction((Instruction)new DupInstruction());
                }
                this.addInstruction((Instruction)new PushValueInstruction((DfType)DfTypes.NULL));
                this.addInstruction((Instruction)new BooleanBinaryInstruction(RelationType.NE, false, (DfaAnchor)(isWideningConversion ? instanceofAnchor : null)));
                if (!isWideningConversion) {
                    CFGBuilder builder = new CFGBuilder(this).push(DfTypes.booleanValue(false)).ifCondition(RelationType.EQ).pop().push(DfTypes.booleanValue(false)).elseBranch();
                    this.generateBoxingUnboxingInstructionFor(context, checkType, (PsiType)unboxedCheckedType, false);
                    this.generateInstanceOfInstructions(context, null, (PsiType)unboxedCheckedType, (PsiType)patternPrimitiveType);
                    builder.end();
                    if (instanceofAnchor != null) {
                        this.addInstruction((Instruction)new ResultOfInstruction(instanceofAnchor));
                    }
                }
            } else {
                PsiClassType boxedType = patternPrimitiveType.getBoxedType(context);
                this.addInstruction((Instruction)new PushValueInstruction(DfTypes.typedObject((PsiType)boxedType, Nullability.NOT_NULL)));
                this.addInstruction((Instruction)new InstanceofInstruction(instanceofAnchor, false));
            }
        } else {
            if (checkType instanceof PsiPrimitiveType) {
                PsiPrimitiveType checkPrimitiveType = (PsiPrimitiveType)checkType;
                PsiClassType boxedType = checkPrimitiveType.getBoxedType(context);
                this.generateBoxingUnboxingInstructionFor(context, checkType, (PsiType)boxedType, false);
            }
            this.addInstruction((Instruction)new PushValueInstruction(DfTypes.typedObject(patternType, Nullability.NOT_NULL)));
            this.addInstruction((Instruction)new InstanceofInstruction(instanceofAnchor, false));
        }
    }

    private static boolean isUnresolvedType(@NotNull PsiType type) {
        PsiClassType ct;
        PsiType psiType;
        if (type == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(62);
        }
        return (psiType = type.getDeepComponentType()) instanceof PsiClassType && (ct = (PsiClassType)psiType).resolve() == null;
    }

    private void generateExactTestingConversion(@NotNull PsiElement context, @NotNull PsiType checkType, @NotNull PsiType patternType, @Nullable DfaAnchor instanceofAnchor) {
        if (context == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(63);
        }
        if (checkType == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(64);
        }
        if (patternType == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(65);
        }
        PsiType exactlyPromotedType = JavaPsiPatternUtil.getExactlyPromotedType((PsiElement)context, (PsiType)checkType, (PsiType)patternType);
        boolean checkTypeIsDouble = checkType.equals(PsiTypes.doubleType());
        boolean checkTypeIsFloat = checkType.equals(PsiTypes.floatType());
        boolean checkTypeIsLong = checkType.equals(PsiTypes.longType());
        if (exactlyPromotedType.equalsToText("java.math.BigDecimal")) {
            exactlyPromotedType = checkTypeIsLong ? PsiTypes.longType() : (checkTypeIsFloat ? PsiTypes.floatType() : PsiTypes.doubleType());
        }
        CFGBuilder builder = new CFGBuilder(this);
        boolean generateOr = false;
        boolean generateAnd = false;
        if (checkTypeIsFloat || checkTypeIsDouble) {
            if (patternType.equals(PsiTypes.floatType()) || patternType.equals(PsiTypes.doubleType())) {
                generateOr = true;
                builder.dup().dup().compare(RelationType.EQ);
                this.addInstruction((Instruction)new NotInstruction(null));
                builder.swap();
            } else {
                generateAnd = true;
                PsiClassType boxedType = checkTypeIsFloat ? PsiTypes.floatType().getBoxedType(context) : PsiTypes.doubleType().getBoxedType(context);
                builder.dup();
                this.generateBoxingUnboxingInstructionFor(context, checkType, (PsiType)boxedType, false);
                builder.push((DfType)(checkTypeIsFloat ? DfTypes.floatValue(-0.0f) : DfTypes.doubleValue(-0.0)));
                this.generateBoxingUnboxingInstructionFor(context, (PsiType)PsiTypes.doubleType(), (PsiType)boxedType, false);
                this.addInstruction((Instruction)new BooleanBinaryInstruction(RelationType.NE, true, null));
                builder.swap();
                if (patternType.equals(PsiTypes.longType())) {
                    builder.dup().push((DfType)(checkTypeIsFloat ? DfTypes.floatValue(9.223372E18f) : DfTypes.doubleValue(9.223372036854776E18))).compare(RelationType.NE).splice(3, 1, 0, 2);
                    this.addInstruction((Instruction)new BooleanAndOrInstruction(false, null));
                    builder.swap();
                }
            }
        } else if (checkTypeIsLong && (patternType.equals(PsiTypes.floatType()) || patternType.equals(PsiTypes.doubleType()))) {
            generateAnd = true;
            builder.dup().push(DfTypes.longValue(Long.MAX_VALUE)).compare(RelationType.NE).swap();
        }
        builder.dup();
        this.generateBoxingUnboxingInstructionFor(context, checkType, exactlyPromotedType, false);
        builder.swap();
        this.generateBoxingUnboxingInstructionFor(context, checkType, patternType, false);
        this.generateBoxingUnboxingInstructionFor(context, patternType, exactlyPromotedType, false);
        this.addInstruction((Instruction)new BooleanBinaryInstruction(RelationType.EQ, false, generateOr || generateAnd ? null : instanceofAnchor));
        if (generateOr) {
            this.addInstruction((Instruction)new BooleanAndOrInstruction(true, instanceofAnchor));
        }
        if (generateAnd) {
            this.addInstruction((Instruction)new BooleanAndOrInstruction(false, instanceofAnchor));
        }
    }

    public void visitMethodReferenceExpression(@NotNull PsiMethodReferenceExpression expression) {
        if (expression == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(66);
        }
        this.startElement((PsiElement)expression);
        PsiExpression qualifier = expression.getQualifierExpression();
        if (qualifier != null) {
            qualifier.accept((PsiElementVisitor)this);
        } else {
            this.pushUnknown();
        }
        this.addInstruction((Instruction)new MethodReferenceInstruction(expression));
        this.finishElement((PsiElement)expression);
    }

    public void visitSynchronizedStatement(@NotNull PsiSynchronizedStatement statement) {
        if (statement == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(67);
        }
        this.startElement((PsiElement)statement);
        PsiExpression lock = statement.getLockExpression();
        if (lock != null) {
            lock.accept((PsiElementVisitor)this);
            this.addInstruction((Instruction)new PopInstruction());
        }
        this.addInstruction((Instruction)new FlushFieldsInstruction());
        PsiCodeBlock body = statement.getBody();
        if (body != null) {
            body.accept((PsiElementVisitor)this);
        }
        this.finishElement((PsiElement)statement);
    }

    public void visitTemplateExpression(@NotNull PsiTemplateExpression expression) {
        if (expression == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(68);
        }
        PsiExpression processor = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression.getProcessor());
        if (this.processConcatTemplate(expression)) {
            return;
        }
        if (processor != null) {
            processor.accept((PsiElementVisitor)this);
        } else {
            this.pushUnknown();
        }
        PsiTemplate template = expression.getTemplate();
        if (template != null) {
            for (PsiExpression embeddedExpression : template.getEmbeddedExpressions()) {
                embeddedExpression.accept((PsiElementVisitor)this);
                this.addInstruction((Instruction)new PopInstruction());
            }
        }
        this.addInstruction((Instruction)new MethodCallInstruction((PsiCall)expression, List.of()));
        if (this.myTrapTracker.shouldHandleException()) {
            this.addThrows(ExceptionUtil.getOwnUnhandledExceptions((PsiElement)expression));
        }
        this.addNullCheck((PsiExpression)expression);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private boolean processConcatTemplate(@NotNull PsiTemplateExpression expression) {
        PsiExpression processor;
        if (expression == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(69);
        }
        if (!JavaPsiStringTemplateUtil.isStrTemplate((PsiExpression)(processor = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression.getProcessor())))) {
            return false;
        }
        PsiLiteralExpression literalExpression = expression.getLiteralExpression();
        if (literalExpression != null) {
            literalExpression.accept((PsiElementVisitor)this);
            return true;
        }
        PsiTemplate template = expression.getTemplate();
        if (template == null) {
            this.pushUnknown();
            return true;
        }
        PsiType stringType = expression.getType();
        if (stringType == null) {
            return false;
        }
        TypeConstraint constraint = TypeConstraints.exact(stringType);
        @NotNull List expressions = template.getEmbeddedExpressions();
        @NotNull List fragments = template.getFragments();
        int count = expressions.size();
        if (count + 1 != fragments.size()) {
            return false;
        }
        for (int i = 0; i < count; ++i) {
            PsiExpression embeddedExpression;
            PsiFragment fragment = (PsiFragment)fragments.get(i);
            String value = fragment.getValue();
            if (value != null) {
                this.addInstruction((Instruction)new PushValueInstruction(DfTypes.referenceConstant((Object)value, stringType)));
            } else {
                this.pushUnknown();
            }
            if (i > 0) {
                this.addInstruction((Instruction)new StringConcatInstruction(null, constraint));
            }
            if ((embeddedExpression = (PsiExpression)expressions.get(i)) instanceof PsiEmptyExpressionImpl) {
                this.addInstruction((Instruction)new PushValueInstruction((DfType)DfTypes.NULL));
            } else {
                embeddedExpression.accept((PsiElementVisitor)this);
            }
            this.addInstruction((Instruction)new StringConcatInstruction(null, constraint));
        }
        PsiFragment lastFragment = (PsiFragment)fragments.get(count);
        String value = lastFragment.getValue();
        if (value != null) {
            this.addInstruction((Instruction)new PushValueInstruction(DfTypes.referenceConstant((Object)value, stringType)));
        } else {
            this.pushUnknown();
        }
        if (count > 0) {
            this.addInstruction((Instruction)new StringConcatInstruction(new JavaExpressionAnchor((PsiExpression)expression), constraint));
        }
        return true;
    }

    public void visitThrowStatement(@NotNull PsiThrowStatement statement) {
        if (statement == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(70);
        }
        this.startElement((PsiElement)statement);
        PsiExpression exception = statement.getException();
        if (exception != null) {
            exception.accept((PsiElementVisitor)this);
            this.addInstruction((Instruction)new PopInstruction());
            this.throwException(exception.getType(), (PsiElement)statement);
        }
        this.finishElement((PsiElement)statement);
    }

    void addConditionalErrorThrow() {
        if (!this.myTrapTracker.shouldHandleException()) {
            return;
        }
        DfaControlTransferValue transfer = this.myTrapTracker.transferValue("java.lang.Error");
        this.addInstruction((Instruction)new EnsureInstruction(null, RelationType.EQ, DfType.TOP, transfer));
    }

    public void visitTryStatement(@NotNull PsiTryStatement statement) {
        PsiCatchSection[] sections;
        EnterFinallyTrap finallyDescriptor;
        if (statement == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(71);
        }
        this.startElement((PsiElement)statement);
        PsiResourceList resourceList = statement.getResourceList();
        PsiCodeBlock tryBlock = statement.getTryBlock();
        PsiCodeBlock finallyBlock = statement.getFinallyBlock();
        EnterFinallyTrap enterFinallyTrap = finallyDescriptor = finallyBlock != null ? new EnterFinallyTrap((PsiElement)finallyBlock, this.getStartOffset((PsiElement)finallyBlock)) : null;
        if (finallyDescriptor != null) {
            this.pushTrap(finallyDescriptor);
        }
        if ((sections = statement.getCatchSections()).length > 0) {
            LinkedHashMap<TryCatchTrap.JavaCatchClauseDescriptor, ControlFlow.ControlFlowOffset> clauses = new LinkedHashMap<TryCatchTrap.JavaCatchClauseDescriptor, ControlFlow.ControlFlowOffset>();
            for (PsiCatchSection section : sections) {
                PsiCodeBlock catchBlock = section.getCatchBlock();
                if (catchBlock == null) continue;
                clauses.put(new TryCatchTrap.JavaCatchClauseDescriptor(section), this.getStartOffset((PsiElement)catchBlock));
            }
            this.pushTrap(new TryCatchTrap((PsiElement)statement, clauses));
        }
        this.processTryWithResources(resourceList, tryBlock);
        InstructionTransfer gotoEnd = this.createTransfer((PsiElement)statement, (PsiElement)tryBlock);
        FList singleFinally = FList.createFromReversed((Iterable)ContainerUtil.createMaybeSingletonList((Object)finallyDescriptor));
        this.controlTransfer(gotoEnd, (FList<DfaControlTransferValue.Trap>)singleFinally);
        if (sections.length > 0) {
            this.popTrap(TryCatchTrap.class);
        }
        for (PsiCatchSection section : sections) {
            PsiCodeBlock catchBlock = section.getCatchBlock();
            if (catchBlock != null) {
                this.visitCodeBlock(catchBlock);
            }
            this.controlTransfer(gotoEnd, (FList<DfaControlTransferValue.Trap>)singleFinally);
        }
        if (finallyBlock != null) {
            this.popTrap(EnterFinallyTrap.class);
            this.pushTrap(new InsideFinallyTrap((PsiElement)finallyBlock));
            finallyBlock.accept((PsiElementVisitor)this);
            this.controlTransfer(new ExitFinallyTransfer(finallyDescriptor), (FList<DfaControlTransferValue.Trap>)FList.emptyList());
            this.popTrap(InsideFinallyTrap.class);
        }
        this.finishElement((PsiElement)statement);
    }

    @NotNull
    private InstructionTransfer createTransfer(PsiElement exitedStatement, PsiElement blockToFlush) {
        List varsToFlush = ContainerUtil.map((Collection)PsiTreeUtil.findChildrenOfType((PsiElement)blockToFlush, PsiVariable.class), PlainDescriptor::new);
        return new InstructionTransfer(this.getEndOffset(exitedStatement), varsToFlush);
    }

    void pushTrap(DfaControlTransferValue.Trap elem) {
        this.myTrapTracker.pushTrap(elem);
    }

    void popTrap(Class<? extends DfaControlTransferValue.Trap> aClass) {
        this.myTrapTracker.popTrap(aClass);
    }

    private void processTryWithResources(@Nullable PsiResourceList resourceList, @Nullable PsiCodeBlock tryBlock) {
        Set closerExceptions = Collections.emptySet();
        EnterFinallyTrap.TwrFinally twrFinallyDescriptor = null;
        if (resourceList != null) {
            resourceList.accept((PsiElementVisitor)this);
            closerExceptions = StreamEx.of((Iterator)resourceList.iterator()).flatCollection(ExceptionUtil::getCloserExceptions).toSet();
            twrFinallyDescriptor = new EnterFinallyTrap.TwrFinally(resourceList, this.getStartOffset((PsiElement)resourceList));
            this.pushTrap(twrFinallyDescriptor);
        }
        if (tryBlock != null) {
            tryBlock.accept((PsiElementVisitor)this);
        }
        if (twrFinallyDescriptor != null) {
            InstructionTransfer gotoEnd = this.createTransfer((PsiElement)resourceList, (PsiElement)tryBlock);
            this.controlTransfer(gotoEnd, (FList<DfaControlTransferValue.Trap>)FList.createFromReversed((Iterable)ContainerUtil.createMaybeSingletonList(twrFinallyDescriptor)));
            this.popTrap(EnterFinallyTrap.TwrFinally.class);
            this.pushTrap(new InsideFinallyTrap((PsiElement)resourceList));
            this.startElement((PsiElement)resourceList);
            this.addInstruction((Instruction)new FlushFieldsInstruction());
            this.addThrows(closerExceptions);
            this.controlTransfer(new ExitFinallyTransfer(twrFinallyDescriptor), (FList<DfaControlTransferValue.Trap>)FList.emptyList());
            this.finishElement((PsiElement)resourceList);
            this.popTrap(InsideFinallyTrap.class);
        }
    }

    public void visitResourceList(@NotNull PsiResourceList resourceList) {
        if (resourceList == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(72);
        }
        for (PsiResourceListElement resource : resourceList) {
            if (resource instanceof PsiResourceVariable) {
                PsiResourceVariable variable = (PsiResourceVariable)resource;
                PsiExpression initializer = variable.getInitializer();
                if (initializer == null) continue;
                this.initializeVariable((PsiVariable)variable, initializer);
                continue;
            }
            if (!(resource instanceof PsiResourceExpression)) continue;
            PsiResourceExpression expression = (PsiResourceExpression)resource;
            expression.getExpression().accept((PsiElementVisitor)this);
            this.addInstruction((Instruction)new PopInstruction());
        }
    }

    public void visitWhileStatement(@NotNull PsiWhileStatement statement) {
        if (statement == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(73);
        }
        this.startElement((PsiElement)statement);
        PsiExpression condition = statement.getCondition();
        if (condition != null) {
            condition.accept((PsiElementVisitor)this);
            this.generateBoxingUnboxingInstructionFor(condition, (PsiType)PsiTypes.booleanType());
        } else {
            this.pushUnknown();
        }
        this.addInstruction((Instruction)new ConditionalGotoInstruction(this.getEndOffset((PsiElement)statement), (DfType)DfTypes.FALSE, (PsiElement)condition));
        PsiStatement body = statement.getBody();
        if (body != null) {
            body.accept((PsiElementVisitor)this);
        }
        if (statement != this.myCodeFragment) {
            this.addInstruction((Instruction)new GotoInstruction(this.getStartOffset((PsiElement)statement)));
        }
        this.finishElement((PsiElement)statement);
    }

    public void visitExpressionList(@NotNull PsiExpressionList list) {
        PsiExpression[] expressions;
        if (list == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(74);
        }
        this.startElement((PsiElement)list);
        for (PsiExpression expression : expressions = list.getExpressions()) {
            expression.accept((PsiElementVisitor)this);
        }
        this.finishElement((PsiElement)list);
    }

    public void visitExpression(@NotNull PsiExpression expression) {
        if (expression == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(75);
        }
        this.startElement((PsiElement)expression);
        DfaValue dfaValue = JavaDfaValueFactory.getExpressionDfaValue(this.myFactory, expression);
        this.push((DfaValue)(dfaValue == null ? this.myFactory.getUnknown() : dfaValue), expression);
        this.finishElement((PsiElement)expression);
    }

    public void visitArrayAccessExpression(@NotNull PsiArrayAccessExpression expression) {
        if (expression == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(76);
        }
        this.startElement((PsiElement)expression);
        this.pushArrayAndIndex(expression);
        this.readArrayElement(expression);
        this.addNullCheck((PsiExpression)expression);
        this.finishElement((PsiElement)expression);
    }

    private void pushArrayAndIndex(PsiArrayAccessExpression arrayStore) {
        arrayStore.getArrayExpression().accept((PsiElementVisitor)this);
        PsiExpression index = arrayStore.getIndexExpression();
        if (index != null) {
            index.accept((PsiElementVisitor)this);
            this.generateBoxingUnboxingInstructionFor(index, (PsiType)PsiTypes.intType());
        } else {
            this.pushUnknown();
        }
    }

    private void readArrayElement(@NotNull PsiArrayAccessExpression expression) {
        if (expression == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(77);
        }
        DfaControlTransferValue transfer = this.createTransfer("java.lang.ArrayIndexOutOfBoundsException");
        this.addInstruction((Instruction)new ArrayAccessInstruction(new JavaExpressionAnchor((PsiExpression)expression), new ArrayIndexProblem(expression), transfer, ArrayElementDescriptor.fromArrayAccess(expression)));
    }

    @Nullable
    private DfaVariableValue getTargetVariable(PsiExpression expression) {
        DfaValue dfaValue;
        PsiAssignmentExpression assignmentExpression;
        PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)expression.getParent());
        if (expression instanceof PsiArrayInitializerExpression && parent instanceof PsiNewExpression) {
            parent = PsiUtil.skipParenthesizedExprUp((PsiElement)parent.getParent());
        }
        if (parent instanceof PsiVariable) {
            PsiVariable var = (PsiVariable)parent;
            return PlainDescriptor.createVariableValue(this.getFactory(), var);
        }
        if (parent instanceof PsiAssignmentExpression && (assignmentExpression = (PsiAssignmentExpression)parent).getOperationTokenType().equals(JavaTokenType.EQ) && PsiTreeUtil.isAncestor((PsiElement)assignmentExpression.getRExpression(), (PsiElement)expression, (boolean)false) && (dfaValue = JavaDfaValueFactory.getExpressionDfaValue(this.getFactory(), assignmentExpression.getLExpression())) instanceof DfaVariableValue) {
            DfaVariableValue var = (DfaVariableValue)dfaValue;
            return var;
        }
        return null;
    }

    public void visitArrayInitializerExpression(@NotNull PsiArrayInitializerExpression expression) {
        if (expression == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(78);
        }
        this.startElement((PsiElement)expression);
        this.initializeArray(expression, (PsiExpression)expression);
        this.finishElement((PsiElement)expression);
    }

    private void initializeArray(PsiArrayInitializerExpression expression, PsiExpression originalExpression) {
        DfaVariableValue var;
        PsiType psiType;
        PsiType type = expression.getType();
        if (type instanceof PsiArrayType) {
            PsiArrayType arrayType = (PsiArrayType)type;
            psiType = arrayType.getComponentType();
        } else {
            psiType = null;
        }
        PsiType componentType = psiType;
        DfaVariableValue arrayWriteTarget = var = this.getTargetVariable((PsiExpression)expression);
        if (var == null) {
            var = this.createTempVariable(type);
        }
        PsiExpression[] initializers = expression.getInitializers();
        if (arrayWriteTarget != null) {
            PsiVariable arrayVariable = (PsiVariable)ObjectUtils.tryCast((Object)arrayWriteTarget.getPsiVariable(), PsiVariable.class);
            if (arrayWriteTarget.isFlushableByCalls() || arrayVariable == null || VariableAccessUtils.variableIsUsed(arrayVariable, (PsiElement)expression) || ExpressionUtils.getConstantArrayElements(arrayVariable) != null || !(ArrayElementDescriptor.getArrayElementValue(this.getFactory(), (DfaValue)arrayWriteTarget, 0) instanceof DfaVariableValue)) {
                arrayWriteTarget = null;
            }
        }
        DfType arrayType = SpecialField.ARRAY_LENGTH.asDfType(DfTypes.intValue(initializers.length)).meet((DfType)(type == null ? DfTypes.OBJECT_OR_NULL : TypeConstraints.exact(type).asDfType())).meet((DfType)DfTypes.LOCAL_OBJECT);
        if (arrayWriteTarget != null) {
            this.addInstruction((Instruction)new JvmPushForWriteInstruction((DfaValue)arrayWriteTarget));
            this.push(arrayType, (PsiExpression)expression);
            this.addInstruction((Instruction)new AssignInstruction(originalExpression, (DfaValue)arrayWriteTarget));
            int index = 0;
            for (PsiExpression initializer : initializers) {
                DfaValue target = null;
                if (index < 32) {
                    target = Objects.requireNonNull(ArrayElementDescriptor.getArrayElementValue(this.getFactory(), (DfaValue)arrayWriteTarget, index));
                }
                ++index;
                this.addInstruction((Instruction)new JvmPushForWriteInstruction((DfaValue)(target == null ? this.myFactory.getUnknown() : target)));
                initializer.accept((PsiElementVisitor)this);
                if (componentType != null) {
                    this.generateBoxingUnboxingInstructionFor(initializer, componentType);
                }
                this.addInstruction((Instruction)new AssignInstruction(initializer, null));
                this.addInstruction((Instruction)new PopInstruction());
            }
        } else {
            for (PsiExpression initializer : initializers) {
                this.addInstruction((Instruction)new JvmPushForWriteInstruction((DfaValue)this.myFactory.getUnknown()));
                initializer.accept((PsiElementVisitor)this);
                if (componentType != null) {
                    this.generateBoxingUnboxingInstructionFor(initializer, componentType);
                }
                this.addInstruction((Instruction)new AssignInstruction(initializer, null));
                this.addInstruction((Instruction)new PopInstruction());
            }
            if (DfaValueFactory.isTempVariable((DfaVariableValue)var)) {
                this.addInstruction((Instruction)new JvmPushForWriteInstruction((DfaValue)var));
                this.push(arrayType, (PsiExpression)expression);
                this.addInstruction((Instruction)new AssignInstruction(null, (DfaValue)var));
            } else {
                this.push(arrayType, (PsiExpression)expression);
            }
        }
    }

    public void visitPolyadicExpression(@NotNull PsiPolyadicExpression expression) {
        if (expression == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(79);
        }
        this.startElement((PsiElement)expression);
        DfaValue dfaValue = JavaDfaValueFactory.getExpressionDfaValue(this.myFactory, (PsiExpression)expression);
        if (dfaValue != null) {
            this.push(dfaValue, (PsiExpression)expression);
            this.finishElement((PsiElement)expression);
            return;
        }
        if (PsiUtilCore.hasErrorElementChild((PsiElement)expression)) {
            this.pushUnknown();
            this.finishElement((PsiElement)expression);
            return;
        }
        PsiExpression[] operands = expression.getOperands();
        IElementType op = expression.getOperationTokenType();
        if (op == JavaTokenType.ANDAND) {
            this.generateShortCircuitAndOr((PsiExpression)expression, operands, expression.getType(), true);
        } else if (op == JavaTokenType.OROR) {
            this.generateShortCircuitAndOr((PsiExpression)expression, operands, expression.getType(), false);
        } else {
            this.generateBinOpChain(expression, op, operands);
        }
        this.finishElement((PsiElement)expression);
    }

    private void checkZeroDivisor(PsiType resType) {
        DfaControlTransferValue transfer = this.createTransfer("java.lang.ArithmeticException");
        this.addInstruction((Instruction)new EnsureInstruction(null, RelationType.NE, (DfType)(PsiTypes.longType().equals((Object)resType) ? DfTypes.longValue(0L) : DfTypes.intValue(0)), transfer, true));
    }

    private void generateBinOpChain(PsiPolyadicExpression expression, @NotNull IElementType op, PsiExpression[] operands) {
        if (op == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(80);
        }
        PsiExpression lExpr = operands[0];
        lExpr.accept((PsiElementVisitor)this);
        PsiType lType = lExpr.getType();
        this.addImplicitToStringThrows(op, lType);
        for (int i = 1; i < operands.length; ++i) {
            PsiExpression rExpr = operands[i];
            PsiType rType = rExpr.getType();
            this.acceptBinaryRightOperand(op, lExpr, lType, rExpr, rType);
            this.addImplicitToStringThrows(op, rType);
            PsiType resType = TypeConversionUtil.calcTypeForBinaryExpression((PsiType)lType, (PsiType)rType, (IElementType)op, (boolean)true);
            JavaDfaAnchor anchor = i == operands.length - 1 ? new JavaExpressionAnchor((PsiExpression)expression) : new JavaPolyadicPartAnchor(expression, i);
            this.generateBinOp(anchor, op, rExpr, resType);
            lExpr = rExpr;
            lType = resType;
        }
    }

    private void addImplicitToStringThrows(@NotNull IElementType op, PsiType type) {
        if (op == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(81);
        }
        if (this.myTrapTracker.shouldHandleException() && op.equals(JavaTokenType.PLUS) && !TypeConversionUtil.isPrimitiveAndNotNullOrWrapper((PsiType)type) && !TypeUtils.isJavaLangString(type)) {
            this.addThrows(List.of());
        }
    }

    private void generateBinOp(@NotNull DfaAnchor anchor, @NotNull IElementType op, PsiExpression rExpr, PsiType resType) {
        Object inst;
        Number number;
        Object divisorValue;
        if (anchor == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(82);
        }
        if (op == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(83);
        }
        if (!(op != JavaTokenType.DIV && op != JavaTokenType.PERC || resType == null || !PsiTypes.longType().isAssignableFrom(resType) || (divisorValue = ExpressionUtils.computeConstantExpression(rExpr)) instanceof Number && (number = (Number)divisorValue).longValue() != 0L)) {
            this.checkZeroDivisor(resType);
        }
        if (op.equals(JavaTokenType.PLUS) && TypeUtils.isJavaLangString(resType)) {
            inst = new StringConcatInstruction(anchor, TypeConstraints.exact(resType));
        } else if (PsiTypes.booleanType().equals((Object)resType)) {
            if (op.equals(JavaTokenType.AND)) {
                inst = new BooleanAndOrInstruction(false, anchor);
            } else if (op.equals(JavaTokenType.OR)) {
                inst = new BooleanAndOrInstruction(true, anchor);
            } else {
                RelationType relation = op == JavaTokenType.XOR ? RelationType.NE : DfaPsiUtil.getRelationByToken(op);
                inst = relation != null ? new BooleanBinaryInstruction(relation, false, anchor) : new EvalUnknownInstruction(anchor, 2);
            }
        } else {
            inst = new NumericBinaryInstruction(JvmPsiRangeSetUtil.binOpFromToken(op), anchor);
        }
        this.addInstruction((Instruction)inst);
    }

    private void acceptBinaryRightOperand(@NotNull IElementType op, PsiExpression lExpr, @Nullable PsiType lType, PsiExpression rExpr, @Nullable PsiType rType) {
        if (op == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(84);
        }
        boolean comparing = op == JavaTokenType.EQEQ || op == JavaTokenType.NE;
        boolean comparingRef = comparing && !TypeConversionUtil.isPrimitiveAndNotNull((PsiType)lType) && !TypeConversionUtil.isPrimitiveAndNotNull((PsiType)rType);
        boolean comparingPrimitiveNumeric = !comparingRef && ComparisonUtils.isComparisonOperation(op) && TypeConversionUtil.isNumericType((PsiType)lType) && TypeConversionUtil.isNumericType((PsiType)rType);
        boolean comparingObjectAndPrimitive = comparing && !comparingRef && !comparingPrimitiveNumeric && (TypeConversionUtil.isNumericType((PsiType)lType) || TypeConversionUtil.isNumericType((PsiType)rType));
        boolean shift = op == JavaTokenType.GTGT || op == JavaTokenType.LTLT || op == JavaTokenType.GTGTGT;
        PsiType leftCast = null;
        PsiType rightCast = null;
        if (comparingObjectAndPrimitive) {
            rightCast = TypeConversionUtil.isNumericType((PsiType)lType) ? rType : lType;
            leftCast = rightCast;
        } else if (shift) {
            leftCast = PsiTypes.longType().equals((Object)PsiPrimitiveType.getOptionallyUnboxedType((PsiType)lType)) ? PsiTypes.longType() : PsiTypes.intType();
            rightCast = PsiTypes.longType().equals((Object)PsiPrimitiveType.getOptionallyUnboxedType((PsiType)rType)) ? PsiTypes.longType() : PsiTypes.intType();
        } else if (!comparingRef) {
            leftCast = rightCast = TypeConversionUtil.unboxAndBalanceTypes((PsiType)lType, (PsiType)rType);
        }
        if (leftCast != null) {
            this.generateBoxingUnboxingInstructionFor((PsiElement)lExpr, lType, leftCast, false);
        }
        rExpr.accept((PsiElementVisitor)this);
        if (rightCast != null) {
            this.generateBoxingUnboxingInstructionFor((PsiElement)rExpr, rType, rightCast, false);
        }
    }

    void generateBoxingUnboxingInstructionFor(@NotNull PsiExpression expression, PsiType expectedType) {
        if (expression == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(85);
        }
        this.generateBoxingUnboxingInstructionFor((PsiElement)expression, expression.getType(), expectedType, false);
    }

    void generateBoxingUnboxingInstructionFor(@NotNull PsiElement context, PsiType actualType, PsiType expectedType, boolean explicit) {
        if (context == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(86);
        }
        if (PsiTypes.voidType().equals((Object)expectedType)) {
            return;
        }
        if (TypeConversionUtil.isPrimitiveAndNotNull((PsiType)expectedType) && TypeConversionUtil.isAssignableFromPrimitiveWrapper((PsiType)ControlFlowAnalyzer.toBound(actualType))) {
            this.addInstruction((Instruction)new GetQualifiedValueInstruction((VariableDescriptor)SpecialField.UNBOX));
            actualType = PsiPrimitiveType.getUnboxedType((PsiType)actualType);
        }
        expectedType = ControlFlowAnalyzer.toBound(expectedType);
        if (TypeConversionUtil.isPrimitiveAndNotNull((PsiType)actualType) && TypeConversionUtil.isAssignableFromPrimitiveWrapper((PsiType)expectedType)) {
            this.addConditionalErrorThrow();
            PsiType boxedType = TypeConversionUtil.isPrimitiveWrapper((PsiType)expectedType) ? expectedType : ((PsiPrimitiveType)actualType).getBoxedType(context);
            PsiPrimitiveType unboxedType = PsiPrimitiveType.getUnboxedType((PsiType)boxedType);
            if (unboxedType != null && !unboxedType.equals((Object)actualType)) {
                this.addInstruction((Instruction)new PrimitiveConversionInstruction(unboxedType, null));
            }
            this.addInstruction((Instruction)new WrapDerivedVariableInstruction(DfTypes.typedObject(boxedType, Nullability.NOT_NULL), (DerivedVariableDescriptor)SpecialField.UNBOX));
        } else if (!Objects.equals(actualType, expectedType) && TypeConversionUtil.isPrimitiveAndNotNull((PsiType)actualType) && TypeConversionUtil.isPrimitiveAndNotNull((PsiType)expectedType) && TypeConversionUtil.isNumericType((PsiType)actualType) && TypeConversionUtil.isNumericType((PsiType)expectedType)) {
            JavaExpressionAnchor javaExpressionAnchor;
            if (explicit && context instanceof PsiExpression) {
                PsiExpression psiExpression = (PsiExpression)context;
                javaExpressionAnchor = new JavaExpressionAnchor(psiExpression);
            } else {
                javaExpressionAnchor = null;
            }
            JavaExpressionAnchor anchor = javaExpressionAnchor;
            this.addInstruction((Instruction)new PrimitiveConversionInstruction((PsiPrimitiveType)expectedType, anchor));
        }
    }

    private static PsiType toBound(PsiType type) {
        PsiWildcardType wildcardType;
        if (type instanceof PsiWildcardType && (wildcardType = (PsiWildcardType)type).isExtends()) {
            return wildcardType.getBound();
        }
        if (type instanceof PsiCapturedWildcardType) {
            PsiCapturedWildcardType capturedWildcardType = (PsiCapturedWildcardType)type;
            return capturedWildcardType.getUpperBound();
        }
        return type;
    }

    private void generateShortCircuitAndOr(PsiExpression expression, PsiExpression[] operands, PsiType exprType, boolean and) {
        ControlFlow.DeferredOffset endOffset = new ControlFlow.DeferredOffset();
        for (int i = 0; i < operands.length; ++i) {
            PsiExpression nextOperand;
            PsiExpression operand = operands[i];
            operand.accept((PsiElementVisitor)this);
            this.generateBoxingUnboxingInstructionFor(operand, exprType);
            PsiExpression psiExpression = nextOperand = i == operands.length - 1 ? null : operands[i + 1];
            if (nextOperand == null) continue;
            ControlFlow.DeferredOffset nextOffset = new ControlFlow.DeferredOffset();
            this.addInstruction((Instruction)new ConditionalGotoInstruction((ControlFlow.ControlFlowOffset)nextOffset, (DfType)DfTypes.booleanValue(and), (PsiElement)operand));
            this.push(DfTypes.booleanValue(!and), expression);
            this.addInstruction((Instruction)new GotoInstruction((ControlFlow.ControlFlowOffset)endOffset));
            nextOffset.setOffset(this.getInstructionCount());
            this.addInstruction((Instruction)new FinishElementInstruction(null));
        }
        endOffset.setOffset(this.getInstructionCount());
        this.addInstruction((Instruction)new ResultOfInstruction((DfaAnchor)new JavaExpressionAnchor(expression)));
    }

    public void visitClassObjectAccessExpression(@NotNull PsiClassObjectAccessExpression expression) {
        if (expression == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(87);
        }
        this.startElement((PsiElement)expression);
        PsiTypeElement operand = expression.getOperand();
        DfConstantType<?> classConstant = DfTypes.referenceConstant((Object)operand.getType(), expression.getType());
        this.push((DfType)classConstant, (PsiExpression)expression);
        this.finishElement((PsiElement)expression);
    }

    public void visitConditionalExpression(@NotNull PsiConditionalExpression expression) {
        if (expression == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(88);
        }
        this.startElement((PsiElement)expression);
        PsiExpression thenExpression = expression.getThenExpression();
        if (thenExpression != null) {
            PsiExpression condition = expression.getCondition();
            PsiExpression elseExpression = expression.getElseExpression();
            ControlFlow.DeferredOffset elseOffset = new ControlFlow.DeferredOffset();
            condition.accept((PsiElementVisitor)this);
            this.generateBoxingUnboxingInstructionFor(condition, (PsiType)PsiTypes.booleanType());
            PsiType type = expression.getType();
            this.addInstruction((Instruction)new ConditionalGotoInstruction((ControlFlow.ControlFlowOffset)elseOffset, (DfType)DfTypes.FALSE, (PsiElement)PsiUtil.skipParenthesizedExprDown((PsiExpression)condition)));
            thenExpression.accept((PsiElementVisitor)this);
            this.generateBoxingUnboxingInstructionFor(thenExpression, type);
            ControlFlow.DeferredOffset endOffset = new ControlFlow.DeferredOffset();
            this.addInstruction((Instruction)new GotoInstruction((ControlFlow.ControlFlowOffset)endOffset));
            elseOffset.setOffset(this.getInstructionCount());
            if (elseExpression != null) {
                elseExpression.accept((PsiElementVisitor)this);
                this.generateBoxingUnboxingInstructionFor(elseExpression, type);
            } else {
                this.pushUnknown();
            }
            endOffset.setOffset(this.getInstructionCount());
        } else {
            this.pushUnknown();
        }
        this.finishElement((PsiElement)expression);
    }

    void pushUnknown() {
        this.addInstruction((Instruction)new PushValueInstruction(DfType.TOP, null));
    }

    public void visitInstanceOfExpression(@NotNull PsiInstanceOfExpression expression) {
        if (expression == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(89);
        }
        this.startElement((PsiElement)expression);
        PsiPrimaryPattern pattern = expression.getPattern();
        PsiExpression operand = expression.getOperand();
        PsiType operandType = operand.getType();
        PsiTypeElement checkType = InstanceOfUtils.findCheckTypeElement(expression);
        CFGBuilder builder = new CFGBuilder(this);
        if (pattern == null) {
            if (checkType == null || operandType == null) {
                this.pushUnknown();
            } else {
                this.buildSimpleInstanceof(builder, expression, operand, operandType, checkType);
            }
        } else if (operandType != null) {
            builder.pushForWrite(this.createTempVariable(operand.getType())).pushExpression(operand).assign();
            this.processPatternInInstanceof((PsiPattern)pattern, expression, operandType);
        } else {
            this.pushUnknown();
        }
        this.finishElement((PsiElement)expression);
    }

    private void buildSimpleInstanceof(@NotNull CFGBuilder builder, @NotNull PsiInstanceOfExpression expression, @NotNull PsiExpression operand, @NotNull PsiType operandType, @NotNull PsiTypeElement checkType) {
        if (builder == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(90);
        }
        if (expression == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(91);
        }
        if (operand == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(92);
        }
        if (operandType == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(93);
        }
        if (checkType == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(94);
        }
        PsiType type = checkType.getType();
        builder.pushExpression(operand);
        this.generateInstanceOfInstructions((PsiElement)expression, new JavaExpressionAnchor((PsiExpression)expression), operandType, type);
    }

    void addMethodThrows(@Nullable PsiMember methodOrClass) {
        if (this.myTrapTracker.shouldHandleException()) {
            if (methodOrClass == null) {
                DfaControlTransferValue transfer = this.myTrapTracker.transferValue("java.lang.Throwable");
                this.addInstruction((Instruction)new EnsureInstruction(null, RelationType.EQ, DfType.TOP, transfer));
            } else {
                List<Object> list;
                if (methodOrClass instanceof PsiMethod) {
                    PsiMethod method = (PsiMethod)methodOrClass;
                    list = Arrays.asList(method.getThrowsList().getReferencedTypes());
                } else {
                    list = List.of();
                }
                this.addThrows(list);
            }
        }
    }

    private void addThrows(Collection<? extends PsiType> exceptions) {
        StreamEx allExceptions = StreamEx.of((Object[])new String[]{"java.lang.Error", "java.lang.RuntimeException"}).map(fqn -> this.myTrapTracker.transfer((String)fqn).getThrowable());
        if (!exceptions.isEmpty()) {
            allExceptions = ((TypeConstraint)((StreamEx)allExceptions.append((Stream)StreamEx.of(exceptions).map(TypeConstraints::instanceOf))).map(TypeConstraint::tryNegate).nonNull().reduce((Object)TypeConstraints.TOP, TypeConstraint::meet)).notInstanceOfTypes().map(TypeConstraint.Exact::instanceOf);
        }
        allExceptions.map(exc -> this.myTrapTracker.transferValue(new ExceptionTransfer((TypeConstraint)exc))).map(transfer -> new EnsureInstruction(null, RelationType.EQ, DfType.TOP, transfer)).forEach(this::addInstruction);
    }

    void throwException(@Nullable PsiType ref, @Nullable PsiElement anchor) {
        if (ref != null) {
            DfaControlTransferValue value = this.myTrapTracker.transferValue(new ExceptionTransfer(TypeConstraints.instanceOf(ref)));
            this.addInstruction((Instruction)new ThrowInstruction(value, anchor));
        }
    }

    public void visitMethodCallExpression(@NotNull PsiMethodCallExpression call) {
        ArrayDeque<PsiMethodCallExpression> calls;
        block8: {
            PsiExpression qualifierExpression;
            if (call == null) {
                ControlFlowAnalyzer.$$$reportNull$$$0(95);
            }
            calls = new ArrayDeque<PsiMethodCallExpression>();
            do {
                calls.addFirst(call);
                this.startElement((PsiElement)call);
                if (this.tryInline(call)) {
                    this.finishElement((PsiElement)call);
                    calls.removeFirst();
                } else {
                    qualifierExpression = call.getMethodExpression().getQualifierExpression();
                    if (qualifierExpression == null) {
                        DfaValue thisVariable = JavaDfaValueFactory.getQualifierOrThisValue(this.myFactory, call.getMethodExpression());
                        if (thisVariable != null) {
                            this.addInstruction((Instruction)new PushInstruction(thisVariable, null));
                        } else {
                            this.pushUnknown();
                        }
                    } else {
                        if (qualifierExpression.isPhysical() || !call.isPhysical()) continue;
                        this.pushUnknown();
                    }
                }
                break block8;
            } while ((call = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)qualifierExpression), PsiMethodCallExpression.class)) != null);
            qualifierExpression.accept((PsiElementVisitor)this);
        }
        calls.forEach(this::finishCall);
    }

    private boolean tryInline(PsiMethodCallExpression call) {
        if (this.myInlining) {
            for (CallInliner inliner : INLINERS) {
                if (!inliner.tryInlineCall(new CFGBuilder(this), call)) continue;
                this.addNullCheck((PsiExpression)call);
                return true;
            }
        }
        return false;
    }

    private void finishCall(PsiMethodCallExpression call) {
        PsiParameter[] parameters;
        PsiExpression[] expressions = call.getArgumentList().getExpressions();
        PsiReferenceExpression methodExpression = call.getMethodExpression();
        JavaResolveResult result = methodExpression.advancedResolve(false);
        PsiMethod method = (PsiMethod)ObjectUtils.tryCast((Object)result.getElement(), PsiMethod.class);
        PsiParameter[] psiParameterArray = parameters = method != null ? method.getParameterList().getParameters() : null;
        if (method != null && ConsumedStreamUtils.isCheckedCallForConsumedStream(method)) {
            this.addConsumedStreamCheckInstructions(methodExpression.getQualifierExpression(), "java.lang.IllegalStateException");
        }
        for (int i = 0; i < expressions.length; ++i) {
            PsiExpression paramExpr = expressions[i];
            paramExpr.accept((PsiElementVisitor)this);
            if (parameters == null || i >= parameters.length) continue;
            this.generateBoxingUnboxingInstructionFor(paramExpr, result.getSubstitutor().substitute(parameters[i].getType()));
        }
        this.foldVarArgs((PsiCall)call, parameters);
        this.addBareCall(call, methodExpression);
        this.finishElement((PsiElement)call);
    }

    void addBareCall(@Nullable PsiMethodCallExpression expression, @NotNull PsiReferenceExpression reference) {
        PsiReferenceExpression anchor;
        List contracts;
        if (reference == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(96);
        }
        this.addConditionalErrorThrow();
        PsiMethod method = (PsiMethod)ObjectUtils.tryCast((Object)reference.resolve(), PsiMethod.class);
        List<Object> list = contracts = method == null ? Collections.emptyList() : DfaUtil.addRangeContracts(method, JavaMethodContractUtil.getMethodCallContracts(method, (PsiCallExpression)expression));
        if (expression == null) {
            assert (reference instanceof PsiMethodReferenceExpression);
            this.addInstruction((Instruction)new MethodCallInstruction((PsiMethodReferenceExpression)reference, contracts));
            anchor = reference;
        } else {
            if (ExpressionUtils.isVoidContext((PsiExpression)expression) && ContainerUtil.all(contracts, c -> c.getReturnValue() != ContractReturnValue.fail() && !(c.getReturnValue() instanceof ContractReturnValue.ParameterReturnValue))) {
                contracts = Collections.emptyList();
            }
            this.addInstruction((Instruction)new MethodCallInstruction((PsiCall)expression, contracts));
            anchor = expression;
        }
        this.processFailResult(method, contracts, (PsiExpression)anchor);
        this.addMethodThrows((PsiMember)method);
        if (expression != null) {
            this.addNullCheck((PsiExpression)expression);
        }
    }

    private void processFailResult(@Nullable PsiMethod method, @NotNull List<? extends MethodContract> contracts, @NotNull PsiExpression anchor) {
        if (contracts == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(97);
        }
        if (anchor == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(98);
        }
        if (CustomMethodHandlers.isConstantCall(method) && !PsiTypes.booleanType().equals((Object)method.getReturnType()) || ContainerUtil.exists(contracts, c -> c.getReturnValue().isFail())) {
            DfaControlTransferValue transfer = this.createTransfer("java.lang.Throwable");
            this.addInstruction((Instruction)new EnsureInstruction((UnsatisfiedConditionProblem)new ContractFailureProblem(anchor), RelationType.NE, DfType.FAIL, transfer));
        }
    }

    @Nullable
    DfaControlTransferValue createTransfer(@NotNull String exception) {
        if (exception == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(99);
        }
        return this.myTrapTracker.maybeTransferValue(exception);
    }

    public void visitEnumConstant(@NotNull PsiEnumConstant enumConstant) {
        if (enumConstant == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(100);
        }
        if (enumConstant.getArgumentList() == null) {
            return;
        }
        this.pushUnknown();
        this.pushConstructorArguments((PsiConstructorCall)enumConstant);
        this.addInstruction((Instruction)new MethodCallInstruction((PsiCall)enumConstant, Collections.emptyList()));
        this.addInstruction((Instruction)new PopInstruction());
    }

    public void visitNewExpression(@NotNull PsiNewExpression expression) {
        if (expression == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(101);
        }
        this.startElement((PsiElement)expression);
        PsiType type = expression.getType();
        if (type instanceof PsiArrayType) {
            PsiArrayInitializerExpression arrayInitializer = expression.getArrayInitializer();
            if (arrayInitializer != null) {
                this.initializeArray(arrayInitializer, (PsiExpression)expression);
                return;
            }
            PsiExpression[] dimensions = expression.getArrayDimensions();
            int dims = dimensions.length;
            if (dims > 0) {
                for (PsiExpression dimension : dimensions) {
                    dimension.accept((PsiElementVisitor)this);
                    this.generateBoxingUnboxingInstructionFor(dimension, (PsiType)PsiTypes.intType());
                }
                DfaControlTransferValue transfer = this.createTransfer("java.lang.NegativeArraySizeException");
                for (int i = dims - 1; i >= 0; --i) {
                    this.addInstruction((Instruction)new EnsureInstruction((UnsatisfiedConditionProblem)new NegativeArraySizeProblem(dimensions[i]), RelationType.GE, (DfType)DfTypes.intValue(0), transfer, true));
                    if (i == 0) continue;
                    this.addInstruction((Instruction)new PopInstruction());
                }
            } else {
                this.pushUnknown();
            }
            DfType arrayValue = TypeConstraints.exact(type).asDfType().meet((DfType)DfTypes.LOCAL_OBJECT);
            this.addInstruction((Instruction)new WrapDerivedVariableInstruction(arrayValue, (DerivedVariableDescriptor)SpecialField.ARRAY_LENGTH, (DfaAnchor)new JavaExpressionAnchor((PsiExpression)expression)));
            this.initializeSmallArray((PsiArrayType)type, dimensions);
        } else {
            PsiExpression qualifier = expression.getQualifier();
            if (qualifier != null) {
                qualifier.accept((PsiElementVisitor)this);
            } else {
                PsiClass outerClass;
                DfaTypeValue qualifierValue = this.myFactory.getUnknown();
                PsiClass aClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)type);
                if (aClass != null && !aClass.hasModifierProperty("static") && (outerClass = aClass.getContainingClass()) != null && InheritanceUtil.hasEnclosingInstanceInScope((PsiClass)outerClass, (PsiElement)expression, (boolean)true, (boolean)false)) {
                    qualifierValue = ThisDescriptor.createThisValue(this.myFactory, outerClass);
                }
                this.addInstruction((Instruction)new PushInstruction((DfaValue)qualifierValue, null));
            }
            PsiMember constructorOrClass = this.pushConstructorArguments((PsiConstructorCall)expression);
            PsiMethod constructor = (PsiMethod)ObjectUtils.tryCast((Object)constructorOrClass, PsiMethod.class);
            PsiAnonymousClass anonymousClass = expression.getAnonymousClass();
            if (anonymousClass != null) {
                this.handleClosure((PsiElement)anonymousClass);
            }
            this.addConditionalErrorThrow();
            List<Object> contracts = constructor == null ? Collections.emptyList() : JavaMethodContractUtil.getMethodCallContracts(constructor, null);
            contracts = DfaUtil.addRangeContracts(constructor, contracts);
            this.addInstruction((Instruction)new MethodCallInstruction((PsiCall)expression, contracts));
            this.processFailResult(constructor, contracts, (PsiExpression)expression);
            this.addMethodThrows(constructorOrClass);
        }
        this.finishElement((PsiElement)expression);
    }

    private void initializeSmallArray(PsiArrayType type, PsiExpression[] dimensions) {
        int lengthValue;
        if (dimensions.length != 1) {
            return;
        }
        PsiType componentType = type.getComponentType();
        if (!(componentType instanceof PsiPrimitiveType)) {
            return;
        }
        Object val = ExpressionUtils.computeConstantExpression(dimensions[0]);
        if (val instanceof Integer && (lengthValue = ((Integer)val).intValue()) > 0 && lengthValue <= 3) {
            DfaVariableValue var = this.createTempVariable((PsiType)type);
            this.addInstruction((Instruction)new SimpleAssignmentInstruction(null, var));
            this.addInstruction((Instruction)new PushValueInstruction(DfTypes.defaultValue(componentType)));
            for (int i = lengthValue - 1; i >= 0; --i) {
                DfaValue value = ArrayElementDescriptor.getArrayElementValue(this.getFactory(), (DfaValue)var, i);
                if (!(value instanceof DfaVariableValue)) continue;
                this.addInstruction((Instruction)new SimpleAssignmentInstruction(null, (DfaVariableValue)value));
            }
            this.addInstruction((Instruction)new PopInstruction());
        }
    }

    @Nullable
    private PsiMember pushConstructorArguments(PsiConstructorCall call) {
        PsiExpressionList args = call.getArgumentList();
        PsiMethod ctr = call.resolveConstructor();
        PsiSubstitutor substitutor = PsiSubstitutor.EMPTY;
        if (call instanceof PsiNewExpression) {
            PsiNewExpression newExpression = (PsiNewExpression)call;
            if (ctr == null) {
                PsiJavaCodeReferenceElement classRef = newExpression.getClassReference();
                ctr = classRef == null ? null : (PsiMember)ObjectUtils.tryCast((Object)classRef.resolve(), PsiClass.class);
            }
            substitutor = call.resolveMethodGenerics().getSubstitutor();
        }
        if (args != null) {
            PsiParameter[] psiParameterArray;
            PsiExpression[] arguments = args.getExpressions();
            if (ctr instanceof PsiMethod) {
                PsiMethod method = ctr;
                psiParameterArray = method.getParameterList().getParameters();
            } else {
                psiParameterArray = null;
            }
            PsiParameter[] parameters = psiParameterArray;
            for (int i = 0; i < arguments.length; ++i) {
                PsiExpression argument = arguments[i];
                argument.accept((PsiElementVisitor)this);
                if (parameters == null || i >= parameters.length) continue;
                this.generateBoxingUnboxingInstructionFor(argument, substitutor.substitute(parameters[i].getType()));
            }
            this.foldVarArgs((PsiCall)call, parameters);
        }
        return ctr;
    }

    private void foldVarArgs(PsiCall call, PsiParameter[] parameters) {
        int arraySize;
        if (!MethodCallUtils.isVarArgCall(call)) {
            return;
        }
        PsiExpressionList args = call.getArgumentList();
        if (args == null) {
            return;
        }
        PsiParameter lastParameter = (PsiParameter)ArrayUtil.getLastElement((Object[])parameters);
        if (lastParameter != null && lastParameter.isVarArgs() && (arraySize = args.getExpressionCount() - parameters.length + 1) >= 0) {
            this.addInstruction((Instruction)new FoldArrayInstruction(null, DfTypes.typedObject(lastParameter.getType(), Nullability.NOT_NULL), arraySize));
        }
    }

    public void visitParenthesizedExpression(@NotNull PsiParenthesizedExpression expression) {
        if (expression == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(102);
        }
        this.startElement((PsiElement)expression);
        PsiExpression inner = expression.getExpression();
        if (inner != null) {
            inner.accept((PsiElementVisitor)this);
        } else {
            this.pushUnknown();
        }
        this.finishElement((PsiElement)expression);
    }

    public void visitPostfixExpression(@NotNull PsiPostfixExpression expression) {
        if (expression == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(103);
        }
        this.startElement((PsiElement)expression);
        PsiExpression operand = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression.getOperand());
        if (operand != null) {
            this.processIncrementDecrement((PsiUnaryExpression)expression, operand, true);
        } else {
            this.pushUnknown();
        }
        this.finishElement((PsiElement)expression);
    }

    private void processIncrementDecrement(PsiUnaryExpression expression, PsiExpression operand, boolean postIncrement) {
        PsiPrimitiveType unboxedType;
        LongRangeBinOp token;
        IElementType exprTokenType = expression.getOperationTokenType();
        if (exprTokenType.equals(JavaTokenType.MINUSMINUS)) {
            token = LongRangeBinOp.MINUS;
        } else if (exprTokenType.equals(JavaTokenType.PLUSPLUS)) {
            token = LongRangeBinOp.PLUS;
        } else {
            throw new IllegalArgumentException("Unexpected token: " + String.valueOf(exprTokenType));
        }
        PsiType operandType = operand.getType();
        PsiArrayAccessExpression arrayStore = (PsiArrayAccessExpression)ObjectUtils.tryCast((Object)operand, PsiArrayAccessExpression.class);
        if (arrayStore == null) {
            operand.accept((PsiElementVisitor)this);
            this.addInstruction((Instruction)new DupInstruction());
        } else {
            this.pushArrayAndIndex(arrayStore);
            this.addInstruction((Instruction)new SpliceInstruction(2, new int[]{1, 0, 1, 0}));
            this.readArrayElement(arrayStore);
        }
        if (postIncrement) {
            if (arrayStore != null) {
                this.addInstruction((Instruction)new SpliceInstruction(3, new int[]{0, 2, 1, 0}));
            } else {
                this.addInstruction((Instruction)new SpliceInstruction(2, new int[]{0, 1, 0}));
            }
        }
        if ((unboxedType = PsiPrimitiveType.getOptionallyUnboxedType((PsiType)operandType)) == null) {
            this.addInstruction((Instruction)new PopInstruction());
            this.pushUnknown();
        } else {
            this.generateBoxingUnboxingInstructionFor(operand, (PsiType)unboxedType);
            PsiType resultType = TypeConversionUtil.binaryNumericPromotion((PsiType)unboxedType, (PsiType)PsiTypes.intType());
            Object addend = TypeConversionUtil.computeCastTo((Object)1, (PsiType)resultType);
            this.addInstruction((Instruction)new PushValueInstruction(DfTypes.primitiveConstant(addend)));
            this.addInstruction((Instruction)new NumericBinaryInstruction(token, null));
            if (!unboxedType.equals((Object)resultType)) {
                this.addInstruction((Instruction)new PrimitiveConversionInstruction(unboxedType, null));
            }
            if (!(operandType instanceof PsiPrimitiveType)) {
                this.addInstruction((Instruction)new WrapDerivedVariableInstruction(DfTypes.typedObject(operandType, Nullability.NOT_NULL), (DerivedVariableDescriptor)SpecialField.UNBOX));
            }
        }
        DfaValue dest = JavaDfaValueFactory.getExpressionDfaValue(this.myFactory, operand);
        if (arrayStore != null) {
            ArrayElementDescriptor staticDescriptor = ArrayElementDescriptor.fromArrayAccess(arrayStore);
            this.addInstruction((Instruction)new JavaArrayStoreInstruction(arrayStore, null, null, (VariableDescriptor)staticDescriptor));
        } else {
            this.addInstruction((Instruction)new AssignInstruction(operand, null, dest));
        }
        if (postIncrement) {
            this.addInstruction((Instruction)new PopInstruction());
        }
        this.addInstruction((Instruction)new ResultOfInstruction((DfaAnchor)new JavaExpressionAnchor((PsiExpression)expression)));
    }

    public void visitPrefixExpression(@NotNull PsiPrefixExpression expression) {
        DfaValue dfaValue;
        if (expression == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(104);
        }
        this.startElement((PsiElement)expression);
        DfaValue dfaValue2 = dfaValue = expression.getOperationTokenType() == JavaTokenType.EXCL ? null : JavaDfaValueFactory.getExpressionDfaValue(this.myFactory, (PsiExpression)expression);
        if (dfaValue != null) {
            this.push(dfaValue, (PsiExpression)expression);
        } else {
            PsiExpression operand = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression.getOperand());
            if (operand == null) {
                this.pushUnknown();
            } else if (PsiUtil.isIncrementDecrementOperation((PsiElement)expression)) {
                this.processIncrementDecrement((PsiUnaryExpression)expression, operand, false);
            } else {
                operand.accept((PsiElementVisitor)this);
                PsiType type = expression.getType();
                PsiPrimitiveType unboxed = PsiPrimitiveType.getUnboxedType((PsiType)type);
                this.generateBoxingUnboxingInstructionFor(operand, (PsiType)(unboxed == null ? type : unboxed));
                if (expression.getOperationTokenType() == JavaTokenType.EXCL) {
                    this.addInstruction((Instruction)new NotInstruction(new JavaExpressionAnchor((PsiExpression)expression)));
                } else if (expression.getOperationTokenType() == JavaTokenType.MINUS && (PsiTypes.intType().equals((Object)type) || PsiTypes.longType().equals((Object)type))) {
                    this.addInstruction((Instruction)new PushValueInstruction(DfTypes.defaultValue(type)));
                    this.addInstruction((Instruction)new SwapInstruction());
                    this.addInstruction((Instruction)new NumericBinaryInstruction(LongRangeBinOp.MINUS, new JavaExpressionAnchor((PsiExpression)expression)));
                } else {
                    this.addInstruction((Instruction)new PopInstruction());
                    this.pushUnknown();
                }
            }
        }
        this.finishElement((PsiElement)expression);
    }

    public void visitReferenceExpression(@NotNull PsiReferenceExpression expression) {
        if (expression == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(105);
        }
        this.startElement((PsiElement)expression);
        this.pushReferenceExpression(expression);
        this.addNullCheck((PsiExpression)expression);
        this.finishElement((PsiElement)expression);
    }

    private void pushReferenceExpression(@NotNull PsiReferenceExpression expression) {
        PsiReferenceExpression ref;
        PsiField field;
        DfaValue constValue;
        boolean writing;
        if (expression == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(106);
        }
        JavaExpressionAnchor anchor = new JavaExpressionAnchor((PsiExpression)expression);
        PsiVariable var = (PsiVariable)ObjectUtils.tryCast((Object)expression.resolve(), PsiVariable.class);
        boolean bl = writing = PsiUtil.isAccessedForWriting((PsiExpression)expression) && !PsiUtil.isAccessedForReading((PsiExpression)expression);
        if (!(writing || var == null || PlainDescriptor.hasInitializationHacks(var) || (constValue = JavaDfaValueFactory.getConstantFromVariable(this.myFactory, var)) == null || JavaDfaValueFactory.maybeUninitializedConstant(constValue, expression, (PsiModifierListOwner)var))) {
            this.addInstruction((Instruction)new PushInstruction(constValue, (DfaAnchor)anchor));
            return;
        }
        PsiExpression qualifierExpression = expression.getQualifierExpression();
        if (var instanceof PsiField && !(field = (PsiField)var).hasModifierProperty("static") && !writing) {
            DfaVariableValue qualifierVar;
            DfaValue effectiveQualifier = JavaDfaValueFactory.getQualifierOrThisValue(this.myFactory, expression);
            if (qualifierExpression == null) {
                this.addInstruction((Instruction)new PushInstruction((DfaValue)(effectiveQualifier == null ? this.myFactory.getUnknown() : effectiveQualifier), null));
            } else {
                qualifierExpression.accept((PsiElementVisitor)this);
            }
            VariableDescriptor descriptor = Objects.requireNonNull(JavaDfaValueFactory.getAccessedVariableOrGetter((PsiElement)field));
            if (effectiveQualifier instanceof DfaVariableValue && JavaDfaHelpers.mayLeakFromType(descriptor.getDfType(qualifierVar = (DfaVariableValue)effectiveQualifier)) && JavaDfaHelpers.mayLeakFromExpression((PsiExpression)expression)) {
                this.addInstruction(new EscapeInstruction(List.of(qualifierVar.getDescriptor())));
            }
            this.addInstruction((Instruction)new GetQualifiedValueInstruction(descriptor, (DfaAnchor)anchor));
            return;
        }
        if (!(qualifierExpression == null || qualifierExpression instanceof PsiReferenceExpression && (ref = (PsiReferenceExpression)qualifierExpression).resolve() instanceof PsiClass)) {
            qualifierExpression.accept((PsiElementVisitor)this);
            this.addInstruction((Instruction)new PopInstruction());
        }
        DfaValue value = JavaDfaValueFactory.getExpressionDfaValue(this.myFactory, (PsiExpression)expression);
        if (writing) {
            this.addInstruction((Instruction)new JvmPushForWriteInstruction((DfaValue)(value == null ? this.myFactory.getUnknown() : value)));
        } else {
            this.addInstruction((Instruction)new PushInstruction((DfaValue)(value == null ? this.myFactory.getUnknown() : value), (DfaAnchor)anchor));
        }
    }

    public void visitLiteralExpression(@NotNull PsiLiteralExpression expression) {
        if (expression == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(107);
        }
        this.startElement((PsiElement)expression);
        DfType dfType = DfaPsiUtil.fromLiteral(expression);
        this.push(dfType, (PsiExpression)expression);
        if (dfType == DfTypes.NULL) {
            this.addNullCheck((PsiExpression)expression);
        }
        this.finishElement((PsiElement)expression);
    }

    public void visitTypeCastExpression(@NotNull PsiTypeCastExpression castExpression) {
        PsiType operandType;
        if (castExpression == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(108);
        }
        this.startElement((PsiElement)castExpression);
        PsiExpression operand = castExpression.getOperand();
        PsiType psiType = operandType = operand == null ? null : operand.getType();
        if (operand != null) {
            operand.accept((PsiElementVisitor)this);
            this.generateBoxingUnboxingInstructionFor((PsiElement)castExpression, operandType, castExpression.getType(), true);
        } else {
            this.addInstruction((Instruction)new PushValueInstruction(DfTypes.typedObject(castExpression.getType(), Nullability.UNKNOWN)));
        }
        PsiTypeElement typeElement = castExpression.getCastType();
        if (!(typeElement == null || operandType == null || typeElement.getType() instanceof PsiPrimitiveType || operandType instanceof PsiLambdaExpressionType || operandType instanceof PsiMethodReferenceType)) {
            DfaControlTransferValue transfer = this.createTransfer("java.lang.ClassCastException");
            this.addInstruction((Instruction)new TypeCastInstruction(castExpression, operand, typeElement.getType(), transfer));
        } else {
            this.addInstruction((Instruction)new ResultOfInstruction((DfaAnchor)new JavaExpressionAnchor((PsiExpression)castExpression)));
        }
        this.finishElement((PsiElement)castExpression);
    }

    public void visitClass(@NotNull PsiClass aClass) {
        if (aClass == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(109);
        }
    }

    @Contract(value="null -> false")
    final boolean wasAdded(PsiElement element) {
        return element != null && this.myCurrentFlow.getStartOffset(element).getInstructionOffset() > -1 && this.myCurrentFlow.getEndOffset(element).getInstructionOffset() > -1;
    }

    public void removeLambda(@NotNull PsiLambdaExpression lambda) {
        if (lambda == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(110);
        }
        int start = this.myCurrentFlow.getStartOffset((PsiElement)lambda).getInstructionOffset();
        int end = this.myCurrentFlow.getEndOffset((PsiElement)lambda).getInstructionOffset();
        for (int i = start; i < end; ++i) {
            Instruction inst = this.myCurrentFlow.getInstruction(i);
            if (!(inst instanceof EscapeInstruction) && !(inst instanceof ClosureInstruction)) continue;
            this.myCurrentFlow.makeNop(i);
        }
    }

    void inlineBlock(@NotNull PsiCodeBlock block, @NotNull Nullability resultNullability, @NotNull DfaVariableValue target, @Nullable PsiType type) {
        if (block == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(111);
        }
        if (resultNullability == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(112);
        }
        if (target == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(113);
        }
        this.enterExpressionBlock(block, resultNullability, target, type);
        block.accept((PsiElementVisitor)this);
        this.exitExpressionBlock();
    }

    private void enterExpressionBlock(@NotNull PsiCodeBlock block, @NotNull Nullability resultNullability, @NotNull DfaVariableValue target, @Nullable PsiType type) {
        if (block == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(114);
        }
        if (resultNullability == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(115);
        }
        if (target == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(116);
        }
        this.pushTrap(new InsideInlinedBlockTrap((PsiElement)block));
        this.addInstruction((Instruction)new PushInstruction((DfaValue)this.myFactory.controlTransfer(DfaControlTransferValue.RETURN_TRANSFER, FList.emptyList()), null));
        this.myExpressionBlockContext = new ExpressionBlockContext(this.myExpressionBlockContext, block, resultNullability == Nullability.NOT_NULL, target, type);
        this.startElement((PsiElement)block);
    }

    private void exitExpressionBlock() {
        this.finishElement((PsiElement)this.myExpressionBlockContext.myCodeBlock);
        this.myExpressionBlockContext = this.myExpressionBlockContext.myPreviousBlock;
        this.popTrap(InsideInlinedBlockTrap.class);
        this.addInstruction((Instruction)new PopInstruction());
    }

    private static List<PsiElement> getClosures(@NotNull PsiClass nestedClass) {
        if (nestedClass == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(117);
        }
        ArrayList<PsiElement> closures = new ArrayList<PsiElement>();
        closures.add((PsiElement)nestedClass);
        for (PsiMethod method : nestedClass.getMethods()) {
            PsiCodeBlock body = method.getBody();
            if (body == null || !method.isPhysical() && nestedClass.isPhysical()) continue;
            closures.add((PsiElement)body);
        }
        return closures;
    }

    void addCustomNullabilityProblem(@NotNull PsiExpression expression, @NotNull NullabilityProblemKind<? super PsiExpression> problem) {
        if (expression == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(118);
        }
        if (problem == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(119);
        }
        this.myCustomNullabilityProblems.put(expression, problem);
    }

    void removeCustomNullabilityProblem(@NotNull PsiExpression expression) {
        if (expression == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(120);
        }
        this.myCustomNullabilityProblems.remove(expression);
    }

    @NotNull
    DfaVariableValue createTempVariable(@Nullable PsiType type) {
        DfType dfType = type == null ? DfType.BOTTOM : DfTypes.typedObject(type, Nullability.UNKNOWN);
        DfaVariableValue dfaVariableValue = this.myCurrentFlow.createTempVariable(dfType);
        if (dfaVariableValue == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(121);
        }
        return dfaVariableValue;
    }

    public static boolean inlinerMayInferPreciseType(PsiExpression expression) {
        return ContainerUtil.exists((Object[])INLINERS, inliner -> inliner.mayInferPreciseType(expression));
    }

    @Nullable
    public static ControlFlow buildFlow(@NotNull PsiElement psiBlock, @NotNull DfaValueFactory targetFactory, boolean useInliners) {
        if (psiBlock == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(122);
        }
        if (targetFactory == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(123);
        }
        if (!useInliners) {
            return new ControlFlowAnalyzer(targetFactory, psiBlock, false).buildControlFlow();
        }
        return DataFlowIRProvider.forElement((PsiElement)psiBlock, (DfaValueFactory)targetFactory);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 121 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueFactory";
                break;
            }
            case 1: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "codeFragment";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: 
            case 16: 
            case 30: 
            case 36: 
            case 38: 
            case 40: 
            case 46: 
            case 66: 
            case 68: 
            case 69: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 85: 
            case 87: 
            case 88: 
            case 89: 
            case 91: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 118: 
            case 120: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 6: 
            case 7: 
            case 13: 
            case 14: 
            case 15: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 34: 
            case 67: 
            case 70: 
            case 71: 
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initializer";
                break;
            }
            case 11: 
            case 111: 
            case 114: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statements";
                break;
            }
            case 17: 
            case 113: 
            case 116: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "switchStmt";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dfType";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "switchBlock";
                break;
            }
            case 42: 
            case 45: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressionValue";
                break;
            }
            case 44: 
            case 47: 
            case 49: 
            case 53: 
            case 59: 
            case 61: 
            case 64: 
            case 94: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checkType";
                break;
            }
            case 48: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourcePattern";
                break;
            }
            case 50: 
            case 54: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endPatternOffset";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "innerPattern";
                break;
            }
            case 55: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patternDfaVar";
                break;
            }
            case 60: 
            case 63: 
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patternType";
                break;
            }
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceList";
                break;
            }
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 80: 
            case 81: 
            case 83: 
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "op";
                break;
            }
            case 82: 
            case 98: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 90: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 92: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operand";
                break;
            }
            case 93: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operandType";
                break;
            }
            case 95: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 96: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 97: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contracts";
                break;
            }
            case 99: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exception";
                break;
            }
            case 100: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enumConstant";
                break;
            }
            case 108: {
                objectArray2 = objectArray3;
                objectArray3[0] = "castExpression";
                break;
            }
            case 109: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 110: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lambda";
                break;
            }
            case 112: 
            case 115: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultNullability";
                break;
            }
            case 117: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nestedClass";
                break;
            }
            case 119: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problem";
                break;
            }
            case 121: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/java/ControlFlowAnalyzer";
                break;
            }
            case 122: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiBlock";
                break;
            }
            case 123: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetFactory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/java/ControlFlowAnalyzer";
                break;
            }
            case 121: {
                objectArray = objectArray2;
                objectArray2[1] = "createTempVariable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "startElement";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "finishElement";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "visitErrorElement";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "visitAssignmentExpression";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "visitAssertStatement";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "visitDeclarationStatement";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "visitField";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "visitClassInitializer";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "visitCodeFragment";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "visitCodeBlock";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "flushCodeBlockVariables";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "visitBlockStatement";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "visitBreakStatement";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "visitYieldStatement";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "addNullCheck";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "controlTransfer";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "visitContinueStatement";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "visitDoWhileStatement";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "visitEmptyStatement";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "visitExpressionStatement";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "visitExpressionListStatement";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "visitForeachPatternStatement";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "visitForeachStatement";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "processForeach";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "visitForStatement";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "visitIfStatement";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "visitStatement";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "visitLabeledStatement";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "visitLambdaExpression";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "visitReturnStatement";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "visitSwitchLabelStatement";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "visitDefaultCaseLabelElement";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "visitSwitchLabeledRuleStatement";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "visitSwitchStatement";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "visitSwitchExpression";
                break;
            }
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "push";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "processSwitch";
                break;
            }
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "processPatternInSwitch";
                break;
            }
            case 45: 
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "processPatternInInstanceof";
                break;
            }
            case 48: 
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "processPattern";
                break;
            }
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "addTypeCheckPattern";
                break;
            }
            case 56: 
            case 57: 
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "addPatternTypeTest";
                break;
            }
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "generateInstanceOfInstructions";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "isUnresolvedType";
                break;
            }
            case 63: 
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "generateExactTestingConversion";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "visitMethodReferenceExpression";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "visitSynchronizedStatement";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "visitTemplateExpression";
                break;
            }
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "processConcatTemplate";
                break;
            }
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "visitThrowStatement";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "visitTryStatement";
                break;
            }
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "visitResourceList";
                break;
            }
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "visitWhileStatement";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "visitExpressionList";
                break;
            }
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "visitExpression";
                break;
            }
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "visitArrayAccessExpression";
                break;
            }
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "readArrayElement";
                break;
            }
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "visitArrayInitializerExpression";
                break;
            }
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "visitPolyadicExpression";
                break;
            }
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "generateBinOpChain";
                break;
            }
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "addImplicitToStringThrows";
                break;
            }
            case 82: 
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "generateBinOp";
                break;
            }
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "acceptBinaryRightOperand";
                break;
            }
            case 85: 
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "generateBoxingUnboxingInstructionFor";
                break;
            }
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "visitClassObjectAccessExpression";
                break;
            }
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "visitConditionalExpression";
                break;
            }
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "visitInstanceOfExpression";
                break;
            }
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "buildSimpleInstanceof";
                break;
            }
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "visitMethodCallExpression";
                break;
            }
            case 96: {
                objectArray = objectArray;
                objectArray[2] = "addBareCall";
                break;
            }
            case 97: 
            case 98: {
                objectArray = objectArray;
                objectArray[2] = "processFailResult";
                break;
            }
            case 99: {
                objectArray = objectArray;
                objectArray[2] = "createTransfer";
                break;
            }
            case 100: {
                objectArray = objectArray;
                objectArray[2] = "visitEnumConstant";
                break;
            }
            case 101: {
                objectArray = objectArray;
                objectArray[2] = "visitNewExpression";
                break;
            }
            case 102: {
                objectArray = objectArray;
                objectArray[2] = "visitParenthesizedExpression";
                break;
            }
            case 103: {
                objectArray = objectArray;
                objectArray[2] = "visitPostfixExpression";
                break;
            }
            case 104: {
                objectArray = objectArray;
                objectArray[2] = "visitPrefixExpression";
                break;
            }
            case 105: {
                objectArray = objectArray;
                objectArray[2] = "visitReferenceExpression";
                break;
            }
            case 106: {
                objectArray = objectArray;
                objectArray[2] = "pushReferenceExpression";
                break;
            }
            case 107: {
                objectArray = objectArray;
                objectArray[2] = "visitLiteralExpression";
                break;
            }
            case 108: {
                objectArray = objectArray;
                objectArray[2] = "visitTypeCastExpression";
                break;
            }
            case 109: {
                objectArray = objectArray;
                objectArray[2] = "visitClass";
                break;
            }
            case 110: {
                objectArray = objectArray;
                objectArray[2] = "removeLambda";
                break;
            }
            case 111: 
            case 112: 
            case 113: {
                objectArray = objectArray;
                objectArray[2] = "inlineBlock";
                break;
            }
            case 114: 
            case 115: 
            case 116: {
                objectArray = objectArray;
                objectArray[2] = "enterExpressionBlock";
                break;
            }
            case 117: {
                objectArray = objectArray;
                objectArray[2] = "getClosures";
                break;
            }
            case 118: 
            case 119: {
                objectArray = objectArray;
                objectArray[2] = "addCustomNullabilityProblem";
                break;
            }
            case 120: {
                objectArray = objectArray;
                objectArray[2] = "removeCustomNullabilityProblem";
                break;
            }
            case 121: {
                break;
            }
            case 122: 
            case 123: {
                objectArray = objectArray;
                objectArray[2] = "buildFlow";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 121 -> new IllegalStateException(string);
        };
    }

    private static class CannotAnalyzeException
    extends RuntimeException {
        private CannotAnalyzeException() {
            super(null, null, false, false);
        }
    }

    static class ExpressionBlockContext {
        @Nullable
        final ExpressionBlockContext myPreviousBlock;
        @NotNull
        final PsiCodeBlock myCodeBlock;
        final boolean myForceNonNullBlockResult;
        @NotNull
        final DfaVariableValue myTarget;
        @Nullable
        private final PsiType myTargetType;

        ExpressionBlockContext(@Nullable ExpressionBlockContext previousBlock, @NotNull PsiCodeBlock codeBlock, boolean forceNonNullBlockResult, @NotNull DfaVariableValue target, @Nullable PsiType targetType) {
            if (codeBlock == null) {
                ExpressionBlockContext.$$$reportNull$$$0(0);
            }
            if (target == null) {
                ExpressionBlockContext.$$$reportNull$$$0(1);
            }
            this.myPreviousBlock = previousBlock;
            this.myCodeBlock = codeBlock;
            this.myForceNonNullBlockResult = forceNonNullBlockResult;
            this.myTarget = target;
            this.myTargetType = targetType;
        }

        boolean isSwitch() {
            return this.myCodeBlock.getParent() instanceof PsiSwitchExpression;
        }

        void generateReturn(PsiExpression returnValue, ControlFlowAnalyzer analyzer) {
            if (returnValue != null) {
                analyzer.addInstruction((Instruction)new JvmPushForWriteInstruction((DfaValue)this.myTarget));
                if (!this.isSwitch()) {
                    analyzer.addCustomNullabilityProblem(returnValue, this.myForceNonNullBlockResult ? NullabilityProblemKind.nullableFunctionReturn : NullabilityProblemKind.noProblem);
                }
                returnValue.accept((PsiElementVisitor)analyzer);
                analyzer.removeCustomNullabilityProblem(returnValue);
                analyzer.generateBoxingUnboxingInstructionFor(returnValue, this.myTargetType);
                analyzer.addInstruction((Instruction)new AssignInstruction(returnValue, null));
                analyzer.addInstruction((Instruction)new PopInstruction());
            }
            analyzer.jumpOut((PsiElement)this.myCodeBlock);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "codeBlock";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "target";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInspection/dataFlow/java/ControlFlowAnalyzer$ExpressionBlockContext";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

