/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.java;

import com.intellij.codeInspection.dataFlow.java.ControlFlowAnalyzer;
import com.intellij.codeInspection.dataFlow.lang.ir.ControlFlow;
import com.intellij.codeInspection.dataFlow.lang.ir.DataFlowIRProvider;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchBlock;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchLabeledRuleStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JavaDataFlowIRProvider
implements DataFlowIRProvider {
    @Nullable
    public ControlFlow createControlFlow(@NotNull DfaValueFactory factory, @NotNull PsiElement psiBlock) {
        if (factory == null) {
            JavaDataFlowIRProvider.$$$reportNull$$$0(0);
        }
        if (psiBlock == null) {
            JavaDataFlowIRProvider.$$$reportNull$$$0(1);
        }
        return new ControlFlowAnalyzer(factory, psiBlock, true).buildControlFlow();
    }

    @NotNull
    public Collection<TextRange> unreachableSegments(@NotNull PsiElement startAnchor, @NotNull Set<PsiElement> unreachable) {
        if (startAnchor == null) {
            JavaDataFlowIRProvider.$$$reportNull$$$0(2);
        }
        if (unreachable == null) {
            JavaDataFlowIRProvider.$$$reportNull$$$0(3);
        }
        HashSet<TextRange> result = new HashSet<TextRange>();
        for (PsiElement element : unreachable) {
            ContainerUtil.addIfNotNull(result, (Object)JavaDataFlowIRProvider.createRange(startAnchor, element, unreachable));
        }
        HashSet<TextRange> hashSet = result;
        if (hashSet == null) {
            JavaDataFlowIRProvider.$$$reportNull$$$0(4);
        }
        return hashSet;
    }

    @Nullable
    private static TextRange createRange(@NotNull PsiElement startAnchor, @NotNull PsiElement unreachable, @NotNull Set<PsiElement> allUnreachable) {
        PsiElement tokenType;
        if (startAnchor == null) {
            JavaDataFlowIRProvider.$$$reportNull$$$0(5);
        }
        if (unreachable == null) {
            JavaDataFlowIRProvider.$$$reportNull$$$0(6);
        }
        if (allUnreachable == null) {
            JavaDataFlowIRProvider.$$$reportNull$$$0(7);
        }
        PsiElement parent = unreachable.getParent();
        if (unreachable instanceof PsiExpression) {
            PsiJavaToken token;
            PsiExpression prev;
            PsiPolyadicExpression polyadicExpression;
            PsiExpression expression = (PsiExpression)unreachable;
            if (parent instanceof PsiConditionalExpression && !allUnreachable.contains(parent)) {
                return expression.getTextRange();
            }
            if (parent instanceof PsiPolyadicExpression && ((tokenType = (polyadicExpression = (PsiPolyadicExpression)parent).getOperationTokenType()) == JavaTokenType.ANDAND || tokenType == JavaTokenType.OROR) && (prev = (PsiExpression)PsiTreeUtil.getPrevSiblingOfType((PsiElement)expression, PsiExpression.class)) != null && !allUnreachable.contains(prev) && (token = polyadicExpression.getTokenBeforeOperand(expression)) != null) {
                return TextRange.create((int)token.getTextRange().getStartOffset(), (int)parent.getTextRange().getEndOffset());
            }
        }
        if (unreachable instanceof PsiCodeBlock) {
            PsiClassInitializer initializer;
            PsiElement tryStatement;
            PsiCatchSection catchSection;
            tokenType = unreachable.getParent();
            if (tokenType instanceof PsiCatchSection && (tokenType = (catchSection = (PsiCatchSection)tokenType).getParent()) instanceof PsiTryStatement && !allUnreachable.contains(tryStatement = (PsiTryStatement)tokenType)) {
                return unreachable.getTextRange();
            }
            tryStatement = unreachable.getParent();
            if (tryStatement instanceof PsiClassInitializer && !allUnreachable.contains(initializer = (PsiClassInitializer)tryStatement)) {
                return unreachable.getTextRange();
            }
        }
        if (unreachable instanceof PsiStatement) {
            PsiStatement statement = (PsiStatement)unreachable;
            if (ControlFlowUtils.isEmpty(unreachable, false, true)) {
                return null;
            }
            PsiElement statementParent = statement.getParent();
            if (unreachable instanceof PsiSwitchLabelStatement) {
                return null;
            }
            if (allUnreachable.contains(statementParent)) {
                return null;
            }
            if (parent instanceof PsiStatement) {
                PsiKeyword elseKeyword;
                PsiIfStatement ifStatement;
                if (parent instanceof PsiIfStatement && (ifStatement = (PsiIfStatement)parent).getElseBranch() == unreachable && (elseKeyword = ifStatement.getElseElement()) != null) {
                    return TextRange.create((int)elseKeyword.getTextRange().getStartOffset(), (int)unreachable.getTextRange().getEndOffset());
                }
                return statement.getTextRange();
            }
            if (parent instanceof PsiCodeBlock) {
                if (statement instanceof PsiSwitchLabeledRuleStatement) {
                    PsiStatement body;
                    PsiSwitchLabeledRuleStatement ruleStatement = (PsiSwitchLabeledRuleStatement)statement;
                    PsiSwitchBlock block = ruleStatement.getEnclosingSwitchBlock();
                    if (!allUnreachable.contains(block) && (body = ruleStatement.getBody()) != null) {
                        return body.getTextRange();
                    }
                    return null;
                }
                PsiStatement prevStatement = (PsiStatement)ObjectUtils.tryCast((Object)PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)statement), PsiStatement.class);
                if (prevStatement instanceof PsiSwitchLabelStatement) {
                    PsiSwitchLabelStatement labelStatement = (PsiSwitchLabelStatement)prevStatement;
                    PsiSwitchBlock block = labelStatement.getEnclosingSwitchBlock();
                    if (block != null && !allUnreachable.contains(block)) {
                        PsiElement lastStatement;
                        PsiJavaToken last = ((PsiCodeBlock)statementParent).getRBrace();
                        PsiSwitchLabelStatement nextLabel = (PsiSwitchLabelStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)statement, PsiSwitchLabelStatement.class);
                        if (nextLabel != null) {
                            last = nextLabel;
                        }
                        if ((lastStatement = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)last)) != null) {
                            return TextRange.create((int)statement.getTextRange().getStartOffset(), (int)lastStatement.getTextRange().getEndOffset());
                        }
                    }
                    return null;
                }
                if (allUnreachable.contains(prevStatement)) {
                    return null;
                }
                PsiElement lastStatement = JavaDataFlowIRProvider.getLastStatement(statement);
                if (prevStatement != null) {
                    if (prevStatement instanceof PsiLoopStatement && PsiTreeUtil.isAncestor((PsiElement)prevStatement, (PsiElement)startAnchor, (boolean)false)) {
                        return null;
                    }
                    return TextRange.create((int)statement.getTextRange().getStartOffset(), (int)lastStatement.getTextRange().getEndOffset());
                }
            }
        }
        return null;
    }

    @NotNull
    private static PsiElement getLastStatement(@NotNull PsiStatement statement) {
        PsiElement nextStatement;
        if (statement == null) {
            JavaDataFlowIRProvider.$$$reportNull$$$0(8);
        }
        PsiStatement lastStatement = statement;
        while ((nextStatement = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)lastStatement)) instanceof PsiStatement && !(nextStatement instanceof PsiSwitchLabelStatement)) {
            lastStatement = nextStatement;
        }
        PsiStatement psiStatement = lastStatement;
        if (psiStatement == null) {
            JavaDataFlowIRProvider.$$$reportNull$$$0(9);
        }
        return psiStatement;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiBlock";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startAnchor";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unreachable";
                break;
            }
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/java/JavaDataFlowIRProvider";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allUnreachable";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/java/JavaDataFlowIRProvider";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "unreachableSegments";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getLastStatement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createControlFlow";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "unreachableSegments";
                break;
            }
            case 4: 
            case 9: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createRange";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getLastStatement";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 9 -> new IllegalStateException(string);
        };
    }
}

