/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.java;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.ConcurrencyAnnotationsManager;
import com.intellij.codeInsight.Nullability;
import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInspection.dataFlow.ContractReturnValue;
import com.intellij.codeInspection.dataFlow.DfaPsiUtil;
import com.intellij.codeInspection.dataFlow.DfaUtil;
import com.intellij.codeInspection.dataFlow.JavaMethodContractUtil;
import com.intellij.codeInspection.dataFlow.MethodContract;
import com.intellij.codeInspection.dataFlow.NullabilityUtil;
import com.intellij.codeInspection.dataFlow.TypeConstraints;
import com.intellij.codeInspection.dataFlow.java.JavaDfaHelpers;
import com.intellij.codeInspection.dataFlow.jvm.SpecialField;
import com.intellij.codeInspection.dataFlow.jvm.descriptors.ArrayElementDescriptor;
import com.intellij.codeInspection.dataFlow.jvm.descriptors.GetterDescriptor;
import com.intellij.codeInspection.dataFlow.jvm.descriptors.PlainDescriptor;
import com.intellij.codeInspection.dataFlow.jvm.descriptors.ThisDescriptor;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.types.DfTypes;
import com.intellij.codeInspection.dataFlow.value.DerivedVariableDescriptor;
import com.intellij.codeInspection.dataFlow.value.DfaTypeValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.VariableDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiEnumConstantInitializer;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiQualifiedExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.JavaConstantExpressionEvaluator;
import com.intellij.psi.impl.source.PsiFieldImpl;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.ExpressionUtils;
import java.lang.runtime.SwitchBootstraps;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JavaDfaValueFactory {
    private static final CallMatcher UNSTABLE_METHODS = CallMatcher.staticCall("java.lang.Thread", "currentThread").parameterCount(0);

    private JavaDfaValueFactory() {
    }

    @Contract(value="_, null -> null")
    @Nullable
    public static DfaValue getExpressionDfaValue(@NotNull DfaValueFactory factory, @Nullable PsiExpression expression) {
        if (factory == null) {
            JavaDfaValueFactory.$$$reportNull$$$0(0);
        }
        PsiExpression psiExpression = expression;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{PsiParenthesizedExpression.class, PsiArrayAccessExpression.class, PsiMethodCallExpression.class, PsiReferenceExpression.class, PsiLiteralExpression.class, PsiNewExpression.class, PsiLambdaExpression.class, PsiQualifiedExpression.class}, (Object)psiExpression, n)) {
            case -1 -> null;
            case 0 -> {
                PsiParenthesizedExpression parens = (PsiParenthesizedExpression)psiExpression;
                yield JavaDfaValueFactory.getExpressionDfaValue(factory, parens.getExpression());
            }
            case 1 -> {
                DfaValue arrayElementValue;
                Object index;
                PsiArrayAccessExpression arrayAccess = (PsiArrayAccessExpression)psiExpression;
                PsiExpression arrayExpression = arrayAccess.getArrayExpression();
                DfaValue qualifier = JavaDfaValueFactory.getQualifierValue(factory, arrayExpression);
                if (qualifier != null && (index = ExpressionUtils.computeConstantExpression(arrayAccess.getIndexExpression())) instanceof Integer && (arrayElementValue = ArrayElementDescriptor.getArrayElementValue(factory, qualifier, (Integer)index)) != null) {
                    yield arrayElementValue;
                }
                PsiType type = expression.getType();
                if (type != null) {
                    yield factory.fromDfType(DfTypes.typedObject(type, DfaPsiUtil.getElementNullabilityForRead(type, null)));
                }
                yield null;
            }
            case 2 -> {
                PsiMethodCallExpression call = (PsiMethodCallExpression)psiExpression;
                yield JavaDfaValueFactory.createReferenceValue(factory, call.getMethodExpression());
            }
            case 3 -> {
                PsiReferenceExpression ref = (PsiReferenceExpression)psiExpression;
                yield JavaDfaValueFactory.createReferenceValue(factory, ref);
            }
            case 4 -> {
                PsiLiteralExpression literal = (PsiLiteralExpression)psiExpression;
                yield factory.fromDfType(DfaPsiUtil.fromLiteral(literal));
            }
            case 5 -> {
                PsiNewExpression newExpression = (PsiNewExpression)psiExpression;
                PsiType psiType = newExpression.getType();
                DfType dfType = psiType == null ? DfType.TOP : TypeConstraints.exact(psiType).asDfType();
                yield factory.fromDfType(dfType.meet((DfType)DfTypes.NOT_NULL_OBJECT));
            }
            case 6 -> {
                PsiLambdaExpression lambda = (PsiLambdaExpression)psiExpression;
                DfType dfType = JavaDfaHelpers.getFunctionDfType((PsiFunctionalExpression)lambda);
                yield factory.fromDfType(dfType.meet((DfType)DfTypes.NOT_NULL_OBJECT));
            }
            case 7 -> {
                PsiQualifiedExpression qualified = (PsiQualifiedExpression)psiExpression;
                PsiJavaCodeReferenceElement qualifier = qualified.getQualifier();
                PsiClass target = qualifier != null ? (PsiClass)ObjectUtils.tryCast((Object)qualifier.resolve(), PsiClass.class) : PsiUtil.getContainingClass((PsiElement)expression);
                if (target == null) {
                    yield factory.fromDfType(DfTypes.typedObject(expression.getType(), Nullability.NOT_NULL));
                }
                yield ThisDescriptor.createThisValue(factory, target);
            }
            default -> {
                PsiType type;
                Object value = JavaConstantExpressionEvaluator.computeConstantExpression((PsiExpression)expression, (boolean)false);
                if (value != null && (type = expression.getType()) != null) {
                    yield factory.fromDfType(DfTypes.constant(value, type));
                }
                yield null;
            }
        };
    }

    private static DfaValue createReferenceValue(DfaValueFactory factory, @NotNull PsiReferenceExpression refExpr) {
        VariableDescriptor var;
        PsiElement target;
        if (refExpr == null) {
            JavaDfaValueFactory.$$$reportNull$$$0(1);
        }
        if ((target = refExpr.resolve()) instanceof PsiVariable) {
            DfaValue constValue;
            PsiVariable variable = (PsiVariable)target;
            if (!(PsiUtil.isAccessedForWriting((PsiExpression)refExpr) || PlainDescriptor.hasInitializationHacks(variable) || (constValue = JavaDfaValueFactory.getConstantFromVariable(factory, variable)) == null || JavaDfaValueFactory.maybeUninitializedConstant(constValue, refExpr, (PsiModifierListOwner)variable))) {
                return constValue;
            }
        }
        if ((var = JavaDfaValueFactory.getAccessedVariableOrGetter(target)) == null) {
            return null;
        }
        DfaValue qualifier = JavaDfaValueFactory.getQualifierOrThisValue(factory, refExpr);
        return var.createValue(factory, qualifier);
    }

    @Nullable
    public static DfaValue getQualifierOrThisValue(DfaValueFactory factory, PsiReferenceExpression refExpr) {
        PsiTypeCastExpression castExpression;
        PsiElement element;
        PsiExpression qualifierExpression = refExpr.getQualifierExpression();
        if (qualifierExpression == null && (element = refExpr.resolve()) instanceof PsiMember && !((PsiMember)element).hasModifierProperty("static")) {
            PsiClass currentClass = PsiUtil.getContainingClass((PsiElement)refExpr);
            PsiClass memberClass = ((PsiMember)element).getContainingClass();
            if (memberClass != null && currentClass != null) {
                PsiClass target = currentClass == memberClass || InheritanceUtil.isInheritorOrSelf((PsiClass)currentClass, (PsiClass)memberClass, (boolean)true) ? currentClass : memberClass;
                return ThisDescriptor.createThisValue(factory, target);
            }
        }
        if ((qualifierExpression = PsiUtil.skipParenthesizedExprDown((PsiExpression)qualifierExpression)) instanceof PsiTypeCastExpression && (castExpression = (PsiTypeCastExpression)qualifierExpression).getType() instanceof PsiClassType) {
            qualifierExpression = castExpression.getOperand();
        }
        return JavaDfaValueFactory.getQualifierValue(factory, qualifierExpression);
    }

    @Nullable
    private static DfaValue getQualifierValue(DfaValueFactory factory, PsiExpression qualifierExpression) {
        DfaValue qualifierValue = JavaDfaValueFactory.getExpressionDfaValue(factory, qualifierExpression);
        if (qualifierValue == null) {
            return null;
        }
        PsiVariable constVar = (PsiVariable)qualifierValue.getDfType().getConstantOfType(PsiVariable.class);
        if (constVar != null) {
            return PlainDescriptor.createVariableValue(factory, constVar);
        }
        return qualifierValue;
    }

    static boolean maybeUninitializedConstant(DfaValue constValue, @NotNull PsiReferenceExpression refExpr, PsiModifierListOwner var) {
        if (refExpr == null) {
            JavaDfaValueFactory.$$$reportNull$$$0(2);
        }
        if (!constValue.getDfType().isConst((Object)var)) {
            return false;
        }
        if (!(var instanceof PsiField) || var instanceof PsiEnumConstant) {
            return false;
        }
        return PsiTreeUtil.getTopmostParentOfType((PsiElement)refExpr, PsiClass.class) == PsiTreeUtil.getTopmostParentOfType((PsiElement)var, PsiClass.class);
    }

    @Contract(value="null -> null")
    @Nullable
    public static VariableDescriptor getAccessedVariableOrGetter(PsiElement target) {
        return JavaDfaValueFactory.getAccessedVariableOrGetter(target, false);
    }

    @Contract(value="null, _ -> null")
    @Nullable
    public static VariableDescriptor getAccessedVariableOrGetter(@Nullable PsiElement target, boolean stable) {
        SpecialField sf = SpecialField.findSpecialField(target);
        if (sf != null) {
            return sf;
        }
        if (target instanceof PsiVariable) {
            PsiVariable variable = (PsiVariable)target;
            return new PlainDescriptor(variable);
        }
        if (target instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)target;
            if (InheritanceUtil.isInheritor((PsiType)method.getReturnType(), (String)"java.util.stream.BaseStream")) {
                return null;
            }
            PsiField targetField = JavaDfaValueFactory.getFieldForGetter(method, stable);
            if (targetField != null) {
                return new PlainDescriptor((PsiVariable)targetField);
            }
            if (!method.isConstructor() && method.getParameterList().isEmpty() && (PropertyUtilBase.isSimplePropertyGetter((PsiMethod)method) || JavaMethodContractUtil.isPure(method) || JavaDfaValueFactory.isClassAnnotatedImmutable(method)) && JavaDfaValueFactory.isContractAllowedForGetter(method) && !UNSTABLE_METHODS.methodMatches(method)) {
                return new GetterDescriptor(method);
            }
        }
        return null;
    }

    @Nullable
    private static PsiField getFieldForGetter(@NotNull PsiMethod method, boolean stable) {
        if (method == null) {
            JavaDfaValueFactory.$$$reportNull$$$0(3);
        }
        if (!stable && PsiUtil.canBeOverridden((PsiMethod)method)) {
            return null;
        }
        if (GetterDescriptor.isKnownStableMethod(method)) {
            return null;
        }
        PsiField field = PropertyUtil.getFieldOfGetter(method);
        if (field == null) {
            return null;
        }
        NullableNotNullManager manager = NullableNotNullManager.getInstance((Project)method.getProject());
        if (manager.isNullable((PsiModifierListOwner)method, true) && !manager.isNullable((PsiModifierListOwner)field, true)) {
            return null;
        }
        return field;
    }

    private static boolean isClassAnnotatedImmutable(PsiMethod method) {
        List annotations = ConcurrencyAnnotationsManager.getInstance((Project)method.getProject()).getImmutableAnnotations();
        return AnnotationUtil.findAnnotation((PsiModifierListOwner)method.getContainingClass(), (Collection)annotations) != null;
    }

    private static boolean isContractAllowedForGetter(PsiMethod method) {
        List<? extends MethodContract> contracts = JavaMethodContractUtil.getMethodCallContracts(method, null);
        if (contracts.size() == 1) {
            MethodContract contract = contracts.get(0);
            return contract.isTrivial() && contract.getReturnValue().equals(ContractReturnValue.returnNew());
        }
        return contracts.isEmpty();
    }

    @NotNull
    public static DfaValue createCommonValue(DfaValueFactory factory, PsiExpression @NotNull [] expressions, PsiType targetType) {
        if (expressions == null) {
            JavaDfaValueFactory.$$$reportNull$$$0(4);
        }
        DfaValue loopElement = null;
        for (PsiExpression expression : expressions) {
            DfaValue expressionValue = JavaDfaValueFactory.getExpressionDfaValue(factory, expression);
            if (expressionValue == null) {
                expressionValue = factory.fromDfType(DfTypes.typedObject(expression.getType(), NullabilityUtil.getExpressionNullability(expression)));
            }
            DfaValue dfaValue = loopElement = loopElement == null ? expressionValue : loopElement.unite(expressionValue);
            if (DfaTypeValue.isUnknown((DfaValue)loopElement)) break;
        }
        Object object = loopElement == null ? factory.getUnknown() : DfaUtil.boxUnbox(loopElement, targetType);
        if (object == null) {
            JavaDfaValueFactory.$$$reportNull$$$0(5);
        }
        return object;
    }

    @Nullable
    static DfaValue getConstantFromVariable(DfaValueFactory factory, PsiVariable variable) {
        PsiEnumConstant constant;
        PsiEnumConstantInitializer cls;
        if (!variable.hasModifierProperty("final") || JavaDfaValueFactory.ignoreInitializer(variable)) {
            return null;
        }
        Object value = variable.computeConstantValue();
        PsiType type = variable.getType();
        if (value == null) {
            Boolean boo = JavaDfaValueFactory.computeJavaLangBooleanFieldReference(variable);
            if (boo != null) {
                DfaTypeValue unboxed = factory.fromDfType((DfType)DfTypes.booleanValue(boo));
                return factory.getWrapperFactory().createWrapper(DfTypes.typedObject(type, Nullability.NOT_NULL), (DerivedVariableDescriptor)SpecialField.UNBOX, (DfaValue)unboxed);
            }
            if (DfaUtil.isEmptyCollectionConstantField(variable)) {
                return factory.fromDfType(DfTypes.constant((Object)variable, type));
            }
            PsiExpression initializer = PsiFieldImpl.getDetachedInitializer((PsiVariable)variable);
            if ((initializer = PsiUtil.skipParenthesizedExprDown((PsiExpression)initializer)) instanceof PsiLiteralExpression && initializer.textMatches((CharSequence)"null")) {
                return factory.fromDfType((DfType)DfTypes.NULL);
            }
            if (variable instanceof PsiField && variable.hasModifierProperty("static") && ExpressionUtils.isNewObject(initializer)) {
                return factory.fromDfType(DfTypes.constant((Object)variable, type));
            }
            return null;
        }
        if (value instanceof PsiEnumConstant && (cls = (constant = (PsiEnumConstant)value).getInitializingClass()) != null) {
            type = JavaPsiFacade.getElementFactory((Project)variable.getProject()).createType((PsiClass)cls);
        }
        return factory.fromDfType(DfTypes.constant(value, type));
    }

    @Nullable
    private static Boolean computeJavaLangBooleanFieldReference(PsiVariable variable) {
        if (!(variable instanceof PsiField)) {
            return null;
        }
        PsiClass psiClass = ((PsiField)variable).getContainingClass();
        if (psiClass == null || !"java.lang.Boolean".equals(psiClass.getQualifiedName())) {
            return null;
        }
        @NonNls String name = variable.getName();
        return "TRUE".equals(name) ? Boolean.TRUE : ("FALSE".equals(name) ? Boolean.FALSE : null);
    }

    public static boolean ignoreInitializer(PsiVariable variable) {
        if (variable instanceof PsiField && variable.hasModifierProperty("final")) {
            if (variable.getClass().getName().equals("org.jetbrains.kotlin.light.classes.symbol.fields.SymbolLightFieldForProperty")) {
                return true;
            }
            if (variable.getType().equals(PsiTypes.booleanType())) {
                PsiLiteralExpression initializer = (PsiLiteralExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)variable.getInitializer()), PsiLiteralExpression.class);
                return initializer != null && initializer.getValue() instanceof Boolean;
            }
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refExpr";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressions";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/java/JavaDfaValueFactory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/java/JavaDfaValueFactory";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createCommonValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getExpressionDfaValue";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createReferenceValue";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "maybeUninitializedConstant";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getFieldForGetter";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createCommonValue";
                break;
            }
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5 -> new IllegalStateException(string);
        };
    }
}

