/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.java.anchor;

import com.intellij.codeInspection.dataFlow.java.anchor.JavaDfaAnchor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiPolyadicExpression;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class JavaPolyadicPartAnchor
extends JavaDfaAnchor {
    @NotNull
    private final PsiPolyadicExpression myExpression;
    private final int myLastOperand;

    public JavaPolyadicPartAnchor(@NotNull PsiPolyadicExpression expression, int operand) {
        if (expression == null) {
            JavaPolyadicPartAnchor.$$$reportNull$$$0(0);
        }
        if (operand < 0) {
            throw new IllegalArgumentException();
        }
        this.myExpression = expression;
        this.myLastOperand = operand;
    }

    @NotNull
    public PsiPolyadicExpression getExpression() {
        PsiPolyadicExpression psiPolyadicExpression = this.myExpression;
        if (psiPolyadicExpression == null) {
            JavaPolyadicPartAnchor.$$$reportNull$$$0(1);
        }
        return psiPolyadicExpression;
    }

    @NotNull
    public TextRange getTextRange() {
        PsiExpression[] operands = this.myExpression.getOperands();
        if (operands.length > this.myLastOperand + 1) {
            return new TextRange(0, operands[this.myLastOperand].getStartOffsetInParent() + operands[this.myLastOperand].getTextLength());
        }
        throw new IllegalStateException("Not enough operands");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JavaPolyadicPartAnchor anchor = (JavaPolyadicPartAnchor)o;
        return this.myLastOperand == anchor.myLastOperand && this.myExpression.equals((Object)anchor.myExpression);
    }

    public int hashCode() {
        return Objects.hash(this.myExpression, this.myLastOperand);
    }

    public String toString() {
        return this.getTextRange().substring(this.myExpression.getText());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/java/anchor/JavaPolyadicPartAnchor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/java/anchor/JavaPolyadicPartAnchor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

