/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.java.inliner;

import com.intellij.codeInsight.Nullability;
import com.intellij.codeInspection.dataFlow.java.CFGBuilder;
import com.intellij.codeInspection.dataFlow.java.inliner.CallInliner;
import com.intellij.codeInspection.dataFlow.jvm.SpecialField;
import com.intellij.codeInspection.dataFlow.jvm.problems.ContractFailureProblem;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.types.DfTypes;
import com.intellij.codeInspection.dataFlow.value.RelationType;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.ArrayList;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AssertJInliner
implements CallInliner {
    private static final String[] METHOD_NAMES = new String[]{"isNotNull", "isNull", "isPresent", "isNotEmpty", "isNotBlank", "isNotPresent", "isEmpty", "isTrue", "isFalse", "contains", "containsSame", "containsInstanceOf", "hasOnlyElementsOfType", "hasOnlyElementsOfTypes", "have", "haveAtLeast", "haveAtLeastOne", "haveAtMost", "haveExactly", "hasSize", "hasSizeBetween", "hasSizeGreaterThan", "hasSizeLessThan", "hasSizeGreaterThanOrEqualTo", "hasSizeLessThanOrEqualTo"};
    private static final CallMatcher ASSERT = CallMatcher.anyOf(CallMatcher.instanceCall("org.assertj.core.api.AbstractAssert", METHOD_NAMES), CallMatcher.instanceCall("com.google.common.truth.Subject", METHOD_NAMES));
    private static final CallMatcher INTERMEDIATE = CallMatcher.anyOf(CallMatcher.instanceCall("org.assertj.core.api.Descriptable", "describedAs", "as"), CallMatcher.instanceCall("org.assertj.core.api.AbstractAssert", "describedAs", "as", "withFailMessage", "overridingErrorMessage"), CallMatcher.instanceCall("org.assertj.core.api.Assert", "withRepresentation", "withThreadDumpOnError"));
    private static final CallMatcher ASSERT_THAT = CallMatcher.anyOf(CallMatcher.staticCall("org.assertj.core.api.BDDAssertions", "then").parameterCount(1), CallMatcher.staticCall("org.assertj.core.api.Assertions", "assertThat").parameterCount(1), CallMatcher.instanceCall("org.assertj.core.api.WithAssertions", "assertThat").parameterCount(1), CallMatcher.staticCall("com.google.common.truth.Truth", "assertThat").parameterCount(1), CallMatcher.staticCall("com.google.common.truth.StandardSubjectBuilder", "that").parameterCount(1));

    @Override
    public boolean tryInlineCall(@NotNull CFGBuilder builder, @NotNull PsiMethodCallExpression call) {
        String methodName;
        PsiExpression[] args;
        if (builder == null) {
            AssertJInliner.$$$reportNull$$$0(0);
        }
        if (call == null) {
            AssertJInliner.$$$reportNull$$$0(1);
        }
        if (!ASSERT.matches((PsiExpression)call)) {
            return false;
        }
        ArrayList<PsiExpression> intermediateArgs = new ArrayList<PsiExpression>();
        PsiMethodCallExpression qualifier = MethodCallUtils.getQualifierMethodCall(call);
        while (INTERMEDIATE.matches((PsiExpression)qualifier)) {
            intermediateArgs.addAll(0, Arrays.asList(qualifier.getArgumentList().getExpressions()));
            qualifier = MethodCallUtils.getQualifierMethodCall(qualifier);
        }
        if (!ASSERT_THAT.matches((PsiExpression)qualifier)) {
            return false;
        }
        PsiMethod method = call.resolveMethod();
        if (method == null) {
            return false;
        }
        PsiExpression valueToCheck = qualifier.getArgumentList().getExpressions()[0];
        builder.pushExpression(valueToCheck);
        for (PsiExpression psiExpression : intermediateArgs) {
            builder.pushExpression(psiExpression);
        }
        builder.splice(intermediateArgs.size(), new int[0]);
        for (PsiExpression arg : args = call.getArgumentList().getExpressions()) {
            builder.pushExpression(arg);
        }
        builder.splice(args.length, new int[0]);
        PsiType psiType = valueToCheck.getType();
        SpecialField field = SpecialField.fromQualifierType(DfTypes.typedObject(psiType, Nullability.UNKNOWN));
        boolean container = field == SpecialField.COLLECTION_SIZE || field == SpecialField.ARRAY_LENGTH || field == SpecialField.STRING_LENGTH || field == SpecialField.OPTIONAL_VALUE;
        switch (methodName = method.getName()) {
            case "isNotNull": 
            case "have": 
            case "haveAtLeast": 
            case "haveAtLeastOne": 
            case "haveAtMost": 
            case "haveExactly": 
            case "hasOnlyElementsOfType": 
            case "hasOnlyElementsOfTypes": {
                builder.ensure(RelationType.NE, DfTypes.NULL, new ContractFailureProblem((PsiExpression)call), "java.lang.AssertionError");
                break;
            }
            case "isNull": {
                builder.ensure(RelationType.EQ, DfTypes.NULL, new ContractFailureProblem((PsiExpression)call), "java.lang.AssertionError");
                break;
            }
            case "isPresent": 
            case "isNotEmpty": 
            case "isNotBlank": 
            case "contains": 
            case "containsSame": 
            case "containsInstanceOf": {
                boolean mayCheckNothing;
                builder.ensure(RelationType.NE, DfTypes.NULL, new ContractFailureProblem((PsiExpression)call), "java.lang.AssertionError");
                if (!container) break;
                boolean bl = mayCheckNothing = methodName.startsWith("contains") && args.length == 0 || args.length == 1 && method.isVarArgs() && !MethodCallUtils.isVarArgCall((PsiCall)call);
                if (mayCheckNothing) break;
                builder.unwrap(field);
                builder.ensure(RelationType.NE, (DfType)(field == SpecialField.OPTIONAL_VALUE ? DfTypes.NULL : DfTypes.intValue(0)), new ContractFailureProblem((PsiExpression)call), "java.lang.AssertionError");
                break;
            }
            case "isNotPresent": 
            case "isEmpty": {
                builder.ensure(RelationType.NE, DfTypes.NULL, new ContractFailureProblem((PsiExpression)call), "java.lang.AssertionError");
                if (!container) break;
                builder.unwrap(field);
                builder.ensure(RelationType.EQ, (DfType)(field == SpecialField.OPTIONAL_VALUE ? DfTypes.NULL : DfTypes.intValue(0)), new ContractFailureProblem((PsiExpression)call), "java.lang.AssertionError");
                break;
            }
            case "isTrue": {
                if (PsiTypes.booleanType().equals((Object)psiType) || TypeUtils.typeEquals("java.lang.Boolean", psiType)) {
                    builder.boxUnbox(valueToCheck, (PsiType)PsiTypes.booleanType()).ensure(RelationType.EQ, DfTypes.TRUE, new ContractFailureProblem((PsiExpression)call), "java.lang.AssertionError");
                    break;
                }
                if (!(psiType instanceof PsiClassType)) break;
                builder.ensure(RelationType.NE, DfTypes.NULL, new ContractFailureProblem((PsiExpression)call), "java.lang.AssertionError");
                break;
            }
            case "isFalse": {
                if (PsiTypes.booleanType().equals((Object)psiType) || TypeUtils.typeEquals("java.lang.Boolean", psiType)) {
                    builder.boxUnbox(valueToCheck, (PsiType)PsiTypes.booleanType()).ensure(RelationType.EQ, DfTypes.FALSE, new ContractFailureProblem((PsiExpression)call), "java.lang.AssertionError");
                    break;
                }
                if (!(psiType instanceof PsiClassType)) break;
                builder.ensure(RelationType.NE, DfTypes.NULL, new ContractFailureProblem((PsiExpression)call), "java.lang.AssertionError");
                break;
            }
            case "hasSize": {
                AssertJInliner.sizeLimit(builder, call, field, RelationType.EQ);
                break;
            }
            case "hasSizeGreaterThan": {
                AssertJInliner.sizeLimit(builder, call, field, RelationType.GT);
                break;
            }
            case "hasSizeLessThan": {
                AssertJInliner.sizeLimit(builder, call, field, RelationType.LT);
                break;
            }
            case "hasSizeGreaterThanOrEqualTo": {
                AssertJInliner.sizeLimit(builder, call, field, RelationType.GE);
                break;
            }
            case "hasSizeLessThanOrEqualTo": {
                AssertJInliner.sizeLimit(builder, call, field, RelationType.LE);
                break;
            }
            case "hasSizeBetween": {
                builder.ensure(RelationType.NE, DfTypes.NULL, new ContractFailureProblem((PsiExpression)call), "java.lang.AssertionError");
                if (field != SpecialField.COLLECTION_SIZE && field != SpecialField.ARRAY_LENGTH || args.length != 2) break;
                Integer min = (Integer)ObjectUtils.tryCast((Object)ExpressionUtils.computeConstantExpression(args[0]), Integer.class);
                Integer max = (Integer)ObjectUtils.tryCast((Object)ExpressionUtils.computeConstantExpression(args[1]), Integer.class);
                builder.unwrap(field);
                if (min != null) {
                    builder.ensure(RelationType.GE, DfTypes.intValue(min), new ContractFailureProblem((PsiExpression)call), "java.lang.AssertionError");
                }
                if (max == null) break;
                builder.ensure(RelationType.LE, DfTypes.intValue(max), new ContractFailureProblem((PsiExpression)call), "java.lang.AssertionError");
            }
        }
        builder.pop().pushUnknown();
        return true;
    }

    private static void sizeLimit(@NotNull CFGBuilder builder, @NotNull PsiMethodCallExpression call, @Nullable SpecialField field, @NotNull RelationType relation) {
        Integer expectedSize;
        if (builder == null) {
            AssertJInliner.$$$reportNull$$$0(2);
        }
        if (call == null) {
            AssertJInliner.$$$reportNull$$$0(3);
        }
        if (relation == null) {
            AssertJInliner.$$$reportNull$$$0(4);
        }
        PsiExpression[] args = call.getArgumentList().getExpressions();
        builder.ensure(RelationType.NE, DfTypes.NULL, new ContractFailureProblem((PsiExpression)call), "java.lang.AssertionError");
        if ((field == SpecialField.COLLECTION_SIZE || field == SpecialField.ARRAY_LENGTH) && args.length == 1 && (expectedSize = (Integer)ObjectUtils.tryCast((Object)ExpressionUtils.computeConstantExpression(args[0]), Integer.class)) != null) {
            builder.unwrap(field);
            builder.ensure(relation, DfTypes.intValue(expectedSize), new ContractFailureProblem((PsiExpression)call), "java.lang.AssertionError");
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relation";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInspection/dataFlow/java/inliner/AssertJInliner";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "tryInlineCall";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "sizeLimit";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

