/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.java.inliner;

import com.intellij.codeInsight.Nullability;
import com.intellij.codeInspection.dataFlow.java.CFGBuilder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.callMatcher.CallMatcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class ComparatorModel {
    private static final CallMatcher KEY_EXTRACTOR = CallMatcher.anyOf(CallMatcher.staticCall("java.util.Comparator", "comparing", "comparingInt", "comparingLong", "comparingDouble").parameterCount(1), CallMatcher.staticCall("java.util.Comparator", "comparing").parameterCount(2));
    private static final CallMatcher NULL_HOSTILE = CallMatcher.anyOf(CallMatcher.staticCall("java.util.Comparator", "naturalOrder", "reverseOrder").parameterCount(0), CallMatcher.staticCall("java.util.Collections", "reverseOrder").parameterCount(0));
    private static final CallMatcher NULL_FRIENDLY = CallMatcher.staticCall("java.util.Comparator", "nullsFirst", "nullsLast").parameterCount(1);
    private static final CallMatcher REVERSED = CallMatcher.instanceCall("java.util.Comparator", "reversed").parameterCount(0);
    private static final CallMatcher REVERSE_ORDER = CallMatcher.staticCall("java.util.Collections", "reverseOrder").parameterCount(1);
    private final boolean myFailsOnNull;

    protected ComparatorModel(boolean failsOnNull) {
        this.myFailsOnNull = failsOnNull;
    }

    abstract void evaluate(CFGBuilder var1);

    abstract void invoke(CFGBuilder var1);

    boolean failsOnNull() {
        return this.myFailsOnNull;
    }

    @NotNull
    static ComparatorModel from(@Nullable PsiExpression expression) {
        PsiField field;
        PsiElement psiElement;
        PsiReferenceExpression ref;
        if ((expression = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression)) == null || NULL_HOSTILE.matches(expression)) {
            return new NullHostile();
        }
        if (expression instanceof PsiReferenceExpression && "CASE_INSENSITIVE_ORDER".equals((ref = (PsiReferenceExpression)expression).getReferenceName()) && (psiElement = ref.resolve()) instanceof PsiField && (field = (PsiField)psiElement).getContainingClass() != null && "java.lang.String".equals(field.getContainingClass().getQualifiedName())) {
            return new NullHostile();
        }
        PsiMethodCallExpression call = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)expression, PsiMethodCallExpression.class);
        if (call == null) {
            return new Unknown(expression);
        }
        PsiExpression qualifier = call.getMethodExpression().getQualifierExpression();
        if (REVERSED.test(call) && qualifier != null) {
            return ComparatorModel.from(qualifier);
        }
        if (REVERSE_ORDER.test(call)) {
            return ComparatorModel.from(call.getArgumentList().getExpressions()[0]);
        }
        if (NULL_FRIENDLY.test(call) && qualifier != null) {
            return new NullFriendly(ComparatorModel.from(qualifier));
        }
        if (KEY_EXTRACTOR.test(call)) {
            PsiExpression[] args = call.getArgumentList().getExpressions();
            PsiExpression keyExtractor = args[0];
            ComparatorModel downstream = args.length == 2 ? ComparatorModel.from(args[1]) : new NullHostile();
            return new KeyExtractor(keyExtractor, downstream);
        }
        return new Unknown(expression);
    }

    private static class NullHostile
    extends ComparatorModel {
        NullHostile() {
            super(true);
        }

        @Override
        void evaluate(CFGBuilder builder) {
        }

        @Override
        void invoke(CFGBuilder builder) {
            builder.pop();
        }
    }

    private static class Unknown
    extends ComparatorModel {
        private final PsiExpression myExpression;

        Unknown(PsiExpression expression) {
            super(false);
            this.myExpression = expression;
        }

        @Override
        void evaluate(CFGBuilder builder) {
            builder.evaluateFunction(this.myExpression);
        }

        @Override
        void invoke(CFGBuilder builder) {
            builder.pushUnknown().invokeFunction(2, this.myExpression).pop();
        }
    }

    private static class NullFriendly
    extends ComparatorModel {
        private final ComparatorModel myDownstream;

        NullFriendly(ComparatorModel downstream) {
            super(false);
            this.myDownstream = downstream;
        }

        @Override
        void evaluate(CFGBuilder builder) {
            this.myDownstream.evaluate(builder);
        }

        @Override
        void invoke(CFGBuilder builder) {
            builder.dup().ifNotNull().chain(this.myDownstream::invoke).elseBranch().pop().end();
        }
    }

    private static final class KeyExtractor
    extends ComparatorModel {
        private final PsiExpression myKeyExtractor;
        private final ComparatorModel myDownstream;

        private KeyExtractor(PsiExpression keyExtractor, ComparatorModel downstream) {
            super(false);
            this.myKeyExtractor = keyExtractor;
            this.myDownstream = downstream;
        }

        @Override
        void evaluate(CFGBuilder builder) {
            builder.evaluateFunction(this.myKeyExtractor);
            this.myDownstream.evaluate(builder);
        }

        @Override
        void invoke(CFGBuilder builder) {
            builder.invokeFunction(1, this.myKeyExtractor, this.myDownstream.myFailsOnNull ? Nullability.NOT_NULL : Nullability.UNKNOWN).chain(this.myDownstream::invoke);
        }
    }
}

