/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.java.inliner;

import com.intellij.codeInspection.dataFlow.java.CFGBuilder;
import com.intellij.codeInspection.dataFlow.java.inliner.CallInliner;
import com.intellij.codeInspection.dataFlow.jvm.SpecialField;
import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeBinOp;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiEnumConstantInitializer;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.ig.callMatcher.CallMatcher;
import org.jetbrains.annotations.NotNull;

public class EnumCompareInliner
implements CallInliner {
    private static final CallMatcher ENUM_COMPARE_TO = CallMatcher.instanceCall("java.lang.Enum", "compareTo").parameterTypes("E");

    @Override
    public boolean tryInlineCall(@NotNull CFGBuilder builder, @NotNull PsiMethodCallExpression call) {
        if (builder == null) {
            EnumCompareInliner.$$$reportNull$$$0(0);
        }
        if (call == null) {
            EnumCompareInliner.$$$reportNull$$$0(1);
        }
        if (!ENUM_COMPARE_TO.matches((PsiExpression)call)) {
            return false;
        }
        PsiExpression qualifier = call.getMethodExpression().getQualifierExpression();
        if (qualifier == null) {
            return false;
        }
        PsiExpression arg = call.getArgumentList().getExpressions()[0];
        PsiClass qualifierClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)qualifier.getType());
        PsiClass argumentClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)arg.getType());
        if (qualifierClass instanceof PsiEnumConstantInitializer) {
            qualifierClass = qualifierClass.getSuperClass();
        }
        if (argumentClass instanceof PsiEnumConstantInitializer) {
            argumentClass = argumentClass.getSuperClass();
        }
        if (qualifierClass == null || !qualifierClass.equals((Object)argumentClass)) {
            return false;
        }
        builder.pushExpression(qualifier).unwrap(SpecialField.ENUM_ORDINAL).pushExpression(arg).unwrap(SpecialField.ENUM_ORDINAL).mathOp(LongRangeBinOp.MINUS, (PsiExpression)call);
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "builder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "call";
                break;
            }
        }
        objectArray[1] = "com/intellij/codeInspection/dataFlow/java/inliner/EnumCompareInliner";
        objectArray[2] = "tryInlineCall";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

