/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.java.inliner;

import com.intellij.codeInspection.dataFlow.java.CFGBuilder;
import com.intellij.codeInspection.dataFlow.java.inliner.CallInliner;
import com.intellij.codeInspection.dataFlow.jvm.SpecialField;
import com.intellij.codeInspection.dataFlow.lang.UnsatisfiedConditionProblem;
import com.intellij.codeInspection.dataFlow.types.DfTypes;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.codeInspection.dataFlow.value.RelationType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.NotNull;

public class IndexOfInliner
implements CallInliner {
    private static final CallMatcher INDEX_OF = CallMatcher.instanceCall("java.lang.String", "indexOf", "lastIndexOf").parameterCount(1);

    @Override
    public boolean tryInlineCall(@NotNull CFGBuilder builder, @NotNull PsiMethodCallExpression call) {
        String strArg;
        if (builder == null) {
            IndexOfInliner.$$$reportNull$$$0(0);
        }
        if (call == null) {
            IndexOfInliner.$$$reportNull$$$0(1);
        }
        if (!INDEX_OF.test(call)) {
            return false;
        }
        PsiExpression qualifier = call.getMethodExpression().getQualifierExpression();
        if (qualifier == null) {
            return false;
        }
        PsiExpression arg = call.getArgumentList().getExpressions()[0];
        DfaVariableValue res = builder.createTempVariable((PsiType)PsiTypes.intType());
        RelationType relationType = RelationType.LT;
        if (TypeUtils.isJavaLangString(arg.getType()) && ((strArg = (String)ObjectUtils.tryCast((Object)ExpressionUtils.computeConstantExpression(arg), String.class)) == null || strArg.isEmpty())) {
            relationType = RelationType.LE;
        }
        builder.pushExpression(qualifier).dup().pushExpression(arg).call(call).assignTo(res).splice(2, 0, 0, 1).unwrap(SpecialField.STRING_LENGTH).compare(relationType).ensure(RelationType.EQ, DfTypes.TRUE, new UnsatisfiedConditionProblem(this){}, null).pop();
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "builder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "call";
                break;
            }
        }
        objectArray[1] = "com/intellij/codeInspection/dataFlow/java/inliner/IndexOfInliner";
        objectArray[2] = "tryInlineCall";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

