/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.java.inliner;

import com.intellij.codeInsight.Nullability;
import com.intellij.codeInspection.dataFlow.DfaOptionalSupport;
import com.intellij.codeInspection.dataFlow.NullabilityProblemKind;
import com.intellij.codeInspection.dataFlow.java.CFGBuilder;
import com.intellij.codeInspection.dataFlow.java.inliner.CallInliner;
import com.intellij.codeInspection.dataFlow.java.inliner.InlinerUtil;
import com.intellij.codeInspection.dataFlow.jvm.SpecialField;
import com.intellij.codeInspection.dataFlow.jvm.descriptors.PlainDescriptor;
import com.intellij.codeInspection.dataFlow.jvm.problems.ContractFailureProblem;
import com.intellij.codeInspection.dataFlow.types.DfTypes;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.codeInspection.dataFlow.value.RelationType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.callMatcher.CallMapper;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.function.BiConsumer;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class OptionalChainInliner
implements CallInliner {
    private static final CallMatcher OPTIONAL_OR_ELSE = CallMatcher.anyOf(CallMatcher.instanceCall("java.util.Optional", "orElse").parameterCount(1), CallMatcher.instanceCall("java.util.OptionalInt", "orElse").parameterCount(1), CallMatcher.instanceCall("java.util.OptionalLong", "orElse").parameterCount(1), CallMatcher.instanceCall("java.util.OptionalDouble", "orElse").parameterCount(1), CallMatcher.instanceCall("com.google.common.base.Optional", "or").parameterTypes("T"));
    private static final CallMatcher OPTIONAL_GET = CallMatcher.anyOf(CallMatcher.exactInstanceCall("java.util.Optional", "get", "orElseThrow").parameterCount(0), CallMatcher.exactInstanceCall("java.util.OptionalInt", "getAsInt", "orElseThrow").parameterCount(0), CallMatcher.exactInstanceCall("java.util.OptionalLong", "getAsLong", "orElseThrow").parameterCount(0), CallMatcher.exactInstanceCall("java.util.OptionalDouble", "getAsDouble", "orElseThrow").parameterCount(0), CallMatcher.instanceCall("com.google.common.base.Optional", "get").parameterCount(0));
    private static final CallMatcher OPTIONAL_OR_NULL = CallMatcher.instanceCall("com.google.common.base.Optional", "orNull").parameterCount(0);
    private static final CallMatcher OPTIONAL_OR_ELSE_GET = CallMatcher.anyOf(CallMatcher.instanceCall("java.util.Optional", "orElseGet").parameterCount(1), CallMatcher.instanceCall("java.util.OptionalInt", "orElseGet").parameterCount(1), CallMatcher.instanceCall("java.util.OptionalLong", "orElseGet").parameterCount(1), CallMatcher.instanceCall("java.util.OptionalDouble", "orElseGet").parameterCount(1), CallMatcher.instanceCall("com.google.common.base.Optional", "or").parameterTypes("com.google.common.base.Supplier"));
    private static final CallMatcher OPTIONAL_OR = CallMatcher.instanceCall("java.util.Optional", "or").parameterCount(1);
    private static final CallMatcher OPTIONAL_IF_PRESENT = CallMatcher.anyOf(CallMatcher.instanceCall("java.util.Optional", "ifPresent").parameterCount(1), CallMatcher.instanceCall("java.util.OptionalInt", "ifPresent").parameterCount(1), CallMatcher.instanceCall("java.util.OptionalLong", "ifPresent").parameterCount(1), CallMatcher.instanceCall("java.util.OptionalDouble", "ifPresent").parameterCount(1));
    private static final CallMatcher OPTIONAL_FILTER = CallMatcher.instanceCall("java.util.Optional", "filter").parameterCount(1);
    private static final CallMatcher OPTIONAL_MAP = CallMatcher.instanceCall("java.util.Optional", "map").parameterCount(1);
    private static final CallMatcher GUAVA_TRANSFORM = CallMatcher.instanceCall("com.google.common.base.Optional", "transform").parameterCount(1);
    private static final CallMatcher OPTIONAL_FLAT_MAP = CallMatcher.instanceCall("java.util.Optional", "flatMap").parameterCount(1);
    private static final CallMatcher OPTIONAL_OF = CallMatcher.anyOf(CallMatcher.staticCall("java.util.Optional", "of", "ofNullable").parameterCount(1), CallMatcher.staticCall("java.util.OptionalInt", "of").parameterCount(1), CallMatcher.staticCall("java.util.OptionalLong", "of").parameterCount(1), CallMatcher.staticCall("java.util.OptionalDouble", "of").parameterCount(1), CallMatcher.staticCall("com.google.common.base.Optional", "of", "fromNullable").parameterCount(1));
    private static final CallMatcher OPTIONAL_EMPTY = CallMatcher.anyOf(CallMatcher.staticCall("java.util.Optional", "empty").parameterCount(0), CallMatcher.staticCall("java.util.OptionalInt", "empty").parameterCount(0), CallMatcher.staticCall("java.util.OptionalLong", "empty").parameterCount(0), CallMatcher.staticCall("java.util.OptionalDouble", "empty").parameterCount(0), CallMatcher.staticCall("com.google.common.base.Optional", "absent").parameterCount(0));
    private static final CallMatcher GUAVA_TO_JAVA = CallMatcher.instanceCall("com.google.common.base.Optional", "toJavaUtil").parameterCount(0);
    private static final CallMapper<BiConsumer<CFGBuilder, PsiMethodCallExpression>> TERMINAL_MAPPER = new CallMapper<BiConsumer<CFGBuilder, PsiMethodCallExpression>>().register(OPTIONAL_OR_ELSE, (builder, call) -> {
        PsiExpression argument = call.getArgumentList().getExpressions()[0];
        if (ExpressionUtils.isNullLiteral(argument)) {
            builder.resultOf((PsiExpression)call);
            return;
        }
        builder.pushExpression(argument).boxUnbox(argument, call.getType()).splice(2, 0, 1, 1).ifNotNull().boxUnbox((PsiExpression)call, OptionalChainInliner.getOptionalElementType(call.getMethodExpression().getQualifierExpression(), true), call.getType()).swap().end().pop().resultOf((PsiExpression)call);
    }).register(OPTIONAL_GET, (builder, call) -> builder.ensure(RelationType.NE, DfTypes.NULL, new ContractFailureProblem((PsiExpression)call), "java.util.NoSuchElementException").boxUnbox((PsiExpression)call, OptionalChainInliner.getOptionalElementType(call.getMethodExpression().getQualifierExpression(), true), call.getType()).resultOf((PsiExpression)call)).register(OPTIONAL_OR_NULL, CFGBuilder::resultOf).register(OPTIONAL_OR_ELSE_GET, (builder, call) -> {
        PsiExpression fn = call.getArgumentList().getExpressions()[0];
        builder.evaluateFunction(fn).dup().ifNull().pop().invokeFunction(0, fn).elseBranch().boxUnbox((PsiExpression)call, OptionalChainInliner.getOptionalElementType(call.getMethodExpression().getQualifierExpression(), true), call.getType()).end().resultOf((PsiExpression)call);
    }).register(OPTIONAL_IF_PRESENT, (builder, call) -> {
        PsiExpression fn = call.getArgumentList().getExpressions()[0];
        PsiExpression qualifier = call.getMethodExpression().getQualifierExpression();
        builder.evaluateFunction(fn).dup().ifNotNull().boxUnbox((PsiExpression)call, OptionalChainInliner.getOptionalElementType(qualifier, true), OptionalChainInliner.getOptionalElementType(qualifier, false)).invokeFunction(1, fn).elseBranch().pop().pushUnknown().end().resultOf((PsiExpression)call);
    });
    private static final CallMapper<BiConsumer<CFGBuilder, PsiExpression>> INTERMEDIATE_MAPPER = new CallMapper<BiConsumer<CFGBuilder, PsiExpression>>().register(OPTIONAL_MAP, (builder, function) -> OptionalChainInliner.inlineMap(builder, function, Nullability.NULLABLE)).register(GUAVA_TRANSFORM, (builder, function) -> OptionalChainInliner.inlineMap(builder, function, Nullability.NOT_NULL)).register(OPTIONAL_FILTER, (builder, function) -> builder.evaluateFunction((PsiExpression)function).dup().ifNotNull().dup().invokeFunction(1, (PsiExpression)function).ifConditionIs(false).pop().pushNull().end().end()).register(OPTIONAL_FLAT_MAP, (builder, function) -> builder.dup().ifNotNull().chain(b -> OptionalChainInliner.invokeAndUnwrapOptional(b, 1, function)).end()).register(OPTIONAL_OR, (builder, function) -> builder.dup().ifNull().pop().chain(b -> OptionalChainInliner.invokeAndUnwrapOptional(b, 0, function)).end()).register(GUAVA_TO_JAVA, (builder, stub) -> {});

    @Override
    public boolean tryInlineCall(@NotNull CFGBuilder builder, @NotNull PsiMethodCallExpression call) {
        BiConsumer<CFGBuilder, PsiMethodCallExpression> terminalInliner;
        if (builder == null) {
            OptionalChainInliner.$$$reportNull$$$0(0);
        }
        if (call == null) {
            OptionalChainInliner.$$$reportNull$$$0(1);
        }
        if ((terminalInliner = TERMINAL_MAPPER.mapFirst(call)) != null) {
            PsiExpression qualifierExpression = call.getMethodExpression().getQualifierExpression();
            if (!OptionalChainInliner.pushOptionalValue(builder, PsiUtil.skipParenthesizedExprDown((PsiExpression)qualifierExpression), null)) {
                return false;
            }
            terminalInliner.accept(builder, call);
            return true;
        }
        if (OptionalChainInliner.pushIntermediateOperationValue(builder, call)) {
            DfaVariableValue result = builder.createTempVariable(call.getType());
            builder.assign((DfaValue)result, DfTypes.typedObject(call.getType(), Nullability.NOT_NULL)).push(SpecialField.OPTIONAL_VALUE.createValue(builder.getFactory(), (DfaValue)result)).splice(3, 1, 0, 2).assign().pop().resultOf((PsiExpression)call);
            return true;
        }
        if (OPTIONAL_EMPTY.test(call)) {
            builder.push(DfaOptionalSupport.getOptionalValue(false), (PsiExpression)call);
            return true;
        }
        return false;
    }

    @Contract(value="null, _ -> null")
    private static PsiType getOptionalElementType(PsiExpression expression, boolean box) {
        if (expression == null) {
            return null;
        }
        PsiClassType type = (PsiClassType)ObjectUtils.tryCast((Object)expression.getType(), PsiClassType.class);
        if (type == null) {
            return null;
        }
        String rawName = type.rawType().getCanonicalText();
        if (rawName.equals("java.util.OptionalInt")) {
            return box ? PsiTypes.intType().getBoxedType((PsiElement)expression) : PsiTypes.intType();
        }
        if (rawName.equals("java.util.OptionalLong")) {
            return box ? PsiTypes.longType().getBoxedType((PsiElement)expression) : PsiTypes.longType();
        }
        if (rawName.equals("java.util.OptionalDouble")) {
            return box ? PsiTypes.doubleType().getBoxedType((PsiElement)expression) : PsiTypes.doubleType();
        }
        if (!rawName.equals("java.util.Optional") && !rawName.equals("com.google.common.base.Optional")) {
            return null;
        }
        PsiType[] parameters = type.getParameters();
        if (parameters.length != 1) {
            return null;
        }
        return parameters[0];
    }

    private static boolean pushOptionalValue(CFGBuilder builder, PsiExpression expression, NullabilityProblemKind<? super PsiExpression> problem) {
        PsiType optionalElementType = OptionalChainInliner.getOptionalElementType(expression, true);
        if (optionalElementType == null) {
            return false;
        }
        if (expression instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression qualifierCall = (PsiMethodCallExpression)expression;
            if (OPTIONAL_EMPTY.test(qualifierCall)) {
                builder.pushNull();
                return true;
            }
            if (OptionalChainInliner.pushIntermediateOperationValue(builder, qualifierCall)) {
                builder.dup().wrap(DfTypes.typedObject(qualifierCall.getType(), Nullability.NOT_NULL), SpecialField.OPTIONAL_VALUE).resultOf((PsiExpression)qualifierCall).pop().assignTo(builder.createTempVariable(optionalElementType));
                return true;
            }
        }
        builder.pushExpression(expression, problem).unwrap(SpecialField.OPTIONAL_VALUE).assignTo(builder.createTempVariable(optionalElementType));
        return true;
    }

    private static boolean pushIntermediateOperationValue(CFGBuilder builder, PsiMethodCallExpression call) {
        if (OPTIONAL_OF.test(call)) {
            PsiType optionalElementType = OptionalChainInliner.getOptionalElementType((PsiExpression)call, true);
            OptionalChainInliner.inlineOf(builder, optionalElementType, call);
            return true;
        }
        BiConsumer<CFGBuilder, PsiExpression> intermediateInliner = INTERMEDIATE_MAPPER.mapFirst(call);
        if (intermediateInliner == null) {
            return false;
        }
        PsiExpression argument = (PsiExpression)ArrayUtil.getFirstElement((Object[])call.getArgumentList().getExpressions());
        PsiExpression qualifierExpression = call.getMethodExpression().getQualifierExpression();
        if (!OptionalChainInliner.pushOptionalValue(builder, PsiUtil.skipParenthesizedExprDown((PsiExpression)qualifierExpression), null)) {
            return false;
        }
        intermediateInliner.accept(builder, argument);
        return true;
    }

    private static void invokeAndUnwrapOptional(CFGBuilder builder, int argCount, PsiExpression function) {
        PsiLambdaExpression lambda = (PsiLambdaExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)function), PsiLambdaExpression.class);
        if (lambda != null) {
            Object[] parameters = lambda.getParameterList().getParameters();
            PsiExpression lambdaBody = LambdaUtil.extractSingleExpressionFromBody((PsiElement)lambda.getBody());
            if (parameters.length == argCount && lambdaBody != null) {
                StreamEx.ofReversed((Object[])parameters).forEach(p -> builder.assignTo((PsiVariable)p).pop());
                if (OptionalChainInliner.pushOptionalValue(builder, lambdaBody, NullabilityProblemKind.nullableFunctionReturn)) {
                    return;
                }
                StreamEx.of((Object[])parameters).map(variable -> PlainDescriptor.createVariableValue(builder.getFactory(), (PsiVariable)variable)).forEach(builder::push);
            }
        }
        builder.evaluateFunction(function).invokeFunction(argCount, function, Nullability.NOT_NULL).pop().pushUnknown();
    }

    private static void inlineMap(CFGBuilder builder, PsiExpression function, Nullability resultNullability) {
        builder.evaluateFunction(function).dup().ifNotNull().invokeFunction(1, function, resultNullability).end();
    }

    private static void inlineOf(CFGBuilder builder, PsiType optionalElementType, PsiMethodCallExpression qualifierCall) {
        PsiExpression argument = qualifierCall.getArgumentList().getExpressions()[0];
        if ("of".equals(qualifierCall.getMethodExpression().getReferenceName())) {
            builder.pushExpression(argument, NullabilityProblemKind.passingToNotNullParameter).boxUnbox(argument, optionalElementType).push(DfaOptionalSupport.getOptionalValue(true), (PsiExpression)qualifierCall).pop();
        } else {
            builder.pushExpression(argument).boxUnbox(argument, optionalElementType).dup().ifNull().push(DfaOptionalSupport.getOptionalValue(false), (PsiExpression)qualifierCall).elseBranch().push(DfaOptionalSupport.getOptionalValue(true), (PsiExpression)qualifierCall).end().pop();
        }
    }

    @Override
    public boolean mayInferPreciseType(@NotNull PsiExpression expression) {
        if (expression == null) {
            OptionalChainInliner.$$$reportNull$$$0(2);
        }
        return InlinerUtil.isLambdaChainParameterReference(expression, TypeUtils::isOptional);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInspection/dataFlow/java/inliner/OptionalChainInliner";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "tryInlineCall";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "mayInferPreciseType";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

