/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.java.inst;

import com.intellij.codeInspection.dataFlow.TypeConstraint;
import com.intellij.codeInspection.dataFlow.interpreter.DataFlowInterpreter;
import com.intellij.codeInspection.dataFlow.java.JavaDfaHelpers;
import com.intellij.codeInspection.dataFlow.jvm.SpecialField;
import com.intellij.codeInspection.dataFlow.jvm.descriptors.ArrayElementDescriptor;
import com.intellij.codeInspection.dataFlow.jvm.problems.IndexOutOfBoundsProblem;
import com.intellij.codeInspection.dataFlow.lang.DfaAnchor;
import com.intellij.codeInspection.dataFlow.lang.ir.DfaInstructionState;
import com.intellij.codeInspection.dataFlow.lang.ir.ExpressionPushingInstruction;
import com.intellij.codeInspection.dataFlow.lang.ir.Instruction;
import com.intellij.codeInspection.dataFlow.memory.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeSet;
import com.intellij.codeInspection.dataFlow.types.DfIntType;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.value.DfaControlTransferValue;
import com.intellij.codeInspection.dataFlow.value.DfaTypeValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.codeInspection.dataFlow.value.VariableDescriptor;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArrayAccessInstruction
extends ExpressionPushingInstruction {
    @Nullable
    private final DfaControlTransferValue myOutOfBoundsTransfer;
    @NotNull
    private final IndexOutOfBoundsProblem myProblem;
    @Nullable
    private final VariableDescriptor myStaticValue;

    public ArrayAccessInstruction(@Nullable DfaAnchor anchor, @NotNull IndexOutOfBoundsProblem indexProblem, @Nullable DfaControlTransferValue outOfBoundsTransfer, @Nullable VariableDescriptor staticValue) {
        if (indexProblem == null) {
            ArrayAccessInstruction.$$$reportNull$$$0(0);
        }
        super(anchor);
        this.myOutOfBoundsTransfer = outOfBoundsTransfer;
        this.myProblem = indexProblem;
        this.myStaticValue = staticValue;
    }

    @NotNull
    public Instruction bindToFactory(@NotNull DfaValueFactory factory) {
        if (factory == null) {
            ArrayAccessInstruction.$$$reportNull$$$0(1);
        }
        DfaControlTransferValue newTransfer = this.myOutOfBoundsTransfer == null ? null : this.myOutOfBoundsTransfer.bindToFactory(factory);
        return new ArrayAccessInstruction(this.getDfaAnchor(), this.myProblem, newTransfer, this.myStaticValue);
    }

    public DfaInstructionState[] accept(@NotNull DataFlowInterpreter interpreter, @NotNull DfaMemoryState stateBefore) {
        DfaValue result;
        DfaInstructionState[] states;
        if (interpreter == null) {
            ArrayAccessInstruction.$$$reportNull$$$0(2);
        }
        if (stateBefore == null) {
            ArrayAccessInstruction.$$$reportNull$$$0(3);
        }
        DfaValue index = stateBefore.pop();
        DfaValue array = stateBefore.pop();
        ArrayList<DfaInstructionState> finalStates = new ArrayList<DfaInstructionState>();
        if (this.myOutOfBoundsTransfer != null) {
            finalStates.addAll(IndexOutOfBoundsProblem.dispatchTransfer(interpreter, stateBefore.createCopy(), this.myOutOfBoundsTransfer));
        }
        if ((states = this.myProblem.processOutOfBounds(interpreter, stateBefore, index, array, this.myOutOfBoundsTransfer)) != null) {
            return states;
        }
        LongRangeSet rangeSet = DfIntType.extractRange(stateBefore.getDfType(index));
        DfaValue arrayElementValue = ArrayElementDescriptor.getArrayElementValue(interpreter.getFactory(), array, rangeSet);
        if (!DfaTypeValue.isUnknown((DfaValue)arrayElementValue)) {
            result = arrayElementValue;
        } else {
            DfType type = TypeConstraint.fromDfType(stateBefore.getDfType(array)).getArrayComponentType();
            DfaTypeValue dfaTypeValue = result = (type = type.meet(ArrayElementDescriptor.getArrayComponentType(array))) == DfType.BOTTOM ? interpreter.getFactory().getUnknown() : interpreter.getFactory().fromDfType(type);
        }
        if (!(result instanceof DfaVariableValue) && array instanceof DfaVariableValue) {
            for (DfaVariableValue value : ((DfaVariableValue)array).getDependentVariables().toArray(new DfaVariableValue[0])) {
                if (value.getQualifier() != array) continue;
                JavaDfaHelpers.dropLocality((DfaValue)value, stateBefore);
            }
        }
        this.pushResult(interpreter, stateBefore, result, new DfaValue[0]);
        finalStates.add(this.nextState(interpreter, stateBefore));
        return finalStates.toArray(DfaInstructionState.EMPTY_ARRAY);
    }

    public List<VariableDescriptor> getRequiredDescriptors(@NotNull DfaValueFactory factory) {
        if (factory == null) {
            ArrayAccessInstruction.$$$reportNull$$$0(4);
        }
        return this.myStaticValue == null ? List.of(SpecialField.ARRAY_LENGTH) : List.of(this.myStaticValue, SpecialField.ARRAY_LENGTH);
    }

    public String toString() {
        return "ARRAY_ACCESS " + String.valueOf(this.getDfaAnchor());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexProblem";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreter";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stateBefore";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInspection/dataFlow/java/inst/ArrayAccessInstruction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "bindToFactory";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "accept";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getRequiredDescriptors";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

