/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.java.inst;

import com.intellij.codeInspection.dataFlow.DfaNullability;
import com.intellij.codeInspection.dataFlow.interpreter.DataFlowInterpreter;
import com.intellij.codeInspection.dataFlow.java.JavaDfaHelpers;
import com.intellij.codeInspection.dataFlow.java.anchor.JavaExpressionAnchor;
import com.intellij.codeInspection.dataFlow.lang.DfaAnchor;
import com.intellij.codeInspection.dataFlow.lang.ir.DfaInstructionState;
import com.intellij.codeInspection.dataFlow.lang.ir.ExpressionPushingInstruction;
import com.intellij.codeInspection.dataFlow.lang.ir.Instruction;
import com.intellij.codeInspection.dataFlow.memory.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.types.DfReferenceType;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.value.DfaTypeValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiUtil;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AssignInstruction
extends ExpressionPushingInstruction {
    private final PsiExpression myRExpression;
    private final PsiExpression myLExpression;
    @Nullable
    private final DfaValue myAssignedValue;

    public AssignInstruction(PsiExpression rExpression, @Nullable DfaValue assignedValue) {
        this(AssignInstruction.getLeftHandOfAssignment(rExpression), rExpression, assignedValue);
    }

    public AssignInstruction(PsiExpression lExpression, PsiExpression rExpression, @Nullable DfaValue assignedValue) {
        super(AssignInstruction.getAnchor(lExpression));
        this.myLExpression = lExpression;
        this.myRExpression = rExpression;
        this.myAssignedValue = assignedValue;
    }

    @Nullable
    private static DfaAnchor getAnchor(PsiExpression lExpression) {
        PsiExpression expression;
        if (lExpression == null) {
            return null;
        }
        PsiElement psiElement = lExpression.getParent();
        if (psiElement instanceof PsiExpression && ((expression = (PsiExpression)psiElement) instanceof PsiAssignmentExpression || PsiUtil.isIncrementDecrementOperation((PsiElement)expression))) {
            return new JavaExpressionAnchor(expression);
        }
        return null;
    }

    @NotNull
    public Instruction bindToFactory(@NotNull DfaValueFactory factory) {
        if (factory == null) {
            AssignInstruction.$$$reportNull$$$0(0);
        }
        if (this.myAssignedValue == null) {
            AssignInstruction assignInstruction = this;
            if (assignInstruction == null) {
                AssignInstruction.$$$reportNull$$$0(1);
            }
            return assignInstruction;
        }
        return new AssignInstruction(this.myLExpression, this.myRExpression, this.myAssignedValue.bindToFactory(factory));
    }

    public DfaInstructionState[] accept(@NotNull DataFlowInterpreter interpreter, @NotNull DfaMemoryState stateBefore) {
        DfaVariableValue sourceVar;
        DfaVariableValue destVar;
        if (interpreter == null) {
            AssignInstruction.$$$reportNull$$$0(2);
        }
        if (stateBefore == null) {
            AssignInstruction.$$$reportNull$$$0(3);
        }
        DfaValue dfaSource = stateBefore.pop();
        DfaValue dfaDest = stateBefore.pop();
        if (!(dfaDest instanceof DfaVariableValue) && this.myAssignedValue != null) {
            dfaDest = this.myAssignedValue;
        }
        interpreter.getListener().beforeAssignment(dfaSource, dfaDest, stateBefore, this.getDfaAnchor());
        if (dfaSource == dfaDest) {
            interpreter.getListener().afterAssignment(dfaSource, dfaDest, stateBefore, this.getDfaAnchor());
            stateBefore.push(dfaDest);
            return this.nextStates(interpreter, stateBefore);
        }
        if (!(dfaDest instanceof DfaVariableValue && (destVar = (DfaVariableValue)dfaDest).getPsiVariable() instanceof PsiLocalVariable && dfaSource instanceof DfaVariableValue && (DfaValueFactory.isTempVariable((DfaVariableValue)(sourceVar = (DfaVariableValue)dfaSource)) || sourceVar.getDescriptor().isCall()))) {
            JavaDfaHelpers.dropLocality(dfaSource, stateBefore);
        }
        if (dfaDest instanceof DfaVariableValue) {
            DfType dfType;
            PsiField field;
            DfaVariableValue var = (DfaVariableValue)dfaDest;
            PsiElement psi = var.getPsiVariable();
            if (dfaSource instanceof DfaTypeValue && (psi instanceof PsiField && (field = (PsiField)psi).hasModifierProperty("static") || var.getQualifier() != null && !stateBefore.getDfType((DfaValue)var.getQualifier()).isLocal()) && (dfType = dfaSource.getDfType()) instanceof DfReferenceType) {
                DfReferenceType refType = (DfReferenceType)dfType;
                dfaSource = dfaSource.getFactory().fromDfType((DfType)refType.dropLocality());
            }
            stateBefore.setVarValue(var, dfaSource);
            interpreter.getListener().afterAssignment(dfaSource, dfaDest, stateBefore, this.getDfaAnchor());
            if (DfaNullability.fromDfType(var.getInherentType()) == DfaNullability.NULLABLE && DfaNullability.fromDfType(stateBefore.getDfType((DfaValue)var)) == DfaNullability.UNKNOWN && this.isVariableInitializer()) {
                stateBefore.meetDfType((DfaValue)var, (DfType)DfaNullability.NULLABLE.asDfType());
            }
        }
        this.pushResult(interpreter, stateBefore, dfaDest instanceof DfaVariableValue ? dfaDest : dfaSource, new DfaValue[0]);
        return this.nextStates(interpreter, stateBefore);
    }

    @Nullable
    public PsiExpression getRExpression() {
        return this.myRExpression;
    }

    @Nullable
    public PsiExpression getLExpression() {
        return this.myLExpression;
    }

    @Nullable
    public DfaValue getAssignedValue() {
        return this.myAssignedValue;
    }

    private boolean isVariableInitializer() {
        return this.myRExpression != null && this.myRExpression.getParent() instanceof PsiVariable;
    }

    @Contract(value="null -> null")
    @Nullable
    private static PsiExpression getLeftHandOfAssignment(PsiExpression rExpression) {
        if (rExpression == null) {
            return null;
        }
        if (rExpression.getParent() instanceof PsiAssignmentExpression) {
            return ((PsiAssignmentExpression)rExpression.getParent()).getLExpression();
        }
        return null;
    }

    public String toString() {
        return "ASSIGN";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/java/inst/AssignInstruction";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreter";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stateBefore";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/java/inst/AssignInstruction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "bindToFactory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "bindToFactory";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

