/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.java.inst;

import com.intellij.codeInspection.dataFlow.DfaNullability;
import com.intellij.codeInspection.dataFlow.NullabilityProblemKind;
import com.intellij.codeInspection.dataFlow.interpreter.DataFlowInterpreter;
import com.intellij.codeInspection.dataFlow.interpreter.StandardDataFlowInterpreter;
import com.intellij.codeInspection.dataFlow.lang.ir.DfaInstructionState;
import com.intellij.codeInspection.dataFlow.lang.ir.Instruction;
import com.intellij.codeInspection.dataFlow.memory.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.types.DfTypes;
import com.intellij.codeInspection.dataFlow.value.DfaControlTransferValue;
import com.intellij.codeInspection.dataFlow.value.DfaTypeValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.psi.PsiElement;
import com.intellij.util.ThreeState;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CheckNotNullInstruction
extends Instruction {
    @NotNull
    private final NullabilityProblemKind.NullabilityProblem<?> myProblem;
    @Nullable
    private final DfaControlTransferValue myTransferValue;

    public CheckNotNullInstruction(@NotNull NullabilityProblemKind.NullabilityProblem<?> problem, @Nullable DfaControlTransferValue transferValue) {
        if (problem == null) {
            CheckNotNullInstruction.$$$reportNull$$$0(0);
        }
        this.myProblem = problem;
        this.myTransferValue = transferValue;
    }

    @NotNull
    public Instruction bindToFactory(@NotNull DfaValueFactory factory) {
        if (factory == null) {
            CheckNotNullInstruction.$$$reportNull$$$0(1);
        }
        if (this.myTransferValue == null) {
            CheckNotNullInstruction checkNotNullInstruction = this;
            if (checkNotNullInstruction == null) {
                CheckNotNullInstruction.$$$reportNull$$$0(2);
            }
            return checkNotNullInstruction;
        }
        return new CheckNotNullInstruction(this.myProblem, this.myTransferValue.bindToFactory(factory));
    }

    @NotNull
    public NullabilityProblemKind.NullabilityProblem<?> getProblem() {
        NullabilityProblemKind.NullabilityProblem<?> nullabilityProblem = this.myProblem;
        if (nullabilityProblem == null) {
            CheckNotNullInstruction.$$$reportNull$$$0(3);
        }
        return nullabilityProblem;
    }

    public DfaInstructionState[] accept(@NotNull DataFlowInterpreter interpreter, @NotNull DfaMemoryState stateBefore) {
        NullabilityProblemKind.NullabilityProblem<?> problem;
        if (interpreter == null) {
            CheckNotNullInstruction.$$$reportNull$$$0(4);
        }
        if (stateBefore == null) {
            CheckNotNullInstruction.$$$reportNull$$$0(5);
        }
        if ((problem = this.getProblem()).thrownException() == null) {
            CheckNotNullInstruction.checkNotNullable(interpreter, stateBefore, stateBefore.peek(), problem);
        } else {
            StandardDataFlowInterpreter standard;
            boolean isNull;
            DfaValue value = stateBefore.pop();
            boolean bl = isNull = interpreter instanceof StandardDataFlowInterpreter && (standard = (StandardDataFlowInterpreter)interpreter).stopOnNull() && stateBefore.getDfType(value) == DfTypes.NULL;
            if (this.myTransferValue == null) {
                stateBefore.push(CheckNotNullInstruction.dereference(interpreter, stateBefore, value, problem));
                if (isNull) {
                    return DfaInstructionState.EMPTY_ARRAY;
                }
            } else {
                ArrayList<DfaInstructionState> result = new ArrayList<DfaInstructionState>();
                DfaMemoryState nullState = stateBefore.createCopy();
                stateBefore.push(CheckNotNullInstruction.dereference(interpreter, stateBefore, value, problem));
                if (!isNull) {
                    result.add(this.nextState(interpreter, stateBefore));
                }
                if (nullState.applyCondition(value.eq((DfType)DfTypes.NULL))) {
                    List dispatched = this.myTransferValue.dispatch(nullState, interpreter);
                    for (DfaInstructionState npeState : dispatched) {
                        npeState.getMemoryState().markEphemeral();
                    }
                    result.addAll(dispatched);
                }
                return result.toArray(DfaInstructionState.EMPTY_ARRAY);
            }
        }
        return this.nextStates(interpreter, stateBefore);
    }

    public String toString() {
        return "CHECK_NOT_NULL " + String.valueOf(this.myProblem);
    }

    static <T extends PsiElement> DfaValue dereference(@NotNull DataFlowInterpreter interpreter, @NotNull DfaMemoryState memState, @NotNull DfaValue value, @Nullable NullabilityProblemKind.NullabilityProblem<T> problem) {
        if (interpreter == null) {
            CheckNotNullInstruction.$$$reportNull$$$0(6);
        }
        if (memState == null) {
            CheckNotNullInstruction.$$$reportNull$$$0(7);
        }
        if (value == null) {
            CheckNotNullInstruction.$$$reportNull$$$0(8);
        }
        CheckNotNullInstruction.checkNotNullable(interpreter, memState, value, problem);
        if (value instanceof DfaTypeValue) {
            DfType dfType = value.getDfType().meet((DfType)DfTypes.NOT_NULL_OBJECT);
            return value.getFactory().fromDfType((DfType)(dfType == DfType.BOTTOM ? DfTypes.NOT_NULL_OBJECT : dfType));
        }
        DfType dfType = memState.getDfType(value);
        if (dfType == DfTypes.NULL) {
            if (problem != null && problem.getKind() == NullabilityProblemKind.nullableFunctionReturn) {
                return value.getFactory().fromDfType((DfType)DfTypes.NOT_NULL_OBJECT);
            }
            memState.setDfType(value, (DfType)DfTypes.NOT_NULL_OBJECT);
        } else if (value instanceof DfaVariableValue) {
            memState.meetDfType(value, (DfType)DfTypes.NOT_NULL_OBJECT);
        }
        return value;
    }

    static void checkNotNullable(@NotNull DataFlowInterpreter interpreter, @NotNull DfaMemoryState state, @NotNull DfaValue value, @Nullable NullabilityProblemKind.NullabilityProblem<?> problem) {
        if (interpreter == null) {
            CheckNotNullInstruction.$$$reportNull$$$0(9);
        }
        if (state == null) {
            CheckNotNullInstruction.$$$reportNull$$$0(10);
        }
        if (value == null) {
            CheckNotNullInstruction.$$$reportNull$$$0(11);
        }
        if (problem != null) {
            DfaNullability nullability = DfaNullability.fromDfType(state.getDfType(value));
            ThreeState failed = nullability == DfaNullability.NOT_NULL ? ThreeState.NO : (nullability == DfaNullability.NULL ? ThreeState.YES : ThreeState.UNSURE);
            interpreter.getListener().onCondition(problem, value, failed, state);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problem";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/java/inst/CheckNotNullInstruction";
                break;
            }
            case 4: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreter";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stateBefore";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "memState";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/java/inst/CheckNotNullInstruction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "bindToFactory";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getProblem";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "bindToFactory";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "dereference";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "checkNotNullable";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }
}

