/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.java.inst;

import com.intellij.codeInsight.Nullability;
import com.intellij.codeInspection.dataFlow.ContractValue;
import com.intellij.codeInspection.dataFlow.DfaCallArguments;
import com.intellij.codeInspection.dataFlow.DfaCallState;
import com.intellij.codeInspection.dataFlow.DfaPsiUtil;
import com.intellij.codeInspection.dataFlow.DfaUtil;
import com.intellij.codeInspection.dataFlow.JavaMethodContractUtil;
import com.intellij.codeInspection.dataFlow.MethodContract;
import com.intellij.codeInspection.dataFlow.MutationSignature;
import com.intellij.codeInspection.dataFlow.NullabilityProblemKind;
import com.intellij.codeInspection.dataFlow.TypeConstraints;
import com.intellij.codeInspection.dataFlow.interpreter.DataFlowInterpreter;
import com.intellij.codeInspection.dataFlow.java.JavaDfaHelpers;
import com.intellij.codeInspection.dataFlow.java.anchor.JavaExpressionAnchor;
import com.intellij.codeInspection.dataFlow.java.anchor.JavaMethodReferenceReturnAnchor;
import com.intellij.codeInspection.dataFlow.java.inst.CheckNotNullInstruction;
import com.intellij.codeInspection.dataFlow.java.inst.MethodCallInstruction;
import com.intellij.codeInspection.dataFlow.lang.DfaAnchor;
import com.intellij.codeInspection.dataFlow.lang.ir.DfaInstructionState;
import com.intellij.codeInspection.dataFlow.lang.ir.ExpressionPushingInstruction;
import com.intellij.codeInspection.dataFlow.memory.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.types.DfTypes;
import com.intellij.codeInspection.dataFlow.value.DfaTypeValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiMethodReferenceUtil;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ObjectUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MethodReferenceInstruction
extends ExpressionPushingInstruction {
    public MethodReferenceInstruction(@NotNull PsiMethodReferenceExpression expression) {
        if (expression == null) {
            MethodReferenceInstruction.$$$reportNull$$$0(0);
        }
        super((DfaAnchor)new JavaExpressionAnchor((PsiExpression)expression));
    }

    public DfaInstructionState[] accept(@NotNull DataFlowInterpreter interpreter, @NotNull DfaMemoryState stateBefore) {
        if (interpreter == null) {
            MethodReferenceInstruction.$$$reportNull$$$0(1);
        }
        if (stateBefore == null) {
            MethodReferenceInstruction.$$$reportNull$$$0(2);
        }
        PsiMethodReferenceExpression expression = this.getMethodReference();
        DfaValue qualifier = stateBefore.pop();
        JavaDfaHelpers.dropLocality(qualifier, stateBefore);
        this.handleMethodReference(qualifier, interpreter, stateBefore);
        this.pushResult(interpreter, stateBefore, JavaDfaHelpers.getFunctionDfType((PsiFunctionalExpression)expression), new DfaValue[0]);
        return this.nextStates(interpreter, stateBefore);
    }

    public String toString() {
        return "METHOD_REF: " + String.valueOf(this.getDfaAnchor());
    }

    @NotNull
    public PsiMethodReferenceExpression getMethodReference() {
        PsiMethodReferenceExpression psiMethodReferenceExpression = (PsiMethodReferenceExpression)((JavaExpressionAnchor)Objects.requireNonNull(this.getDfaAnchor())).getExpression();
        if (psiMethodReferenceExpression == null) {
            MethodReferenceInstruction.$$$reportNull$$$0(3);
        }
        return psiMethodReferenceExpression;
    }

    private void handleMethodReference(@NotNull DfaValue qualifier, @NotNull DataFlowInterpreter interpreter, @NotNull DfaMemoryState state) {
        Nullability expectedNullability;
        PsiClass containingClass;
        PsiMethodReferenceExpression methodRef;
        PsiMethod sam;
        if (qualifier == null) {
            MethodReferenceInstruction.$$$reportNull$$$0(4);
        }
        if (interpreter == null) {
            MethodReferenceInstruction.$$$reportNull$$$0(5);
        }
        if (state == null) {
            MethodReferenceInstruction.$$$reportNull$$$0(6);
        }
        if ((sam = LambdaUtil.getFunctionalInterfaceMethod((PsiElement)(methodRef = this.getMethodReference()))) == null) {
            return;
        }
        JavaResolveResult resolveResult = methodRef.advancedResolve(false);
        PsiMethod method = (PsiMethod)ObjectUtils.tryCast((Object)resolveResult.getElement(), PsiMethod.class);
        if (method == null) {
            return;
        }
        PsiSubstitutor substitutor = resolveResult.getSubstitutor();
        DfaCallArguments callArguments = MethodReferenceInstruction.getMethodReferenceCallArguments(state, methodRef, qualifier, interpreter, sam, method, substitutor);
        if (MethodReferenceInstruction.isQualifierDereferenced(methodRef)) {
            CheckNotNullInstruction.dereference(interpreter, state, callArguments.getQualifier(), NullabilityProblemKind.callMethodRefNPE.problem(methodRef, null));
        }
        List<? extends MethodContract> contracts = JavaMethodContractUtil.getMethodCallContracts(method, null);
        PsiType returnType = substitutor.substitute(method.getReturnType());
        Object dfType = method.isConstructor() ? ((containingClass = method.getContainingClass()) != null ? TypeConstraints.exactClass(containingClass).asDfType().meet((DfType)DfTypes.NOT_NULL_OBJECT) : DfTypes.NOT_NULL_OBJECT) : DfTypes.typedObject(returnType, DfaPsiUtil.getElementNullabilityForRead(returnType, (PsiModifierListOwner)method));
        DfaTypeValue defaultResult = interpreter.getFactory().fromDfType(dfType);
        PsiType type = LambdaUtil.getFunctionalInterfaceReturnType((PsiFunctionalExpression)methodRef);
        if (!(type instanceof PsiPrimitiveType) && (expectedNullability = DfaPsiUtil.getTypeNullability(type)) == Nullability.NOT_NULL) {
            CheckNotNullInstruction.checkNotNullable(interpreter, state, (DfaValue)defaultResult, NullabilityProblemKind.nullableFunctionReturn.problem((PsiExpression)methodRef, null));
        }
        if (contracts.isEmpty() || !JavaMethodContractUtil.isPure(method)) {
            return;
        }
        Set<DfaCallState> currentStates = Collections.singleton(new DfaCallState(state.createClosureState(), callArguments, (DfaValue)defaultResult));
        JavaMethodReferenceReturnAnchor anchor = new JavaMethodReferenceReturnAnchor(methodRef);
        DfaValue[] args = callArguments.toArray();
        for (MethodContract methodContract : contracts) {
            HashSet<DfaMemoryState> results = new HashSet<DfaMemoryState>();
            currentStates = MethodCallInstruction.addContractResults(methodContract, currentStates, interpreter.getFactory(), results);
            for (DfaMemoryState result : results) {
                ContractValue.flushContractTempVariables(result);
                DfaValue value = result.pop();
                interpreter.getListener().beforePush(args, value, (DfaAnchor)anchor, result);
                result.push(value);
            }
        }
        for (DfaCallState dfaCallState : currentStates) {
            interpreter.getListener().beforePush(args, (DfaValue)defaultResult, (DfaAnchor)anchor, dfaCallState.getMemoryState());
            dfaCallState.getMemoryState().push((DfaValue)defaultResult);
            ContractValue.flushContractTempVariables(dfaCallState.getMemoryState());
        }
    }

    static boolean isQualifierDereferenced(@NotNull PsiMethodReferenceExpression methodRef) {
        if (methodRef == null) {
            MethodReferenceInstruction.$$$reportNull$$$0(7);
        }
        if (methodRef.isConstructor()) {
            return false;
        }
        PsiElement target = methodRef.resolve();
        if (!(target instanceof PsiMethod)) {
            return false;
        }
        if (((PsiMethod)target).hasModifierProperty("static")) {
            return false;
        }
        return PsiMethodReferenceUtil.isStaticallyReferenced((PsiMethodReferenceExpression)methodRef);
    }

    @NotNull
    private static DfaCallArguments getMethodReferenceCallArguments(@NotNull DfaMemoryState state, @NotNull PsiMethodReferenceExpression methodRef, DfaValue qualifier, @NotNull DataFlowInterpreter interpreter, @NotNull PsiMethod sam, @NotNull PsiMethod method, @NotNull PsiSubstitutor substitutor) {
        if (state == null) {
            MethodReferenceInstruction.$$$reportNull$$$0(8);
        }
        if (methodRef == null) {
            MethodReferenceInstruction.$$$reportNull$$$0(9);
        }
        if (interpreter == null) {
            MethodReferenceInstruction.$$$reportNull$$$0(10);
        }
        if (sam == null) {
            MethodReferenceInstruction.$$$reportNull$$$0(11);
        }
        if (method == null) {
            MethodReferenceInstruction.$$$reportNull$$$0(12);
        }
        if (substitutor == null) {
            MethodReferenceInstruction.$$$reportNull$$$0(13);
        }
        PsiParameter[] samParameters = sam.getParameterList().getParameters();
        boolean firstParameterIsQualifier = MethodReferenceInstruction.isQualifierDereferenced(methodRef);
        PsiParameter[] parameters = method.getParameterList().getParameters();
        Object[] arguments = parameters.length == 0 ? DfaValue.EMPTY_ARRAY : new DfaValue[parameters.length];
        Arrays.fill(arguments, interpreter.getFactory().getUnknown());
        for (int i = 0; i < samParameters.length; ++i) {
            DfaTypeValue value = interpreter.getFactory().fromDfType(DfTypes.typedObject(substitutor.substitute(samParameters[i].getType()), DfaPsiUtil.getFunctionalParameterNullability((PsiFunctionalExpression)methodRef, i)));
            if (i == 0 && firstParameterIsQualifier) {
                qualifier = value;
                continue;
            }
            int idx = i - (firstParameterIsQualifier ? 1 : 0);
            if (idx >= arguments.length) break;
            PsiType parameterType = parameters[idx].getType();
            if (parameterType instanceof PsiEllipsisType) continue;
            Nullability nullability = DfaPsiUtil.getElementNullabilityForWrite(substitutor.substitute(parameterType), (PsiModifierListOwner)parameters[idx]);
            arguments[idx] = MethodReferenceInstruction.adaptMethodRefArgument(interpreter, state, (DfaValue)value, methodRef, parameters[idx], nullability);
        }
        return new DfaCallArguments(qualifier, (DfaValue[])arguments, MutationSignature.fromMethod(method));
    }

    @NotNull
    static DfaValue adaptMethodRefArgument(@NotNull DataFlowInterpreter interpreter, @NotNull DfaMemoryState memState, @NotNull DfaValue arg, @NotNull PsiMethodReferenceExpression methodRef, @NotNull PsiParameter parameter, @Nullable Nullability nullability) {
        if (interpreter == null) {
            MethodReferenceInstruction.$$$reportNull$$$0(14);
        }
        if (memState == null) {
            MethodReferenceInstruction.$$$reportNull$$$0(15);
        }
        if (arg == null) {
            MethodReferenceInstruction.$$$reportNull$$$0(16);
        }
        if (methodRef == null) {
            MethodReferenceInstruction.$$$reportNull$$$0(17);
        }
        if (parameter == null) {
            MethodReferenceInstruction.$$$reportNull$$$0(18);
        }
        if (TypeConversionUtil.isPrimitiveAndNotNull((PsiType)parameter.getType())) {
            arg = CheckNotNullInstruction.dereference(interpreter, memState, arg, NullabilityProblemKind.unboxingMethodRefParameter.problem(methodRef, null));
            DfaValue dfaValue = DfaUtil.boxUnbox(arg, parameter.getType());
            if (dfaValue == null) {
                MethodReferenceInstruction.$$$reportNull$$$0(19);
            }
            return dfaValue;
        }
        if (nullability == Nullability.NOT_NULL) {
            DfaValue dfaValue = CheckNotNullInstruction.dereference(interpreter, memState, arg, NullabilityProblemKind.passingToNotNullMethodRefParameter.problem(methodRef, null));
            if (dfaValue == null) {
                MethodReferenceInstruction.$$$reportNull$$$0(20);
            }
            return dfaValue;
        }
        if (nullability == Nullability.UNKNOWN) {
            CheckNotNullInstruction.checkNotNullable(interpreter, memState, arg, NullabilityProblemKind.passingToNonAnnotatedMethodRefParameter.problem(methodRef, null));
        }
        DfaValue dfaValue = arg;
        if (dfaValue == null) {
            MethodReferenceInstruction.$$$reportNull$$$0(21);
        }
        return dfaValue;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 19, 20, 21 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: 
            case 5: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreter";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stateBefore";
                break;
            }
            case 3: 
            case 19: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/java/inst/MethodReferenceInstruction";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 7: 
            case 9: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodRef";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sam";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "memState";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arg";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/java/inst/MethodReferenceInstruction";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethodReference";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "adaptMethodRefArgument";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 3: 
            case 19: 
            case 20: 
            case 21: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "handleMethodReference";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isQualifierDereferenced";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getMethodReferenceCallArguments";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "adaptMethodRefArgument";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 19, 20, 21 -> new IllegalStateException(string);
        };
    }
}

