/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.java.inst;

import com.intellij.codeInspection.dataFlow.CustomMethodHandlers;
import com.intellij.codeInspection.dataFlow.TypeConstraint;
import com.intellij.codeInspection.dataFlow.jvm.SpecialField;
import com.intellij.codeInspection.dataFlow.lang.DfaAnchor;
import com.intellij.codeInspection.dataFlow.lang.ir.EvalInstruction;
import com.intellij.codeInspection.dataFlow.memory.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeBinOp;
import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeSet;
import com.intellij.codeInspection.dataFlow.types.DfBooleanType;
import com.intellij.codeInspection.dataFlow.types.DfFloatingPointType;
import com.intellij.codeInspection.dataFlow.types.DfIntConstantType;
import com.intellij.codeInspection.dataFlow.types.DfIntType;
import com.intellij.codeInspection.dataFlow.types.DfIntegralType;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.types.DfTypes;
import com.intellij.codeInspection.dataFlow.value.DfaTypeValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StringConcatInstruction
extends EvalInstruction {
    @NotNull
    private final TypeConstraint myStringType;

    public StringConcatInstruction(@Nullable DfaAnchor anchor, @NotNull TypeConstraint stringType) {
        if (stringType == null) {
            StringConcatInstruction.$$$reportNull$$$0(0);
        }
        super(anchor, 2);
        this.myStringType = stringType;
    }

    @NotNull
    public DfaValue eval(@NotNull DfaValueFactory factory, @NotNull DfaMemoryState state, DfaValue ... arguments) {
        DfIntType rightRange;
        if (factory == null) {
            StringConcatInstruction.$$$reportNull$$$0(1);
        }
        if (state == null) {
            StringConcatInstruction.$$$reportNull$$$0(2);
        }
        if (arguments == null) {
            StringConcatInstruction.$$$reportNull$$$0(3);
        }
        DfaValue left = arguments[0];
        DfaValue right = arguments[1];
        String leftString = StringConcatInstruction.getString(state, left);
        String rightString = StringConcatInstruction.getString(state, right);
        if (leftString != null && rightString != null && leftString.length() + rightString.length() <= 256) {
            DfaTypeValue dfaTypeValue = factory.fromDfType(DfTypes.concatenationResult(leftString + rightString, this.myStringType));
            if (dfaTypeValue == null) {
                StringConcatInstruction.$$$reportNull$$$0(4);
            }
            return dfaTypeValue;
        }
        DfIntType leftRange = StringConcatInstruction.getLength(factory, state, left, leftString);
        DfType resultRange = leftRange.eval(rightRange = StringConcatInstruction.getLength(factory, state, right, rightString), LongRangeBinOp.PLUS);
        DfType result = resultRange.isConst((Object)0) ? DfTypes.referenceConstant((Object)"", this.myStringType) : SpecialField.STRING_LENGTH.asDfType(resultRange).meet(this.myStringType.asDfType());
        DfaTypeValue dfaTypeValue = factory.fromDfType(result);
        if (dfaTypeValue == null) {
            StringConcatInstruction.$$$reportNull$$$0(5);
        }
        return dfaTypeValue;
    }

    @NotNull
    private static DfIntType getLength(@NotNull DfaValueFactory factory, @NotNull DfaMemoryState state, @NotNull DfaValue dfaValue, @Nullable String constValue) {
        DfType lengthType;
        if (factory == null) {
            StringConcatInstruction.$$$reportNull$$$0(6);
        }
        if (state == null) {
            StringConcatInstruction.$$$reportNull$$$0(7);
        }
        if (dfaValue == null) {
            StringConcatInstruction.$$$reportNull$$$0(8);
        }
        if (constValue != null) {
            DfIntConstantType dfIntConstantType = DfTypes.intValue(constValue.length());
            if (dfIntConstantType == null) {
                StringConcatInstruction.$$$reportNull$$$0(9);
            }
            return dfIntConstantType;
        }
        if (dfaValue.getDfType() instanceof DfIntegralType) {
            DfType decimalString = CustomMethodHandlers.numberAsDecimalString(state, dfaValue);
            lengthType = SpecialField.STRING_LENGTH.getFromQualifier(decimalString);
        } else if (dfaValue.getDfType() instanceof DfBooleanType) {
            lengthType = DfTypes.intRange(LongRangeSet.range((long)4L, (long)5L));
        } else if (dfaValue.getDfType() instanceof DfFloatingPointType) {
            lengthType = DfTypes.intRange(LongRangeSet.range((long)3L, (long)26L));
        } else {
            DfaValue lengthValue = SpecialField.STRING_LENGTH.createValue(factory, dfaValue);
            lengthType = state.getDfType(lengthValue);
        }
        if (lengthType instanceof DfIntType) {
            DfIntType intType;
            DfIntType dfIntType = intType = (DfIntType)lengthType;
            if (dfIntType == null) {
                StringConcatInstruction.$$$reportNull$$$0(10);
            }
            return dfIntType;
        }
        DfIntType dfIntType = (DfIntType)DfTypes.intRange(LongRangeSet.range((long)0L, (long)Integer.MAX_VALUE));
        if (dfIntType == null) {
            StringConcatInstruction.$$$reportNull$$$0(11);
        }
        return dfIntType;
    }

    @Nullable
    private static String getString(@NotNull DfaMemoryState state, DfaValue value) {
        DfType dfType;
        if (state == null) {
            StringConcatInstruction.$$$reportNull$$$0(12);
        }
        if ((dfType = state.getDfType(value)).equals((Object)DfTypes.NULL)) {
            return "null";
        }
        Object constant = dfType.getConstantOfType(Object.class);
        return constant instanceof String || constant instanceof Integer || constant instanceof Long || constant instanceof Boolean ? constant.toString() : null;
    }

    public String toString() {
        return "STRING_CONCAT";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 9, 10, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stringType";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 2: 
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/java/inst/StringConcatInstruction";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dfaValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/java/inst/StringConcatInstruction";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "eval";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getLength";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "eval";
                break;
            }
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getLength";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getString";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 9, 10, 11 -> new IllegalStateException(string);
        };
    }
}

