/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.jvm;

import com.intellij.codeInspection.dataFlow.TypeConstraints;
import com.intellij.codeInspection.dataFlow.jvm.transfer.EnterFinallyTrap;
import com.intellij.codeInspection.dataFlow.jvm.transfer.ExceptionTransfer;
import com.intellij.codeInspection.dataFlow.jvm.transfer.TryCatchAllTrap;
import com.intellij.codeInspection.dataFlow.jvm.transfer.TryCatchTrap;
import com.intellij.codeInspection.dataFlow.value.DfaControlTransferValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FList;
import com.intellij.util.containers.FactoryMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TrapTracker {
    @NotNull
    private FList<DfaControlTransferValue.Trap> myTrapStack;
    @NotNull
    private final DfaValueFactory myFactory;
    @NotNull
    private final Map<String, ExceptionTransfer> myExceptionCache;

    public TrapTracker(@NotNull DfaValueFactory factory, @NotNull TypeConstraints.TypeConstraintFactory typeConstraintFactory) {
        if (factory == null) {
            TrapTracker.$$$reportNull$$$0(0);
        }
        if (typeConstraintFactory == null) {
            TrapTracker.$$$reportNull$$$0(1);
        }
        this.myTrapStack = FList.emptyList();
        this.myFactory = factory;
        this.myExceptionCache = FactoryMap.create(fqn -> new ExceptionTransfer(typeConstraintFactory.create((String)fqn).instanceOf()));
    }

    public ExceptionTransfer transfer(@NotNull String exceptionName) {
        if (exceptionName == null) {
            TrapTracker.$$$reportNull$$$0(2);
        }
        return this.myExceptionCache.get(exceptionName);
    }

    @NotNull
    public FList<DfaControlTransferValue.Trap> trapStack() {
        FList<DfaControlTransferValue.Trap> fList = this.myTrapStack;
        if (fList == null) {
            TrapTracker.$$$reportNull$$$0(3);
        }
        return fList;
    }

    @NotNull
    public DfaControlTransferValue transferValue(@NotNull String exceptionName) {
        if (exceptionName == null) {
            TrapTracker.$$$reportNull$$$0(4);
        }
        DfaControlTransferValue dfaControlTransferValue = this.myFactory.controlTransfer((DfaControlTransferValue.TransferTarget)this.transfer(exceptionName), this.myTrapStack);
        if (dfaControlTransferValue == null) {
            TrapTracker.$$$reportNull$$$0(5);
        }
        return dfaControlTransferValue;
    }

    @Nullable
    public DfaControlTransferValue maybeTransferValue(@NotNull String exceptionName) {
        if (exceptionName == null) {
            TrapTracker.$$$reportNull$$$0(6);
        }
        return this.shouldHandleException() ? this.myFactory.controlTransfer((DfaControlTransferValue.TransferTarget)this.transfer(exceptionName), this.myTrapStack) : null;
    }

    @NotNull
    public DfaControlTransferValue transferValue(@NotNull DfaControlTransferValue.TransferTarget target) {
        if (target == null) {
            TrapTracker.$$$reportNull$$$0(7);
        }
        DfaControlTransferValue dfaControlTransferValue = this.myFactory.controlTransfer(target, this.myTrapStack);
        if (dfaControlTransferValue == null) {
            TrapTracker.$$$reportNull$$$0(8);
        }
        return dfaControlTransferValue;
    }

    @NotNull
    public @NotNull FList<// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull DfaControlTransferValue.Trap> getTrapsInsideElement(@Nullable PsiElement element) {
        if (element == null) {
            FList fList = FList.emptyList();
            if (fList == null) {
                TrapTracker.$$$reportNull$$$0(9);
            }
            return fList;
        }
        FList fList = FList.createFromReversed((Iterable)ContainerUtil.reverse((List)ContainerUtil.findAll(this.myTrapStack, cd -> PsiTreeUtil.isAncestor((PsiElement)element, (PsiElement)cd.getAnchor(), (boolean)true))));
        if (fList == null) {
            TrapTracker.$$$reportNull$$$0(10);
        }
        return fList;
    }

    public boolean shouldHandleException() {
        for (DfaControlTransferValue.Trap trap : this.myTrapStack) {
            if (!(trap instanceof TryCatchTrap) && !(trap instanceof EnterFinallyTrap) && !(trap instanceof TryCatchAllTrap)) continue;
            return true;
        }
        return false;
    }

    public void pushTrap(DfaControlTransferValue.Trap trap) {
        this.myTrapStack = this.myTrapStack.prepend((Object)trap);
    }

    public void popTrap(Class<? extends DfaControlTransferValue.Trap> aClass) {
        if (!aClass.isInstance(this.myTrapStack.getHead())) {
            throw new IllegalStateException("Unexpected trap-stack head (wanted: " + aClass.getSimpleName() + "); stack: " + String.valueOf(this.myTrapStack));
        }
        this.myTrapStack = this.myTrapStack.getTail();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 5, 8, 9, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeConstraintFactory";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptionName";
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/jvm/TrapTracker";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/jvm/TrapTracker";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "trapStack";
                break;
            }
            case 5: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "transferValue";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getTrapsInsideElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "transfer";
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 4: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "transferValue";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "maybeTransferValue";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 5, 8, 9, 10 -> new IllegalStateException(string);
        };
    }
}

