/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.jvm.problems;

import com.intellij.codeInspection.dataFlow.interpreter.DataFlowInterpreter;
import com.intellij.codeInspection.dataFlow.lang.UnsatisfiedConditionProblem;
import com.intellij.codeInspection.dataFlow.lang.ir.DfaInstructionState;
import com.intellij.codeInspection.dataFlow.memory.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.types.DfTypes;
import com.intellij.codeInspection.dataFlow.value.DerivedVariableDescriptor;
import com.intellij.codeInspection.dataFlow.value.DfaCondition;
import com.intellij.codeInspection.dataFlow.value.DfaControlTransferValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.RelationType;
import com.intellij.util.ThreeState;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface IndexOutOfBoundsProblem
extends UnsatisfiedConditionProblem {
    @NotNull
    public DerivedVariableDescriptor getLengthDescriptor();

    private boolean applyBoundsCheck(@NotNull DfaMemoryState memState, @NotNull DfaValue array, @NotNull DfaValue index) {
        if (memState == null) {
            IndexOutOfBoundsProblem.$$$reportNull$$$0(0);
        }
        if (array == null) {
            IndexOutOfBoundsProblem.$$$reportNull$$$0(1);
        }
        if (index == null) {
            IndexOutOfBoundsProblem.$$$reportNull$$$0(2);
        }
        DfaValueFactory factory = index.getFactory();
        DfaValue length = this.getLengthDescriptor().createValue(factory, array);
        DfaCondition lengthMoreThanZero = length.cond(RelationType.GT, (DfType)DfTypes.intValue(0));
        if (!memState.applyCondition(lengthMoreThanZero)) {
            return false;
        }
        DfaCondition indexNonNegative = index.cond(RelationType.GE, (DfType)DfTypes.intValue(0));
        if (!memState.applyCondition(indexNonNegative)) {
            return false;
        }
        DfaCondition indexLessThanLength = index.cond(RelationType.LT, length);
        return memState.applyCondition(indexLessThanLength);
    }

    default public DfaInstructionState @Nullable [] processOutOfBounds(@NotNull DataFlowInterpreter interpreter, @NotNull DfaMemoryState stateBefore, @NotNull DfaValue index, @NotNull DfaValue array, @Nullable DfaControlTransferValue outOfBoundsTransfer) {
        if (interpreter == null) {
            IndexOutOfBoundsProblem.$$$reportNull$$$0(3);
        }
        if (stateBefore == null) {
            IndexOutOfBoundsProblem.$$$reportNull$$$0(4);
        }
        if (index == null) {
            IndexOutOfBoundsProblem.$$$reportNull$$$0(5);
        }
        if (array == null) {
            IndexOutOfBoundsProblem.$$$reportNull$$$0(6);
        }
        boolean alwaysOutOfBounds = !this.applyBoundsCheck(stateBefore, array, index);
        ThreeState failed = alwaysOutOfBounds ? ThreeState.YES : ThreeState.UNSURE;
        interpreter.getListener().onCondition((UnsatisfiedConditionProblem)this, index, failed, stateBefore);
        if (alwaysOutOfBounds) {
            if (outOfBoundsTransfer != null) {
                List<DfaInstructionState> states = IndexOutOfBoundsProblem.dispatchTransfer(interpreter, stateBefore, outOfBoundsTransfer);
                return states.toArray(DfaInstructionState.EMPTY_ARRAY);
            }
            return DfaInstructionState.EMPTY_ARRAY;
        }
        return null;
    }

    @NotNull
    public static List<DfaInstructionState> dispatchTransfer(@NotNull DataFlowInterpreter interpreter, @NotNull DfaMemoryState stateBefore, @NotNull DfaControlTransferValue outOfBoundsTransfer) {
        if (interpreter == null) {
            IndexOutOfBoundsProblem.$$$reportNull$$$0(7);
        }
        if (stateBefore == null) {
            IndexOutOfBoundsProblem.$$$reportNull$$$0(8);
        }
        if (outOfBoundsTransfer == null) {
            IndexOutOfBoundsProblem.$$$reportNull$$$0(9);
        }
        List states = outOfBoundsTransfer.dispatch(stateBefore, interpreter);
        for (DfaInstructionState state : states) {
            state.getMemoryState().markEphemeral();
        }
        List list = states;
        if (list == null) {
            IndexOutOfBoundsProblem.$$$reportNull$$$0(10);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "memState";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "array";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "index";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreter";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stateBefore";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outOfBoundsTransfer";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/jvm/problems/IndexOutOfBoundsProblem";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/jvm/problems/IndexOutOfBoundsProblem";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "dispatchTransfer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "applyBoundsCheck";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "processOutOfBounds";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "dispatchTransfer";
                break;
            }
            case 10: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 10 -> new IllegalStateException(string);
        };
    }
}

