/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.types;

import com.intellij.codeInspection.dataFlow.jvm.JvmPsiRangeSetUtil;
import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeSet;
import com.intellij.codeInspection.dataFlow.types.DfAbstractRangeType;
import com.intellij.codeInspection.dataFlow.types.DfIntType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class DfIntRangeType
extends DfAbstractRangeType
implements DfIntType {
    @NotNull
    static final LongRangeSet FULL_RANGE = Objects.requireNonNull(JvmPsiRangeSetUtil.typeRange((PsiType)PsiTypes.intType()));

    DfIntRangeType(@NotNull LongRangeSet range, @Nullable LongRangeSet wideRange) {
        if (range == null) {
            DfIntRangeType.$$$reportNull$$$0(0);
        }
        super(DfIntRangeType.checkRange(range), wideRange);
    }

    @NotNull
    private static LongRangeSet checkRange(@NotNull LongRangeSet range) {
        if (range == null) {
            DfIntRangeType.$$$reportNull$$$0(1);
        }
        if (!FULL_RANGE.contains(range)) {
            throw new IllegalArgumentException("Illegal range supplied for int type: " + String.valueOf(range));
        }
        LongRangeSet longRangeSet = FULL_RANGE.equals(range) ? FULL_RANGE : range;
        if (longRangeSet == null) {
            DfIntRangeType.$$$reportNull$$$0(2);
        }
        return longRangeSet;
    }

    @Override
    @NotNull
    public String toString() {
        if (this.getRange() == FULL_RANGE) {
            return "int";
        }
        String string = "int " + JvmPsiRangeSetUtil.getPresentationText(this.getRange(), (PsiType)PsiTypes.intType());
        if (string == null) {
            DfIntRangeType.$$$reportNull$$$0(3);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/types/DfIntRangeType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/types/DfIntRangeType";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "checkRange";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "checkRange";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }
}

