/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.types;

import com.intellij.codeInspection.dataFlow.jvm.JvmPsiRangeSetUtil;
import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeSet;
import com.intellij.codeInspection.dataFlow.types.DfIntegralType;
import com.intellij.codeInspection.dataFlow.types.DfPrimitiveType;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.types.DfTypes;
import com.intellij.codeInspection.dataFlow.value.RelationType;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.util.TypeConversionUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface DfJvmIntegralType
extends DfIntegralType,
DfPrimitiveType {
    @Override
    @NotNull
    default public DfType castTo(@NotNull PsiPrimitiveType type) {
        if (type == null) {
            DfJvmIntegralType.$$$reportNull$$$0(0);
        }
        if (this.getConstantOfType(Object.class) != null) {
            DfType dfType = DfPrimitiveType.super.castTo(type);
            if (dfType == null) {
                DfJvmIntegralType.$$$reportNull$$$0(1);
            }
            return dfType;
        }
        if (type.equals((Object)PsiTypes.doubleType()) || type.equals((Object)PsiTypes.floatType())) {
            LongRangeSet range = this.getWideRange();
            if (range.isEmpty()) {
                DfType dfType = DfType.BOTTOM;
                if (dfType == null) {
                    DfJvmIntegralType.$$$reportNull$$$0(2);
                }
                return dfType;
            }
            DfType dfType = type.equals((Object)PsiTypes.doubleType()) ? DfTypes.doubleRange(range.min(), range.max()) : DfTypes.floatRange(range.min(), range.max());
            if (dfType == null) {
                DfJvmIntegralType.$$$reportNull$$$0(3);
            }
            return dfType;
        }
        if (!TypeConversionUtil.isIntegralNumberType((PsiType)type)) {
            DfType dfType = DfPrimitiveType.super.castTo(type);
            if (dfType == null) {
                DfJvmIntegralType.$$$reportNull$$$0(4);
            }
            return dfType;
        }
        LongRangeSet range = JvmPsiRangeSetUtil.castTo(this.getRange(), type);
        LongRangeSet wideRange = JvmPsiRangeSetUtil.castTo(this.getWideRange(), type);
        DfType dfType = type.equals((Object)PsiTypes.longType()) ? DfTypes.longRange(range, wideRange) : DfTypes.intRange(range, wideRange);
        if (dfType == null) {
            DfJvmIntegralType.$$$reportNull$$$0(5);
        }
        return dfType;
    }

    @NotNull
    default public DfType fromRelation(@NotNull RelationType relationType) {
        if (relationType == null) {
            DfJvmIntegralType.$$$reportNull$$$0(6);
        }
        if (relationType == RelationType.IS || relationType == RelationType.IS_NOT) {
            DfType dfType = DfType.TOP;
            if (dfType == null) {
                DfJvmIntegralType.$$$reportNull$$$0(7);
            }
            return dfType;
        }
        DfType dfType = DfTypes.rangeClamped(this.getRange().fromRelation(relationType), this.getLongRangeType());
        if (dfType == null) {
            DfJvmIntegralType.$$$reportNull$$$0(8);
        }
        return dfType;
    }

    default public boolean isSuperType(@NotNull DfType other) {
        if (other == null) {
            DfJvmIntegralType.$$$reportNull$$$0(9);
        }
        if (other == DfType.BOTTOM) {
            return true;
        }
        if (!(other instanceof DfIntegralType)) {
            return false;
        }
        DfIntegralType integralType = (DfIntegralType)other;
        if (integralType.getLongRangeType() != this.getLongRangeType()) {
            return false;
        }
        return this.getRange().contains(integralType.getRange()) && this.getWideRange().contains(integralType.getWideRange());
    }

    @NotNull
    default public DfType join(@NotNull DfType other) {
        if (other == null) {
            DfJvmIntegralType.$$$reportNull$$$0(10);
        }
        if (other == DfType.BOTTOM || other == this) {
            DfJvmIntegralType dfJvmIntegralType = this;
            if (dfJvmIntegralType == null) {
                DfJvmIntegralType.$$$reportNull$$$0(11);
            }
            return dfJvmIntegralType;
        }
        if (!(other instanceof DfIntegralType)) {
            DfType dfType = DfType.TOP;
            if (dfType == null) {
                DfJvmIntegralType.$$$reportNull$$$0(12);
            }
            return dfType;
        }
        if (((DfIntegralType)other).getLongRangeType() != this.getLongRangeType()) {
            DfType dfType = DfType.TOP;
            if (dfType == null) {
                DfJvmIntegralType.$$$reportNull$$$0(13);
            }
            return dfType;
        }
        LongRangeSet range = ((DfIntegralType)other).getRange().join(this.getRange());
        LongRangeSet wideRange = ((DfIntegralType)other).getWideRange().join(this.getWideRange());
        DfType dfType = DfTypes.range(range, wideRange, this.getLongRangeType());
        if (dfType == null) {
            DfJvmIntegralType.$$$reportNull$$$0(14);
        }
        return dfType;
    }

    @Nullable
    default public DfType tryJoinExactly(@NotNull DfType other) {
        if (other == null) {
            DfJvmIntegralType.$$$reportNull$$$0(15);
        }
        if (other == DfType.BOTTOM || other == this) {
            return this;
        }
        if (other == DfType.TOP) {
            return other;
        }
        if (!(other instanceof DfIntegralType)) {
            return null;
        }
        if (((DfIntegralType)other).getLongRangeType() != this.getLongRangeType()) {
            return null;
        }
        LongRangeSet range = ((DfIntegralType)other).getRange().tryJoinExactly(this.getRange());
        LongRangeSet wideRange = ((DfIntegralType)other).getWideRange().tryJoinExactly(this.getWideRange());
        if (range == null || wideRange == null) {
            return null;
        }
        return DfTypes.range(range, wideRange, this.getLongRangeType());
    }

    @NotNull
    default public DfType meet(@NotNull DfType other) {
        if (other == null) {
            DfJvmIntegralType.$$$reportNull$$$0(16);
        }
        if (other == DfType.TOP || other == this) {
            DfJvmIntegralType dfJvmIntegralType = this;
            if (dfJvmIntegralType == null) {
                DfJvmIntegralType.$$$reportNull$$$0(17);
            }
            return dfJvmIntegralType;
        }
        if (!(other instanceof DfIntegralType)) {
            DfType dfType = DfType.BOTTOM;
            if (dfType == null) {
                DfJvmIntegralType.$$$reportNull$$$0(18);
            }
            return dfType;
        }
        if (((DfIntegralType)other).getLongRangeType() != this.getLongRangeType()) {
            DfType dfType = DfType.BOTTOM;
            if (dfType == null) {
                DfJvmIntegralType.$$$reportNull$$$0(19);
            }
            return dfType;
        }
        LongRangeSet range = ((DfIntegralType)other).getRange().meet(this.getRange());
        LongRangeSet wideRange = ((DfIntegralType)other).getWideRange().meet(this.getWideRange());
        DfType dfType = DfTypes.range(range, wideRange, this.getLongRangeType());
        if (dfType == null) {
            DfJvmIntegralType.$$$reportNull$$$0(20);
        }
        return dfType;
    }

    @NotNull
    default public DfType meetRange(@NotNull LongRangeSet range) {
        if (range == null) {
            DfJvmIntegralType.$$$reportNull$$$0(21);
        }
        LongRangeSet resultRange = range.meet(this.getRange());
        LongRangeSet wideRange = range.meet(this.getWideRange());
        DfType dfType = DfTypes.range(resultRange, wideRange, this.getLongRangeType());
        if (dfType == null) {
            DfJvmIntegralType.$$$reportNull$$$0(22);
        }
        return dfType;
    }

    default public DfType widen() {
        LongRangeSet wideRange = this.getWideRange();
        return wideRange.equals(this.getRange()) ? this : DfTypes.range(wideRange, null, this.getLongRangeType());
    }

    @Nullable
    default public DfType tryNegate() {
        LongRangeSet range = this.getRange();
        LongRangeSet res = this.getLongRangeType().fullRange().subtract(range);
        return res.intersects(range) ? null : DfTypes.range(res, null, this.getLongRangeType());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 5, 7, 8, 11, 12, 13, 14, 17, 18, 19, 20, 22 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/types/DfJvmIntegralType";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relationType";
                break;
            }
            case 9: 
            case 10: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/types/DfJvmIntegralType";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "castTo";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "fromRelation";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "join";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "meet";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "meetRange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "castTo";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "fromRelation";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isSuperType";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "join";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "tryJoinExactly";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "meet";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "meetRange";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 5, 7, 8, 11, 12, 13, 14, 17, 18, 19, 20, 22 -> new IllegalStateException(string);
        };
    }
}

