/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.types;

import com.intellij.codeInsight.Nullability;
import com.intellij.codeInspection.dataFlow.DfaNullability;
import com.intellij.codeInspection.dataFlow.Mutability;
import com.intellij.codeInspection.dataFlow.TypeConstraint;
import com.intellij.codeInspection.dataFlow.TypeConstraints;
import com.intellij.codeInspection.dataFlow.jvm.JvmPsiRangeSetUtil;
import com.intellij.codeInspection.dataFlow.jvm.SpecialField;
import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeSet;
import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeType;
import com.intellij.codeInspection.dataFlow.types.DfBooleanConstantType;
import com.intellij.codeInspection.dataFlow.types.DfBooleanType;
import com.intellij.codeInspection.dataFlow.types.DfConstantType;
import com.intellij.codeInspection.dataFlow.types.DfDoubleConstantType;
import com.intellij.codeInspection.dataFlow.types.DfDoubleRangeType;
import com.intellij.codeInspection.dataFlow.types.DfDoubleType;
import com.intellij.codeInspection.dataFlow.types.DfFloatConstantType;
import com.intellij.codeInspection.dataFlow.types.DfFloatRangeType;
import com.intellij.codeInspection.dataFlow.types.DfFloatType;
import com.intellij.codeInspection.dataFlow.types.DfGenericObjectType;
import com.intellij.codeInspection.dataFlow.types.DfIntConstantType;
import com.intellij.codeInspection.dataFlow.types.DfIntRangeType;
import com.intellij.codeInspection.dataFlow.types.DfIntType;
import com.intellij.codeInspection.dataFlow.types.DfLongConstantType;
import com.intellij.codeInspection.dataFlow.types.DfLongRangeType;
import com.intellij.codeInspection.dataFlow.types.DfLongType;
import com.intellij.codeInspection.dataFlow.types.DfNullConstantType;
import com.intellij.codeInspection.dataFlow.types.DfReferenceConstantType;
import com.intellij.codeInspection.dataFlow.types.DfReferenceType;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DfTypes {
    public static final DfBooleanType BOOLEAN = new DfBooleanType(){

        public boolean isSuperType(@NotNull DfType other) {
            if (other == null) {
                1.$$$reportNull$$$0(0);
            }
            return other == BOTTOM || other instanceof DfBooleanType;
        }

        @NotNull
        public DfType join(@NotNull DfType other) {
            if (other == null) {
                1.$$$reportNull$$$0(1);
            }
            1 v0 = other instanceof DfBooleanType ? this : TOP;
            if (v0 == null) {
                1.$$$reportNull$$$0(2);
            }
            return v0;
        }

        @Nullable
        public DfType tryJoinExactly(@NotNull DfType other) {
            if (other == null) {
                1.$$$reportNull$$$0(3);
            }
            return other instanceof DfBooleanType ? this : null;
        }

        @NotNull
        public DfType meet(@NotNull DfType other) {
            if (other == null) {
                1.$$$reportNull$$$0(4);
            }
            if (other == TOP) {
                1 v0 = this;
                if (v0 == null) {
                    1.$$$reportNull$$$0(5);
                }
                return v0;
            }
            if (other instanceof DfBooleanType) {
                DfType dfType = other;
                if (dfType == null) {
                    1.$$$reportNull$$$0(6);
                }
                return dfType;
            }
            DfType dfType = BOTTOM;
            if (dfType == null) {
                1.$$$reportNull$$$0(7);
            }
            return dfType;
        }

        @NotNull
        public DfType tryNegate() {
            DfType dfType = BOTTOM;
            if (dfType == null) {
                1.$$$reportNull$$$0(8);
            }
            return dfType;
        }

        public int hashCode() {
            return 345661;
        }

        @NotNull
        public String toString() {
            return "boolean";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 5, 6, 7, 8 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "other";
                    break;
                }
                case 2: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/dataFlow/types/DfTypes$1";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/dataFlow/types/DfTypes$1";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "join";
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "meet";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "tryNegate";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "isSuperType";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "join";
                    break;
                }
                case 2: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "tryJoinExactly";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "meet";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 5, 6, 7, 8 -> new IllegalStateException(string);
            };
        }
    };
    @NotNull
    public static final DfBooleanConstantType TRUE = new DfBooleanConstantType(true);
    @NotNull
    public static final DfBooleanConstantType FALSE = new DfBooleanConstantType(false);
    public static final DfIntType INT = new DfIntRangeType(Objects.requireNonNull(JvmPsiRangeSetUtil.typeRange((PsiType)PsiTypes.intType())), null);
    public static final DfLongType LONG = new DfLongRangeType(LongRangeSet.all(), null);
    public static final DfFloatType FLOAT = new DfFloatRangeType(Float.NEGATIVE_INFINITY, Float.POSITIVE_INFINITY, false, true);
    public static final DfFloatType FLOAT_NAN = new DfFloatConstantType(Float.NaN);
    public static final DfDoubleType DOUBLE = new DfDoubleRangeType(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, false, true);
    public static final DfDoubleType DOUBLE_NAN = new DfDoubleConstantType(Double.NaN);
    public static final DfNullConstantType NULL = new DfNullConstantType();
    public static final DfReferenceType NOT_NULL_OBJECT = DfTypes.customObject(TypeConstraints.TOP, DfaNullability.NOT_NULL, Mutability.UNKNOWN, null, DfType.BOTTOM);
    public static final DfReferenceType OBJECT_OR_NULL = DfTypes.customObject(TypeConstraints.TOP, DfaNullability.UNKNOWN, Mutability.UNKNOWN, null, DfType.BOTTOM);
    public static final DfReferenceType LOCAL_OBJECT = new DfGenericObjectType(Set.of(), TypeConstraints.TOP, DfaNullability.NOT_NULL, Mutability.UNKNOWN, null, DfType.BOTTOM, true);

    private DfTypes() {
    }

    @Contract(pure=true)
    @NotNull
    public static DfBooleanConstantType booleanValue(boolean value) {
        DfBooleanConstantType dfBooleanConstantType = value ? TRUE : FALSE;
        if (dfBooleanConstantType == null) {
            DfTypes.$$$reportNull$$$0(0);
        }
        return dfBooleanConstantType;
    }

    @NotNull
    public static DfType intRangeClamped(LongRangeSet range) {
        return DfTypes.intRange(range.meet(DfIntRangeType.FULL_RANGE));
    }

    @NotNull
    public static DfType intRange(LongRangeSet range) {
        if (range.equals(DfIntRangeType.FULL_RANGE)) {
            DfIntType dfIntType = INT;
            if (dfIntType == null) {
                DfTypes.$$$reportNull$$$0(1);
            }
            return dfIntType;
        }
        if (range.isEmpty()) {
            DfType dfType = DfType.BOTTOM;
            if (dfType == null) {
                DfTypes.$$$reportNull$$$0(2);
            }
            return dfType;
        }
        Long value = range.getConstantValue();
        if (value != null) {
            return DfTypes.intValue(Math.toIntExact(value));
        }
        return new DfIntRangeType(range, null);
    }

    @NotNull
    static DfType intRange(@NotNull LongRangeSet range, @Nullable LongRangeSet wideRange) {
        if (range == null) {
            DfTypes.$$$reportNull$$$0(3);
        }
        if (wideRange == null || wideRange.equals(range) || wideRange.isEmpty()) {
            return DfTypes.intRange(range);
        }
        if (range.isEmpty()) {
            DfType dfType = DfType.BOTTOM;
            if (dfType == null) {
                DfTypes.$$$reportNull$$$0(4);
            }
            return dfType;
        }
        Long value = range.getConstantValue();
        if (value != null) {
            return new DfIntConstantType(Math.toIntExact(value), wideRange);
        }
        return new DfIntRangeType(range, wideRange);
    }

    @NotNull
    public static DfIntConstantType intValue(int value) {
        return new DfIntConstantType(value, null);
    }

    @NotNull
    public static DfType longRange(LongRangeSet range) {
        if (range.equals(LongRangeSet.all())) {
            DfLongType dfLongType = LONG;
            if (dfLongType == null) {
                DfTypes.$$$reportNull$$$0(5);
            }
            return dfLongType;
        }
        if (range.isEmpty()) {
            DfType dfType = DfType.BOTTOM;
            if (dfType == null) {
                DfTypes.$$$reportNull$$$0(6);
            }
            return dfType;
        }
        Long value = range.getConstantValue();
        if (value != null) {
            return DfTypes.longValue(value);
        }
        return new DfLongRangeType(range, null);
    }

    @NotNull
    static DfType longRange(@NotNull LongRangeSet range, @Nullable LongRangeSet wideRange) {
        if (range == null) {
            DfTypes.$$$reportNull$$$0(7);
        }
        if (wideRange == null || wideRange.equals(range) || wideRange.isEmpty()) {
            return DfTypes.longRange(range);
        }
        if (range.isEmpty()) {
            DfType dfType = DfType.BOTTOM;
            if (dfType == null) {
                DfTypes.$$$reportNull$$$0(8);
            }
            return dfType;
        }
        Long value = range.getConstantValue();
        if (value != null) {
            return new DfLongConstantType(value, wideRange);
        }
        return new DfLongRangeType(range, wideRange);
    }

    @NotNull
    public static DfLongConstantType longValue(long value) {
        return new DfLongConstantType(value, null);
    }

    @NotNull
    public static DfType rangeClamped(@NotNull LongRangeSet range, @NotNull LongRangeType lrType) {
        if (range == null) {
            DfTypes.$$$reportNull$$$0(9);
        }
        if (lrType == null) {
            DfTypes.$$$reportNull$$$0(10);
        }
        return switch (lrType) {
            default -> throw new MatchException(null, null);
            case LongRangeType.INT32 -> DfTypes.intRangeClamped(range);
            case LongRangeType.INT64 -> DfTypes.longRange(range);
        };
    }

    @NotNull
    static DfType range(@NotNull LongRangeSet range, @Nullable LongRangeSet wideRange, @NotNull LongRangeType lrType) {
        if (range == null) {
            DfTypes.$$$reportNull$$$0(11);
        }
        if (lrType == null) {
            DfTypes.$$$reportNull$$$0(12);
        }
        return switch (lrType) {
            default -> throw new MatchException(null, null);
            case LongRangeType.INT32 -> DfTypes.intRange(range, wideRange);
            case LongRangeType.INT64 -> DfTypes.longRange(range, wideRange);
        };
    }

    public static DfFloatConstantType floatValue(float value) {
        return new DfFloatConstantType(value);
    }

    public static DfType floatRange(float min, float max) {
        if (min > max) {
            throw new IllegalArgumentException();
        }
        return DfFloatRangeType.create(min, max, false, false);
    }

    public static DfDoubleConstantType doubleValue(double value) {
        return new DfDoubleConstantType(value);
    }

    public static DfType doubleRange(double min, double max) {
        if (min > max) {
            throw new IllegalArgumentException();
        }
        return DfDoubleRangeType.create(min, max, false, false);
    }

    @NotNull
    public static DfConstantType<?> constant(@Nullable Object constant, @NotNull PsiType type) {
        if (type == null) {
            DfTypes.$$$reportNull$$$0(13);
        }
        if (constant == null) {
            DfNullConstantType dfNullConstantType = NULL;
            if (dfNullConstantType == null) {
                DfTypes.$$$reportNull$$$0(14);
            }
            return dfNullConstantType;
        }
        DfConstantType<?> primitiveConstant = DfTypes.primitiveConstantImpl(constant);
        if (primitiveConstant != null) {
            DfConstantType<?> dfConstantType = primitiveConstant;
            if (dfConstantType == null) {
                DfTypes.$$$reportNull$$$0(15);
            }
            return dfConstantType;
        }
        return DfTypes.referenceConstant(constant, type);
    }

    @NotNull
    public static DfConstantType<?> constant(@Nullable Object constant, @NotNull DfType type) {
        if (type == null) {
            DfTypes.$$$reportNull$$$0(16);
        }
        if (constant == null) {
            DfNullConstantType dfNullConstantType = NULL;
            if (dfNullConstantType == null) {
                DfTypes.$$$reportNull$$$0(17);
            }
            return dfNullConstantType;
        }
        DfConstantType<?> primitiveConstant = DfTypes.primitiveConstantImpl(constant);
        if (primitiveConstant != null) {
            DfConstantType<?> dfConstantType = primitiveConstant;
            if (dfConstantType == null) {
                DfTypes.$$$reportNull$$$0(18);
            }
            return dfConstantType;
        }
        if (!(type instanceof DfReferenceType)) {
            throw new IllegalArgumentException("Not reference type: " + String.valueOf(type) + "; constant: " + String.valueOf(constant));
        }
        return new DfReferenceConstantType(constant, ((DfReferenceType)type).getConstraint(), false);
    }

    @NotNull
    public static DfConstantType<?> referenceConstant(@NotNull Object constant, @NotNull PsiType type) {
        if (constant == null) {
            DfTypes.$$$reportNull$$$0(19);
        }
        if (type == null) {
            DfTypes.$$$reportNull$$$0(20);
        }
        return new DfReferenceConstantType(constant, TypeConstraints.instanceOf(type), false);
    }

    @NotNull
    public static DfConstantType<?> referenceConstant(@NotNull Object constant, @NotNull TypeConstraint constraint) {
        if (constant == null) {
            DfTypes.$$$reportNull$$$0(21);
        }
        if (constraint == null) {
            DfTypes.$$$reportNull$$$0(22);
        }
        return new DfReferenceConstantType(constant, constraint, false);
    }

    @NotNull
    public static DfConstantType<?> primitiveConstant(@NotNull Object constant) {
        DfConstantType<?> res;
        if (constant == null) {
            DfTypes.$$$reportNull$$$0(23);
        }
        if ((res = DfTypes.primitiveConstantImpl(constant)) == null) {
            throw new IllegalArgumentException("Invalid value supplied: " + String.valueOf(constant) + "(type: " + String.valueOf(constant.getClass()) + ")");
        }
        DfConstantType<?> dfConstantType = res;
        if (dfConstantType == null) {
            DfTypes.$$$reportNull$$$0(24);
        }
        return dfConstantType;
    }

    @Nullable
    private static DfConstantType<?> primitiveConstantImpl(@NotNull Object constant) {
        if (constant == null) {
            DfTypes.$$$reportNull$$$0(25);
        }
        if (constant instanceof Boolean) {
            return DfTypes.booleanValue((Boolean)constant);
        }
        if (constant instanceof Integer || constant instanceof Short || constant instanceof Byte) {
            return DfTypes.intValue(((Number)constant).intValue());
        }
        if (constant instanceof Character) {
            return DfTypes.intValue(((Character)constant).charValue());
        }
        if (constant instanceof Long) {
            return DfTypes.longValue((Long)constant);
        }
        if (constant instanceof Float) {
            return DfTypes.floatValue(((Float)constant).floatValue());
        }
        if (constant instanceof Double) {
            return DfTypes.doubleValue((Double)constant);
        }
        return null;
    }

    @NotNull
    public static DfConstantType<?> concatenationResult(@NotNull String constant, @NotNull TypeConstraint constraint) {
        if (constant == null) {
            DfTypes.$$$reportNull$$$0(26);
        }
        if (constraint == null) {
            DfTypes.$$$reportNull$$$0(27);
        }
        return new DfReferenceConstantType(constant, constraint, true);
    }

    public static DfConstantType<?> defaultValue(@NotNull PsiType type) {
        if (type == null) {
            DfTypes.$$$reportNull$$$0(28);
        }
        if (type instanceof PsiPrimitiveType) {
            return switch (type.getCanonicalText()) {
                case "boolean" -> FALSE;
                case "byte", "char", "short", "int" -> DfTypes.intValue(0);
                case "long" -> DfTypes.longValue(0L);
                case "float" -> DfTypes.floatValue(0.0f);
                case "double" -> DfTypes.doubleValue(0.0);
                default -> NULL;
            };
        }
        return NULL;
    }

    @NotNull
    public static DfType typedObject(@Nullable PsiType type) {
        if (type == null) {
            DfType dfType = DfType.TOP;
            if (dfType == null) {
                DfTypes.$$$reportNull$$$0(29);
            }
            return dfType;
        }
        return DfTypes.typedObject(type, type.getNullability().nullability());
    }

    @NotNull
    public static DfType typedObject(@Nullable PsiType type, @NotNull Nullability nullability) {
        TypeConstraint constraint;
        if (nullability == null) {
            DfTypes.$$$reportNull$$$0(30);
        }
        if (type == null) {
            DfType dfType = DfType.TOP;
            if (dfType == null) {
                DfTypes.$$$reportNull$$$0(31);
            }
            return dfType;
        }
        if (type instanceof PsiPrimitiveType) {
            if (type.equals(PsiTypes.voidType())) {
                DfType dfType = DfType.BOTTOM;
                if (dfType == null) {
                    DfTypes.$$$reportNull$$$0(32);
                }
                return dfType;
            }
            if (type.equals(PsiTypes.booleanType())) {
                DfBooleanType dfBooleanType = BOOLEAN;
                if (dfBooleanType == null) {
                    DfTypes.$$$reportNull$$$0(33);
                }
                return dfBooleanType;
            }
            if (type.equals(PsiTypes.intType())) {
                DfIntType dfIntType = INT;
                if (dfIntType == null) {
                    DfTypes.$$$reportNull$$$0(34);
                }
                return dfIntType;
            }
            if (type.equals(PsiTypes.charType()) || type.equals(PsiTypes.shortType()) || type.equals(PsiTypes.byteType())) {
                return DfTypes.intRange(Objects.requireNonNull(JvmPsiRangeSetUtil.typeRange(type)));
            }
            if (type.equals(PsiTypes.longType())) {
                DfLongType dfLongType = LONG;
                if (dfLongType == null) {
                    DfTypes.$$$reportNull$$$0(35);
                }
                return dfLongType;
            }
            if (type.equals(PsiTypes.doubleType())) {
                DfDoubleType dfDoubleType = DOUBLE;
                if (dfDoubleType == null) {
                    DfTypes.$$$reportNull$$$0(36);
                }
                return dfDoubleType;
            }
            if (type.equals(PsiTypes.floatType())) {
                DfFloatType dfFloatType = FLOAT;
                if (dfFloatType == null) {
                    DfTypes.$$$reportNull$$$0(37);
                }
                return dfFloatType;
            }
            if (type.equals(PsiTypes.nullType())) {
                DfNullConstantType dfNullConstantType = NULL;
                if (dfNullConstantType == null) {
                    DfTypes.$$$reportNull$$$0(38);
                }
                return dfNullConstantType;
            }
        }
        if ((constraint = TypeConstraints.instanceOf(type)) == TypeConstraints.BOTTOM) {
            Object object = nullability == Nullability.NOT_NULL ? DfType.BOTTOM : NULL;
            if (object == null) {
                DfTypes.$$$reportNull$$$0(39);
            }
            return object;
        }
        if (constraint.isSingleton() && nullability == Nullability.NOT_NULL) {
            return new DfReferenceConstantType(constraint, constraint, false);
        }
        Mutability mutability = Mutability.UNKNOWN;
        if (type.hasAnnotation(Mutability.UNMODIFIABLE_ANNOTATION)) {
            mutability = Mutability.UNMODIFIABLE;
        } else if (type.hasAnnotation(Mutability.UNMODIFIABLE_VIEW_ANNOTATION)) {
            mutability = Mutability.UNMODIFIABLE_VIEW;
        }
        return new DfGenericObjectType(Set.of(), constraint, DfaNullability.fromNullability(nullability), mutability, null, DfType.BOTTOM, false);
    }

    public static DfReferenceType customObject(@NotNull TypeConstraint constraint, @NotNull DfaNullability nullability, @NotNull Mutability mutability, @Nullable SpecialField jvmSpecialField, @NotNull DfType sfType) {
        if (constraint == null) {
            DfTypes.$$$reportNull$$$0(40);
        }
        if (nullability == null) {
            DfTypes.$$$reportNull$$$0(41);
        }
        if (mutability == null) {
            DfTypes.$$$reportNull$$$0(42);
        }
        if (sfType == null) {
            DfTypes.$$$reportNull$$$0(43);
        }
        if (nullability == DfaNullability.NULL) {
            throw new IllegalArgumentException();
        }
        return new DfGenericObjectType(Set.of(), constraint, nullability, mutability, jvmSpecialField, sfType, false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 3, 7, 9, 10, 11, 12, 13, 16, 19, 20, 21, 22, 23, 25, 26, 27, 28, 30, 40, 41, 42, 43 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/types/DfTypes";
                break;
            }
            case 3: 
            case 7: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lrType";
                break;
            }
            case 13: 
            case 16: 
            case 20: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 19: 
            case 21: 
            case 23: 
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constant";
                break;
            }
            case 22: 
            case 27: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constraint";
                break;
            }
            case 30: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nullability";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mutability";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sfType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "booleanValue";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "intRange";
                break;
            }
            case 3: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/types/DfTypes";
                break;
            }
            case 5: 
            case 6: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "longRange";
                break;
            }
            case 14: 
            case 15: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "constant";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "primitiveConstant";
                break;
            }
            case 29: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "typedObject";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "intRange";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "longRange";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "rangeClamped";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "range";
                break;
            }
            case 13: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "constant";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "referenceConstant";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "primitiveConstant";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "primitiveConstantImpl";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "concatenationResult";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "defaultValue";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "typedObject";
                break;
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "customObject";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 3, 7, 9, 10, 11, 12, 13, 16, 19, 20, 21, 22, 23, 25, 26, 27, 28, 30, 40, 41, 42, 43 -> new IllegalArgumentException(string);
        };
    }
}

