/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.deadCode;

import com.intellij.analysis.AnalysisBundle;
import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.GlobalInspectionTool;
import com.intellij.codeInspection.GlobalJavaInspectionContext;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.deadCode.RefSerializationUtil;
import com.intellij.codeInspection.deadCode.RefUnreachableFilter;
import com.intellij.codeInspection.deadCode.UnreferencedFilter;
import com.intellij.codeInspection.ex.EntryPointsManager;
import com.intellij.codeInspection.ex.EntryPointsManagerBase;
import com.intellij.codeInspection.ex.GlobalInspectionContextBase;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.JobDescriptor;
import com.intellij.codeInspection.reference.EntryPoint;
import com.intellij.codeInspection.reference.RefClass;
import com.intellij.codeInspection.reference.RefClassImpl;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefElementImpl;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefField;
import com.intellij.codeInspection.reference.RefFunctionalExpression;
import com.intellij.codeInspection.reference.RefImplicitConstructor;
import com.intellij.codeInspection.reference.RefJavaElement;
import com.intellij.codeInspection.reference.RefJavaElementImpl;
import com.intellij.codeInspection.reference.RefJavaVisitor;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefMethod;
import com.intellij.codeInspection.reference.RefOverridable;
import com.intellij.codeInspection.reference.RefUtil;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.codeInspection.unusedSymbol.UnusedSymbolLocalInspection;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiImplicitClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.impl.PsiClassImplUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiMethodUtil;
import com.intellij.uast.UastMetaLanguage;
import com.intellij.util.containers.Stack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.UMethod;

public class UnusedDeclarationInspectionBase
extends GlobalInspectionTool {
    protected static final Logger LOG = Logger.getInstance(UnusedDeclarationInspectionBase.class);
    public boolean ADD_MAINS_TO_ENTRIES = true;
    public boolean ADD_APPLET_TO_ENTRIES = true;
    public boolean ADD_SERVLET_TO_ENTRIES = true;
    public boolean ADD_NONJAVA_TO_ENTRIES = true;
    protected boolean TEST_ENTRY_POINTS = true;
    public static final String SHORT_NAME = "unused";
    public static final String ALTERNATIVE_ID = "UnusedDeclaration";
    @ApiStatus.Internal
    public final UnusedSymbolLocalInspection localInspectionBase = this.createUnusedSymbolLocalInspection();
    private static final Key<Set<RefElement>> PROCESSED_SUSPICIOUS_ELEMENTS_KEY = Key.create((String)"java.unused.declaration.processed.suspicious.elements");
    private static final Key<Integer> PHASE_KEY = Key.create((String)"java.unused.declaration.phase");
    private final boolean myEnabledInEditor;
    private final Map<String, Element> entryPointElements = new ConcurrentHashMap<String, Element>();

    public UnusedDeclarationInspectionBase() {
        this(!ApplicationManager.getApplication().isUnitTestMode());
    }

    @TestOnly
    public UnusedDeclarationInspectionBase(boolean enabledInEditor) {
        this.myEnabledInEditor = enabledInEditor;
    }

    @NotNull
    protected UnusedSymbolLocalInspection createUnusedSymbolLocalInspection() {
        return new UnusedSymbolLocalInspection();
    }

    @NotNull
    public UnusedSymbolLocalInspection getSharedLocalInspectionTool() {
        UnusedSymbolLocalInspection unusedSymbolLocalInspection = this.localInspectionBase;
        if (unusedSymbolLocalInspection == null) {
            UnusedDeclarationInspectionBase.$$$reportNull$$$0(0);
        }
        return unusedSymbolLocalInspection;
    }

    private boolean isAddMainsEnabled() {
        return this.ADD_MAINS_TO_ENTRIES;
    }

    private boolean isAddAppletEnabled() {
        return this.ADD_APPLET_TO_ENTRIES;
    }

    private boolean isAddServletEnabled() {
        return this.ADD_SERVLET_TO_ENTRIES;
    }

    private boolean isAddNonJavaUsedEnabled() {
        return this.ADD_NONJAVA_TO_ENTRIES;
    }

    public boolean isTestEntryPoints() {
        return this.TEST_ENTRY_POINTS;
    }

    public void setTestEntryPoints(boolean testEntryPoints) {
        this.TEST_ENTRY_POINTS = testEntryPoints;
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = InspectionsBundle.message((String)"group.names.declaration.redundancy", (Object[])new Object[0]);
        if (string == null) {
            UnusedDeclarationInspectionBase.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        return SHORT_NAME;
    }

    public void readSettings(@NotNull Element node) throws InvalidDataException {
        if (node == null) {
            UnusedDeclarationInspectionBase.$$$reportNull$$$0(2);
        }
        super.readSettings(node);
        this.localInspectionBase.readSettings(node);
        for (EntryPoint extension : this.getExtensions()) {
            extension.readExternal(node);
            this.saveEntryPointElement(extension);
        }
        String testEntriesAttr = node.getAttributeValue("test_entries");
        this.TEST_ENTRY_POINTS = testEntriesAttr == null || Boolean.parseBoolean(testEntriesAttr);
    }

    protected void saveEntryPointElement(@NotNull EntryPoint entryPoint) {
        if (entryPoint == null) {
            UnusedDeclarationInspectionBase.$$$reportNull$$$0(3);
        }
        Element element = new Element("root");
        entryPoint.writeExternal(element);
        this.entryPointElements.put(entryPoint.getDisplayName(), element);
    }

    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        if (node == null) {
            UnusedDeclarationInspectionBase.$$$reportNull$$$0(4);
        }
        this.localInspectionBase.writeSettings(node);
        this.writeUnusedDeclarationSettings(node);
        if (!this.TEST_ENTRY_POINTS) {
            node.setAttribute("test_entries", Boolean.toString(false));
        }
    }

    @ApiStatus.Internal
    public void writeUnusedDeclarationSettings(@NotNull Element node) throws WriteExternalException {
        if (node == null) {
            UnusedDeclarationInspectionBase.$$$reportNull$$$0(5);
        }
        super.writeSettings(node);
        for (EntryPoint extension : this.getExtensions()) {
            extension.writeExternal(node);
        }
    }

    public boolean isReadActionNeeded() {
        return false;
    }

    public boolean isGlobalSimpleInspectionTool() {
        return Registry.is((String)"java.unused.declaration.inspection.use.shallow.local.anaysis.as.global");
    }

    public void checkFile(@NotNull PsiFile psiFile, @NotNull InspectionManager manager, @NotNull ProblemsHolder ignored, @NotNull GlobalInspectionContext globalContext, @NotNull ProblemDescriptionsProcessor problemDescriptionsProcessor) {
        if (psiFile == null) {
            UnusedDeclarationInspectionBase.$$$reportNull$$$0(6);
        }
        if (manager == null) {
            UnusedDeclarationInspectionBase.$$$reportNull$$$0(7);
        }
        if (ignored == null) {
            UnusedDeclarationInspectionBase.$$$reportNull$$$0(8);
        }
        if (globalContext == null) {
            UnusedDeclarationInspectionBase.$$$reportNull$$$0(9);
        }
        if (problemDescriptionsProcessor == null) {
            UnusedDeclarationInspectionBase.$$$reportNull$$$0(10);
        }
        if (!psiFile.getLanguage().isKindOf("JAVA")) {
            return;
        }
        ProblemsHolder problemsHolder = new ProblemsHolder(manager, psiFile, false);
        final PsiElementVisitor visitor2 = this.localInspectionBase.buildVisitor(problemsHolder, false);
        psiFile.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(this){

            public void visitElement(@NotNull PsiElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                element.accept(visitor2);
                super.visitElement(element);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInspection/deadCode/UnusedDeclarationInspectionBase$1", "visitElement"));
            }
        });
        for (ProblemDescriptor problemDescriptor : problemsHolder.getResults()) {
            PsiElement psiElement = problemDescriptor.getPsiElement();
            if (psiElement == null) continue;
            PsiNamedElement member = globalContext.getRefManager().getContainerElement(psiElement);
            RefElement reference = globalContext.getRefManager().getReference((PsiElement)member);
            if (reference == null) continue;
            problemDescriptionsProcessor.addProblemElement((RefEntity)reference, new CommonProblemDescriptor[]{problemDescriptor});
        }
    }

    public void runInspection(final @NotNull AnalysisScope scope, @NotNull InspectionManager manager, final @NotNull GlobalInspectionContext globalContext, @NotNull ProblemDescriptionsProcessor problemDescriptionsProcessor) {
        if (scope == null) {
            UnusedDeclarationInspectionBase.$$$reportNull$$$0(11);
        }
        if (manager == null) {
            UnusedDeclarationInspectionBase.$$$reportNull$$$0(12);
        }
        if (globalContext == null) {
            UnusedDeclarationInspectionBase.$$$reportNull$$$0(13);
        }
        if (problemDescriptionsProcessor == null) {
            UnusedDeclarationInspectionBase.$$$reportNull$$$0(14);
        }
        globalContext.getRefManager().iterate((RefVisitor)new RefJavaVisitor(){

            public void visitElement(@NotNull RefEntity refEntity) {
                if (refEntity == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (refEntity instanceof RefElementImpl) {
                    RefElementImpl refElement = (RefElementImpl)refEntity;
                    if (!refElement.isSuspicious()) {
                        return;
                    }
                    PsiFile file = refElement.getContainingFile();
                    if (file == null) {
                        return;
                    }
                    if (!((GlobalInspectionContextBase)globalContext).isToCheckFile((PsiFileSystemItem)file, (InspectionProfileEntry)UnusedDeclarationInspectionBase.this) && !scope.contains((PsiElement)file)) {
                        UnusedDeclarationInspectionBase.getEntryPointsManager(globalContext).addEntryPoint((RefElement)refElement, false);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refEntity", "com/intellij/codeInspection/deadCode/UnusedDeclarationInspectionBase$2", "visitElement"));
            }
        });
        globalContext.putUserData(PHASE_KEY, (Object)1);
        globalContext.putUserData(PROCESSED_SUSPICIOUS_ELEMENTS_KEY, new HashSet());
    }

    public boolean isEntryPoint(@NotNull RefElement owner) {
        EntryPointsManager entryPointsManager;
        UElement uElement;
        if (owner == null) {
            UnusedDeclarationInspectionBase.$$$reportNull$$$0(15);
        }
        PsiElement element = owner.getPsiElement();
        if (owner instanceof RefJavaElement && (uElement = ((RefJavaElement)owner).getUastElement()) != null) {
            element = uElement.getJavaPsi();
        }
        if (RefUtil.isImplicitUsage((PsiElement)element)) {
            return true;
        }
        if (element instanceof PsiModifierListOwner && (entryPointsManager = EntryPointsManager.getInstance((Project)element.getProject())).isEntryPoint(element)) {
            return true;
        }
        if (element != null) {
            for (EntryPoint extension : this.getExtensions()) {
                if (!extension.isSelected() || !extension.isEntryPoint(owner, element)) continue;
                return true;
            }
            if (this.isAddMainsEnabled() && owner instanceof RefMethod && ((RefMethod)owner).isAppMain()) {
                return true;
            }
            if (element instanceof PsiImplicitClass) {
                return true;
            }
            return owner instanceof RefClass && (this.isAddAppletEnabled() && ((RefClass)owner).isApplet() || this.isAddServletEnabled() && ((RefClass)owner).isServlet());
        }
        return false;
    }

    public boolean isEntryPoint(@NotNull PsiElement element) {
        if (element == null) {
            UnusedDeclarationInspectionBase.$$$reportNull$$$0(16);
        }
        return this.isStrictEntryPoint(element) || RefUtil.isImplicitUsage((PsiElement)element);
    }

    public boolean isStrictEntryPoint(@NotNull PsiElement element) {
        EntryPointsManager entryPointsManager;
        if (element == null) {
            UnusedDeclarationInspectionBase.$$$reportNull$$$0(17);
        }
        if (element instanceof PsiMethod && this.isAddMainsEnabled() && PsiClassImplUtil.isMainOrPremainMethod((PsiMethod)((PsiMethod)element))) {
            return true;
        }
        Project project = element.getProject();
        if (element instanceof PsiClass) {
            PsiClass servlet;
            PsiClass applet;
            PsiClass aClass = (PsiClass)element;
            if (element instanceof PsiImplicitClass) {
                return true;
            }
            JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
            if (this.isAddAppletEnabled() && (applet = psiFacade.findClass("java.applet.Applet", GlobalSearchScope.allScope((Project)project))) != null && aClass.isInheritor(applet, true)) {
                return true;
            }
            if (this.isAddServletEnabled() && (servlet = psiFacade.findClass("javax.servlet.Servlet", GlobalSearchScope.allScope((Project)project))) != null && aClass.isInheritor(servlet, true)) {
                return true;
            }
            if (this.isAddMainsEnabled() && UnusedDeclarationInspectionBase.hasMainMethodDeep(aClass)) {
                return true;
            }
        }
        if (element instanceof PsiModifierListOwner && (entryPointsManager = EntryPointsManager.getInstance((Project)project)).isEntryPoint(element)) {
            return true;
        }
        for (EntryPoint extension : this.getExtensions()) {
            if (!extension.isSelected() || !extension.isEntryPoint(element)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasMainMethodDeep(@NotNull PsiClass aClass) {
        if (aClass == null) {
            UnusedDeclarationInspectionBase.$$$reportNull$$$0(18);
        }
        if (PsiMethodUtil.hasMainMethod((PsiClass)aClass)) {
            return true;
        }
        for (PsiClass innerClass : aClass.getInnerClasses()) {
            if (!innerClass.hasModifierProperty("static") || !PsiMethodUtil.hasMainMethod((PsiClass)innerClass)) continue;
            return true;
        }
        return false;
    }

    public boolean isGlobalEnabledInEditor() {
        return this.myEnabledInEditor;
    }

    @NotNull
    public static UnusedDeclarationInspectionBase findUnusedDeclarationInspection(@NotNull PsiElement element) {
        InspectionProfileImpl profile;
        UnusedDeclarationInspectionBase tool;
        if (element == null) {
            UnusedDeclarationInspectionBase.$$$reportNull$$$0(19);
        }
        UnusedDeclarationInspectionBase unusedDeclarationInspectionBase = (tool = (UnusedDeclarationInspectionBase)(profile = InspectionProjectProfileManager.getInstance((Project)element.getProject()).getCurrentProfile()).getUnwrappedTool(SHORT_NAME, element)) == null ? new UnusedDeclarationInspectionBase() : tool;
        if (unusedDeclarationInspectionBase == null) {
            UnusedDeclarationInspectionBase.$$$reportNull$$$0(20);
        }
        return unusedDeclarationInspectionBase;
    }

    public static boolean isDeclaredAsEntryPoint(@NotNull PsiElement method) {
        if (method == null) {
            UnusedDeclarationInspectionBase.$$$reportNull$$$0(21);
        }
        return UnusedDeclarationInspectionBase.findUnusedDeclarationInspection(method).isEntryPoint(method);
    }

    public boolean queryExternalUsagesRequests(@NotNull InspectionManager manager, final @NotNull GlobalInspectionContext globalContext, @NotNull ProblemDescriptionsProcessor problemDescriptionsProcessor) {
        if (manager == null) {
            UnusedDeclarationInspectionBase.$$$reportNull$$$0(22);
        }
        if (globalContext == null) {
            UnusedDeclarationInspectionBase.$$$reportNull$$$0(23);
        }
        if (problemDescriptionsProcessor == null) {
            UnusedDeclarationInspectionBase.$$$reportNull$$$0(24);
        }
        this.checkForReachableRefs(globalContext);
        int phase = Objects.requireNonNull((Integer)globalContext.getUserData(PHASE_KEY));
        if (phase == 2) {
            globalContext.putUserData(PROCESSED_SUSPICIOUS_ELEMENTS_KEY, null);
            return false;
        }
        final Set processedSuspicious = (Set)globalContext.getUserData(PROCESSED_SUSPICIOUS_ELEMENTS_KEY);
        final boolean firstPhase = phase == 1;
        final RefUnreachableFilter filter = firstPhase ? new StrictUnreferencedFilter(this, globalContext) : new RefUnreachableFilter(this, globalContext);
        LOG.assertTrue(processedSuspicious != null, (Object)("phase: " + phase));
        final Collection uastLanguages = ((UastMetaLanguage)Language.findInstance(UastMetaLanguage.class)).getMatchingLanguages();
        globalContext.getRefManager().iterate((RefVisitor)new RefJavaVisitor(){

            public void visitField(@NotNull RefField refField) {
                if (refField == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (!filter.accepts((RefJavaElement)refField) || processedSuspicious.contains(refField)) {
                    return;
                }
                processedSuspicious.add(refField);
                UField uField = refField.getUastElement();
                if (uField != null && RefSerializationUtil.isSerializationImplicitlyUsedField(uField)) {
                    UnusedDeclarationInspectionBase.getEntryPointsManager(globalContext).addEntryPoint((RefElement)refField, false);
                } else {
                    ((GlobalJavaInspectionContext)globalContext.getExtension(GlobalJavaInspectionContext.CONTEXT)).enqueueFieldUsagesProcessor(refField, psiReference -> {
                        UnusedDeclarationInspectionBase.getEntryPointsManager(globalContext).addEntryPoint((RefElement)refField, false);
                        return false;
                    });
                }
            }

            public void visitMethod(@NotNull RefMethod refMethod) {
                UMethod uMethod;
                RefClass ownerClass;
                if (refMethod == null) {
                    3.$$$reportNull$$$0(1);
                }
                if (!filter.accepts((RefJavaElement)refMethod) || processedSuspicious.contains(refMethod)) {
                    return;
                }
                processedSuspicious.add(refMethod);
                if (refMethod instanceof RefImplicitConstructor) {
                    RefImplicitConstructor ctor = (RefImplicitConstructor)refMethod;
                    RefClass ownerClass2 = ctor.getOwnerClass();
                    this.doVisitClass(ownerClass2);
                    return;
                }
                if (refMethod.isConstructor() && (ownerClass = refMethod.getOwnerClass()) != null) {
                    this.queryQualifiedNameUsages(ownerClass);
                }
                if ((uMethod = refMethod.getUastElement()) != null && RefSerializationUtil.isSerializationMethod(uMethod, refMethod.getOwnerClass())) {
                    UnusedDeclarationInspectionBase.getEntryPointsManager(globalContext).addEntryPoint((RefElement)refMethod, false);
                } else if (!refMethod.isExternalOverride() && !"private".equals(refMethod.getAccessModifier())) {
                    processedSuspicious.addAll(refMethod.getDerivedMethods());
                    UnusedDeclarationInspectionBase.enqueueMethodUsages(globalContext, refMethod);
                }
            }

            public void visitClass(@NotNull RefClass refClass) {
                if (refClass == null) {
                    3.$$$reportNull$$$0(2);
                }
                if (!filter.accepts((RefJavaElement)refClass) || processedSuspicious.contains(refClass)) {
                    return;
                }
                this.doVisitClass(refClass);
            }

            private void doVisitClass(@NotNull RefClass refClass) {
                if (refClass == null) {
                    3.$$$reportNull$$$0(3);
                }
                if (!refClass.isAnonymous()) {
                    processedSuspicious.add(refClass);
                    ((GlobalJavaInspectionContext)globalContext.getExtension(GlobalJavaInspectionContext.CONTEXT)).enqueueDerivedClassesProcessor(refClass, inheritor -> {
                        UnusedDeclarationInspectionBase.getEntryPointsManager(globalContext).addEntryPoint((RefElement)refClass, false);
                        return false;
                    });
                    ((GlobalJavaInspectionContext)globalContext.getExtension(GlobalJavaInspectionContext.CONTEXT)).enqueueClassUsagesProcessor(refClass, reference -> {
                        if (!UnusedDeclarationInspectionBase.this.isAddNonJavaUsedEnabled() && !uastLanguages.contains(reference.getElement().getLanguage())) {
                            return true;
                        }
                        UnusedDeclarationInspectionBase.getEntryPointsManager(globalContext).addEntryPoint((RefElement)refClass, false);
                        return false;
                    });
                    this.queryQualifiedNameUsages(refClass);
                }
            }

            void queryQualifiedNameUsages(@NotNull RefClass refClass) {
                if (refClass == null) {
                    3.$$$reportNull$$$0(4);
                }
                if (firstPhase && UnusedDeclarationInspectionBase.this.isAddNonJavaUsedEnabled()) {
                    ((GlobalJavaInspectionContext)globalContext.getExtension(GlobalJavaInspectionContext.CONTEXT)).enqueueQualifiedNameOccurrencesProcessor(refClass, () -> {
                        EntryPointsManager entryPointsManager = UnusedDeclarationInspectionBase.getEntryPointsManager(globalContext);
                        entryPointsManager.addEntryPoint((RefElement)refClass, false);
                        for (RefMethod constructor : refClass.getConstructors()) {
                            entryPointsManager.addEntryPoint((RefElement)constructor, false);
                        }
                    });
                    for (RefElement element : refClass.getInReferences()) {
                        if (element instanceof RefJavaElement) continue;
                        UnusedDeclarationInspectionBase.getEntryPointsManager(globalContext).addEntryPoint((RefElement)refClass, false);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "refField";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "refMethod";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "refClass";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/codeInspection/deadCode/UnusedDeclarationInspectionBase$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitField";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitMethod";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitClass";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "doVisitClass";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "queryQualifiedNameUsages";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        globalContext.putUserData(PHASE_KEY, (Object)2);
        return true;
    }

    private static void enqueueMethodUsages(@NotNull GlobalInspectionContext globalContext, @NotNull RefMethod refMethod) {
        if (globalContext == null) {
            UnusedDeclarationInspectionBase.$$$reportNull$$$0(25);
        }
        if (refMethod == null) {
            UnusedDeclarationInspectionBase.$$$reportNull$$$0(26);
        }
        if (refMethod.getSuperMethods().isEmpty()) {
            ((GlobalJavaInspectionContext)globalContext.getExtension(GlobalJavaInspectionContext.CONTEXT)).enqueueMethodUsagesProcessor(refMethod, psiReference -> {
                UnusedDeclarationInspectionBase.getEntryPointsManager(globalContext).addEntryPoint((RefElement)refMethod, false);
                return false;
            });
        } else {
            for (RefMethod refSuper : refMethod.getSuperMethods()) {
                UnusedDeclarationInspectionBase.enqueueMethodUsages(globalContext, refSuper);
            }
        }
    }

    public JobDescriptor @Nullable [] getAdditionalJobs(@NotNull GlobalInspectionContext context) {
        if (context == null) {
            UnusedDeclarationInspectionBase.$$$reportNull$$$0(27);
        }
        return new JobDescriptor[]{context.getStdJobDescriptors().BUILD_GRAPH, context.getStdJobDescriptors().FIND_EXTERNAL_USAGES};
    }

    void checkForReachableRefs(@NotNull GlobalInspectionContext context) {
        if (context == null) {
            UnusedDeclarationInspectionBase.$$$reportNull$$$0(28);
        }
        CodeScanner codeScanner = new CodeScanner();
        RefManager refManager = context.getRefManager();
        for (RefElement entry : UnusedDeclarationInspectionBase.getEntryPointsManager(context).getEntryPoints(refManager)) {
            entry.accept((RefVisitor)codeScanner);
        }
        while (!codeScanner.myNextRound.isEmpty()) {
            ((RefElement)codeScanner.myNextRound.pop()).accept((RefVisitor)codeScanner);
        }
        while (codeScanner.newlyInstantiatedClassesCount() != 0) {
            codeScanner.cleanInstantiatedClassesCount();
            codeScanner.processDelayedMethods();
            while (!codeScanner.myNextRound.isEmpty()) {
                ((RefElement)codeScanner.myNextRound.pop()).accept((RefVisitor)codeScanner);
            }
        }
    }

    private static EntryPointsManager getEntryPointsManager(@NotNull GlobalInspectionContext context) {
        if (context == null) {
            UnusedDeclarationInspectionBase.$$$reportNull$$$0(29);
        }
        return ((GlobalJavaInspectionContext)context.getExtension(GlobalJavaInspectionContext.CONTEXT)).getEntryPointsManager(context.getRefManager());
    }

    @NotNull
    public List<EntryPoint> getExtensions() {
        List extensions = EntryPointsManagerBase.DEAD_CODE_EP_NAME.getExtensionList();
        ArrayList<EntryPoint> deadCodeAddIns = new ArrayList<EntryPoint>(extensions.size());
        for (EntryPoint entryPoint : extensions) {
            try {
                EntryPoint clone = entryPoint.clone();
                Element element = this.entryPointElements.get(entryPoint.getDisplayName());
                if (element != null) {
                    clone.readExternal(element);
                }
                deadCodeAddIns.add(clone);
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
        deadCodeAddIns.sort((o1, o2) -> o1.getDisplayName().compareToIgnoreCase(o2.getDisplayName()));
        ArrayList<EntryPoint> arrayList = deadCodeAddIns;
        if (arrayList == null) {
            UnusedDeclarationInspectionBase.$$$reportNull$$$0(30);
        }
        return arrayList;
    }

    @Contract(pure=true)
    @NotNull
    public static String getDisplayNameText() {
        String string = AnalysisBundle.message((String)"inspection.dead.code.display.name", (Object[])new Object[0]);
        if (string == null) {
            UnusedDeclarationInspectionBase.$$$reportNull$$$0(31);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 21, 22, 23, 24, 25, 26, 27, 28, 29 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/deadCode/UnusedDeclarationInspectionBase";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entryPoint";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 7: 
            case 12: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ignored";
                break;
            }
            case 9: 
            case 13: 
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalContext";
                break;
            }
            case 10: 
            case 14: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemDescriptionsProcessor";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 16: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refMethod";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSharedLocalInspectionTool";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/deadCode/UnusedDeclarationInspectionBase";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "findUnusedDeclarationInspection";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtensions";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayNameText";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "readSettings";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "saveEntryPointElement";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "writeSettings";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "writeUnusedDeclarationSettings";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "checkFile";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "runInspection";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isEntryPoint";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isStrictEntryPoint";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "hasMainMethodDeep";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "findUnusedDeclarationInspection";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isDeclaredAsEntryPoint";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "queryExternalUsagesRequests";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "enqueueMethodUsages";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getAdditionalJobs";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "checkForReachableRefs";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getEntryPointsManager";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 21, 22, 23, 24, 25, 26, 27, 28, 29 -> new IllegalArgumentException(string);
        };
    }

    private static final class StrictUnreferencedFilter
    extends UnreferencedFilter {
        private StrictUnreferencedFilter(@NotNull UnusedDeclarationInspectionBase tool, @NotNull GlobalInspectionContext context) {
            if (tool == null) {
                StrictUnreferencedFilter.$$$reportNull$$$0(0);
            }
            if (context == null) {
                StrictUnreferencedFilter.$$$reportNull$$$0(1);
            }
            super(tool, context);
        }

        @Override
        public int getElementProblemCount(@NotNull RefJavaElement refElement) {
            int problemCount;
            if (refElement == null) {
                StrictUnreferencedFilter.$$$reportNull$$$0(2);
            }
            if ((problemCount = super.getElementProblemCount(refElement)) > -1) {
                return problemCount;
            }
            return refElement.isReferenced() ? 0 : 1;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tool";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "refElement";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInspection/deadCode/UnusedDeclarationInspectionBase$StrictUnreferencedFilter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getElementProblemCount";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class CodeScanner
    extends RefJavaVisitor {
        private final Map<RefClass, Set<RefMethod>> myClassIDtoMethods = new HashMap<RefClass, Set<RefMethod>>();
        private final Set<RefClass> myInstantiatedClasses = new HashSet<RefClass>();
        private int myInstantiatedClassesCount;
        private final Set<RefClass> myProcessedClasses = new HashSet<RefClass>();
        private final Set<RefMethod> myProcessedMethods = new HashSet<RefMethod>();
        private final Set<RefFunctionalExpression> myProcessedFunctionalExpressions = new HashSet<RefFunctionalExpression>();
        private final Stack<RefElement> myNextRound = new Stack();

        private CodeScanner() {
        }

        public void visitMethod(@NotNull RefMethod method) {
            if (method == null) {
                CodeScanner.$$$reportNull$$$0(0);
            }
            if (!this.myProcessedMethods.contains(method)) {
                RefClass methodOwnerClass = method.getOwnerClass();
                if (method.isStatic() || method.isConstructor() || method.isEntry()) {
                    if (method.isStatic()) {
                        RefElementImpl owner = (RefElementImpl)method.getOwner();
                        if (owner != null) {
                            owner.setReachable(true);
                        }
                    } else if (methodOwnerClass != null) {
                        this.addInstantiatedClass(methodOwnerClass);
                    }
                    this.myProcessedMethods.add(method);
                    this.makeContentReachable((RefJavaElementImpl)method);
                    this.makeReachable((RefElement)methodOwnerClass);
                } else if (methodOwnerClass == null || this.isClassInstantiated(methodOwnerClass)) {
                    this.myProcessedMethods.add(method);
                    this.makeContentReachable((RefJavaElementImpl)method);
                } else {
                    this.addDelayedMethod(method, methodOwnerClass);
                }
                for (RefOverridable reference : method.getDerivedReferences()) {
                    if (reference instanceof RefMethod) {
                        this.visitMethod((RefMethod)reference);
                        continue;
                    }
                    if (!(reference instanceof RefFunctionalExpression)) continue;
                    this.visitFunctionalExpression((RefFunctionalExpression)reference);
                }
            }
        }

        public void visitFunctionalExpression(@NotNull RefFunctionalExpression functionalExpression) {
            if (functionalExpression == null) {
                CodeScanner.$$$reportNull$$$0(1);
            }
            if (this.myProcessedFunctionalExpressions.add(functionalExpression)) {
                this.makeContentReachable((RefJavaElementImpl)functionalExpression);
            }
        }

        public void visitClass(@NotNull RefClass refClass) {
            if (refClass == null) {
                CodeScanner.$$$reportNull$$$0(2);
            }
            if (this.myProcessedClasses.add(refClass)) {
                ((RefClassImpl)refClass).setReachable(true);
                this.makeReachable((RefElement)refClass);
                this.addInstantiatedClass(refClass);
            }
        }

        public void visitField(@NotNull RefField field) {
            if (field == null) {
                CodeScanner.$$$reportNull$$$0(3);
            }
            if (!field.isReachable()) {
                this.makeContentReachable((RefJavaElementImpl)field);
                this.makeReachable((RefElement)field.getOwnerClass());
            }
        }

        private void addInstantiatedClass(@NotNull RefClass refClass) {
            if (refClass == null) {
                CodeScanner.$$$reportNull$$$0(4);
            }
            if (this.myInstantiatedClasses.add(refClass)) {
                ((RefClassImpl)refClass).setReachable(true);
                ++this.myInstantiatedClassesCount;
                List refMethods = refClass.getLibraryMethods();
                for (RefMethod refMethod : refMethods) {
                    refMethod.accept((RefVisitor)this);
                }
                for (RefClass baseClass : refClass.getBaseClasses()) {
                    this.addInstantiatedClass(baseClass);
                }
            }
        }

        private void makeContentReachable(@NotNull RefJavaElementImpl refElement) {
            if (refElement == null) {
                CodeScanner.$$$reportNull$$$0(5);
            }
            refElement.setReachable(true);
            this.makeReachable((RefElement)refElement);
        }

        private void makeReachable(@Nullable RefElement refElement) {
            if (refElement == null) {
                return;
            }
            this.myNextRound.addAll(refElement.getOutReferences());
        }

        private void addDelayedMethod(@NotNull RefMethod refMethod, @NotNull RefClass ownerClass) {
            if (refMethod == null) {
                CodeScanner.$$$reportNull$$$0(6);
            }
            if (ownerClass == null) {
                CodeScanner.$$$reportNull$$$0(7);
            }
            Set methods = this.myClassIDtoMethods.computeIfAbsent(ownerClass, __ -> new HashSet());
            methods.add(refMethod);
        }

        private boolean isClassInstantiated(@NotNull RefClass refClass) {
            if (refClass == null) {
                CodeScanner.$$$reportNull$$$0(8);
            }
            return refClass.isUtilityClass() || this.myInstantiatedClasses.contains(refClass);
        }

        private int newlyInstantiatedClassesCount() {
            return this.myInstantiatedClassesCount;
        }

        private void cleanInstantiatedClassesCount() {
            this.myInstantiatedClassesCount = 0;
        }

        private void processDelayedMethods() {
            RefClass[] instClasses;
            for (RefClass refClass : instClasses = this.myInstantiatedClasses.toArray(new RefClass[0])) {
                RefMethod[] arMethods;
                Set<RefMethod> methods;
                if (!this.isClassInstantiated(refClass) || (methods = this.myClassIDtoMethods.get(refClass)) == null) continue;
                for (RefMethod arMethod : arMethods = methods.toArray(new RefMethod[0])) {
                    arMethod.accept((RefVisitor)this);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "method";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "functionalExpression";
                    break;
                }
                case 2: 
                case 4: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "refClass";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "field";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "refElement";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "refMethod";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ownerClass";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInspection/deadCode/UnusedDeclarationInspectionBase$CodeScanner";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitMethod";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitFunctionalExpression";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitClass";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitField";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addInstantiatedClass";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "makeContentReachable";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addDelayedMethod";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isClassInstantiated";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

