/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.deprecation;

import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.apiUsage.ApiUsageUastVisitor;
import com.intellij.codeInspection.deprecation.DeprecatedApiUsageProcessor;
import com.intellij.codeInspection.deprecation.DeprecationInspectionBase;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiElementVisitor;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;

public class DeprecationInspection
extends DeprecationInspectionBase {
    public static final String SHORT_NAME = "Deprecation";
    public static final String ID = "deprecation";
    @Language(value="jvm-field-name")
    public static final String IGNORE_METHODS_OF_DEPRECATED_NAME = "IGNORE_METHODS_OF_DEPRECATED";
    public boolean IGNORE_INSIDE_DEPRECATED = true;
    public boolean IGNORE_ABSTRACT_DEPRECATED_OVERRIDES = true;
    public boolean IGNORE_IMPORT_STATEMENTS = true;
    public boolean IGNORE_METHODS_OF_DEPRECATED = true;

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            DeprecationInspection.$$$reportNull$$$0(0);
        }
        if (!Registry.is((String)"kotlin.deprecation.inspection.enabled", (boolean)false) && holder.getFile().getLanguage().getID().equals("kotlin")) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                DeprecationInspection.$$$reportNull$$$0(1);
            }
            return psiElementVisitor;
        }
        PsiElementVisitor psiElementVisitor = ApiUsageUastVisitor.createPsiElementVisitor(new DeprecatedApiUsageProcessor(holder, this.IGNORE_INSIDE_DEPRECATED, this.IGNORE_ABSTRACT_DEPRECATED_OVERRIDES, this.IGNORE_IMPORT_STATEMENTS, this.IGNORE_METHODS_OF_DEPRECATED, this.IGNORE_IN_SAME_OUTERMOST_CLASS, false));
        if (psiElementVisitor == null) {
            DeprecationInspection.$$$reportNull$$$0(2);
        }
        return psiElementVisitor;
    }

    @NotNull
    public String getGroupDisplayName() {
        return "";
    }

    @NotNull
    public String getShortName() {
        return SHORT_NAME;
    }

    @NotNull
    public String getID() {
        return ID;
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"IGNORE_INSIDE_DEPRECATED", (String)JavaAnalysisBundle.message((String)"ignore.inside.deprecated.members", (Object[])new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"IGNORE_IMPORT_STATEMENTS", (String)JavaAnalysisBundle.message((String)"ignore.inside.non.static.imports", (Object[])new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"IGNORE_ABSTRACT_DEPRECATED_OVERRIDES", (String)JavaAnalysisBundle.message((String)"html.ignore.overrides.of.deprecated.abstract.methods", (Object[])new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)IGNORE_METHODS_OF_DEPRECATED_NAME, (String)JavaAnalysisBundle.message((String)"ignore.members.of.deprecated.classes", (Object[])new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), DeprecationInspection.getSameOutermostClassCheckBox()});
        if (optPane == null) {
            DeprecationInspection.$$$reportNull$$$0(3);
        }
        return optPane;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/deprecation/DeprecationInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/deprecation/DeprecationInspection";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3 -> new IllegalStateException(string);
        };
    }
}

