/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.java19modules;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInsight.daemon.impl.analysis.JavaModuleGraphUtil;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.GlobalJavaBatchInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefFile;
import com.intellij.codeInspection.reference.RefGraphAnnotator;
import com.intellij.codeInspection.reference.RefJavaModule;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefModule;
import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.java.codeserver.core.JavaPsiModuleUtil;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.module.LanguageLevelUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiJavaParserFacade;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPackageAccessibilityStatement;
import com.intellij.psi.PsiRequiresStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UFile;
import org.jetbrains.uast.UImportStatement;
import org.jetbrains.uast.UastContextKt;

public final class Java9RedundantRequiresStatementInspection
extends GlobalJavaBatchInspectionTool {
    private static final Key<Set<String>> IMPORTED_JAVA_PACKAGES = Key.create((String)"imported_java_packages");

    public CommonProblemDescriptor @Nullable [] checkElement(@NotNull RefEntity refEntity, @NotNull AnalysisScope scope, @NotNull InspectionManager manager, @NotNull GlobalInspectionContext globalContext) {
        if (refEntity == null) {
            Java9RedundantRequiresStatementInspection.$$$reportNull$$$0(0);
        }
        if (scope == null) {
            Java9RedundantRequiresStatementInspection.$$$reportNull$$$0(1);
        }
        if (manager == null) {
            Java9RedundantRequiresStatementInspection.$$$reportNull$$$0(2);
        }
        if (globalContext == null) {
            Java9RedundantRequiresStatementInspection.$$$reportNull$$$0(3);
        }
        if (refEntity instanceof RefJavaModule) {
            List requiredModules;
            Set moduleImportedPackages;
            RefJavaModule refJavaModule = (RefJavaModule)refEntity;
            RefModule refModule = refJavaModule.getModule();
            PsiJavaModule psiJavaModule = refJavaModule.getPsiElement();
            if (refModule != null && psiJavaModule != null && (moduleImportedPackages = (Set)refModule.getUserData(IMPORTED_JAVA_PACKAGES)) != null && !(requiredModules = refJavaModule.getRequiredModules()).isEmpty()) {
                ArrayList<ProblemDescriptor> descriptors = new ArrayList<ProblemDescriptor>();
                for (RefJavaModule.RequiredModule requiredModule : requiredModules) {
                    PsiRequiresStatement requiresStatement;
                    String requiredModuleName;
                    boolean isJavaBase;
                    if (requiredModule.isTransitive() || !(isJavaBase = "java.base".equals(requiredModuleName = requiredModule.moduleName())) && !Java9RedundantRequiresStatementInspection.isDependencyUnused(requiredModule.packagesExportedByModule(), moduleImportedPackages, refJavaModule.getName()) || (requiresStatement = (PsiRequiresStatement)ContainerUtil.find((Iterable)psiJavaModule.getRequires(), statement -> requiredModuleName.equals(statement.getModuleName()))) == null || this.isSuppressedFor((PsiElement)requiresStatement)) continue;
                    PsiJavaModule dependentModule = requiresStatement.resolve();
                    DeleteRedundantRequiresStatementFix requiresStatementFix = new DeleteRedundantRequiresStatementFix(requiredModuleName, moduleImportedPackages, dependentModule, psiJavaModule);
                    String message = JavaAnalysisBundle.message((String)"inspection.redundant.requires.statement.description", (Object[])new Object[]{requiredModuleName}) + " ";
                    message = isJavaBase ? message + JavaAnalysisBundle.message((String)"inspection.redundant.requires.statement.message.java.base.implicitly.required", (Object[])new Object[0]) : (!requiresStatementFix.hasReexportedDependencies() ? message + JavaAnalysisBundle.message((String)"inspection.redundant.requires.statement.message.module.unused", (Object[])new Object[0]) : message + JavaAnalysisBundle.message((String)"inspection.redundant.requires.statement.message.transitive.dependencies.on.can.be.used.directly", (Object[])new Object[]{StringUtil.join(requiresStatementFix.myDependencies, (String)"', '")}));
                    ProblemDescriptor descriptor = manager.createProblemDescriptor((PsiElement)requiresStatement, message, (LocalQuickFix)requiresStatementFix, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, false);
                    descriptors.add(descriptor);
                }
                if (!ContainerUtil.isEmpty(descriptors)) {
                    return descriptors.toArray(CommonProblemDescriptor.EMPTY_ARRAY);
                }
            }
        }
        return null;
    }

    private static boolean isDependencyUnused(@NotNull Map<String, List<String>> dependencyExportedPackages, @NotNull Set<String> importedPackageNames, @NotNull String contextModuleName) {
        if (dependencyExportedPackages == null) {
            Java9RedundantRequiresStatementInspection.$$$reportNull$$$0(4);
        }
        if (importedPackageNames == null) {
            Java9RedundantRequiresStatementInspection.$$$reportNull$$$0(5);
        }
        if (contextModuleName == null) {
            Java9RedundantRequiresStatementInspection.$$$reportNull$$$0(6);
        }
        for (Map.Entry<String, List<String>> entry : dependencyExportedPackages.entrySet()) {
            String exportedPackageName = entry.getKey();
            List<String> exportedToModules = entry.getValue();
            if (!exportedToModules.isEmpty() && !exportedToModules.contains(contextModuleName) || !importedPackageNames.contains(exportedPackageName)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public RefGraphAnnotator getAnnotator(@NotNull RefManager refManager) {
        if (refManager == null) {
            Java9RedundantRequiresStatementInspection.$$$reportNull$$$0(7);
        }
        return new RedundantRequiresStatementAnnotator();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refEntity";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalContext";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencyExportedPackages";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importedPackageNames";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextModuleName";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refManager";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInspection/java19modules/Java9RedundantRequiresStatementInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkElement";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isDependencyUnused";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getAnnotator";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class DeleteRedundantRequiresStatementFix
    extends PsiUpdateModCommandQuickFix {
        private final String myRequiredModuleName;
        private final Set<String> myImportedPackages;
        private final Set<String> myDependencies;

        DeleteRedundantRequiresStatementFix(String requiredModuleName, Set<String> importedPackages, PsiJavaModule dependentModule, PsiJavaModule currentModule) {
            this.myRequiredModuleName = requiredModuleName;
            this.myImportedPackages = importedPackages;
            this.myDependencies = this.getReexportedDependencies(currentModule, dependentModule);
        }

        boolean hasReexportedDependencies() {
            return !this.myDependencies.isEmpty();
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = JavaAnalysisBundle.message((String)"inspection.redundant.requires.statement.fix.family", (Object[])new Object[0]);
            if (string == null) {
                DeleteRedundantRequiresStatementFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Nls
        @NotNull
        public String getName() {
            String string = JavaAnalysisBundle.message((String)"inspection.redundant.requires.statement.fix.name", (Object[])new Object[]{this.myRequiredModuleName});
            if (string == null) {
                DeleteRedundantRequiresStatementFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            if (project == null) {
                DeleteRedundantRequiresStatementFix.$$$reportNull$$$0(2);
            }
            if (element == null) {
                DeleteRedundantRequiresStatementFix.$$$reportNull$$$0(3);
            }
            if (updater == null) {
                DeleteRedundantRequiresStatementFix.$$$reportNull$$$0(4);
            }
            if (!(element instanceof PsiRequiresStatement)) {
                return;
            }
            PsiRequiresStatement statementToDelete = (PsiRequiresStatement)element;
            this.addTransitiveDependencies(statementToDelete);
            statementToDelete.delete();
        }

        @NotNull
        private Set<String> getReexportedDependencies(@NotNull PsiJavaModule currentModule, @NotNull PsiJavaModule dependencyModule) {
            if (currentModule == null) {
                DeleteRedundantRequiresStatementFix.$$$reportNull$$$0(5);
            }
            if (dependencyModule == null) {
                DeleteRedundantRequiresStatementFix.$$$reportNull$$$0(6);
            }
            Set directDependencies = StreamEx.of(currentModule.getRequires().iterator()).map(PsiRequiresStatement::getModuleName).nonNull().toSet();
            List transitiveModules = ((StreamEx)((StreamEx)StreamEx.of(dependencyModule.getRequires().iterator()).filter(statement -> statement.hasModifierProperty("transitive"))).filter(requiresStatement -> !directDependencies.contains(requiresStatement.getModuleName()))).map(PsiRequiresStatement::resolve).nonNull().toList();
            Set set = ((StreamEx)StreamEx.of((Collection)transitiveModules).filter(transitiveModule -> this.isReexported(currentModule, (PsiJavaModule)transitiveModule))).map(transitiveModule -> transitiveModule.getName()).toSet();
            if (set == null) {
                DeleteRedundantRequiresStatementFix.$$$reportNull$$$0(7);
            }
            return set;
        }

        private boolean isReexported(@NotNull PsiJavaModule currentModule, @NotNull PsiJavaModule transitiveModule) {
            if (currentModule == null) {
                DeleteRedundantRequiresStatementFix.$$$reportNull$$$0(8);
            }
            if (transitiveModule == null) {
                DeleteRedundantRequiresStatementFix.$$$reportNull$$$0(9);
            }
            return ((StreamEx)StreamEx.of(transitiveModule.getExports().iterator()).map(PsiPackageAccessibilityStatement::getPackageName).nonNull().filter(this.myImportedPackages::contains)).anyMatch(packageName -> JavaPsiModuleUtil.exports((PsiJavaModule)transitiveModule, (String)packageName, (PsiJavaModule)currentModule));
        }

        private void addTransitiveDependencies(@NotNull PsiRequiresStatement statementToDelete) {
            PsiElement parent;
            if (statementToDelete == null) {
                DeleteRedundantRequiresStatementFix.$$$reportNull$$$0(10);
            }
            if ((parent = statementToDelete.getParent()) instanceof PsiJavaModule) {
                PsiJavaModule currentModule = (PsiJavaModule)parent;
                PsiJavaParserFacade parserFacade = JavaPsiFacade.getInstance((Project)currentModule.getProject()).getParserFacade();
                for (String dependencyName : this.myDependencies) {
                    PsiStatement requiresStatement = parserFacade.createModuleStatementFromText("requires " + dependencyName, null);
                    currentModule.addAfter((PsiElement)requiresStatement, (PsiElement)statementToDelete);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3, 4, 5, 6, 8, 9, 10 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/java19modules/Java9RedundantRequiresStatementInspection$DeleteRedundantRequiresStatementFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
                case 5: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "currentModule";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dependencyModule";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "transitiveModule";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statementToDelete";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 8: 
                case 9: 
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/java19modules/Java9RedundantRequiresStatementInspection$DeleteRedundantRequiresStatementFix";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getReexportedDependencies";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "getReexportedDependencies";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "isReexported";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "addTransitiveDependencies";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3, 4, 5, 6, 8, 9, 10 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class RedundantRequiresStatementAnnotator
    extends RefGraphAnnotator {
        private static final Set<String> DONT_COLLECT_PACKAGES = Collections.emptySet();

        private RedundantRequiresStatementAnnotator() {
        }

        public void onReferencesBuild(RefElement refElement) {
            RefFile refFile;
            PsiFile file;
            UFile uFile;
            if (refElement instanceof RefFile && (uFile = (UFile)UastContextKt.toUElement((PsiElement)(file = (refFile = (RefFile)refElement).getPsiElement()), UFile.class)) != null) {
                RedundantRequiresStatementAnnotator.onJavaFileReferencesBuilt(refFile, uFile);
            }
        }

        private static void onJavaFileReferencesBuilt(@NotNull RefFile refFile, UFile file) {
            Set<String> packageNames;
            RefModule refModule;
            if (refFile == null) {
                RedundantRequiresStatementAnnotator.$$$reportNull$$$0(0);
            }
            if ((refModule = refFile.getModule()) != null && LanguageLevelUtil.getEffectiveLanguageLevel((Module)refModule.getModule()).isAtLeast(LanguageLevel.JDK_1_9) && (packageNames = RedundantRequiresStatementAnnotator.getImportedPackages(refModule)) != DONT_COLLECT_PACKAGES) {
                Stream.concat(file.getImports().stream().map(st -> RedundantRequiresStatementAnnotator.getPackageName(st)), file.getImplicitImports().stream()).filter(p -> !StringUtil.isEmpty((String)p)).forEach(packageNames::add);
            }
        }

        @Nullable
        private static String getPackageName(UImportStatement statement) {
            UFile uFile;
            PsiElement resolved = statement.resolve();
            if (resolved instanceof PsiPackage) {
                return ((PsiPackage)resolved).getQualifiedName();
            }
            if (resolved != null && (uFile = (UFile)UastContextKt.getUastParentOfType((PsiElement)resolved, UFile.class)) != null) {
                return uFile.getPackageName();
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @NotNull
        private static Set<String> getImportedPackages(@NotNull RefModule refModule) {
            if (refModule == null) {
                RedundantRequiresStatementAnnotator.$$$reportNull$$$0(1);
            }
            RefModule refModule2 = refModule;
            // MONITORENTER : refModule2
            Set<String> importedPackages = (Set<String>)refModule.getUserData(IMPORTED_JAVA_PACKAGES);
            if (importedPackages == null) {
                PsiJavaModule javaModule = JavaModuleGraphUtil.findDescriptorByModule(refModule.getModule(), false);
                if (javaModule == null) {
                    javaModule = JavaModuleGraphUtil.findDescriptorByModule(refModule.getModule(), true);
                }
                importedPackages = javaModule != null ? ConcurrentCollectionFactory.createConcurrentSet() : DONT_COLLECT_PACKAGES;
                refModule.putUserData(IMPORTED_JAVA_PACKAGES, importedPackages);
            }
            Set<String> set = importedPackages;
            // MONITOREXIT : refModule2
            if (set != null) return set;
            RedundantRequiresStatementAnnotator.$$$reportNull$$$0(2);
            return set;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "refFile";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "refModule";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/java19modules/Java9RedundantRequiresStatementInspection$RedundantRequiresStatementAnnotator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/java19modules/Java9RedundantRequiresStatementInspection$RedundantRequiresStatementAnnotator";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getImportedPackages";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "onJavaFileReferencesBuilt";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getImportedPackages";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }
}

