/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.nullable;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.Nullability;
import com.intellij.codeInsight.NullabilityAnnotationInfo;
import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInsight.intention.AddAnnotationModCommandAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.nullable.NullableStuffInspectionBase;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModCommand;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.modcommand.ModCommandExecutor;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtilRt;
import java.util.ArrayList;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

public class AnnotateOverriddenMethodParameterFix
implements LocalQuickFix {
    private final Nullability myTargetNullability;

    AnnotateOverriddenMethodParameterFix(@NotNull Nullability targetNullability) {
        if (targetNullability == null) {
            AnnotateOverriddenMethodParameterFix.$$$reportNull$$$0(0);
        }
        this.myTargetNullability = targetNullability;
    }

    @NotNull
    public String getName() {
        String string = this.myTargetNullability == Nullability.NOT_NULL ? JavaAnalysisBundle.message((String)"annotate.overridden.methods.parameters.nonnull", (Object[])new Object[0]) : JavaAnalysisBundle.message((String)"annotate.overridden.methods.parameters.nullable", (Object[])new Object[0]);
        if (string == null) {
            AnnotateOverriddenMethodParameterFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean startInWriteAction() {
        return false;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        ArrayList toAnnotate;
        block8: {
            block7: {
                if (project == null) {
                    AnnotateOverriddenMethodParameterFix.$$$reportNull$$$0(2);
                }
                if (descriptor == null) {
                    AnnotateOverriddenMethodParameterFix.$$$reportNull$$$0(3);
                }
                toAnnotate = new ArrayList();
                PsiParameter parameter = (PsiParameter)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getPsiElement(), PsiParameter.class, (boolean)false);
                if (parameter == null) break block7;
                if (AnnotateOverriddenMethodParameterFix.processParameterInheritorsUnderProgress(parameter, toAnnotate::add)) break block8;
            }
            return;
        }
        FileModificationService.getInstance().preparePsiElementsForWrite(toAnnotate);
        ActionContext actionContext = ActionContext.from((ProblemDescriptor)descriptor);
        for (PsiParameter psiParam : toAnnotate) {
            assert (psiParam != null) : toAnnotate;
            ModCommandExecutor.executeInteractively((ActionContext)actionContext, (String)this.getFamilyName(), null, () -> {
                NullabilityAnnotationInfo info = NullableNotNullManager.getInstance((Project)project).findEffectiveNullabilityInfo((PsiModifierListOwner)psiParam);
                if (info != null && info.getNullability() == this.myTargetNullability && info.getInheritedFrom() == null && !info.isInferred()) {
                    return ModCommand.nop();
                }
                ModCommandAction action = this.myTargetNullability == Nullability.NOT_NULL ? AddAnnotationModCommandAction.createAddNotNullFix((PsiModifierListOwner)psiParam) : AddAnnotationModCommandAction.createAddNullableFix((PsiModifierListOwner)psiParam);
                return action == null || action.getPresentation(actionContext) == null ? ModCommand.nop() : action.perform(actionContext);
            });
        }
    }

    public static boolean processParameterInheritorsUnderProgress(@NotNull PsiParameter parameter, @NotNull Consumer<? super PsiParameter> consumer) {
        PsiMethod method;
        if (parameter == null) {
            AnnotateOverriddenMethodParameterFix.$$$reportNull$$$0(4);
        }
        if (consumer == null) {
            AnnotateOverriddenMethodParameterFix.$$$reportNull$$$0(5);
        }
        if ((method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)parameter, PsiMethod.class)) == null) {
            return false;
        }
        Object[] parameters = method.getParameterList().getParameters();
        int index = ArrayUtilRt.find((Object[])parameters, (Object)parameter);
        return AnnotateOverriddenMethodParameterFix.processModifiableInheritorsUnderProgress(method, psiMethod -> {
            PsiParameter[] psiParameters = psiMethod.getParameterList().getParameters();
            if (index < psiParameters.length) {
                consumer.accept(psiParameters[index]);
            }
        });
    }

    @NotNull
    public String getFamilyName() {
        String string = JavaAnalysisBundle.message((String)"annotate.overridden.methods.parameters.family.name", (Object[])new Object[0]);
        if (string == null) {
            AnnotateOverriddenMethodParameterFix.$$$reportNull$$$0(6);
        }
        return string;
    }

    public static boolean processModifiableInheritorsUnderProgress(@NotNull PsiMethod method, @NotNull Consumer<? super PsiMethod> consumer) {
        if (method == null) {
            AnnotateOverriddenMethodParameterFix.$$$reportNull$$$0(7);
        }
        if (consumer == null) {
            AnnotateOverriddenMethodParameterFix.$$$reportNull$$$0(8);
        }
        return ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
            for (PsiMethod psiMethod : OverridingMethodsSearch.search((PsiMethod)method).asIterable()) {
                ReadAction.run(() -> {
                    if (psiMethod.isPhysical() && !NullableStuffInspectionBase.shouldSkipOverriderAsGenerated(psiMethod)) {
                        consumer.accept(psiMethod);
                    }
                });
            }
        }, JavaAnalysisBundle.message((String)"searching.for.overriding.methods", (Object[])new Object[0]), true, method.getProject());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetNullability";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/nullable/AnnotateOverriddenMethodParameterFix";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/nullable/AnnotateOverriddenMethodParameterFix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 6: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processParameterInheritorsUnderProgress";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processModifiableInheritorsUnderProgress";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 6 -> new IllegalStateException(string);
        };
    }
}

