/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.redundantCast;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.miscGenerics.SuspiciousMethodCallUtil;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.codeInspection.redundantCast.RemoveRedundantCastUtil;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.util.PsiExpressionTrimRenderer;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.RedundantCastUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.bugs.PrimitiveArrayArgumentToVariableArgMethodInspection;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.format.FormatDecode;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.VariableNameGenerator;
import java.util.ArrayList;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RedundantCastInspection
extends AbstractBaseJavaLocalInspectionTool
implements CleanupLocalInspectionTool {
    private final LocalQuickFix myQuickFixAction = new AcceptSuggested();
    private static final CallMatcher CLASS_CAST_MATCHER = CallMatcher.instanceCall("java.lang.Class", "cast").parameterCount(1);
    @NonNls
    private static final String SHORT_NAME = "RedundantCast";
    public boolean IGNORE_SUSPICIOUS_METHOD_CALLS = true;

    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            RedundantCastInspection.$$$reportNull$$$0(0);
        }
        if (!PsiUtil.isLanguageLevel5OrHigher((PsiElement)holder.getFile())) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                RedundantCastInspection.$$$reportNull$$$0(1);
            }
            return psiElementVisitor;
        }
        return new RedundantCastUtil.RedundantCastVisitorBase(){

            public void visitMethodReferenceExpression(@NotNull PsiMethodReferenceExpression methodRef) {
                if (methodRef == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.visitMethodReferenceExpression(methodRef);
                if (CLASS_CAST_MATCHER.methodReferenceMatches(methodRef)) {
                    PsiType type = methodRef.getFunctionalInterfaceType();
                    if (type == null) {
                        return;
                    }
                    PsiType parameterType = LambdaUtil.getLambdaParameterFromType((PsiType)type, (int)0);
                    PsiType returnType = LambdaUtil.getFunctionalInterfaceReturnType((PsiType)type);
                    if (parameterType != null && parameterType.equals(returnType)) {
                        holder.problem((PsiElement)methodRef, JavaAnalysisBundle.message((String)"inspection.redundant.cast.methodref.descriptor", (Object[])new Object[0])).fix((LocalQuickFix)new ReplaceWithIdentityLambdaFix()).register();
                    }
                }
            }

            @Override
            protected void registerCast(@NotNull PsiTypeCastExpression typeCast) {
                ProblemDescriptor descriptor;
                if (typeCast == null) {
                    1.$$$reportNull$$$0(1);
                }
                if ((descriptor = RedundantCastInspection.this.createDescription(typeCast, holder.getManager(), isOnTheFly)) != null) {
                    holder.registerProblem(descriptor);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "methodRef";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "typeCast";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/codeInspection/redundantCast/RedundantCastInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitMethodReferenceExpression";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "registerCast";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"IGNORE_SUSPICIOUS_METHOD_CALLS", (String)JavaAnalysisBundle.message((String)"ignore.casts.in.suspicious.collections.method.calls", (Object[])new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            RedundantCastInspection.$$$reportNull$$$0(2);
        }
        return optPane;
    }

    @Nullable
    private ProblemDescriptor createDescription(@NotNull PsiTypeCastExpression cast, @NotNull InspectionManager manager, boolean onTheFly) {
        PsiElement gParent;
        if (cast == null) {
            RedundantCastInspection.$$$reportNull$$$0(3);
        }
        if (manager == null) {
            RedundantCastInspection.$$$reportNull$$$0(4);
        }
        PsiExpression operand = cast.getOperand();
        PsiTypeElement castType = cast.getCastType();
        if (operand == null || castType == null) {
            return null;
        }
        PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)cast.getParent());
        if (parent instanceof PsiExpressionList && (gParent = parent.getParent()) instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression call = (PsiMethodCallExpression)gParent;
            if (this.IGNORE_SUSPICIOUS_METHOD_CALLS) {
                PsiExpression lastArgument;
                PsiType operandType = operand.getType();
                String message = SuspiciousMethodCallUtil.getSuspiciousMethodCallMessage(call, operand, operandType, true, new ArrayList<SuspiciousMethodCallUtil.PatternMethod>(), 0);
                if (message != null) {
                    return null;
                }
                PsiExpression[] arguments = call.getArgumentList().getExpressions();
                if (arguments.length > 0 && (lastArgument = arguments[arguments.length - 1]) == cast && PrimitiveArrayArgumentToVariableArgMethodInspection.isConfusingArgument((PsiCall)call, operand, arguments)) {
                    return null;
                }
                if (FormatDecode.isSuspiciousFormatCall(call, cast)) {
                    return null;
                }
            }
        }
        String message = JavaAnalysisBundle.message((String)"inspection.redundant.cast.problem.descriptor", (Object[])new Object[]{PsiExpressionTrimRenderer.render((PsiExpression)operand)});
        return manager.createProblemDescriptor((PsiElement)castType, message, this.myQuickFixAction, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, onTheFly);
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = InspectionsBundle.message((String)"group.names.verbose.or.redundant.code.constructs", (Object[])new Object[0]);
        if (string == null) {
            RedundantCastInspection.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        return SHORT_NAME;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/redundantCast/RedundantCastInspection";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cast";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/redundantCast/RedundantCastInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createDescription";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 5 -> new IllegalStateException(string);
        };
    }

    private static class AcceptSuggested
    extends PsiUpdateModCommandQuickFix {
        private AcceptSuggested() {
        }

        @NotNull
        public String getFamilyName() {
            String string = JavaAnalysisBundle.message((String)"inspection.redundant.cast.remove.quickfix", (Object[])new Object[0]);
            if (string == null) {
                AcceptSuggested.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement castTypeElement, @NotNull ModPsiUpdater updater) {
            PsiTypeCastExpression cast;
            PsiElement psiElement;
            if (project == null) {
                AcceptSuggested.$$$reportNull$$$0(1);
            }
            if (castTypeElement == null) {
                AcceptSuggested.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                AcceptSuggested.$$$reportNull$$$0(3);
            }
            if ((psiElement = castTypeElement.getParent()) instanceof PsiTypeCastExpression && RedundantCastUtil.isCastRedundant(cast = (PsiTypeCastExpression)psiElement)) {
                RemoveRedundantCastUtil.removeCast(cast);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/redundantCast/RedundantCastInspection$AcceptSuggested";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "castTypeElement";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/redundantCast/RedundantCastInspection$AcceptSuggested";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class ReplaceWithIdentityLambdaFix
    extends PsiUpdateModCommandQuickFix {
        private ReplaceWithIdentityLambdaFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = JavaAnalysisBundle.message((String)"inspection.redundant.cast.remove.quickfix", (Object[])new Object[0]);
            if (string == null) {
                ReplaceWithIdentityLambdaFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            PsiParameter parameter;
            PsiMethodReferenceExpression methodRef;
            if (project == null) {
                ReplaceWithIdentityLambdaFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                ReplaceWithIdentityLambdaFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                ReplaceWithIdentityLambdaFix.$$$reportNull$$$0(3);
            }
            if ((methodRef = (PsiMethodReferenceExpression)ObjectUtils.tryCast((Object)element, PsiMethodReferenceExpression.class)) == null) {
                return;
            }
            VariableNameGenerator generator = new VariableNameGenerator(element, VariableKind.PARAMETER);
            PsiType type = methodRef.getFunctionalInterfaceType();
            PsiMethod method = LambdaUtil.getFunctionalInterfaceMethod((PsiType)type);
            PsiType returnType = LambdaUtil.getFunctionalInterfaceReturnType((PsiType)type);
            if (returnType != null) {
                generator.byType(returnType);
            }
            if (method != null && (parameter = method.getParameterList().getParameter(0)) != null) {
                generator.byName(parameter.getName());
            }
            String varName = generator.generate(true);
            new CommentTracker().replaceAndRestoreComments(element, varName + "->" + varName);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/redundantCast/RedundantCastInspection$ReplaceWithIdentityLambdaFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/redundantCast/RedundantCastInspection$ReplaceWithIdentityLambdaFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

