/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.redundantCast;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.util.PsiPrecedenceUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ig.psiutils.CommentTracker;

public final class RemoveRedundantCastUtil {
    private static final Logger LOG = Logger.getInstance(RemoveRedundantCastUtil.class);

    public static PsiExpression removeCast(PsiTypeCastExpression castExpression) {
        if (castExpression == null) {
            return null;
        }
        PsiElement parent = castExpression.getParent();
        PsiExpression operand = castExpression.getOperand();
        if (operand instanceof PsiParenthesizedExpression) {
            PsiParenthesizedExpression parExpr = (PsiParenthesizedExpression)operand;
            PsiElement topParent = PsiUtil.skipParenthesizedExprUp((PsiElement)parent);
            if (!(topParent instanceof PsiExpression) || !PsiPrecedenceUtil.areParenthesesNeeded((PsiExpression)parExpr.getExpression(), (PsiExpression)((PsiExpression)topParent), (boolean)true)) {
                operand = parExpr.getExpression();
            }
        }
        if (operand == null) {
            return null;
        }
        PsiTypeCastExpression toBeReplaced = castExpression;
        while (parent instanceof PsiParenthesizedExpression) {
            toBeReplaced = (PsiExpression)parent;
            parent = parent.getParent();
        }
        try {
            return (PsiExpression)new CommentTracker().replaceAndRestoreComments((PsiElement)toBeReplaced, (PsiElement)operand);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
            return toBeReplaced;
        }
    }
}

