/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.reference;

import com.intellij.codeInspection.reference.RefClass;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefFunctionalExpression;
import com.intellij.codeInspection.reference.RefJavaElement;
import com.intellij.codeInspection.reference.RefJavaElementImpl;
import com.intellij.codeInspection.reference.RefJavaUtil;
import com.intellij.codeInspection.reference.RefJavaVisitor;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefMethod;
import com.intellij.codeInspection.reference.RefMethodImpl;
import com.intellij.codeInspection.reference.RefOverridable;
import com.intellij.codeInspection.reference.RefParameter;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.codeInspection.reference.WritableRefEntity;
import com.intellij.openapi.application.ReadAction;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import org.jetbrains.uast.UBlockExpression;
import org.jetbrains.uast.UCallableReferenceExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.ULambdaExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UParameter;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UReturnExpression;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;

public final class RefFunctionalExpressionImpl
extends RefJavaElementImpl
implements RefFunctionalExpression {
    private static final int IS_METHOD_REFERENCE_MASK = 65536;
    private static final int IS_BODY_EMPTY_MASK = 131072;

    RefFunctionalExpressionImpl(@NotNull UExpression expr, @NotNull PsiElement psi, @NotNull RefManager manager) {
        if (expr == null) {
            RefFunctionalExpressionImpl.$$$reportNull$$$0(0);
        }
        if (psi == null) {
            RefFunctionalExpressionImpl.$$$reportNull$$$0(1);
        }
        if (manager == null) {
            RefFunctionalExpressionImpl.$$$reportNull$$$0(2);
        }
        super((UElement)expr, psi, manager);
    }

    protected synchronized void initialize() {
        UExpression element = this.getUastElement();
        LOG.assertTrue(element != null);
        PsiElement sourceElement = element.getSourcePsi();
        LOG.assertTrue(sourceElement != null);
        this.setOwner();
        if (element instanceof ULambdaExpression) {
            ULambdaExpression lambda = (ULambdaExpression)element;
            this.setParameters(lambda.getParameters());
        } else if (element instanceof UCallableReferenceExpression) {
            PsiMethod resolvedMethod = LambdaUtil.getFunctionalInterfaceMethod((PsiElement)sourceElement);
            UMethod uMethodRef = (UMethod)UastContextKt.toUElement((PsiElement)resolvedMethod, UMethod.class);
            if (uMethodRef != null) {
                this.setParameters(uMethodRef.getUastParameters());
            }
            this.setFlag(true, 65536L);
        } else assert (false);
        this.setHasEmptyBody();
    }

    public void buildReferences() {
        Object object;
        UExpression element = this.getUastElement();
        LOG.assertTrue(element != null);
        PsiElement sourceElement = element.getSourcePsi();
        LOG.assertTrue(sourceElement != null);
        PsiMethod resolvedMethod = LambdaUtil.getFunctionalInterfaceMethod((PsiElement)sourceElement);
        if (resolvedMethod != null && (object = this.getRefManager().getReference((PsiElement)resolvedMethod)) instanceof RefMethod) {
            RefMethod refMethod = (RefMethod)object;
            refMethod.addDerivedReference((RefOverridable)this);
            refMethod.initializeIfNeeded();
            RefClass refClass = refMethod.getOwnerClass();
            if (refClass != null) {
                refClass.addDerivedReference((RefOverridable)this);
            }
            if (element instanceof UCallableReferenceExpression && !TypeConversionUtil.isVoidType((PsiType)resolvedMethod.getReturnType())) {
                ((RefMethodImpl)refMethod).updateReturnValueTemplate(element);
            }
        }
        if (element instanceof ULambdaExpression) {
            ULambdaExpression lambda = (ULambdaExpression)element;
            RefJavaUtil.getInstance().addReferencesTo((UElement)element, (RefJavaElement)this, new UElement[]{lambda.getBody()});
        } else if (element instanceof UCallableReferenceExpression) {
            RefJavaUtil.getInstance().addReferencesTo((UElement)element, (RefJavaElement)this, new UElement[]{element});
            for (RefParameter parameter : this.getParameters()) {
                this.addReference((RefElement)parameter, parameter.getPsiElement(), (UElement)element, false, true, null);
            }
        }
    }

    @NotNull
    public Collection<? extends RefOverridable> getDerivedReferences() {
        List list = Collections.emptyList();
        if (list == null) {
            RefFunctionalExpressionImpl.$$$reportNull$$$0(3);
        }
        return list;
    }

    public void addDerivedReference(@NotNull RefOverridable reference) {
        if (reference == null) {
            RefFunctionalExpressionImpl.$$$reportNull$$$0(4);
        }
        throw new AssertionError((Object)"Should not be called!");
    }

    @NotNull
    public synchronized @Unmodifiable List<RefParameter> getParameters() {
        LOG.assertTrue(this.isInitialized());
        List list = ContainerUtil.filterIsInstance((Collection)this.getChildren(), RefParameter.class);
        if (list == null) {
            RefFunctionalExpressionImpl.$$$reportNull$$$0(5);
        }
        return list;
    }

    @Nullable
    public UExpression getUastElement() {
        return (UExpression)UastContextKt.toUElement((PsiElement)this.getPsiElement(), UExpression.class);
    }

    public synchronized boolean hasEmptyBody() {
        LOG.assertTrue(this.isInitialized());
        return this.checkFlag(131072L);
    }

    public boolean isMethodReference() {
        LOG.assertTrue(this.isInitialized());
        return this.checkFlag(65536L);
    }

    public void accept(@NotNull RefVisitor visitor2) {
        if (visitor2 == null) {
            RefFunctionalExpressionImpl.$$$reportNull$$$0(6);
        }
        if (visitor2 instanceof RefJavaVisitor) {
            RefJavaVisitor javaVisitor = (RefJavaVisitor)visitor2;
            ReadAction.run(() -> javaVisitor.visitFunctionalExpression((RefFunctionalExpression)this));
        } else {
            super.accept(visitor2);
        }
    }

    private void setOwner() {
        RefElement pDeclarationRef;
        UExpression element = this.getUastElement();
        assert (element != null);
        UElement pDeclaration = UastUtils.getParentOfType((UElement)element, (boolean)true, UMethod.class, (Class[])new Class[]{UClass.class, ULambdaExpression.class, UField.class});
        if (pDeclaration != null && (pDeclarationRef = this.getRefManager().getReference(pDeclaration.getSourcePsi())) != null) {
            ((WritableRefEntity)pDeclarationRef).add((RefEntity)this);
        }
    }

    private void setParameters(@NotNull List<UParameter> parameters) {
        if (parameters == null) {
            RefFunctionalExpressionImpl.$$$reportNull$$$0(7);
        }
        if (parameters.isEmpty()) {
            return;
        }
        UExpression element = this.getUastElement();
        assert (element != null);
        for (int i = 0; i < parameters.size(); ++i) {
            UParameter param = parameters.get(i);
            if (param.getSourcePsi() == null) continue;
            this.getRefJavaManager().getParameterReference(param, i, (RefElement)this);
        }
    }

    private void setHasEmptyBody() {
        UBlockExpression body;
        ULambdaExpression lambda;
        UExpression uExpression;
        UExpression element = this.getUastElement();
        assert (element != null);
        boolean isEmptyBody = false;
        if (element instanceof ULambdaExpression && (uExpression = (lambda = (ULambdaExpression)element).getBody()) instanceof UBlockExpression && ((body = (UBlockExpression)uExpression).getExpressions().isEmpty() || RefFunctionalExpressionImpl.checkIfOnlyCallsSuper(body, lambda.getFunctionalInterfaceType()))) {
            isEmptyBody = true;
        }
        this.setFlag(isEmptyBody, 131072L);
    }

    private static boolean checkIfOnlyCallsSuper(@NotNull UBlockExpression body, @Nullable PsiType type) {
        List expressions;
        if (body == null) {
            RefFunctionalExpressionImpl.$$$reportNull$$$0(8);
        }
        if ((expressions = body.getExpressions()).size() > 1) {
            return false;
        }
        UExpression expression = (UExpression)expressions.get(0);
        if (expression instanceof UReturnExpression) {
            UReturnExpression r = (UReturnExpression)expression;
            expression = r.getReturnExpression();
        }
        if (expression instanceof UQualifiedReferenceExpression) {
            UMethod lambdaMethod = (UMethod)UastContextKt.toUElement((PsiElement)LambdaUtil.getFunctionalInterfaceMethod((PsiType)type), UMethod.class);
            return lambdaMethod != null && RefJavaUtil.getInstance().isCallToSuperMethod(expression, lambdaMethod);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psi";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/reference/RefFunctionalExpressionImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "body";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/reference/RefFunctionalExpressionImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDerivedReferences";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addDerivedReference";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setParameters";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "checkIfOnlyCallsSuper";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 5 -> new IllegalStateException(string);
        };
    }
}

