/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.reference;

import com.intellij.analysis.AnalysisBundle;
import com.intellij.codeInspection.reference.RefClass;
import com.intellij.codeInspection.reference.RefClassImpl;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefElementImpl;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefFieldImpl;
import com.intellij.codeInspection.reference.RefFunctionalExpressionImpl;
import com.intellij.codeInspection.reference.RefJavaElement;
import com.intellij.codeInspection.reference.RefJavaFileImpl;
import com.intellij.codeInspection.reference.RefJavaManager;
import com.intellij.codeInspection.reference.RefJavaUtil;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefMethod;
import com.intellij.codeInspection.reference.RefMethodImpl;
import com.intellij.codeInspection.reference.RefParameter;
import com.intellij.codeInspection.reference.RefParameterImpl;
import com.intellij.codeInspection.reference.WritableRefEntity;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.lang.Language;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiImplicitClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSyntheticClass;
import com.intellij.psi.SyntheticElement;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.ui.CoreAwareIconManager;
import com.intellij.ui.IconManager;
import com.intellij.util.containers.Stack;
import java.util.Collection;
import java.util.Collections;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UAnnotated;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UCallableReferenceExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UDeclarationKt;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.ULambdaExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UastCallKind;
import org.jetbrains.uast.UastUtils;

public abstract sealed class RefJavaElementImpl
extends RefElementImpl
implements RefJavaElement
permits RefClassImpl, RefFieldImpl, RefFunctionalExpressionImpl, RefMethodImpl, RefParameterImpl {
    private static final int ACCESS_MODIFIER_MASK = 3;
    private static final int ACCESS_PRIVATE = 0;
    private static final int ACCESS_PROTECTED = 1;
    private static final int ACCESS_PACKAGE = 2;
    private static final int ACCESS_PUBLIC = 3;
    private static final int IS_STATIC_MASK = 4;
    private static final int IS_FINAL_MASK = 8;
    private static final int IS_SYNTHETIC_JSP_ELEMENT_MASK = 1024;
    private static final int FORBID_PROTECTED_ACCESS_MASK = 2048;

    protected RefJavaElementImpl(@NotNull String name, @NotNull RefJavaElement owner) {
        if (name == null) {
            RefJavaElementImpl.$$$reportNull$$$0(0);
        }
        if (owner == null) {
            RefJavaElementImpl.$$$reportNull$$$0(1);
        }
        super(name, (RefElement)owner);
        String am = owner.getAccessModifier();
        this.doSetAccessModifier(am);
        boolean synthOwner = owner.isSyntheticJSP();
        if (synthOwner) {
            this.setSyntheticJSP(true);
        }
    }

    protected RefJavaElementImpl(UDeclaration elem, PsiElement psi, RefManager manager) {
        super(RefJavaElementImpl.getName((UElement)elem), psi, manager);
        boolean isSynth;
        assert (!(psi instanceof UElement));
        PsiElement psiElement = elem.getJavaPsi();
        if (!(psiElement instanceof PsiModifierListOwner)) {
            throw new AssertionError();
        }
        PsiModifierListOwner javaPsi = (PsiModifierListOwner)psiElement;
        this.setAccessModifier(RefJavaUtil.getInstance().getAccessModifier(javaPsi));
        boolean bl = isSynth = javaPsi instanceof PsiMethod && psi instanceof SyntheticElement || psi instanceof PsiSyntheticClass;
        if (isSynth) {
            this.setSyntheticJSP(true);
        }
        this.setIsStatic(elem.isStatic());
        this.setIsFinal(elem.isFinal());
    }

    RefJavaElementImpl(@NotNull UElement declaration, @NotNull PsiElement psi, @NotNull RefManager manager) {
        if (declaration == null) {
            RefJavaElementImpl.$$$reportNull$$$0(2);
        }
        if (psi == null) {
            RefJavaElementImpl.$$$reportNull$$$0(3);
        }
        if (manager == null) {
            RefJavaElementImpl.$$$reportNull$$$0(4);
        }
        super(RefJavaElementImpl.getName(declaration), psi, manager);
    }

    @NotNull
    public synchronized Collection<RefClass> getOutTypeReferences() {
        Collection<Object> collection;
        WritableRefEntity writableRefEntity = this.getOwner();
        if (writableRefEntity instanceof RefJavaElement) {
            RefJavaElement e = (RefJavaElement)writableRefEntity;
            collection = e.getOutTypeReferences();
        } else {
            collection = Collections.emptySet();
        }
        if (collection == null) {
            RefJavaElementImpl.$$$reportNull$$$0(5);
        }
        return collection;
    }

    synchronized void addOutTypeReference(RefClass refClass) {
        WritableRefEntity writableRefEntity = this.getOwner();
        if (writableRefEntity instanceof RefJavaElementImpl) {
            RefJavaElementImpl e = (RefJavaElementImpl)writableRefEntity;
            e.addOutTypeReference(refClass);
        }
    }

    @NotNull
    private static String getName(@NotNull UElement declaration) {
        PsiElement element;
        if (declaration == null) {
            RefJavaElementImpl.$$$reportNull$$$0(6);
        }
        if ((element = declaration.getJavaPsi()) instanceof PsiAnonymousClass) {
            PsiAnonymousClass anonymousClass = (PsiAnonymousClass)element;
            PsiClass psiBaseClass = anonymousClass.getBaseClassType().resolve();
            if (psiBaseClass == null) {
                String string = JavaAnalysisBundle.message((String)"inspection.reference.anonymous.class", (Object[])new Object[0]);
                if (string == null) {
                    RefJavaElementImpl.$$$reportNull$$$0(7);
                }
                return string;
            }
            String string = JavaAnalysisBundle.message((String)"inspection.reference.anonymous.name", (Object[])new Object[]{psiBaseClass.getName()});
            if (string == null) {
                RefJavaElementImpl.$$$reportNull$$$0(8);
            }
            return string;
        }
        if (element instanceof PsiImplicitClass) {
            String string = JavaAnalysisBundle.message((String)"inspection.reference.implicit.class", (Object[])new Object[]{element.getContainingFile().getName()});
            if (string == null) {
                RefJavaElementImpl.$$$reportNull$$$0(9);
            }
            return string;
        }
        if (element instanceof PsiSyntheticClass) {
            PsiSyntheticClass jspClass = (PsiSyntheticClass)element;
            String string = "<" + jspClass.getContainingFile().getName() + ">";
            if (string == null) {
                RefJavaElementImpl.$$$reportNull$$$0(10);
            }
            return string;
        }
        if (element instanceof PsiMethod) {
            Language language;
            if (element instanceof SyntheticElement && ((language = element.getLanguage()).isKindOf("JSP") || language.isKindOf("JSPX"))) {
                String string = JavaAnalysisBundle.message((String)"inspection.reference.jsp.holder.method.anonymous.name", (Object[])new Object[0]);
                if (string == null) {
                    RefJavaElementImpl.$$$reportNull$$$0(11);
                }
                return string;
            }
            String string = PsiFormatUtil.formatMethod((PsiMethod)((PsiMethod)element), (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)257, (int)2);
            if (string == null) {
                RefJavaElementImpl.$$$reportNull$$$0(12);
            }
            return string;
        }
        if (declaration instanceof ULambdaExpression || declaration instanceof UCallableReferenceExpression) {
            UAnnotated pDeclaration;
            UDeclaration elementDeclaration = UDeclarationKt.getContainingDeclaration((UElement)declaration);
            boolean isMethodReference = declaration instanceof UCallableReferenceExpression;
            if (elementDeclaration != null && (pDeclaration = (UAnnotated)UastUtils.getParentOfType((UElement)elementDeclaration, (boolean)false, UMethod.class, (Class[])new Class[]{UClass.class, ULambdaExpression.class, UField.class})) != null && pDeclaration.getSourcePsi() instanceof PsiNamedElement) {
                String name = ((PsiNamedElement)pDeclaration.getSourcePsi()).getName();
                String string = JavaAnalysisBundle.message((String)(isMethodReference ? "inspection.reference.method.reference.name" : "inspection.reference.lambda.name"), (Object[])new Object[]{name});
                if (string == null) {
                    RefJavaElementImpl.$$$reportNull$$$0(13);
                }
                return string;
            }
            String string = JavaAnalysisBundle.message((String)(isMethodReference ? "inspection.reference.default.method.reference.name" : "inspection.reference.default.lambda.name"), (Object[])new Object[0]);
            if (string == null) {
                RefJavaElementImpl.$$$reportNull$$$0(14);
            }
            return string;
        }
        String name = null;
        if (element instanceof PsiNamedElement) {
            PsiNamedElement named = (PsiNamedElement)element;
            name = named.getName();
        }
        String string = name == null ? AnalysisBundle.message((String)"inspection.reference.anonymous", (Object[])new Object[0]) : name;
        if (string == null) {
            RefJavaElementImpl.$$$reportNull$$$0(15);
        }
        return string;
    }

    public boolean isFinal() {
        return this.checkFlag(8L);
    }

    public boolean isStatic() {
        return this.checkFlag(4L);
    }

    void setIsStatic(boolean isStatic) {
        this.setFlag(isStatic, 4L);
    }

    void setIsFinal(boolean isFinal) {
        this.setFlag(isFinal, 8L);
    }

    public boolean isSyntheticJSP() {
        return this.checkFlag(1024L);
    }

    private void setSyntheticJSP(boolean synthetic) {
        this.setFlag(synthetic, 1024L);
    }

    @NotNull
    public synchronized String getAccessModifier() {
        long access_id = this.myFlags & 3L;
        if (access_id == 0L) {
            return "private";
        }
        if (access_id == 3L) {
            return "public";
        }
        if (access_id == 2L) {
            return "packageLocal";
        }
        return "protected";
    }

    public void setAccessModifier(String visibility) {
        this.doSetAccessModifier(visibility);
    }

    private synchronized void doSetAccessModifier(@NotNull String visibility) {
        if (visibility == null) {
            RefJavaElementImpl.$$$reportNull$$$0(16);
        }
        int accessFlag = switch (visibility) {
            case "private" -> 0;
            case "public" -> 3;
            case "packageLocal" -> 2;
            default -> 1;
        };
        this.myFlags = this.myFlags & 0xFFFFFFFFFFFFFFFCL | (long)accessFlag;
    }

    public boolean isSuspiciousRecursive() {
        return this.isCalledOnlyFrom(this, (Stack<RefJavaElement>)new Stack());
    }

    private boolean isCalledOnlyFrom(RefJavaElement refElement, Stack<RefJavaElement> callStack) {
        if (callStack.contains((Object)this)) {
            return refElement == this;
        }
        if (this.getInReferences().isEmpty()) {
            return false;
        }
        if (refElement instanceof RefMethod) {
            RefMethod refMethod = (RefMethod)refElement;
            for (Object refSuper : refMethod.getSuperMethods()) {
                if (refSuper.getInReferences().isEmpty()) continue;
                return false;
            }
            if (refMethod.isConstructor()) {
                boolean unreachable = true;
                for (RefElement refOut : refMethod.getOutReferences()) {
                    unreachable &= !refOut.isReachable();
                }
                if (unreachable) {
                    return true;
                }
            }
        }
        callStack.push((Object)this);
        for (RefElement refCaller : this.getInReferences()) {
            RefJavaElementImpl ref;
            if (((RefElementImpl)refCaller).isSuspicious() && refCaller instanceof RefJavaElementImpl && (ref = (RefJavaElementImpl)refCaller).isCalledOnlyFrom(refElement, callStack)) continue;
            callStack.pop();
            return false;
        }
        callStack.pop();
        return true;
    }

    void addReference(RefElement refWhat, PsiElement psiWhat, UElement from, boolean forWriting, boolean forReading, UExpression expression) {
        PsiElement psiFrom = from.getPsi();
        if (refWhat != null) {
            if (refWhat instanceof RefParameter) {
                RefParameter param = (RefParameter)refWhat;
                if (forWriting) {
                    param.parameterReferenced(true);
                }
                if (forReading) {
                    param.parameterReferenced(false);
                }
            }
            this.addOutReference(refWhat);
            if (refWhat instanceof RefJavaFileImpl) {
                RefJavaFileImpl file = (RefJavaFileImpl)refWhat;
                file.addInReference((RefElement)this);
                this.getRefManager().fireNodeMarkedReferenced(psiWhat, psiFrom);
            } else if (refWhat instanceof RefJavaElementImpl) {
                RefJavaElementImpl refJava = (RefJavaElementImpl)refWhat;
                refJava.markReferenced(this, forWriting, forReading, expression);
            }
        } else {
            this.getRefManager().fireNodeMarkedReferenced(psiWhat, psiFrom);
        }
    }

    protected void markReferenced(@NotNull RefElementImpl refFrom, boolean forWriting, boolean forReading, @Nullable UExpression expressionFrom) {
        if (refFrom == null) {
            RefJavaElementImpl.$$$reportNull$$$0(17);
        }
        this.addInReference((RefElement)refFrom);
        this.setForbidProtectedAccess(refFrom, expressionFrom);
        this.getRefManager().fireNodeMarkedReferenced((RefElement)this, (RefElement)refFrom, false, forReading, forWriting, expressionFrom == null ? null : expressionFrom.getSourcePsi());
    }

    void setForbidProtectedAccess(RefElementImpl refFrom, @Nullable UExpression expressionFrom) {
        UCallExpression call;
        if (!this.checkFlag(2048L) && (expressionFrom instanceof UQualifiedReferenceExpression || expressionFrom instanceof UCallExpression && (call = (UCallExpression)expressionFrom).getKind() == UastCallKind.CONSTRUCTOR_CALL)) {
            this.initializeIfNeeded();
            refFrom.initializeIfNeeded();
            if (RefJavaUtil.getPackage((RefEntity)refFrom) != RefJavaUtil.getPackage((RefEntity)this)) {
                this.setFlag(true, 2048L);
            }
        }
    }

    public boolean isProtectedAccessForbidden() {
        return this.checkFlag(2048L);
    }

    RefJavaManager getRefJavaManager() {
        return (RefJavaManager)this.getRefManager().getExtension(RefJavaManager.MANAGER);
    }

    public void referenceRemoved() {
        super.referenceRemoved();
        if (this.isEntry()) {
            this.getRefJavaManager().getEntryPointsManager().removeEntryPoint((RefElement)this);
        }
    }

    public Icon getIcon(boolean expanded) {
        IconManager iconManager;
        PsiElement element;
        if (this.isSyntheticJSP() && (element = this.getPsiElement()) != null && element.isValid() && (iconManager = IconManager.getInstance()) instanceof CoreAwareIconManager) {
            CoreAwareIconManager manager = (CoreAwareIconManager)iconManager;
            return manager.getIcon(element.getContainingFile().getVirtualFile(), 3, element.getProject());
        }
        return super.getIcon(expanded);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 7, 8, 9, 10, 11, 12, 13, 14, 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psi";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/reference/RefJavaElementImpl";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visibility";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refFrom";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/reference/RefJavaElementImpl";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutTypeReferences";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getName";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "doSetAccessModifier";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "markReferenced";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 7, 8, 9, 10, 11, 12, 13, 14, 15 -> new IllegalStateException(string);
        };
    }
}

